/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.adm.model.ApplicationDependencyVulnerabilityCollection;
import com.oracle.bmc.adm.requests.ListApplicationDependencyVulnerabilitiesRequest;
import com.oracle.bmc.adm.responses.ListApplicationDependencyVulnerabilitiesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListApplicationDependencyVulnerabilitiesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListApplicationDependencyVulnerabilitiesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListApplicationDependencyVulnerabilitiesRequest interceptRequest(ListApplicationDependencyVulnerabilitiesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListApplicationDependencyVulnerabilitiesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20220421").path("vulnerabilityAudits").path(HttpUtils.encodePathSegment((String)request.getVulnerabilityAuditId())).path("applicationDependencyVulnerabilities");
        if (request.getVulnerabilityId() != null) {
            target = target.queryParam("vulnerabilityId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getVulnerabilityId())});
        }
        if (request.getCvssV3GreaterThanOrEqual() != null) {
            target = target.queryParam("cvssV3GreaterThanOrEqual", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCvssV3GreaterThanOrEqual())});
        }
        if (request.getCvssV2GreaterThanOrEqual() != null) {
            target = target.queryParam("cvssV2GreaterThanOrEqual", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCvssV2GreaterThanOrEqual())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getGav() != null) {
            target = target.queryParam("gav", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getGav())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ListApplicationDependencyVulnerabilitiesResponse> fromResponse() {
        Function<Response, ListApplicationDependencyVulnerabilitiesResponse> transformer = new Function<Response, ListApplicationDependencyVulnerabilitiesResponse>(){

            public ListApplicationDependencyVulnerabilitiesResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.adm.responses.ListApplicationDependencyVulnerabilitiesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ApplicationDependencyVulnerabilityCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListApplicationDependencyVulnerabilitiesResponse.Builder builder = ListApplicationDependencyVulnerabilitiesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.applicationDependencyVulnerabilityCollection((ApplicationDependencyVulnerabilityCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListApplicationDependencyVulnerabilitiesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

