/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import javax.lang.model.element.Element;
import javax.swing.Action;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.util.NbBundle;

public abstract class SpringXMLConfigCompletionDoc
implements CompletionDocumentation {
    public static SpringXMLConfigCompletionDoc getAttribValueDoc(String text) {
        return new AttribValueDoc(text);
    }

    public static SpringXMLConfigCompletionDoc createJavaDoc(CompilationController cc, Element element) {
        return new JavaElementDoc(ElementJavadoc.create((CompilationInfo)cc, (Element)element));
    }

    public static SpringXMLConfigCompletionDoc createBeanRefDoc(String beanId, List<String> beanNames, String beanClassName, String beanFileLoc, Action goToBeanAction) {
        return new BeanRefDoc(beanId, beanNames, beanClassName, beanFileLoc, goToBeanAction);
    }

    public URL getURL() {
        return null;
    }

    public CompletionDocumentation resolveLink(String link) {
        return null;
    }

    public Action getGotoSourceAction() {
        return null;
    }

    private static class AttribValueDoc
    extends SpringXMLConfigCompletionDoc {
        private String text;

        public AttribValueDoc(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    private static class BeanRefDoc
    extends SpringXMLConfigCompletionDoc {
        private String beanId;
        private List<String> beanNames;
        private String beanClassName;
        private String beanLocFile;
        private Action goToBeanAction;
        private String displayText;

        public BeanRefDoc(String beanId, List<String> beanNames, String beanClassName, String beanLocFile, Action goToBeanAction) {
            this.beanId = beanId;
            this.beanNames = beanNames;
            this.beanClassName = beanClassName;
            this.beanLocFile = beanLocFile;
            this.goToBeanAction = goToBeanAction;
        }

        public String getText() {
            if (this.displayText == null) {
                StringBuilder sb = new StringBuilder();
                if (this.beanLocFile != null) {
                    sb.append("<b>");
                    sb.append(new File(this.beanLocFile).getName());
                    sb.append("</b>");
                    sb.append("<br>");
                    sb.append("<br>");
                }
                String beanName = this.getBeanName();
                ArrayList<String> otherNames = new ArrayList<String>(this.beanNames);
                otherNames.remove(beanName);
                if (otherNames.size() > 0) {
                    sb.append(NbBundle.getMessage(SpringXMLConfigCompletionDoc.class, (String)"LBL_BeanLabelWithAliases", (Object)beanName, (Object)StringUtils.join(otherNames, ", ")));
                } else {
                    sb.append(NbBundle.getMessage(SpringXMLConfigCompletionDoc.class, (String)"LBL_BeanLabel", (Object)beanName));
                }
                if (this.beanClassName != null) {
                    sb.append("<pre>");
                    sb.append(this.beanClassName);
                    sb.append("</pre>");
                }
                this.displayText = sb.toString();
            }
            return this.displayText;
        }

        private String getBeanName() {
            if (this.beanId != null && this.beanId.trim().length() > 0) {
                return this.beanId;
            }
            for (String name : this.beanNames) {
                if (name == null || name.trim().length() <= 0) continue;
                return name;
            }
            return NbBundle.getMessage(SpringXMLConfigCompletionDoc.class, (String)"LBL_Unnamed");
        }

        @Override
        public Action getGotoSourceAction() {
            return this.goToBeanAction;
        }
    }

    protected static class JavaElementDoc
    extends SpringXMLConfigCompletionDoc {
        private ElementJavadoc elementJavadoc;

        public JavaElementDoc(ElementJavadoc elementJavadoc) {
            this.elementJavadoc = elementJavadoc;
        }

        @Override
        public JavaElementDoc resolveLink(String link) {
            ElementJavadoc doc = this.elementJavadoc.resolveLink(link);
            return doc != null ? new JavaElementDoc(doc) : null;
        }

        @Override
        public URL getURL() {
            return this.elementJavadoc.getURL();
        }

        public String getText() {
            return this.elementJavadoc.getText();
        }

        public Future<String> getFutureText() {
            return this.elementJavadoc.getTextAsync();
        }

        @Override
        public Action getGotoSourceAction() {
            return this.elementJavadoc.getGotoSourceAction();
        }
    }
}

