/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.CallNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.parsing.api.Snapshot;

class JsKeyStrokeHandler
implements KeystrokeHandler {
    public boolean beforeCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public boolean afterCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public boolean charBackspaced(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public int beforeBreak(Document doc, int caretOffset, JTextComponent target) throws BadLocationException {
        return -1;
    }

    public OffsetRange findMatching(Document doc, int caretOffset) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, final int caretOffset) {
        final LinkedHashSet ranges = new LinkedHashSet();
        if (info instanceof JsParserResult) {
            final JsParserResult jsParserResult = (JsParserResult)info;
            FunctionNode root = jsParserResult.getRoot();
            final TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)jsParserResult.getSnapshot(), (int)caretOffset);
            if (root != null && ts != null) {
                root.accept(new NodeVisitor(new LexicalContext()){

                    private OffsetRange getOffsetRange(IdentNode node) {
                        return new OffsetRange(node.getStart(), node.getStart() + node.getName().length());
                    }

                    private OffsetRange getOffsetRange(Node node) {
                        if (node instanceof FunctionNode) {
                            return this.getOffsetRange((FunctionNode)node);
                        }
                        if (node instanceof IdentNode) {
                            return this.getOffsetRange((IdentNode)node);
                        }
                        return new OffsetRange(node.getStart(), node.getFinish());
                    }

                    private OffsetRange getOffsetRange(FunctionNode node) {
                        return new OffsetRange(com.oracle.js.parser.Token.descPosition((long)node.getFirstToken()), com.oracle.js.parser.Token.descPosition((long)node.getLastToken()) + com.oracle.js.parser.Token.descLength((long)node.getLastToken()));
                    }

                    protected boolean enterDefault(Node node) {
                        OffsetRange range = this.getOffsetRange(node);
                        if (node != null && range.getStart() <= caretOffset && caretOffset <= range.getEnd()) {
                            ranges.add(new OffsetRange(range.getStart(), range.getEnd()));
                            return super.enterDefault(node);
                        }
                        return false;
                    }

                    public boolean enterFunctionNode(FunctionNode node) {
                        OffsetRange fnRange = this.getOffsetRange(node);
                        if (node.isProgram()) {
                            ranges.add(new OffsetRange(0, jsParserResult.getSnapshot().getText().length()));
                            if (fnRange.getStart() <= caretOffset && caretOffset <= fnRange.getEnd()) {
                                ranges.add(new OffsetRange(fnRange.getStart(), fnRange.getEnd()));
                            }
                            this.processFunction(node);
                            return false;
                        }
                        if (fnRange.getStart() <= caretOffset && caretOffset <= fnRange.getEnd()) {
                            ranges.add(new OffsetRange(fnRange.getStart(), fnRange.getEnd()));
                            int firstParamOffset = fnRange.getEnd();
                            int lastParamOffset = -1;
                            for (Node param : node.getParameters()) {
                                OffsetRange paramRange = this.getOffsetRange(param);
                                if (param.getStart() < firstParamOffset) {
                                    firstParamOffset = paramRange.getStart();
                                }
                                if (param.getFinish() <= lastParamOffset) continue;
                                lastParamOffset = paramRange.getEnd();
                            }
                            if (node.getParameters().size() > 1 && firstParamOffset < lastParamOffset && firstParamOffset <= caretOffset && caretOffset <= lastParamOffset) {
                                ranges.add(new OffsetRange(firstParamOffset, lastParamOffset));
                                for (Node param : node.getParameters()) {
                                    param.accept((NodeVisitor)this);
                                }
                            }
                            if (fnRange.getStart() <= caretOffset && caretOffset <= fnRange.getEnd()) {
                                ranges.add(new OffsetRange(fnRange.getStart(), fnRange.getEnd()));
                                this.processFunction(node);
                            }
                        }
                        return false;
                    }

                    private void processFunction(FunctionNode node) {
                        Block body = node.getBody();
                        for (Node statement : body.getStatements()) {
                            OffsetRange stRange = this.getOffsetRange(statement);
                            if (stRange.getStart() > caretOffset || caretOffset > stRange.getEnd()) continue;
                            statement.accept((NodeVisitor)this);
                        }
                    }

                    public boolean enterVarNode(VarNode node) {
                        OffsetRange range = this.getOffsetRange((Node)node);
                        ts.move(range.getStart());
                        Token token = LexUtilities.findPreviousIncluding((TokenSequence)ts, Arrays.asList(JsTokenId.KEYWORD_VAR));
                        if (token != null && ts.offset() <= caretOffset && caretOffset <= range.getEnd()) {
                            ranges.add(new OffsetRange(ts.offset(), range.getEnd()));
                            return this.enterDefault((Node)node);
                        }
                        return false;
                    }

                    public boolean enterLiteralNode(LiteralNode node) {
                        if (node.isString() && node.getStart() <= caretOffset && caretOffset <= node.getFinish()) {
                            ranges.add(new OffsetRange(node.getStart() - 1, node.getFinish() + 1));
                        }
                        return super.enterLiteralNode(node);
                    }

                    public boolean enterCallNode(CallNode node) {
                        if (node.getArgs().size() > 1) {
                            OffsetRange range = this.getOffsetRange((Node)node);
                            if (range.getStart() <= caretOffset && caretOffset <= range.getEnd()) {
                                OffsetRange argRange;
                                ranges.add(range);
                                int firstArgOffset = node.getFinish();
                                int lastArgOffset = -1;
                                for (Node arg : node.getArgs()) {
                                    argRange = this.getOffsetRange(arg);
                                    if (argRange.getStart() < firstArgOffset) {
                                        firstArgOffset = argRange.getStart();
                                        if (arg instanceof LiteralNode && ((LiteralNode)arg).isString()) {
                                            --firstArgOffset;
                                        }
                                    }
                                    if (argRange.getEnd() <= lastArgOffset) continue;
                                    lastArgOffset = argRange.getEnd();
                                    if (!(arg instanceof LiteralNode) || !((LiteralNode)arg).isString()) continue;
                                    ++lastArgOffset;
                                }
                                if (firstArgOffset <= caretOffset && caretOffset <= lastArgOffset) {
                                    ranges.add(new OffsetRange(firstArgOffset, lastArgOffset));
                                }
                                for (Node arg : node.getArgs()) {
                                    argRange = this.getOffsetRange(arg);
                                    if (argRange.getStart() > caretOffset || caretOffset > argRange.getEnd()) continue;
                                    arg.accept((NodeVisitor)this);
                                }
                            }
                            return false;
                        }
                        return super.enterCallNode(node);
                    }
                });
            }
        }
        ArrayList<OffsetRange> retval = new ArrayList<OffsetRange>(ranges);
        Collections.reverse(retval);
        return retval;
    }

    public int getNextWordOffset(Document doc, int caretOffset, boolean reverse) {
        return -1;
    }
}

