/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.sql;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.jsp.jstl.sql.Result;

class ResultImpl
implements Result,
Serializable {
    private List<SortedMap<String, Object>> rowMap = new ArrayList<SortedMap<String, Object>>();
    private List<Object[]> rowByIndex = new ArrayList<Object[]>();
    private String[] columnNames;
    private boolean isLimited;

    public ResultImpl(ResultSet rs, int startRow, int maxRows) throws SQLException {
        int i;
        ResultSetMetaData rsmd = rs.getMetaData();
        int noOfColumns = rsmd.getColumnCount();
        this.columnNames = new String[noOfColumns];
        for (i = 1; i <= noOfColumns; ++i) {
            this.columnNames[i - 1] = rsmd.getColumnName(i);
        }
        for (i = 0; i < startRow; ++i) {
            rs.next();
        }
        int processedRows = 0;
        while (rs.next()) {
            if (maxRows != -1 && processedRows == maxRows) {
                this.isLimited = true;
                break;
            }
            Object[] columns = new Object[noOfColumns];
            TreeMap<String, Object> columnMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            for (int i2 = 1; i2 <= noOfColumns; ++i2) {
                Object value = rs.getObject(i2);
                if (rs.wasNull()) {
                    value = null;
                }
                columns[i2 - 1] = value;
                columnMap.put(this.columnNames[i2 - 1], value);
            }
            this.rowMap.add(columnMap);
            this.rowByIndex.add(columns);
            ++processedRows;
        }
    }

    @Override
    public SortedMap[] getRows() {
        if (this.rowMap == null) {
            return null;
        }
        return this.rowMap.toArray(new SortedMap[0]);
    }

    @Override
    public Object[][] getRowsByIndex() {
        if (this.rowByIndex == null) {
            return null;
        }
        return (Object[][])this.rowByIndex.toArray((T[])new Object[0][0]);
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int getRowCount() {
        if (this.rowMap == null) {
            return -1;
        }
        return this.rowMap.size();
    }

    @Override
    public boolean isLimitedByMaxRows() {
        return this.isLimited;
    }
}

