/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.OCID;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.CustomerKeyIdFormatter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CustomerAuthenticationDetailsProvider
implements AuthenticationDetailsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CustomerAuthenticationDetailsProvider.class);

    @Override
    public String getKeyId() {
        if (!OCID.isValid(this.getTenantId())) {
            if (StringUtils.isBlank((CharSequence)this.getTenantId())) {
                LOG.warn("tenantId may not be null");
            } else {
                LOG.warn("tenantId '{}' does not match expected pattern", (Object)this.getTenantId());
            }
        }
        if (!OCID.isValid(this.getUserId())) {
            if (StringUtils.isBlank((CharSequence)this.getUserId())) {
                LOG.warn("userId may not be null");
            } else {
                LOG.warn("userId '{}' does not match expected pattern", (Object)this.getUserId());
            }
        }
        String keyId = CustomerKeyIdFormatter.createKeyId(this);
        LOG.debug("Using keyId: {}", (Object)keyId);
        return keyId;
    }
}

