/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.google.common.base.Optional;
import com.google.common.base.Suppliers;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.retrier.RetryCondition;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waiter.GenericWaiter;
import java.util.Objects;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.commons.lang3.mutable.MutableObject;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcGenericRetrier {
    private static final Logger LOG = LoggerFactory.getLogger(BmcGenericRetrier.class);
    private final GenericWaiter waiter;
    private final RetryCondition retryCondition;

    public BmcGenericRetrier(@NonNull RetryConfiguration retryConfiguration) {
        if (retryConfiguration == null) {
            throw new NullPointerException("retryConfiguration is marked non-null but is null");
        }
        this.waiter = new GenericWaiter(retryConfiguration);
        this.retryCondition = retryConfiguration.getRetryCondition();
    }

    public <REQUEST, RESPONSE> RESPONSE execute(@NonNull REQUEST requestToUse, @NonNull Function<REQUEST, RESPONSE> functionCall) {
        if (requestToUse == null) {
            throw new NullPointerException("requestToUse is marked non-null but is null");
        }
        if (functionCall == null) {
            throw new NullPointerException("functionCall is marked non-null but is null");
        }
        MutableObject lastKnownException = new MutableObject();
        LOG.debug("Retry policy to use: {MaximumNumberAttempts={}, MinSleepBetween=0, MaxSleepBetween={}ms, ExponentialBackoffBase=2}", (Object)8, (Object)RetryConfiguration.DEFAULT_MAX_WAIT_TIME);
        Optional response = this.waiter.execute(Suppliers.ofInstance(requestToUse), request -> {
            if (lastKnownException.getValue() != null) {
                LOG.debug("Http Status Code: {}, Error Code: {}, Retrying: {}", new Object[]{((BmcException)lastKnownException.getValue()).getStatusCode(), ((BmcException)lastKnownException.getValue()).getServiceCode(), ((BmcException)lastKnownException.getValue()).getMessage()});
            }
            try {
                return this.doFunctionCall(request, functionCall);
            }
            catch (BmcException e) {
                if (!this.retryCondition.shouldBeRetried(e)) {
                    LOG.debug("Http Status Code: {}, Error Code: {}, Not retrying, not retriable: {}", new Object[]{e.getStatusCode(), e.getServiceCode(), e.getMessage()});
                    throw e;
                }
                lastKnownException.setValue((Object)e);
                return null;
            }
        }, Objects::nonNull);
        if (response.isPresent()) {
            return (RESPONSE)response.get();
        }
        throw (BmcException)lastKnownException.getValue();
    }

    protected <REQUEST, RESPONSE> RESPONSE doFunctionCall(@Nullable @NonNull REQUEST request, @NonNull Function<REQUEST, RESPONSE> functionCall) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (functionCall == null) {
            throw new NullPointerException("functionCall is marked non-null but is null");
        }
        return functionCall.apply(request);
    }

    public GenericWaiter getWaiter() {
        return this.waiter;
    }

    public RetryCondition getRetryCondition() {
        return this.retryCondition;
    }
}

