/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.gulp.ui.options;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javascript.gulp.exec.GulpExecutable;
import org.netbeans.modules.javascript.gulp.ui.options.Bundle;
import org.netbeans.modules.javascript.gulp.util.FileUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class GulpOptionsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(GulpOptionsPanel.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel errorLabel;
    private JButton gulpBrowseButton;
    private JLabel gulpLabel;
    private JButton gulpSearchButton;
    private JTextField gulpTextField;
    private JLabel hintLabel;
    private JLabel installLabel;

    public GulpOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.init();
    }

    private void init() {
        this.errorLabel.setText(" ");
        this.hintLabel.setText(Bundle.GulpOptionsPanel_gulp_hint(GulpExecutable.GULP_NAME));
        this.gulpTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public String getGulp() {
        return this.gulpTextField.getText();
    }

    public void setGulp(String gulp) {
        this.gulpTextField.setText(gulp);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.gulpLabel = new JLabel();
        this.gulpTextField = new JTextField();
        this.gulpBrowseButton = new JButton();
        this.gulpSearchButton = new JButton();
        this.hintLabel = new JLabel();
        this.installLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.gulpLabel.setLabelFor(this.gulpTextField);
        Mnemonics.setLocalizedText((JLabel)this.gulpLabel, (String)NbBundle.getMessage(GulpOptionsPanel.class, (String)"GulpOptionsPanel.gulpLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.gulpBrowseButton, (String)NbBundle.getMessage(GulpOptionsPanel.class, (String)"GulpOptionsPanel.gulpBrowseButton.text"));
        this.gulpBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GulpOptionsPanel.this.gulpBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.gulpSearchButton, (String)NbBundle.getMessage(GulpOptionsPanel.class, (String)"GulpOptionsPanel.gulpSearchButton.text"));
        this.gulpSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GulpOptionsPanel.this.gulpSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.hintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.installLabel, (String)NbBundle.getMessage(GulpOptionsPanel.class, (String)"GulpOptionsPanel.installLabel.text"));
        this.installLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GulpOptionsPanel.this.installLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                GulpOptionsPanel.this.installLabelMouseEntered(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.gulpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.installLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.gulpTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gulpBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gulpSearchButton)))).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gulpLabel).addComponent(this.gulpTextField, -2, -1, -2).addComponent(this.gulpBrowseButton).addComponent(this.gulpSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hintLabel).addComponent(this.installLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void installLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void installLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("https://github.com/gulpjs/gulp/blob/master/docs/getting-started.md"));
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void gulpBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(GulpOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.GulpOptionsPanel_gulp_browse_title()).showOpenDialog();
        if (file != null) {
            this.gulpTextField.setText(file.getAbsolutePath());
        }
    }

    private void gulpSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        Iterator<String> iterator = FileUtils.findFileOnUsersPath(GulpExecutable.GULP_NAME).iterator();
        if (iterator.hasNext()) {
            String gulp = iterator.next();
            this.gulpTextField.setText(new File(gulp).getAbsolutePath());
            return;
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.GulpOptionsPanel_gulp_none());
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            GulpOptionsPanel.this.fireChange();
        }
    }
}

