/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class FailureRecorder
extends ProjectComponent
implements JUnitResultFormatter,
BuildListener {
    public static final String MAGIC_PROPERTY_CLASS_LOCATION = "ant.junit.failureCollector";
    public static final String DEFAULT_CLASS_LOCATION = System.getProperty("java.io.tmpdir") + "FailedTests";
    private static final String LOG_PREFIX = "    [junit]";
    private static SortedSet<TestInfos> failedTests = new TreeSet<TestInfos>();
    private BufferedWriter writer;
    private String locationName;

    private String getLocationName() {
        if (this.locationName == null) {
            String syspropValue = System.getProperty(MAGIC_PROPERTY_CLASS_LOCATION);
            String antpropValue = this.getProject().getProperty(MAGIC_PROPERTY_CLASS_LOCATION);
            if (syspropValue != null) {
                this.locationName = syspropValue;
                this.verbose("System property 'ant.junit.failureCollector' set, so use its value '" + syspropValue + "' as location for collector class.");
            } else if (antpropValue != null) {
                this.locationName = antpropValue;
                this.verbose("Ant property 'ant.junit.failureCollector' set, so use its value '" + antpropValue + "' as location for collector class.");
            } else {
                this.locationName = DEFAULT_CLASS_LOCATION;
                this.verbose("System property 'ant.junit.failureCollector' not set, so use value as location for collector class: '" + DEFAULT_CLASS_LOCATION + "'");
            }
            File locationFile = new File(this.locationName);
            if (!locationFile.isAbsolute()) {
                File f = new File(this.getProject().getBaseDir(), this.locationName);
                this.locationName = f.getAbsolutePath();
                this.verbose("Location file is relative (" + locationFile + ") use absolute path instead (" + this.locationName + ")");
            }
        }
        return this.locationName;
    }

    public void setProject(Project project) {
        super.setProject(project);
        if (project.getBuildListeners().stream().noneMatch(FailureRecorder.class::isInstance)) {
            this.verbose("Register FailureRecorder (@" + this.hashCode() + ") as BuildListener");
            project.addBuildListener((BuildListener)this);
        }
    }

    @Override
    public void endTestSuite(JUnitTest suite) throws BuildException {
    }

    public void addError(Test test, Throwable throwable) {
        failedTests.add(new TestInfos(test));
    }

    public void addFailure(Test test, AssertionFailedError error) {
        failedTests.add(new TestInfos(test));
    }

    @Override
    public void setOutput(OutputStream out) {
        if (out != System.out) {
            FileUtils.close((OutputStream)out);
        }
    }

    @Override
    public void setSystemError(String err) {
    }

    @Override
    public void setSystemOutput(String out) {
    }

    @Override
    public void startTestSuite(JUnitTest suite) throws BuildException {
    }

    public void endTest(Test test) {
    }

    public void startTest(Test test) {
    }

    private void writeJavaClass() {
        try {
            File sourceFile = new File(this.getLocationName() + ".java");
            this.verbose("Write collector class to '" + sourceFile.getAbsolutePath() + "'");
            if (sourceFile.exists() && !sourceFile.delete()) {
                throw new IOException("could not delete " + sourceFile);
            }
            this.writer = new BufferedWriter(new FileWriter(sourceFile));
            this.createClassHeader();
            this.createSuiteMethod();
            this.createClassFooter();
        }
        catch (IOException e) {
            this.log(StringUtils.getStackTrace((Throwable)e));
        }
        finally {
            FileUtils.close((Writer)this.writer);
        }
    }

    private void createClassHeader() throws IOException {
        String className = this.getLocationName().replace('\\', '/');
        if (className.contains("/")) {
            className = className.substring(className.lastIndexOf(47) + 1);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss,SSS");
        this.writer.write("// generated on: ");
        this.writer.write(sdf.format(new Date()));
        this.writer.newLine();
        this.writer.write("import junit.framework.*;");
        this.writer.newLine();
        this.writer.write("public class ");
        this.writer.write(className);
        this.writer.write(" extends TestCase {");
        this.writer.newLine();
        this.writer.write("    public ");
        this.writer.write(className);
        this.writer.write("(String testname) {");
        this.writer.newLine();
        this.writer.write("        super(testname);");
        this.writer.newLine();
        this.writer.write("    }");
        this.writer.newLine();
    }

    private void createSuiteMethod() throws IOException {
        this.writer.write("    public static Test suite() {");
        this.writer.newLine();
        this.writer.write("        TestSuite suite = new TestSuite();");
        this.writer.newLine();
        for (TestInfos testInfos : failedTests) {
            this.writer.write("        suite.addTest(");
            this.writer.write(String.valueOf(testInfos));
            this.writer.write(");");
            this.writer.newLine();
        }
        this.writer.write("        return suite;");
        this.writer.newLine();
        this.writer.write("    }");
        this.writer.newLine();
    }

    private void createClassFooter() throws IOException {
        this.writer.write("}");
        this.writer.newLine();
    }

    public void log(String message) {
        this.getProject().log("    [junit] " + message, 2);
    }

    public void verbose(String message) {
        this.getProject().log("    [junit] " + message, 3);
    }

    public void buildFinished(BuildEvent event) {
    }

    public void buildStarted(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
        if (!failedTests.isEmpty()) {
            this.writeJavaClass();
        }
    }

    public void taskStarted(BuildEvent event) {
    }

    public static class TestInfos
    implements Comparable<TestInfos> {
        private final String className;
        private final String methodName;

        public TestInfos(Test test) {
            this.className = test.getClass().getName();
            String methodName = test.toString();
            this.methodName = methodName.substring(0, methodName.indexOf(40));
        }

        public String toString() {
            return "new " + this.className + "(\"" + this.methodName + "\")";
        }

        @Override
        public int compareTo(TestInfos other) {
            return Comparator.comparing(Object::toString).compare(this, other);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof TestInfos && this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

