/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpInterpreter;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.support.Bundle;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public final class FileRunner {
    static final Logger LOGGER = Logger.getLogger(FileRunner.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(FileRunner.class);
    public static final ExecutionDescriptor.LineConvertorFactory PHP_LINE_CONVERTOR_FACTORY = new PhpLineConvertorFactory();
    final File file;
    volatile PhpProject project;
    volatile String command;
    volatile String phpArgs;
    volatile String fileArgs;
    volatile String workDir;
    volatile boolean debug = false;

    public FileRunner(File file) {
        this.file = file;
    }

    public FileRunner project(PhpProject project) {
        this.project = project;
        return this;
    }

    public FileRunner command(String command) {
        this.command = command;
        return this;
    }

    public FileRunner phpArgs(String phpArgs) {
        this.phpArgs = phpArgs;
        return this;
    }

    public FileRunner fileArgs(String fileArgs) {
        this.fileArgs = fileArgs;
        return this;
    }

    public FileRunner workDir(String workDir) {
        this.workDir = workDir;
        return this;
    }

    public void run() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                PhpExecutable executable = FileRunner.this.getExecutable(Bundle.FileRunner_run_displayName(FileRunner.this.getDisplayName()));
                executable.run(FileRunner.this.getDescriptor(FileRunner.this.getPostExecution(executable)));
            }
        });
    }

    public void debug() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                PhpExecutable executable = FileRunner.this.getExecutable(Bundle.FileRunner_debug_displayName(FileRunner.this.getDisplayName()));
                try {
                    executable.debug(FileUtil.toFileObject((File)FileRunner.this.file), FileRunner.this.getDescriptor(FileRunner.this.getPostExecution(executable)));
                }
                catch (ExecutionException ex) {
                    UiUtils.processExecutionException((ExecutionException)ex);
                }
            }
        });
    }

    PhpExecutable getExecutable(String displayName) {
        PhpExecutable executable = new PhpExecutable(this.command);
        if (StringUtils.hasText((String)this.workDir)) {
            executable.workDir(new File(this.workDir));
        } else {
            executable.workDir(this.file.getParentFile());
        }
        executable.displayName(displayName).viaAutodetection(false).viaPhpInterpreter(false).additionalParameters(this.getParams());
        return executable;
    }

    String getDisplayName() {
        return this.project != null ? this.project.getName() : this.file.getName();
    }

    private List<String> getParams() {
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.hasText((String)this.phpArgs)) {
            params.addAll(Arrays.asList(Utilities.parseParameters((String)this.phpArgs)));
        }
        params.add(this.file.getAbsolutePath());
        if (StringUtils.hasText((String)this.fileArgs)) {
            params.addAll(Arrays.asList(Utilities.parseParameters((String)this.fileArgs)));
        }
        return params;
    }

    ExecutionDescriptor getDescriptor(Runnable postExecution) {
        ExecutionDescriptor descriptor = PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.charset(Charset.forName(this.getEncoding())).controllable(true).optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory").outConvertorFactory(PHP_LINE_CONVERTOR_FACTORY);
        if (!this.getPhpOptions().isOpenResultInOutputWindow()) {
            descriptor = descriptor.inputOutput(InputOutput.NULL).frontWindow(false).frontWindowOnError(false);
        }
        if (postExecution != null) {
            descriptor = descriptor.postExecution(postExecution);
        }
        return descriptor;
    }

    private Runnable getPostExecution(PhpExecutable executable) {
        File tmpFile;
        if (this.getRedirectToFile() && (tmpFile = this.createTempFile()) != null) {
            String charset = FileEncodingQuery.getEncoding((FileObject)FileUtil.toFileObject((File)this.file)).name();
            executable.fileOutput(tmpFile, charset, false);
            return new PostExecution(tmpFile);
        }
        return null;
    }

    private String getEncoding() {
        return this.project != null ? ProjectPropertiesSupport.getEncoding(this.project) : FileEncodingQuery.getDefaultEncoding().name();
    }

    boolean getRedirectToFile() {
        return this.getPhpOptions().isOpenResultInBrowser() || this.getPhpOptions().isOpenResultInEditor();
    }

    File createTempFile() {
        try {
            File tmpFile = File.createTempFile(this.file.getName(), ".html");
            tmpFile.deleteOnExit();
            return tmpFile;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    private PhpOptions getPhpOptions() {
        return PhpOptions.getInstance();
    }

    private static final class PostExecution
    implements Runnable {
        private final File tmpFile;

        public PostExecution(File tmpFile) {
            this.tmpFile = tmpFile;
        }

        @Override
        public void run() {
            PhpOptions options = PhpOptions.getInstance();
            try {
                if (options.isOpenResultInBrowser()) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(Utilities.toURI((File)this.tmpFile).toURL());
                }
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
            if (options.isOpenResultInEditor()) {
                FileUtils.openFile((File)this.tmpFile);
            }
        }
    }

    private static final class PhpLineConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        private PhpLineConvertorFactory() {
        }

        public LineConvertor newLineConvertor() {
            LineConvertor[] lineConvertors = new LineConvertor[PhpInterpreter.LINE_PATTERNS.length];
            int i = 0;
            for (Pattern linePattern : PhpInterpreter.LINE_PATTERNS) {
                lineConvertors[i++] = LineConvertors.filePattern(null, (Pattern)linePattern, null, (int)1, (int)2);
            }
            return LineConvertors.proxy((LineConvertor[])lineConvertors);
        }
    }
}

