/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.base.Environment;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;

public final class ExternalProcessBuilder
implements Callable<Process> {
    private static final Logger LOGGER = Logger.getLogger(ExternalProcessBuilder.class.getName());
    private static final Pattern ESCAPED_PATTERN = Pattern.compile("\".*\"");
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private final String executable;
    private final File workingDirectory;
    private final boolean redirectErrorStream;
    private final List<String> arguments = new ArrayList<String>();
    private final List<File> paths = new ArrayList<File>();
    private final Map<String, String> envVariables = new HashMap<String, String>();

    public ExternalProcessBuilder(@NonNull String executable) {
        this(new BuilderData(executable));
    }

    private ExternalProcessBuilder(BuilderData builder) {
        this.executable = builder.executable;
        this.workingDirectory = builder.workingDirectory;
        this.redirectErrorStream = builder.redirectErrorStream;
        this.arguments.addAll(builder.arguments);
        this.paths.addAll(builder.paths);
        this.envVariables.putAll(builder.envVariables);
    }

    @NonNull
    @CheckReturnValue
    public ExternalProcessBuilder workingDirectory(@NonNull File workingDirectory) {
        Parameters.notNull((CharSequence)"workingDirectory", (Object)workingDirectory);
        BuilderData builder = new BuilderData(this);
        return new ExternalProcessBuilder(builder.workingDirectory(workingDirectory));
    }

    @NonNull
    @CheckReturnValue
    public ExternalProcessBuilder redirectErrorStream(boolean redirectErrorStream) {
        BuilderData builder = new BuilderData(this);
        return new ExternalProcessBuilder(builder.redirectErrorStream(redirectErrorStream));
    }

    @NonNull
    @CheckReturnValue
    public ExternalProcessBuilder prependPath(@NonNull File path) {
        Parameters.notNull((CharSequence)"path", (Object)path);
        BuilderData builder = new BuilderData(this);
        return new ExternalProcessBuilder(builder.prependPath(path));
    }

    @NonNull
    @CheckReturnValue
    public ExternalProcessBuilder addArgument(@NonNull String argument) {
        Parameters.notNull((CharSequence)"argument", (Object)argument);
        BuilderData builder = new BuilderData(this);
        return new ExternalProcessBuilder(builder.addArgument(argument));
    }

    @NonNull
    @CheckReturnValue
    public ExternalProcessBuilder addEnvironmentVariable(@NonNull String name, @NonNull String value) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"value", (Object)value);
        BuilderData builder = new BuilderData(this);
        return new ExternalProcessBuilder(builder.addEnvironmentVariable(name, value));
    }

    @Override
    @NonNull
    public Process call() throws IOException {
        ProcessBuilder builder = ProcessBuilder.getLocal();
        builder.setExecutable(this.executable);
        if (this.workingDirectory != null) {
            builder.setWorkingDirectory(this.workingDirectory.getPath());
        }
        builder.setArguments(this.arguments);
        builder.setRedirectErrorStream(this.redirectErrorStream);
        Environment env = builder.getEnvironment();
        for (File file : this.paths) {
            env.prependPath("PATH", file.getPath());
        }
        for (Map.Entry entry : this.envVariables.entrySet()) {
            env.setVariable((String)entry.getKey(), (String)entry.getValue());
        }
        this.adjustProxy(env);
        return builder.call();
    }

    private void adjustProxy(Environment env) {
        String proxy = ExternalProcessBuilder.getNetBeansHttpProxy();
        if (proxy != null && env.getVariable("HTTP_PROXY") == null && env.getVariable("http_proxy") == null) {
            env.setVariable("HTTP_PROXY", proxy);
            env.setVariable("http_proxy", proxy);
        }
    }

    private static String getNetBeansHttpProxy() {
        int port;
        String host = System.getProperty("http.proxyHost");
        if (host == null) {
            return null;
        }
        String portHttp = System.getProperty("http.proxyPort");
        try {
            port = Integer.parseInt(portHttp);
        }
        catch (NumberFormatException e) {
            port = 8080;
        }
        Preferences prefs = NbPreferences.root().node("org/netbeans/core");
        boolean useAuth = prefs.getBoolean(USE_PROXY_AUTHENTICATION, false);
        String auth = "";
        if (useAuth) {
            auth = prefs.get(PROXY_AUTHENTICATION_USERNAME, "") + ":" + prefs.get(PROXY_AUTHENTICATION_PASSWORD, "") + '@';
        }
        if (host.indexOf(58) == -1) {
            host = "http://" + auth + host;
        }
        return host + ":" + port;
    }

    private static class BuilderData {
        private final String executable;
        private File workingDirectory;
        private boolean redirectErrorStream;
        private List<String> arguments = new ArrayList<String>();
        private List<File> paths = new ArrayList<File>();
        private Map<String, String> envVariables = new HashMap<String, String>();

        public BuilderData(String executable) {
            this.executable = executable;
        }

        public BuilderData(ExternalProcessBuilder builder) {
            this.executable = builder.executable;
            this.workingDirectory = builder.workingDirectory;
            this.redirectErrorStream = builder.redirectErrorStream;
            this.arguments.addAll(builder.arguments);
            this.paths.addAll(builder.paths);
            this.envVariables.putAll(builder.envVariables);
        }

        public BuilderData workingDirectory(File workingDirectory) {
            assert (workingDirectory != null);
            this.workingDirectory = workingDirectory;
            return this;
        }

        public BuilderData redirectErrorStream(boolean redirectErrorStream) {
            this.redirectErrorStream = redirectErrorStream;
            return this;
        }

        public BuilderData prependPath(File path) {
            assert (path != null);
            this.paths.add(path);
            return this;
        }

        public BuilderData addArgument(String argument) {
            assert (argument != null);
            this.arguments.add(argument);
            return this;
        }

        public BuilderData addEnvironmentVariable(String name, String value) {
            assert (name != null);
            assert (value != null);
            this.envVariables.put(name, value);
            return this;
        }
    }
}

