/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.Status;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.EncryptedKey;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.ActAs;
import com.sun.xml.ws.security.trust.elements.AllowPostdating;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.IssuedTokens;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.RenewTarget;
import com.sun.xml.ws.security.trust.elements.Renewing;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.elements.ValidateTarget;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import com.sun.xml.ws.security.trust.elements.str.KeyIdentifier;
import com.sun.xml.ws.security.trust.elements.str.Reference;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.impl.bindings.BinarySecretType;
import com.sun.xml.ws.security.trust.impl.bindings.EntropyType;
import com.sun.xml.ws.security.trust.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenResponseCollectionType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenResponseType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenType;
import com.sun.xml.ws.security.trust.impl.elements.BinarySecretImpl;
import com.sun.xml.ws.security.trust.impl.elements.CancelTargetImpl;
import com.sun.xml.ws.security.trust.impl.elements.ClaimsImpl;
import com.sun.xml.ws.security.trust.impl.elements.EntropyImpl;
import com.sun.xml.ws.security.trust.impl.elements.IssuedTokensImpl;
import com.sun.xml.ws.security.trust.impl.elements.LifetimeImpl;
import com.sun.xml.ws.security.trust.impl.elements.OnBehalfOfImpl;
import com.sun.xml.ws.security.trust.impl.elements.RenewTargetImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestSecurityTokenImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestSecurityTokenResponseCollectionImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestSecurityTokenResponseImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedAttachedReferenceImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedProofTokenImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedSecurityTokenImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedTokenCancelledImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedUnattachedReferenceImpl;
import com.sun.xml.ws.security.trust.impl.elements.StatusImpl;
import com.sun.xml.ws.security.trust.impl.elements.UseKeyImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.DirectReferenceImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.KeyIdentifierImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.SecurityTokenReferenceImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.TrustNamespacePrefixMapper;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSTrustElementFactoryImpl
extends WSTrustElementFactory {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    private static final String RST = "RST";
    private static final String RSTRCollection = "RSTRCollection";

    @Override
    public RequestSecurityToken createRSTForIssue(URI tokenType, URI requestType, URI context, AppliesTo scopes, Claims claims, Entropy entropy, Lifetime lifetime) throws WSTrustException {
        if (tokenType == null && scopes == null) {
            log.log(Level.WARNING, LogStringsMessages.WST_1003_TOKENTYPE_APPLIESTO_NULL());
        }
        return new RequestSecurityTokenImpl(tokenType, requestType, context, scopes, claims, entropy, lifetime, null);
    }

    @Override
    public RequestSecurityTokenResponse createRSTRForIssue(URI tokenType, URI context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attachedReference, RequestedUnattachedReference unattachedRef, RequestedProofToken proofToken, Entropy entropy, Lifetime lifetime) throws WSTrustException {
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl(tokenType, context, token, scopes, attachedReference, unattachedRef, proofToken, entropy, lifetime, null);
        return rstr;
    }

    @Override
    public RequestSecurityTokenResponseCollection createRSTRCollectionForIssue(URI tokenType, URI context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attached, RequestedUnattachedReference unattached, RequestedProofToken proofToken, Entropy entropy, Lifetime lifetime) throws WSTrustException {
        RequestSecurityTokenResponseCollectionImpl rstrCollection = new RequestSecurityTokenResponseCollectionImpl(tokenType, context, token, scopes, attached, unattached, proofToken, entropy, lifetime);
        return rstrCollection;
    }

    @Override
    public RequestSecurityTokenResponse createRSTRForRenew(URI tokenType, URI context, RequestedSecurityToken token, RequestedAttachedReference attachedReference, RequestedUnattachedReference unattachedRef, RequestedProofToken proofToken, Entropy entropy, Lifetime lifetime) throws WSTrustException {
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl(tokenType, context, token, null, attachedReference, unattachedRef, proofToken, entropy, lifetime, null);
        return rstr;
    }

    @Override
    public IssuedTokens createIssuedTokens(RequestSecurityTokenResponseCollection issuedTokens) {
        return new IssuedTokensImpl(issuedTokens);
    }

    @Override
    public OnBehalfOf createOnBehalfOf(Token oboToken) {
        return new OnBehalfOfImpl(oboToken);
    }

    @Override
    public ValidateTarget createValidateTarget(Token token) {
        throw new UnsupportedOperationException("Unsupported operation: ValidateTarget");
    }

    @Override
    public ActAs createActAs(Token token) {
        throw new UnsupportedOperationException("Unsupported operation: createActAs");
    }

    @Override
    public Entropy createEntropy(BinarySecret secret) {
        return new EntropyImpl(secret);
    }

    @Override
    public Entropy createEntropy(EncryptedKey key) {
        return new EntropyImpl(key);
    }

    @Override
    public BinarySecret createBinarySecret(byte[] rawValue, String type) {
        return new BinarySecretImpl(rawValue, type);
    }

    @Override
    public BinarySecret createBinarySecret(Element elem) throws WSTrustException {
        return new BinarySecretImpl(BinarySecretImpl.fromElement(elem));
    }

    @Override
    public Lifetime createLifetime(AttributedDateTime created, AttributedDateTime expires) {
        return new LifetimeImpl(created, expires);
    }

    @Override
    public Claims createClaims(Element elem) throws WSTrustException {
        return new ClaimsImpl(ClaimsImpl.fromElement(elem));
    }

    @Override
    public Claims createClaims(Claims claims) throws WSTrustException {
        ClaimsImpl newClaims = new ClaimsImpl();
        if (claims != null) {
            newClaims.setDialect(claims.getDialect());
            newClaims.getAny().addAll(claims.getAny());
            newClaims.getOtherAttributes().putAll(claims.getOtherAttributes());
        }
        return newClaims;
    }

    @Override
    public Claims createClaims() throws WSTrustException {
        return new ClaimsImpl();
    }

    @Override
    public Status createStatus(String code, String reason) {
        return new StatusImpl(code, reason);
    }

    @Override
    public RequestedSecurityToken createRequestedSecurityToken(Token token) {
        return new RequestedSecurityTokenImpl(token);
    }

    @Override
    public RequestedSecurityToken createRequestedSecurityToken() {
        return new RequestedSecurityTokenImpl();
    }

    @Override
    public DirectReference createDirectReference(String valueType, String uri) {
        return new DirectReferenceImpl(valueType, uri);
    }

    public DirectReference createDirectReference(String valueType, String uri, String instanceId) {
        return new DirectReferenceImpl(valueType, uri, instanceId);
    }

    @Override
    public KeyIdentifier createKeyIdentifier(String valueType, String encodingType) {
        return new KeyIdentifierImpl(valueType, encodingType);
    }

    @Override
    public SecurityTokenReference createSecurityTokenReference(Reference ref) {
        return new SecurityTokenReferenceImpl(ref);
    }

    @Override
    public RequestedAttachedReference createRequestedAttachedReference(SecurityTokenReference str) {
        return new RequestedAttachedReferenceImpl(str);
    }

    @Override
    public RequestedUnattachedReference createRequestedUnattachedReference(SecurityTokenReference str) {
        return new RequestedUnattachedReferenceImpl(str);
    }

    @Override
    public RequestedProofToken createRequestedProofToken() {
        return new RequestedProofTokenImpl();
    }

    @Override
    public SecondaryParameters createSecondaryParameters() {
        throw new UnsupportedOperationException("Unsupported operation: createSecondaryParameters");
    }

    @Override
    public UseKey createUseKey(Token token, String sig) {
        UseKeyImpl useKey = new UseKeyImpl(token);
        if (sig != null) {
            useKey.setSignatureID(URI.create(sig));
        }
        return useKey;
    }

    @Override
    public RequestSecurityToken createRSTForRenew(URI tokenType, URI requestType, URI context, RenewTarget target, AllowPostdating apd, Renewing renewingInfo) {
        return new RequestSecurityTokenImpl(tokenType, requestType, context, target, apd, renewingInfo);
    }

    @Override
    public RenewTarget createRenewTarget(SecurityTokenReference str) {
        return new RenewTargetImpl(str);
    }

    @Override
    public CancelTarget createCancelTarget(SecurityTokenReference str) {
        return new CancelTargetImpl(str);
    }

    @Override
    public RequestSecurityToken createRSTForCancel(URI requestType, CancelTarget target) {
        return new RequestSecurityTokenImpl(null, requestType, target);
    }

    @Override
    public RequestSecurityTokenResponse createRSTRForCancel() {
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl();
        rstr.setRequestedTokenCancelled(new RequestedTokenCancelledImpl());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1008_CREATED_RSTR_CANCEL(rstr.toString()));
        }
        return rstr;
    }

    @Override
    public RequestSecurityToken createRSTForValidate(URI tokenType, URI requestType) {
        return new RequestSecurityTokenImpl(tokenType, requestType);
    }

    @Override
    public RequestSecurityTokenResponse createRSTRForValidate(URI tokenType, RequestedSecurityToken token, Status status) {
        return new RequestSecurityTokenResponseImpl(tokenType, null, token, null, null, null, null, null, null, status);
    }

    @Override
    public RequestSecurityToken createRST() {
        return new RequestSecurityTokenImpl();
    }

    @Override
    public RequestSecurityTokenResponse createRSTR() {
        return new RequestSecurityTokenResponseImpl();
    }

    @Override
    public RequestSecurityTokenResponseCollection createRSTRC(List<RequestSecurityTokenResponse> rstrs) {
        RequestSecurityTokenResponseCollectionImpl rstrc = new RequestSecurityTokenResponseCollectionImpl();
        rstrc.getRequestSecurityTokenResponses().addAll(rstrs);
        return rstrc;
    }

    @Override
    public RequestSecurityToken createRSTFrom(Source src) {
        try {
            Unmarshaller unmarshaller = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement<RequestSecurityTokenType> rstType = unmarshaller.unmarshal(src, RequestSecurityTokenType.class);
            RequestSecurityTokenType type = rstType.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0006_FAIL_RST_SOURCE(src.toString()), ex);
            throw new RuntimeException(LogStringsMessages.WST_0006_FAIL_RST_SOURCE(src.toString()), ex);
        }
    }

    @Override
    public RequestSecurityToken createRSTFrom(Element elem) {
        try {
            Unmarshaller unmarshaller = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement<RequestSecurityTokenType> rstType = unmarshaller.unmarshal(elem, RequestSecurityTokenType.class);
            RequestSecurityTokenType type = rstType.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0007_FAIL_RST_ELEM(elem.toString()), ex);
            throw new RuntimeException(LogStringsMessages.WST_0007_FAIL_RST_ELEM(elem.toString()), ex);
        }
    }

    @Override
    public RequestSecurityTokenResponse createRSTRFrom(Source src) {
        try {
            Unmarshaller unmarshaller = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement<RequestSecurityTokenResponseType> rstType = unmarshaller.unmarshal(src, RequestSecurityTokenResponseType.class);
            RequestSecurityTokenResponseType type = rstType.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0008_FAIL_RSTR_SOURCE(src.toString()), ex);
            throw new RuntimeException(LogStringsMessages.WST_0008_FAIL_RSTR_SOURCE(src.toString()), ex);
        }
    }

    @Override
    public RequestSecurityTokenResponse createRSTRFrom(Element elem) {
        try {
            Unmarshaller unmarshaller = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement<RequestSecurityTokenResponseType> rstType = unmarshaller.unmarshal(elem, RequestSecurityTokenResponseType.class);
            RequestSecurityTokenResponseType type = rstType.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0008_FAIL_RSTR_SOURCE(elem.toString()), ex);
            throw new RuntimeException(LogStringsMessages.WST_0008_FAIL_RSTR_SOURCE(elem.toString()), ex);
        }
    }

    @Override
    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(Source src) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement<RequestSecurityTokenResponseCollectionType> rstrcType = u.unmarshal(src, RequestSecurityTokenResponseCollectionType.class);
            RequestSecurityTokenResponseCollectionType type = rstrcType.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(Element elem) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement<RequestSecurityTokenResponseCollectionType> rstrcType = u.unmarshal(elem, RequestSecurityTokenResponseCollectionType.class);
            RequestSecurityTokenResponseCollectionType type = rstrcType.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public RequestSecurityToken createRSTFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenType type = (RequestSecurityTokenType)elem.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE(RST), e);
            throw new RuntimeException(LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE(RST), e);
        }
    }

    @Override
    public RequestSecurityTokenResponse createRSTRFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenResponseType type = (RequestSecurityTokenResponseType)elem.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0009_FAIL_RSTR_ELEM(elem.toString()), e);
            throw new RuntimeException(LogStringsMessages.WST_0009_FAIL_RSTR_ELEM(elem.toString()), e);
        }
    }

    @Override
    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenResponseCollectionType type = (RequestSecurityTokenResponseCollectionType)elem.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE(RSTRCollection), e);
            throw new RuntimeException(LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE(RSTRCollection), e);
        }
    }

    @Override
    public SecurityTokenReference createSecurityTokenReference(JAXBElement elem) {
        try {
            SecurityTokenReferenceType type = (SecurityTokenReferenceType)elem.getValue();
            return new SecurityTokenReferenceImpl(type);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE("STR"), e);
            throw new RuntimeException(LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE("STR"), e);
        }
    }

    @Override
    public SecurityContextToken createSecurityContextToken(URI identifier, String instance, String wsuId) {
        throw new UnsupportedOperationException("this operation is not supported");
    }

    @Override
    public JAXBElement toJAXBElement(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toJAXBElement((RequestSecurityToken)request);
        }
        return null;
    }

    @Override
    public JAXBElement toJAXBElement(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toJAXBElement((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toJAXBElement((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    @Override
    public JAXBElement toJAXBElement(SecurityTokenReference str) {
        JAXBElement<SecurityTokenReferenceType> strElement = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)((Object)str));
        return strElement;
    }

    @Override
    public JAXBElement toJAXBElement(RequestSecurityToken rst) {
        JAXBElement<RequestSecurityTokenType> rstElement = new ObjectFactory().createRequestSecurityToken((RequestSecurityTokenType)((Object)rst));
        return rstElement;
    }

    @Override
    public JAXBElement toJAXBElement(RequestSecurityTokenResponse rstr) {
        JAXBElement<RequestSecurityTokenResponseType> rstElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)((Object)rstr));
        return rstElement;
    }

    public JAXBElement toJAXBElement(Entropy entropy) {
        JAXBElement<EntropyType> etElement = new ObjectFactory().createEntropy((EntropyType)((Object)entropy));
        return etElement;
    }

    @Override
    public JAXBElement toJAXBElement(RequestSecurityTokenResponseCollection rstrCollection) {
        JAXBElement<RequestSecurityTokenResponseCollectionType> rstElement = new ObjectFactory().createRequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)((Object)rstrCollection));
        return rstElement;
    }

    @Override
    public Source toSource(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toSource((RequestSecurityToken)request);
        }
        return null;
    }

    @Override
    public Source toSource(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toSource((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toSource((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    @Override
    public Source toSource(RequestSecurityToken rst) {
        try {
            return new JAXBSource(this.getMarshaller(), (Object)this.toJAXBElement(rst));
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE(RST), ex);
            throw new RuntimeException(LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE(RST), ex);
        }
    }

    @Override
    public Source toSource(RequestSecurityTokenResponse rstr) {
        try {
            return new JAXBSource(this.getMarshaller(), (Object)this.toJAXBElement(rstr));
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE("RSTR"), ex);
            throw new RuntimeException(LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE("RSTR"), ex);
        }
    }

    @Override
    public Source toSource(RequestSecurityTokenResponseCollection rstrCollection) {
        try {
            return new JAXBSource(this.getMarshaller(), (Object)this.toJAXBElement(rstrCollection));
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE(RSTRCollection), ex);
            throw new RuntimeException(LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE(RSTRCollection), ex);
        }
    }

    @Override
    public Element toElement(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toElement((RequestSecurityToken)request);
        }
        return null;
    }

    @Override
    public Element toElement(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toElement((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toElement((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    @Override
    public Element toElement(RequestSecurityToken rst) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenType> rstElement = new ObjectFactory().createRequestSecurityToken((RequestSecurityTokenType)((Object)rst));
            this.getMarshaller().marshal(rstElement, doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), e);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), e);
        }
    }

    @Override
    public Element toElement(RequestSecurityTokenResponse rstr) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenResponseType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)((Object)rstr));
            this.getMarshaller().marshal(rstrElement, doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    @Override
    public Element toElement(RequestSecurityTokenResponse rstr, Document doc) {
        try {
            JAXBElement<RequestSecurityTokenResponseType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)((Object)rstr));
            this.getMarshaller().marshal(rstrElement, doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    @Override
    public Element toElement(RequestSecurityTokenResponseCollection rstrCollection) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenResponseCollectionType> rstElement = new ObjectFactory().createRequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)((Object)rstrCollection));
            this.getMarshaller().marshal(rstElement, doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    @Override
    public Element toElement(BinarySecret secret) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)((Object)secret));
            this.getMarshaller().marshal(bsElement, doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    @Override
    public Element toElement(SecurityTokenReference str, Document doc) {
        try {
            if (doc == null) {
                doc = WSTrustUtil.newDocument();
            }
            JAXBElement<SecurityTokenReferenceType> strElement = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)((Object)str));
            this.getMarshaller().marshal(strElement, doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    @Override
    public Element toElement(BinarySecret secret, Document doc) {
        try {
            if (doc == null) {
                doc = WSTrustUtil.newDocument();
            }
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)((Object)secret));
            this.getMarshaller().marshal(bsElement, doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    @Override
    public Marshaller getMarshaller() {
        try {
            Marshaller marshaller = WSTrustElementFactoryImpl.getContext().createMarshaller();
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new TrustNamespacePrefixMapper());
            return marshaller;
        }
        catch (PropertyException e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), e);
            throw new RuntimeException(LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), e);
        }
        catch (JAXBException jbe) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), jbe);
            throw new RuntimeException(LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), jbe);
        }
    }
}

