/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import org.netbeans.modules.netserver.websocket.AbstractWSHandler7;
import org.netbeans.modules.netserver.websocket.Utils;
import org.netbeans.modules.netserver.websocket.WebSocketClientImpl;

class WebSocketHandlerClient7
extends AbstractWSHandler7<WebSocketClientImpl> {
    private boolean handshakeRed;
    private int version;
    private String myGeneratedKey;

    WebSocketHandlerClient7(WebSocketClientImpl webSocketClient, int version) {
        super(webSocketClient);
        this.version = version;
    }

    @Override
    public void sendHandshake() {
        StringBuilder builder = new StringBuilder("GET");
        builder.append(' ');
        builder.append(((WebSocketClientImpl)this.getWebSocketPoint()).getUri().getPath());
        builder.append(' ');
        builder.append("HTTP/1.1");
        builder.append("\r\n");
        builder.append("Host");
        builder.append(": ");
        builder.append(((WebSocketClientImpl)this.getWebSocketPoint()).getUri().getHost());
        builder.append("\r\n");
        builder.append("Upgrade: websocket");
        builder.append("\r\n");
        builder.append("Connection: Upgrade");
        builder.append("\r\n");
        if (this.version >= 7 && this.version <= 10) {
            builder.append("Sec-WebSocket-Origin: ");
        } else {
            builder.append("Origin: ");
        }
        builder.append(Utils.getOrigin(((WebSocketClientImpl)this.getWebSocketPoint()).getUri()));
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Protocol: chat");
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Version: ");
        if (this.version == 7) {
            builder.append(this.version);
        } else if (this.version > 7 && this.version < 13) {
            builder.append(8);
        } else {
            builder.append(13);
        }
        builder.append("\r\n");
        builder.append("Sec-WebSocket-Key");
        builder.append(": ");
        builder.append(this.getSecKey());
        builder.append("\r\n");
        builder.append("\r\n");
        ((WebSocketClientImpl)this.getWebSocketPoint()).send(builder.toString().getBytes(Charset.forName("UTF-8")), ((WebSocketClientImpl)this.getWebSocketPoint()).getKey());
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws IOException {
        if (this.handshakeRed) {
            super.read(byteBuffer);
        } else {
            this.readHandshake(byteBuffer);
            this.handshakeRed = true;
            ((WebSocketClientImpl)this.getWebSocketPoint()).getWebSocketReadHandler().accepted(this.getKey());
        }
    }

    @Override
    protected boolean isClient() {
        return true;
    }

    @Override
    protected void readDelegate(byte[] bytes, int dataType) {
        ((WebSocketClientImpl)this.getWebSocketPoint()).getWebSocketReadHandler().read(this.getKey(), bytes, dataType);
    }

    @Override
    protected boolean verifyMask(boolean hasMask) throws IOException {
        return true;
    }

    @Override
    protected SelectionKey getKey() {
        return ((WebSocketClientImpl)this.getWebSocketPoint()).getKey();
    }

    private void readHandshake(ByteBuffer buffer) throws IOException {
        List<String> headers = Utils.readHttpRequest(((WebSocketClientImpl)this.getWebSocketPoint()).getChannel(), buffer);
        String acceptKey = null;
        String accept = "Sec-WebSocket-Accept:";
        for (String header : headers) {
            if (!header.startsWith(accept)) continue;
            acceptKey = header.substring(accept.length()).trim();
        }
        if (acceptKey == null) {
            throw new IOException("Wrong accept key on handshake received");
        }
        String requiredKey = this.generateAcceptKey(this.getSecKey());
        if (!acceptKey.equals(requiredKey)) {
            throw new IOException("Wrong accept key on handshake received: " + requiredKey + " while expected is :" + requiredKey);
        }
    }

    private String getSecKey() {
        if (this.myGeneratedKey == null) {
            byte[] bytes = new byte[16];
            this.getRandom().nextBytes(bytes);
            this.myGeneratedKey = Base64.getEncoder().encodeToString(bytes);
        }
        return this.myGeneratedKey;
    }
}

