/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.options;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.debugger.Properties;

public class Options {
    private static final String PROPERTIES_VISUAL = "debugger.options.JPDA.visual";
    public static final String PROPERTY_TCC = "TrackComponentChanges";
    public static final String PROPERTY_UPLOAD_AGENT = "UploadAgent";
    private static Reference<Properties> propertiesRef = new WeakReference<Object>(null);

    private Options() {
    }

    private static boolean isUploadAgentDefault() {
        return true;
    }

    private static boolean isTrackComponentChangesDefault() {
        return false;
    }

    public static synchronized Properties getProperties() {
        Properties properties = propertiesRef.get();
        if (properties == null) {
            properties = Properties.getDefault().getProperties(PROPERTIES_VISUAL);
            propertiesRef = new WeakReference<Properties>(properties);
        }
        return properties;
    }

    public static boolean isUploadAgent() {
        return Options.getProperties().getBoolean(PROPERTY_UPLOAD_AGENT, Options.isUploadAgentDefault());
    }

    public static boolean isTrackComponentChanges() {
        return Options.getProperties().getBoolean(PROPERTY_TCC, Options.isTrackComponentChangesDefault());
    }

    public static void setUploadAgent(boolean ua) {
        Options.getProperties().setBoolean(PROPERTY_UPLOAD_AGENT, ua);
    }

    public static void setTrackComponentChanges(boolean tcc) {
        Options.getProperties().setBoolean(PROPERTY_TCC, tcc);
    }
}

