/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.nodes.ClassInstanceCreationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.UseTraitStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public class ASTNodeInfo<T extends ASTNode> {
    private final T node;
    private Kind kind;

    ASTNodeInfo(T node) {
        this.node = node;
    }

    ASTNodeInfo(Kind kind, T node) {
        this.kind = kind;
        this.node = node;
    }

    public String getName() {
        return ASTNodeInfo.toName(this.getOriginalNode());
    }

    public QualifiedName getQualifiedName() {
        return ASTNodeInfo.toQualifiedName(this.node, false);
    }

    public static QualifiedName toQualifiedName(ASTNode node, boolean type) {
        String toName;
        ASTNode cname;
        QualifiedName retval = null;
        if (node instanceof FunctionInvocation) {
            FunctionInvocation fi = (FunctionInvocation)node;
            retval = QualifiedName.create(fi.getFunctionName().getName());
        } else if (node instanceof ClassName) {
            cname = (ClassName)node;
            retval = QualifiedName.create(cname.getName());
        } else if (node instanceof Identifier) {
            cname = (Identifier)node;
            retval = QualifiedName.createUnqualifiedName((Identifier)cname);
        } else if (node instanceof NamespaceName) {
            retval = QualifiedName.create((NamespaceName)node);
        } else if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation instanceCreation = (ClassInstanceCreation)node;
            retval = QualifiedName.create(instanceCreation.getClassName().getName());
        } else if (node instanceof SingleUseStatementPart) {
            SingleUseStatementPart statementPart = (SingleUseStatementPart)node;
            retval = QualifiedName.create(statementPart.getName());
        } else if (type && node instanceof StaticDispatch) {
            StaticDispatch staticDispatch = (StaticDispatch)node;
            retval = QualifiedName.create(staticDispatch.getDispatcher());
        } else if (node instanceof Scalar) {
            toName = ASTNodeInfo.toName(node);
            retval = QualifiedName.create(toName);
        }
        if (retval == null) {
            toName = ASTNodeInfo.toName(node);
            retval = toName == null ? QualifiedName.createUnqualifiedName("") : QualifiedName.createUnqualifiedName(toName);
        }
        return retval;
    }

    public Kind getKind() {
        return this.kind == null ? ASTNodeInfo.toKind(this.getOriginalNode()) : this.kind;
    }

    public PhpElementKind getPhpElementKind() {
        Kind k = this.getKind();
        switch (k) {
            case INCLUDE: {
                return PhpElementKind.INCLUDE;
            }
            case IFACE: {
                return PhpElementKind.IFACE;
            }
            case CLASS: {
                return PhpElementKind.CLASS;
            }
            case CLASS_INSTANCE_CREATION: {
                return PhpElementKind.CLASS;
            }
            case METHOD: {
                return PhpElementKind.METHOD;
            }
            case STATIC_METHOD: {
                return PhpElementKind.METHOD;
            }
            case FIELD: {
                return PhpElementKind.FIELD;
            }
            case STATIC_FIELD: {
                return PhpElementKind.FIELD;
            }
            case CLASS_CONSTANT: {
                return PhpElementKind.TYPE_CONSTANT;
            }
            case STATIC_CLASS_CONSTANT: {
                return PhpElementKind.TYPE_CONSTANT;
            }
            case VARIABLE: {
                return PhpElementKind.VARIABLE;
            }
            case CONSTANT: {
                return PhpElementKind.CONSTANT;
            }
            case FUNCTION: {
                return PhpElementKind.FUNCTION;
            }
            case USE_STATEMENT: {
                return PhpElementKind.USE_STATEMENT;
            }
            case GROUP_USE_STATEMENT: {
                return PhpElementKind.GROUP_USE_STATEMENT;
            }
            case TRAIT: {
                return PhpElementKind.TRAIT;
            }
            case USE_ALIAS: {
                return PhpElementKind.USE_ALIAS;
            }
            case ENUM: {
                return PhpElementKind.ENUM;
            }
            case ENUM_CASE: {
                return PhpElementKind.ENUM_CASE;
            }
        }
        assert (false) : k;
        throw new IllegalStateException();
    }

    public OffsetRange getRange() {
        return ASTNodeInfo.toOffsetRange(this.getOriginalNode());
    }

    public final T getOriginalNode() {
        return this.node;
    }

    public static ASTNodeInfo<FieldAccess> create(FieldAccess fieldAccess) {
        return new ASTNodeInfo<FieldAccess>(fieldAccess);
    }

    public static ASTNodeInfo<SingleUseStatementPart> create(SingleUseStatementPart statementPart) {
        return new ASTNodeInfo<SingleUseStatementPart>(statementPart);
    }

    public static ASTNodeInfo<GotoStatement> create(GotoStatement statement) {
        return new ASTNodeInfo<GotoStatement>(statement);
    }

    public static ASTNodeInfo<GotoLabel> create(GotoLabel label) {
        return new ASTNodeInfo<GotoLabel>(label);
    }

    public static ASTNodeInfo<FunctionInvocation> create(FunctionInvocation functionInvocation) {
        return new ASTNodeInfo<FunctionInvocation>(functionInvocation);
    }

    public static ASTNodeInfo<Variable> create(Variable variable) {
        return new ASTNodeInfo<Variable>(variable);
    }

    public static ASTNodeInfo<StaticDispatch> create(StaticDispatch staticDispatch) {
        return new ASTNodeInfo<StaticDispatch>(staticDispatch);
    }

    public static ASTNodeInfo<StaticMethodInvocation> create(StaticMethodInvocation staticMethodInvocation) {
        return new ASTNodeInfo<StaticMethodInvocation>(staticMethodInvocation);
    }

    public static ASTNodeInfo<StaticFieldAccess> create(StaticFieldAccess staticFieldAccess) {
        return new ASTNodeInfo<StaticFieldAccess>(staticFieldAccess);
    }

    public static ASTNodeInfo<StaticConstantAccess> create(StaticConstantAccess staticConstantAccess) {
        return new ASTNodeInfo<StaticConstantAccess>(staticConstantAccess);
    }

    public static ASTNodeInfo<ClassInstanceCreation> create(ClassInstanceCreation instanceCreation) {
        if (instanceCreation.isAnonymous()) {
            return ClassInstanceCreationInfo.create(instanceCreation);
        }
        return new ASTNodeInfo<ClassInstanceCreation>(instanceCreation);
    }

    public static ASTNodeInfo<ClassName> create(ClassName className) {
        return new ASTNodeInfo<ClassName>(className);
    }

    public static ASTNodeInfo<Expression> create(Kind kind, NamespaceName namespaceName) {
        return new ASTNodeInfo<Expression>(kind, namespaceName);
    }

    public static ASTNodeInfo<Expression> create(Kind kind, Identifier identifier) {
        return new ASTNodeInfo<Expression>(kind, identifier);
    }

    public static ASTNodeInfo<Scalar> create(Kind kind, Scalar scalar) {
        return new ASTNodeInfo<Scalar>(kind, scalar);
    }

    public static ASTNodeInfo<MethodInvocation> create(MethodInvocation methodInvocation) {
        return new ASTNodeInfo<MethodInvocation>(methodInvocation);
    }

    public static ASTNodeInfo<ReturnStatement> create(ReturnStatement returnStatement) {
        return new ASTNodeInfo<ReturnStatement>(returnStatement);
    }

    private static Kind toKind(ASTNode node) {
        if (node instanceof GotoStatement) {
            return Kind.GOTO;
        }
        if (node instanceof GotoLabel) {
            return Kind.GOTO;
        }
        if (node instanceof FunctionInvocation) {
            return Kind.FUNCTION;
        }
        if (node instanceof Variable) {
            return Kind.VARIABLE;
        }
        if (node instanceof StaticMethodInvocation) {
            return Kind.STATIC_METHOD;
        }
        if (node instanceof StaticFieldAccess) {
            return Kind.STATIC_FIELD;
        }
        if (node instanceof MethodInvocation) {
            return Kind.METHOD;
        }
        if (node instanceof StaticConstantAccess) {
            return Kind.STATIC_CLASS_CONSTANT;
        }
        if (node instanceof ClassName) {
            return Kind.CLASS;
        }
        if (node instanceof ClassInstanceCreation) {
            return Kind.CLASS_INSTANCE_CREATION;
        }
        if (node instanceof FieldAccess) {
            return Kind.FIELD;
        }
        if (node instanceof ReturnStatement) {
            return Kind.RETURN_MARKER;
        }
        if (node instanceof SingleUseStatementPart) {
            return Kind.USE_STATEMENT;
        }
        if (node instanceof GroupUseStatementPart) {
            return Kind.GROUP_USE_STATEMENT;
        }
        throw new IllegalStateException(node.getClass().getName());
    }

    protected static String toName(ASTNode node) {
        if (node instanceof GotoStatement) {
            GotoStatement gotoStatement = (GotoStatement)node;
            return gotoStatement.getLabel().getName();
        }
        if (node instanceof GotoLabel) {
            GotoLabel gotoLabel = (GotoLabel)node;
            return gotoLabel.getName().getName();
        }
        if (node instanceof FunctionInvocation) {
            FunctionInvocation fi = (FunctionInvocation)node;
            return CodeUtils.extractFunctionName(fi);
        }
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            return ASTNodeInfo.toNameVar(var);
        }
        if (node instanceof StaticMethodInvocation) {
            StaticMethodInvocation smi = (StaticMethodInvocation)node;
            return ASTNodeInfo.toName(smi.getMethod());
        }
        if (node instanceof StaticFieldAccess) {
            StaticFieldAccess sfa = (StaticFieldAccess)node;
            return ASTNodeInfo.toNameField(sfa.getField());
        }
        if (node instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)node;
            return ASTNodeInfo.toName(mi.getMethod());
        }
        if (node instanceof StaticConstantAccess) {
            StaticConstantAccess sca = (StaticConstantAccess)node;
            return sca.getConstantName().getName();
        }
        if (node instanceof ClassName) {
            ClassName cname = (ClassName)node;
            return CodeUtils.extractClassName(cname);
        }
        if (node instanceof Identifier) {
            Identifier cname = (Identifier)node;
            return cname.getName();
        }
        if (node instanceof NamespaceName) {
            return ASTNodeInfo.toName(CodeUtils.extractUnqualifiedIdentifier((NamespaceName)node));
        }
        if (node instanceof Scalar) {
            Scalar scalar = (Scalar)node;
            return NavUtils.isQuoted(scalar.getStringValue()) ? NavUtils.dequote(scalar.getStringValue()) : scalar.getStringValue();
        }
        if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation instanceCreation = (ClassInstanceCreation)node;
            return ASTNodeInfo.toName(instanceCreation.getClassName());
        }
        if (node instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)node;
            return ASTNodeInfo.toNameField(fieldAccess.getField());
        }
        if (node instanceof ReturnStatement) {
            return "return";
        }
        if (node instanceof Reference) {
            return ASTNodeInfo.toName(((Reference)node).getExpression());
        }
        if (node instanceof SingleUseStatementPart) {
            return ASTNodeInfo.toQualifiedName(node, false).toString();
        }
        if (node instanceof GroupUseStatementPart) {
            assert (false) : "should not get here: " + node;
            return "?? GroupUseStatementPart ??";
        }
        if (node instanceof Variadic) {
            return ASTNodeInfo.toName(((Variadic)node).getExpression());
        }
        throw new IllegalStateException(node.getClass().toString());
    }

    protected static OffsetRange toOffsetRange(ASTNode node) {
        if (node instanceof GotoStatement) {
            GotoStatement gotoStatement = (GotoStatement)node;
            return ASTNodeInfo.toOffsetRange(gotoStatement.getLabel());
        }
        if (node instanceof GotoLabel) {
            GotoLabel gotoLabel = (GotoLabel)node;
            return ASTNodeInfo.toOffsetRange(gotoLabel.getName());
        }
        if (node instanceof FunctionInvocation) {
            return ASTNodeInfo.toOffsetRange(((FunctionInvocation)node).getFunctionName().getName());
        }
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            return ASTNodeInfo.toOffsetRangeVar(var);
        }
        if (node instanceof StaticMethodInvocation) {
            StaticMethodInvocation smi = (StaticMethodInvocation)node;
            return ASTNodeInfo.toOffsetRange(smi.getMethod());
        }
        if (node instanceof StaticFieldAccess) {
            StaticFieldAccess sfa = (StaticFieldAccess)node;
            return ASTNodeInfo.toOffsetRange(sfa.getField());
        }
        if (node instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)node;
            return ASTNodeInfo.toOffsetRange(mi.getMethod());
        }
        if (node instanceof StaticConstantAccess) {
            StaticConstantAccess sca = (StaticConstantAccess)node;
            Identifier constant = sca.getConstantName();
            return new OffsetRange(constant.getStartOffset(), constant.getEndOffset());
        }
        if (node instanceof ClassName) {
            Identifier id = CodeUtils.extractUnqualifiedIdentifier(((ClassName)node).getName());
            if (id == null) {
                return new OffsetRange(node.getStartOffset(), node.getEndOffset());
            }
            return new OffsetRange(id.getStartOffset(), id.getEndOffset());
        }
        if (node instanceof Identifier) {
            Identifier cname = (Identifier)node;
            return new OffsetRange(cname.getStartOffset(), cname.getEndOffset());
        }
        if (node instanceof NamespaceName) {
            return ASTNodeInfo.toOffsetRange(CodeUtils.extractUnqualifiedIdentifier((NamespaceName)node));
        }
        if (node instanceof Scalar) {
            Scalar scalar = (Scalar)node;
            if (NavUtils.isQuoted(scalar.getStringValue())) {
                return new OffsetRange(node.getStartOffset() + 1, node.getEndOffset() - 1);
            }
            return new OffsetRange(node.getStartOffset(), node.getEndOffset());
        }
        if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation instanceCreation = (ClassInstanceCreation)node;
            return ASTNodeInfo.toOffsetRange(instanceCreation.getClassName());
        }
        if (node instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)node;
            return ASTNodeInfo.toOffsetRange(fieldAccess.getField());
        }
        if (node instanceof ReturnStatement) {
            ReturnStatement returnStatement = (ReturnStatement)node;
            return new OffsetRange(returnStatement.getStartOffset(), returnStatement.getEndOffset());
        }
        if (node instanceof Reference) {
            return ASTNodeInfo.toOffsetRange(((Reference)node).getExpression());
        }
        if (node instanceof SingleUseStatementPart || node instanceof GroupUseStatementPart) {
            return new OffsetRange(node.getStartOffset(), node.getEndOffset());
        }
        if (node instanceof Variadic) {
            return ASTNodeInfo.toOffsetRange(((Variadic)node).getExpression());
        }
        if (node instanceof ParenthesisExpression) {
            return ASTNodeInfo.toOffsetRange(((ParenthesisExpression)node).getExpression());
        }
        if (node instanceof LambdaFunctionDeclaration) {
            return new OffsetRange(node.getStartOffset(), node.getEndOffset());
        }
        if (node instanceof ArrowFunctionDeclaration) {
            return new OffsetRange(node.getStartOffset(), node.getEndOffset());
        }
        if (node instanceof ArrayCreation) {
            return new OffsetRange(node.getStartOffset(), node.getEndOffset());
        }
        throw new IllegalStateException(node.getClass().toString());
    }

    static String toNameVar(Variable var) {
        return CodeUtils.extractVariableName(var);
    }

    static String toNameField(Variable var) {
        String retval = CodeUtils.extractVariableName(var);
        if (retval != null && !retval.startsWith("$")) {
            retval = "$" + retval;
        }
        return retval;
    }

    public static OffsetRange toOffsetRangeVar(Variable node) {
        Expression name = node.getName();
        while (name instanceof Variable) {
            while (name instanceof ArrayAccess) {
                ArrayAccess access = (ArrayAccess)name;
                name = access.getName();
            }
            if (!(name instanceof Variable)) continue;
            Variable var = (Variable)name;
            name = var.getName();
        }
        return new OffsetRange(name.getStartOffset(), name.getEndOffset());
    }

    static class UsedTraitsVisitor
    extends DefaultVisitor {
        private final List<UseTraitStatementPart> useParts = new LinkedList<UseTraitStatementPart>();

        UsedTraitsVisitor() {
        }

        @Override
        public void visit(UseTraitStatementPart node) {
            this.useParts.add(node);
        }

        public Collection<QualifiedName> getUsedTraits() {
            HashSet<QualifiedName> retval = new HashSet<QualifiedName>();
            for (UseTraitStatementPart useTraitStatementPart : this.useParts) {
                retval.add(QualifiedName.create(useTraitStatementPart.getName()));
            }
            return retval;
        }
    }

    public static enum Kind {
        NAMESPACE_DECLARATION,
        USE_STATEMENT,
        GROUP_USE_STATEMENT,
        IFACE,
        CLASS,
        CLASS_INSTANCE_CREATION,
        METHOD,
        STATIC_METHOD,
        FIELD,
        STATIC_FIELD,
        CLASS_CONSTANT,
        STATIC_CLASS_CONSTANT,
        VARIABLE,
        CONSTANT,
        FUNCTION,
        PARAMETER,
        INCLUDE,
        RETURN_MARKER,
        GOTO,
        TRAIT,
        USE_ALIAS,
        ENUM,
        ENUM_CASE;

    }
}

