/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.FormCodeSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.openide.nodes.Node;

public class BorderLayoutSupport
extends AbstractLayoutSupport {
    private String assistantParams;

    @Override
    public Class getSupportedClass() {
        return BorderLayout.class;
    }

    @Override
    public LayoutConstraints getNewConstraints(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        if (component != null && component.getParent() != containerDelegate) {
            component = null;
        }
        String primary = "Center";
        String alternateX = null;
        String alternateY = null;
        int w = containerDelegate.getSize().width;
        int h = containerDelegate.getSize().height;
        Insets contInsets = containerDelegate.getInsets();
        int marginW = this.getMargin(w - contInsets.left - contInsets.right);
        int marginH = this.getMargin(h - contInsets.top - contInsets.bottom);
        int xC = 1;
        int yC = 1;
        if (w > 25) {
            if (posInCont.x < contInsets.left + marginW) {
                xC = 0;
            } else if (posInCont.x >= w - marginW - contInsets.right) {
                xC = 2;
            }
        }
        if (h > 25) {
            if (posInCont.y < contInsets.top + marginH) {
                yC = 0;
            } else if (posInCont.y >= h - marginH - contInsets.bottom) {
                yC = 2;
            }
        }
        if (xC == 0) {
            primary = "Before";
        } else if (xC == 2) {
            primary = "After";
        } else {
            String string = alternateX = posInCont.x - contInsets.left < (w - contInsets.left - contInsets.right) / 2 ? "Before" : "After";
        }
        if (yC == 0) {
            alternateX = primary;
            primary = "First";
        } else if (yC == 2) {
            alternateX = primary;
            primary = "Last";
        } else {
            alternateY = posInCont.y - contInsets.top < (h - contInsets.top - contInsets.bottom) / 2 ? "First" : "Last";
        }
        String[] suggested = new String[]{primary, alternateY, alternateX};
        String[] free = this.findFreePositions();
        for (int i = 0; i < suggested.length; ++i) {
            int idx;
            String str = suggested[i];
            if (str == null) continue;
            for (int j = 0; j < free.length; ++j) {
                if (!free[j].equals(str)) continue;
                if (this.isAWTContainer()) {
                    str = (String)BorderLayoutSupport.toAbsolute(str);
                }
                this.assistantParams = str;
                return new BorderConstraints(str);
            }
            if (component == null || containerDelegate.getComponent(idx = this.getComponentOnPosition(str)) != component) continue;
            if (this.isAWTContainer()) {
                str = (String)BorderLayoutSupport.toAbsolute(str);
            }
            this.assistantParams = str;
            return new BorderConstraints(str);
        }
        if (this.isAWTContainer()) {
            free[0] = (String)BorderLayoutSupport.toAbsolute(free[0]);
        }
        this.assistantParams = free[0];
        return new BorderConstraints(free[0]);
    }

    private boolean isAWTContainer() {
        Container cont = this.getLayoutContext().getPrimaryContainer();
        return cont != null && !(cont instanceof JComponent) && !(cont instanceof RootPaneContainer);
    }

    @Override
    public String getAssistantContext() {
        return "borderLayout";
    }

    @Override
    public Object[] getAssistantParams() {
        return new Object[]{this.assistantParams};
    }

    @Override
    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        int y2;
        int y1;
        int x2;
        int x1;
        String position = (String)newConstraints.getConstraintsObject();
        Component[] comps = containerDelegate.getComponents();
        Dimension contSize = containerDelegate.getSize();
        Insets contInsets = containerDelegate.getInsets();
        Dimension compPrefSize = component != null ? component.getPreferredSize() : new Dimension(0, 0);
        int marginW = this.getMargin(contSize.width - contInsets.left - contInsets.right);
        int marginH = this.getMargin(contSize.height - contInsets.top - contInsets.bottom);
        if ("First".equals(position) || "North".equals(position)) {
            x1 = contInsets.left;
            x2 = contSize.width - contInsets.right;
            y1 = contInsets.top;
            y2 = contInsets.top + (compPrefSize.height > 0 ? compPrefSize.height : marginH);
        } else if ("Last".equals(position) || "South".equals(position)) {
            x1 = contInsets.left;
            x2 = contSize.width - contInsets.right;
            y1 = contSize.height - contInsets.bottom - (compPrefSize.height > 0 ? compPrefSize.height : marginH);
            y2 = contSize.height - contInsets.bottom;
        } else {
            int index;
            if ("Before".equals(position) || "West".equals(position)) {
                x1 = contInsets.left;
                x2 = contInsets.left + (compPrefSize.width > 0 ? compPrefSize.width : marginW);
            } else if ("After".equals(position) || "East".equals(position)) {
                x1 = contSize.width - contInsets.right - (compPrefSize.width > 0 ? compPrefSize.width : marginW);
                x2 = contSize.width - contInsets.right;
            } else {
                index = this.getComponentOnPosition("Before");
                x1 = contInsets.left;
                if (index >= 0) {
                    x1 += comps[index].getSize().width;
                }
                index = this.getComponentOnPosition("After");
                x2 = contSize.width - contInsets.right;
                if (index >= 0) {
                    x2 -= comps[index].getSize().width;
                }
            }
            index = this.getComponentOnPosition("First");
            y1 = contInsets.top;
            if (index >= 0) {
                y1 += comps[index].getSize().height;
            }
            index = this.getComponentOnPosition("Last");
            y2 = contSize.height - contInsets.bottom;
            if (index >= 0) {
                y2 -= comps[index].getSize().height;
            }
        }
        if (x1 >= x2 && (x1 = contInsets.left) >= (x2 = contSize.width - contInsets.right)) {
            return true;
        }
        if (y1 >= y2) {
            y1 = contInsets.top;
            x2 = contSize.height - contInsets.bottom;
            if (y1 >= y2) {
                return true;
            }
        }
        g.drawRect(x1, y1, x2 - x1 - 1, y2 - y1 - 1);
        return true;
    }

    @Override
    protected LayoutConstraints readConstraintsCode(CodeExpression constrExp, CodeGroup constrCode, CodeExpression compExp) {
        BorderConstraints constr = new BorderConstraints("Center");
        FormCodeSupport.readPropertyExpression(constrExp, constr.getProperties()[0], false);
        return constr;
    }

    @Override
    protected CodeExpression createConstraintsCode(CodeGroup constrCode, LayoutConstraints constr, CodeExpression compExp, int index) {
        if (!(constr instanceof BorderConstraints)) {
            return null;
        }
        return this.getCodeStructure().createExpression(FormCodeSupport.createOrigin(constr.getProperties()[0]));
    }

    @Override
    protected LayoutConstraints createDefaultConstraints() {
        String pos = this.findFreePositions()[0];
        if (this.isAWTContainer()) {
            pos = (String)BorderLayoutSupport.toAbsolute(pos);
        }
        return new BorderConstraints(pos);
    }

    private String[] findFreePositions() {
        ArrayList<String> positions = new ArrayList<String>(6);
        if (this.getComponentOnPosition("Center") == -1) {
            positions.add("Center");
        }
        if (this.getComponentOnPosition("First") == -1) {
            positions.add("First");
        }
        if (this.getComponentOnPosition("Last") == -1) {
            positions.add("Last");
        }
        if (this.getComponentOnPosition("After") == -1) {
            positions.add("After");
        }
        if (this.getComponentOnPosition("Before") == -1) {
            positions.add("Before");
        }
        if (positions.isEmpty()) {
            positions.add("Center");
        }
        String[] free = new String[positions.size()];
        positions.toArray(free);
        return free;
    }

    private int getComponentOnPosition(String position) {
        List<LayoutConstraints> constraints = this.getConstraintsList();
        if (constraints == null) {
            return -1;
        }
        position = (String)BorderLayoutSupport.toAbsolute(position);
        int n = constraints.size();
        for (int i = 0; i < n; ++i) {
            LayoutConstraints constr = constraints.get(i);
            if (constr == null || !position.equals(BorderLayoutSupport.toAbsolute(constr.getConstraintsObject()))) continue;
            return i;
        }
        return -1;
    }

    private static Object toAbsolute(Object constraint) {
        if ("Before".equals(constraint)) {
            constraint = "West";
        } else if ("After".equals(constraint)) {
            constraint = "East";
        } else if ("First".equals(constraint)) {
            constraint = "North";
        } else if ("Last".equals(constraint)) {
            constraint = "South";
        }
        return constraint;
    }

    private int getMargin(int size) {
        int margin = size / 8;
        if (margin < 10) {
            margin = 10;
        }
        if (margin > 50) {
            margin = 50;
        }
        return margin;
    }

    static class BorderDirectionEditor
    extends PropertyEditorSupport {
        private final String[] values = new String[]{"Center", "Before", "After", "First", "Last", "West", "East", "North", "South"};
        private final String[] javaInitStrings = new String[]{"java.awt.BorderLayout.CENTER", "java.awt.BorderLayout.LINE_START", "java.awt.BorderLayout.LINE_END", "java.awt.BorderLayout.PAGE_START", "java.awt.BorderLayout.PAGE_END", "java.awt.BorderLayout.WEST", "java.awt.BorderLayout.EAST", "java.awt.BorderLayout.NORTH", "java.awt.BorderLayout.SOUTH"};

        BorderDirectionEditor() {
        }

        @Override
        public String[] getTags() {
            return this.values;
        }

        @Override
        public String getAsText() {
            return (String)this.getValue();
        }

        @Override
        public void setAsText(String str) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!str.equals(this.values[i])) continue;
                this.setValue(str);
                break;
            }
        }

        @Override
        public String getJavaInitializationString() {
            Object value = this.getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                return this.javaInitStrings[i];
            }
            return null;
        }
    }

    public static class BorderConstraints
    implements LayoutConstraints {
        private String direction;
        private Node.Property[] properties;

        public BorderConstraints(String direction) {
            this.direction = direction;
        }

        @Override
        public Node.Property[] getProperties() {
            if (this.properties == null) {
                this.properties = new FormProperty[]{new FormProperty("BorderConstraints direction", String.class, BorderLayoutSupport.getBundle().getString("PROP_direction"), BorderLayoutSupport.getBundle().getString("HINT_direction")){

                    @Override
                    public Object getTargetValue() {
                        return direction;
                    }

                    @Override
                    public void setTargetValue(Object value) {
                        direction = (String)value;
                    }

                    @Override
                    public PropertyEditor getExpliciteEditor() {
                        return new BorderDirectionEditor();
                    }

                    @Override
                    public void setPropertyContext(FormPropertyContext ctx) {
                    }
                }};
                this.properties[0].setValue("NOI18N", (Object)Boolean.TRUE);
            }
            return this.properties;
        }

        @Override
        public Object getConstraintsObject() {
            return this.direction;
        }

        @Override
        public LayoutConstraints cloneConstraints() {
            return new BorderConstraints(this.direction);
        }
    }
}

