/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.interop.InteropException;

public final class ArityException
extends InteropException {
    private static final long serialVersionUID = 1857745390734085182L;
    private final int expectedArity;
    private final int actualArity;

    private ArityException(int expectedArity, int actualArity, Throwable cause) {
        super(null, cause);
        this.expectedArity = expectedArity;
        this.actualArity = actualArity;
    }

    private ArityException(int expectedArity, int actualArity) {
        super((String)null);
        this.expectedArity = expectedArity;
        this.actualArity = actualArity;
    }

    @Override
    public String getMessage() {
        return "Arity error - expected: " + this.expectedArity + " actual: " + this.actualArity;
    }

    public int getExpectedArity() {
        return this.expectedArity;
    }

    public int getActualArity() {
        return this.actualArity;
    }

    public static ArityException create(int expectedArity, int actualArity) {
        return new ArityException(expectedArity, actualArity);
    }

    public static ArityException create(int expectedArity, int actualArity, Throwable cause) {
        return new ArityException(expectedArity, actualArity, cause);
    }
}

