/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.terraform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.languages.hcl.HCLParserResult;
import org.netbeans.modules.languages.hcl.SourceRef;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLContainer;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.terraform.Bundle;
import org.netbeans.modules.parsing.api.Snapshot;

public class TerraformParserResult
extends HCLParserResult {
    private Map<String, HCLBlock> definedBlocks = new HashMap<String, HCLBlock>();

    public TerraformParserResult(Snapshot snapshot) {
        super(snapshot);
    }

    @Override
    protected void processDocument(HCLDocument doc, SourceRef references) {
        doc.accept(this::duplicateAttributeVisitor);
        doc.accept(this::checkBlockDeclarationVisitor);
    }

    private boolean checkBlockDeclarationVisitor(HCLElement e) {
        if (e instanceof HCLBlock) {
            HCLBlock block = (HCLBlock)e;
            if (block.getParent() instanceof HCLDocument) {
                List<HCLIdentifier> decl = block.getDeclaration();
                HCLIdentifier type = decl.get(0);
                BlockType bt = BlockType.get(type.id());
                if (bt != null) {
                    if (decl.size() != bt.definitionLength) {
                        this.addError(type, Bundle.INVALID_BLOCK_DECLARATION(bt.type, bt.definitionLength - 1));
                    } else if (this.definedBlocks.put(block.id(), block) != null) {
                        switch (bt) {
                            case CHECK: 
                            case DATA: 
                            case MODULE: 
                            case OUTPUT: 
                            case RESOURCE: 
                            case VARIABLE: {
                                this.addError(decl.get(bt.definitionLength - 1), Bundle.DUPLICATE_BLOCK(block.id()));
                            }
                        }
                    }
                } else {
                    this.addError(type, Bundle.UNKNOWN_BLOCK(type.id()));
                }
            }
            return true;
        }
        return !(e instanceof HCLDocument);
    }

    private boolean duplicateAttributeVisitor(HCLElement e) {
        if (e instanceof HCLDocument) {
            HCLDocument doc = (HCLDocument)e;
            for (HCLAttribute hCLAttribute : doc.getAttributes()) {
                this.addError(hCLAttribute, Bundle.UNEXPECTED_DOCUMENT_ATTRIBUTE(hCLAttribute.id()));
            }
            return false;
        }
        if (e instanceof HCLContainer) {
            HCLContainer c = (HCLContainer)e;
            if (c.hasAttributes()) {
                HashSet<String> defined = new HashSet<String>();
                for (HCLAttribute hCLAttribute : c.getAttributes()) {
                    if (defined.add(hCLAttribute.id())) continue;
                    this.addError(hCLAttribute.getName(), Bundle.DUPLICATE_ATTRIBUTE(hCLAttribute.id()));
                }
            }
            return false;
        }
        return true;
    }

    public static enum BlockType {
        CHECK("check", 2),
        DATA("data", 3),
        LOCALS("locals", 1),
        MODULE("module", 2),
        MOVED("moved", 1),
        OUTPUT("output", 2),
        PROVIDER("provider", 2),
        RESOURCE("resource", 3),
        TERRAFORM("terraform", 1),
        VARIABLE("variable", 2);

        final String type;
        final int definitionLength;
        private static final Map<String, BlockType> TYPES;

        private BlockType(String type, int definitionLenght) {
            this.type = type;
            this.definitionLength = definitionLenght;
        }

        public static BlockType get(String name) {
            return TYPES.get(name);
        }

        static {
            TYPES = new HashMap<String, BlockType>();
            for (BlockType bt : BlockType.values()) {
                TYPES.put(bt.type, bt);
            }
        }
    }
}

