/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.netbeans.modules.project.dependency.Dependency;

public final class DependencyChange {
    private final EnumSet<Options> options;
    private final Kind kind;
    private final List<Dependency> dependencies;

    private DependencyChange(EnumSet<Options> options, Kind kind, List<Dependency> dependencies) {
        this.options = options;
        this.kind = kind;
        this.dependencies = Collections.unmodifiableList(dependencies);
    }

    public EnumSet<Options> getOptions() {
        return this.options;
    }

    public Kind getKind() {
        return this.kind;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DependencyChange{");
        switch (this.kind) {
            case ADD: {
                sb.append("ADD: ");
                break;
            }
            case REMOVE: {
                sb.append("REMOVE:");
            }
        }
        boolean next = false;
        for (Dependency d : this.dependencies) {
            if (next) {
                sb.append(", ");
            }
            sb.append(d.toString());
            next = true;
        }
        sb.append("}");
        return sb.toString();
    }

    public static DependencyChange add(List<Dependency> dependencies, Options ... options) {
        return new DependencyChange(options == null ? EnumSet.noneOf(Options.class) : EnumSet.copyOf(Arrays.asList(options)), Kind.ADD, dependencies);
    }

    public static DependencyChange remove(List<Dependency> dependencies, Options ... options) {
        return new DependencyChange(options == null ? EnumSet.noneOf(Options.class) : EnumSet.copyOf(Arrays.asList(options)), Kind.REMOVE, dependencies);
    }

    public static Builder builder(Kind k) {
        return new Builder(k);
    }

    public static final class Builder {
        private List<Dependency> dependencies = new ArrayList<Dependency>();
        private EnumSet<Options> options = EnumSet.noneOf(Options.class);
        private Kind kind;

        private Builder(Kind kind) {
            this.kind = kind;
        }

        public DependencyChange create() {
            return new DependencyChange(this.options, this.kind, this.dependencies);
        }

        public Builder dependency(Dependency ... deps) {
            return this.dependency(Arrays.asList(deps));
        }

        public Builder dependency(Collection<Dependency> deps) {
            this.dependencies.addAll(deps);
            return this;
        }

        public Builder option(Options ... toAdd) {
            if (toAdd == null) {
                return this;
            }
            this.options.addAll(Arrays.asList(toAdd));
            return this;
        }
    }

    public static enum Options {
        skipConflicts,
        ignoreVersions;

    }

    public static enum Kind {
        ADD,
        REMOVE;

    }
}

