/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.model;

import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.AccessNode;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.CallNode;
import com.oracle.js.parser.ir.CatchNode;
import com.oracle.js.parser.ir.ClassElement;
import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.ExportClauseNode;
import com.oracle.js.parser.ir.ExportNode;
import com.oracle.js.parser.ir.ExportSpecifierNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.ExpressionStatement;
import com.oracle.js.parser.ir.ForNode;
import com.oracle.js.parser.ir.FromNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.ImportClauseNode;
import com.oracle.js.parser.ir.ImportNode;
import com.oracle.js.parser.ir.ImportSpecifierNode;
import com.oracle.js.parser.ir.IndexNode;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.LabelNode;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.NameSpaceImportNode;
import com.oracle.js.parser.ir.NamedImportsNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.ObjectNode;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.ReturnNode;
import com.oracle.js.parser.ir.TernaryNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.WithNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.doc.api.JsDocumentationSupport;
import org.netbeans.modules.javascript2.doc.spi.DocParameter;
import org.netbeans.modules.javascript2.doc.spi.JsComment;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.doc.spi.JsModifier;
import org.netbeans.modules.javascript2.model.CatchBlockImpl;
import org.netbeans.modules.javascript2.model.DeclarationScopeImpl;
import org.netbeans.modules.javascript2.model.EmbeddingHelper;
import org.netbeans.modules.javascript2.model.FunctionArgumentAccessor;
import org.netbeans.modules.javascript2.model.JsArrayImpl;
import org.netbeans.modules.javascript2.model.JsFunctionImpl;
import org.netbeans.modules.javascript2.model.JsFunctionReference;
import org.netbeans.modules.javascript2.model.JsObjectImpl;
import org.netbeans.modules.javascript2.model.JsObjectReference;
import org.netbeans.modules.javascript2.model.JsWithObjectImpl;
import org.netbeans.modules.javascript2.model.ModelBuilder;
import org.netbeans.modules.javascript2.model.ModelExtender;
import org.netbeans.modules.javascript2.model.ModelResolver;
import org.netbeans.modules.javascript2.model.OccurrenceBuilder;
import org.netbeans.modules.javascript2.model.ParameterObject;
import org.netbeans.modules.javascript2.model.api.JsArray;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.JsWith;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.api.Occurrence;
import org.netbeans.modules.javascript2.model.spi.FunctionArgument;
import org.netbeans.modules.javascript2.model.spi.FunctionInterceptor;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.model.spi.PathNodeVisitor;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.javascript2.types.api.Type;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.openide.filesystems.FileObject;

public class ModelVisitor
extends PathNodeVisitor
implements ModelResolver {
    private static final Logger LOGGER = Logger.getLogger(ModelVisitor.class.getName());
    private final ModelBuilder modelBuilder;
    private final OccurrenceBuilder occurrenceBuilder;
    private final org.netbeans.modules.javascript2.types.spi.ParserResult parserResult;
    private final Stack<Collection<JsObjectImpl>> functionArgumentStack = new Stack();
    private Map<FunctionInterceptor, Collection<FunctionCall>> functionCalls = null;
    private static final String BLOCK_OBJECT_NAME_PREFIX = "block-";
    private final Map<JsObject, VarNode> varNodeScopes = new IdentityHashMap<JsObject, VarNode>();

    public ModelVisitor(org.netbeans.modules.javascript2.types.spi.ParserResult parserResult, OccurrenceBuilder occurrenceBuilder) {
        FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
        this.modelBuilder = new ModelBuilder(JsFunctionImpl.createGlobal(fileObject, Integer.MAX_VALUE, parserResult.getSnapshot().getMimeType()));
        this.occurrenceBuilder = occurrenceBuilder;
        this.parserResult = parserResult;
    }

    @Override
    public void init() {
        FunctionNode root = (FunctionNode)this.parserResult.getLookup().lookup(FunctionNode.class);
        if (root != null) {
            root.accept((NodeVisitor)this);
        }
    }

    @Override
    public JsObject getGlobalObject() {
        return this.modelBuilder.getGlobal();
    }

    @Override
    public void processCalls(ModelElementFactory elementFactory, Map<String, Map<Integer, List<TypeUsage>>> returnTypesFromFrameworks) {
        Map<FunctionInterceptor, Collection<FunctionCall>> calls = this.getCallsForProcessing();
        if (calls != null && !calls.isEmpty()) {
            for (Map.Entry<FunctionInterceptor, Collection<FunctionCall>> entry : calls.entrySet()) {
                Collection<FunctionCall> fncCalls = entry.getValue();
                if (fncCalls == null || fncCalls.isEmpty()) continue;
                for (FunctionCall call : fncCalls) {
                    List<TypeUsage> types;
                    Collection<TypeUsage> returnTypes = entry.getKey().intercept(this.parserResult.getSnapshot(), call.getName(), this.getGlobalObject(), call.getScope(), elementFactory, call.getArguments());
                    if (returnTypes == null) continue;
                    Map<Integer, List<TypeUsage>> functionCalls = returnTypesFromFrameworks.get(call.getName());
                    if (functionCalls == null) {
                        functionCalls = new HashMap<Integer, List<TypeUsage>>();
                        returnTypesFromFrameworks.put(call.getName(), functionCalls);
                    }
                    if ((types = functionCalls.get(call.getCallOffset())) == null) {
                        types = new ArrayList<TypeUsage>();
                        functionCalls.put(call.getCallOffset(), types);
                    }
                    for (TypeUsage type : returnTypes) {
                        if (types.contains(type)) continue;
                        types.add(type);
                    }
                }
            }
        }
    }

    @Override
    public List<Identifier> getASTNodeName(Object astNode) {
        if (astNode instanceof Node) {
            return ModelVisitor.getNodeName((Node)astNode, this.parserResult);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean enterAccessNode(AccessNode accessNode) {
        BinaryNode node;
        BinaryNode binaryNode = node = this.getPath().get(this.getPath().size() - 1) instanceof BinaryNode ? (BinaryNode)this.getPath().get(this.getPath().size() - 1) : null;
        if ((node == null || node.tokenType() != TokenType.ASSIGN) && accessNode.getBase() instanceof IdentNode && "this".equals(((IdentNode)accessNode.getBase()).getName())) {
            String iNode = accessNode.getProperty();
            JsObject current = this.modelBuilder.getCurrentDeclarationFunction();
            JsObject property = current.getProperty(iNode);
            if (property == null && current.getParent() != null && (current.getParent().getJSKind() == JsElement.Kind.CONSTRUCTOR || current.getParent().getJSKind() == JsElement.Kind.OBJECT) && (property = (current = current.getParent()).getProperty(iNode)) == null && "prototype".equals(current.getName())) {
                current = current.getParent();
                property = current.getProperty(iNode);
            }
            if (property == null && current.getParent() == null) {
                property = this.modelBuilder.getGlobal().getProperty(iNode);
            }
            if (property != null && !property.getModifiers().contains(Modifier.PRIVATE)) {
                ((JsObjectImpl)property).addOccurrence(new OffsetRange(accessNode.getFinish() - iNode.length(), accessNode.getFinish()));
            }
        }
        return super.enterAccessNode(accessNode);
    }

    @Override
    public Node leaveAccessNode(AccessNode accessNode) {
        this.createJsObject(accessNode, this.parserResult, this.modelBuilder);
        return super.leaveAccessNode(accessNode);
    }

    @Override
    public boolean enterBlock(Block block) {
        DeclarationScopeImpl blockScope = (DeclarationScopeImpl)this.modelBuilder.getCurrentDeclarationScope().getProperty(BLOCK_OBJECT_NAME_PREFIX + block.getStart());
        if (blockScope != null) {
            this.modelBuilder.setCurrentObject(blockScope);
        }
        return super.enterBlock(block);
    }

    @Override
    public Node leaveBlock(Block block) {
        DeclarationScopeImpl currentScope = this.modelBuilder.getCurrentDeclarationScope();
        if (currentScope.getJSKind() == JsElement.Kind.BLOCK && currentScope.getName().equals(BLOCK_OBJECT_NAME_PREFIX + block.getStart())) {
            this.modelBuilder.reset();
        }
        return super.leaveBlock(block);
    }

    @Override
    public boolean enterBinaryNode(BinaryNode binaryNode) {
        Expression lhs = binaryNode.lhs();
        Expression rhs = binaryNode.rhs();
        if (lhs instanceof LiteralNode.ArrayLiteralNode && binaryNode.tokenType() == TokenType.ASSIGN) {
            LiteralNode.ArrayLiteralNode lan = (LiteralNode.ArrayLiteralNode)lhs;
            if (rhs instanceof LiteralNode.ArrayLiteralNode) {
                LiteralNode.ArrayLiteralNode ran = (LiteralNode.ArrayLiteralNode)rhs;
                List lExpressions = lan.getElementExpressions();
                List rExpressions = ran.getElementExpressions();
                for (int i = 0; i < lExpressions.size(); ++i) {
                    Expression lExpression = (Expression)lExpressions.get(i);
                    if (i < rExpressions.size()) {
                        Expression rExpression = (Expression)rExpressions.get(i);
                        this.processBinaryNode((Node)lExpression, (Node)rExpression, TokenType.ASSIGN);
                        continue;
                    }
                    break;
                }
            } else {
                rhs.accept((NodeVisitor)this);
            }
        } else if (lhs instanceof ObjectNode && binaryNode.tokenType() == TokenType.ASSIGN) {
            ObjectNode lObjectNode = (ObjectNode)lhs;
            JsObjectImpl rObject = null;
            DeclarationScopeImpl scope = this.modelBuilder.getCurrentDeclarationScope();
            Collection<? extends JsObject> variables = ModelUtils.getVariables(scope);
            if (rhs instanceof ObjectNode) {
                ObjectNode rObjectNode = (ObjectNode)rhs;
                rObject = org.netbeans.modules.javascript2.model.ModelElementFactory.createAnonymousObject(this.parserResult, rObjectNode, this.modelBuilder);
                this.modelBuilder.setCurrentObject(rObject);
                rObject.setJsKind(JsElement.Kind.OBJECT_LITERAL);
                if (!this.functionArgumentStack.isEmpty()) {
                    this.functionArgumentStack.peek().add(rObject);
                }
                for (PropertyNode rPropertyNode : rObjectNode.getElements()) {
                    rPropertyNode.accept((NodeVisitor)this);
                }
                this.modelBuilder.reset();
            } else {
                rhs.accept((NodeVisitor)this);
                if (rhs instanceof IdentNode) {
                    rObject = (JsObjectImpl)ModelUtils.getScopeVariable(scope, ((IdentNode)rhs).getName());
                }
            }
            if (rObject != null) {
                for (PropertyNode lPropertyNode : lObjectNode.getElements()) {
                    BinaryNode bNode;
                    String variableName = null;
                    if (this.isKeyAndValueEquals(lPropertyNode)) {
                        variableName = lPropertyNode.getKeyName();
                        lPropertyNode.accept((NodeVisitor)this);
                    } else if (lPropertyNode.getValue() instanceof IdentNode) {
                        variableName = ((IdentNode)lPropertyNode.getValue()).getName();
                    } else if (lPropertyNode.getValue() instanceof BinaryNode && (bNode = (BinaryNode)lPropertyNode.getValue()).tokenType() == TokenType.ASSIGN && bNode.lhs() instanceof IdentNode) {
                        variableName = ((IdentNode)bNode.lhs()).getName();
                    }
                    if (variableName == null) continue;
                    JsObject variable = ModelUtils.getScopeVariable(scope, variableName);
                    JsObject rProperty = rObject.getProperty(lPropertyNode.getKeyName());
                    if (variable == null || rProperty == null) continue;
                    for (TypeUsage typeUsage : rProperty.getAssignments()) {
                        variable.addAssignment(typeUsage, rProperty.getOffset());
                    }
                    if (this.isKeyAndValueEquals(lPropertyNode)) continue;
                    rProperty.addOccurrence(new OffsetRange(lPropertyNode.getStart(), lPropertyNode.getStart() + lPropertyNode.getKeyName().length()));
                }
                return false;
            }
        } else {
            this.processBinaryNode((Node)lhs, (Node)rhs, binaryNode.tokenType());
        }
        return super.enterBinaryNode(binaryNode);
    }

    private boolean isKeyAndValueEquals(PropertyNode pNode) {
        if (pNode.getKey() instanceof IdentNode && pNode.getValue() instanceof IdentNode) {
            IdentNode key = (IdentNode)pNode.getKey();
            IdentNode value = (IdentNode)pNode.getValue();
            return key.getName().equals(value.getName()) && key.getStart() == value.getStart();
        }
        if (pNode.getKey() instanceof IdentNode && pNode.getValue() instanceof BinaryNode && ((BinaryNode)pNode.getValue()).tokenType() == TokenType.ASSIGN && ((BinaryNode)pNode.getValue()).lhs() instanceof IdentNode) {
            IdentNode key = (IdentNode)pNode.getKey();
            IdentNode value = (IdentNode)((BinaryNode)pNode.getValue()).lhs();
            return key.getName().equals(value.getName()) && key.getStart() == value.getStart();
        }
        return false;
    }

    private void processBinaryNode(Node lhs, Node rhs, TokenType tokenType) {
        if (tokenType == TokenType.ASSIGN && !(rhs instanceof ObjectNode) && (lhs instanceof AccessNode || lhs instanceof IdentNode || lhs instanceof IndexNode)) {
            JsFunctionImpl parent = this.modelBuilder.getCurrentDeclarationFunction();
            if (parent == null) {
                return;
            }
            String fieldName = null;
            if (lhs instanceof AccessNode) {
                AccessNode aNode = (AccessNode)lhs;
                JsObjectImpl property = null;
                List<Identifier> fqName = ModelVisitor.getName(aNode);
                if (fqName != null && "this".equals(fqName.get(0).getName())) {
                    fieldName = aNode.getProperty();
                    if (rhs instanceof IdentNode) {
                        this.addOccurrence((IdentNode)rhs, fieldName);
                    }
                    property = (JsObjectImpl)this.createJsObject(aNode, this.parserResult, this.modelBuilder);
                } else if (fqName != null && (property = ModelUtils.getJsObject(this.modelBuilder, fqName, true)).getParent().getJSKind().isFunction() && !property.getModifiers().contains(Modifier.STATIC)) {
                    property.getModifiers().add(Modifier.STATIC);
                }
                if (property != null) {
                    JsDocumentationHolder docHolder;
                    Collection<Object> types;
                    IdentNode iNode;
                    String parameter = null;
                    JsFunctionImpl function = this.modelBuilder.getCurrentDeclarationFunction();
                    if (rhs instanceof IdentNode && function.getParameter((iNode = (IdentNode)rhs).getName()) != null) {
                        parameter = "@param;" + function.getFullyQualifiedName() + ":" + iNode.getName();
                    }
                    if (parameter == null) {
                        types = ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, rhs);
                        ArrayList<TypeUsage> correctedTypes = new ArrayList<TypeUsage>(types.size());
                        for (TypeUsage typeUsage : types) {
                            String typeName = typeUsage.getType();
                            if (typeName.startsWith("@var;")) {
                                String varName = typeName.substring("@var;".length());
                                if (function.getParameter(varName) != null) {
                                    correctedTypes.add(new TypeUsage("@param;" + function.getFullyQualifiedName() + ":" + varName, typeUsage.getOffset(), false));
                                    continue;
                                }
                                correctedTypes.add(typeUsage);
                                continue;
                            }
                            correctedTypes.add(typeUsage);
                        }
                        types = correctedTypes;
                    } else {
                        types = new ArrayList();
                        types.add(new TypeUsage(parameter, rhs.getStart(), false));
                    }
                    if (property.getDocumentation() == null && (docHolder = JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)this.parserResult)) != null) {
                        property.setDocumentation(docHolder.getDocumentation(lhs));
                        property.setDeprecated(docHolder.isDeprecated(lhs));
                        List list = docHolder.getReturnType(lhs);
                        if (!list.isEmpty()) {
                            for (Type type : list) {
                                property.addAssignment(new TypeUsage(type.getType(), type.getOffset(), true), lhs.getFinish());
                            }
                        }
                    }
                    for (TypeUsage typeUsage : types) {
                        property.addAssignment(typeUsage, lhs.getStart() + 5);
                    }
                }
            } else {
                JsObject lObject = null;
                boolean indexNodeReferProperty = false;
                int assignmentOffset = lhs.getFinish();
                if (lhs instanceof IndexNode) {
                    Identifier newPropName;
                    LiteralNode lNode;
                    IndexNode iNode = (IndexNode)lhs;
                    if (iNode.getBase() instanceof IdentNode) {
                        lObject = this.processLhs(org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (IdentNode)iNode.getBase()), parent, false);
                        assignmentOffset = iNode.getFinish();
                    }
                    if (lObject != null && iNode.getIndex() instanceof LiteralNode && (lNode = (LiteralNode)iNode.getIndex()).isString() && (newPropName = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, lNode)) != null) {
                        indexNodeReferProperty = true;
                        if (lObject.getProperty(lNode.getString()) == null) {
                            JsObjectImpl newProperty = new JsObjectImpl(lObject, newPropName, newPropName.getOffsetRange(), true, this.parserResult.getSnapshot().getMimeType(), null);
                            lObject.addProperty(newPropName.getName(), newProperty);
                            assignmentOffset = lNode.getFinish();
                        }
                        lObject = this.processLhs(newPropName, lObject, true);
                    }
                } else if (lhs instanceof IdentNode) {
                    lObject = this.processLhs(org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (IdentNode)lhs), parent, true);
                }
                if (lObject != null && !(rhs instanceof FunctionNode)) {
                    Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, rhs);
                    if (lhs instanceof IndexNode && lObject instanceof JsArrayImpl) {
                        ((JsArrayImpl)lObject).addTypesInArray(types);
                    } else {
                        boolean isIndexNode = lhs instanceof IndexNode;
                        if (!isIndexNode || isIndexNode && indexNodeReferProperty) {
                            for (TypeUsage type : types) {
                                lObject.addAssignment(type, assignmentOffset);
                            }
                        }
                    }
                }
            }
            if (fieldName == null && rhs instanceof IdentNode) {
                this.addOccurence((IdentNode)rhs, false);
            }
        } else if (tokenType != TokenType.ASSIGN || tokenType == TokenType.ASSIGN && lhs instanceof IndexNode) {
            if (lhs instanceof IdentNode) {
                this.addOccurence((IdentNode)lhs, tokenType == TokenType.ASSIGN);
            }
            if (rhs instanceof IdentNode) {
                this.addOccurence((IdentNode)rhs, false);
            }
        }
    }

    @Override
    public Node leaveBinaryNode(BinaryNode binaryNode) {
        JsObject refFunction;
        JsObject origFunction;
        Expression rlhs;
        Expression lhs = binaryNode.lhs();
        Expression rhs = binaryNode.rhs();
        if (lhs instanceof IdentNode && rhs instanceof BinaryNode && (rlhs = ((BinaryNode)rhs).lhs()) instanceof IdentNode && (origFunction = this.modelBuilder.getCurrentDeclarationFunction().getProperty(((IdentNode)rlhs).getName())) != null && origFunction.getJSKind().isFunction() && (refFunction = this.modelBuilder.getCurrentDeclarationFunction().getProperty(((IdentNode)lhs).getName())) != null && !refFunction.getJSKind().isFunction()) {
            JsFunctionReference newReference = new JsFunctionReference(refFunction.getParent(), refFunction.getDeclarationName(), (JsFunction)origFunction, true, (Set<Modifier>)origFunction.getModifiers());
            refFunction.getParent().addProperty(newReference.getName(), newReference);
        }
        return super.leaveBinaryNode(binaryNode);
    }

    @Override
    public boolean enterCallNode(CallNode callNode) {
        this.functionArgumentStack.push(new ArrayList(3));
        if (callNode.getFunction() instanceof IdentNode) {
            IdentNode iNode = (IdentNode)callNode.getFunction();
            this.addOccurence(iNode, false, true);
        }
        for (Node argument : callNode.getArgs()) {
            if (!(argument instanceof IdentNode)) continue;
            this.addOccurence((IdentNode)argument, false);
        }
        this.processObjectPropertyAssignment(callNode);
        return super.enterCallNode(callNode);
    }

    @Override
    public Node leaveCallNode(CallNode callNode) {
        Collection<JsObjectImpl> functionArguments = this.functionArgumentStack.pop();
        Expression function = callNode.getFunction();
        if (function instanceof AccessNode || function instanceof IdentNode) {
            List<Identifier> funcName;
            if (function instanceof AccessNode) {
                funcName = ModelVisitor.getName((AccessNode)function);
            } else {
                funcName = new ArrayList<Identifier>();
                funcName.add(new Identifier(((IdentNode)function).getName(), ((IdentNode)function).getStart()));
            }
            if (funcName != null) {
                StringBuilder sb = new StringBuilder();
                for (Identifier identifier : funcName) {
                    sb.append(identifier.getName());
                    sb.append(".");
                }
                if (this.functionCalls == null) {
                    this.functionCalls = new LinkedHashMap<FunctionInterceptor, Collection<FunctionCall>>();
                }
                String name = sb.substring(0, sb.length() - 1);
                ArrayList<FunctionInterceptor> interceptorsToUse = new ArrayList<FunctionInterceptor>();
                for (FunctionInterceptor interceptor : ModelExtender.getDefault().getFunctionInterceptors()) {
                    if (!interceptor.getNamePattern().matcher(name).matches()) continue;
                    interceptorsToUse.add(interceptor);
                }
                for (FunctionInterceptor interceptor : interceptorsToUse) {
                    ArrayList<FunctionArgument> funcArg = new ArrayList<FunctionArgument>();
                    for (int i = 0; i < callNode.getArgs().size(); ++i) {
                        Node argument = (Node)callNode.getArgs().get(i);
                        this.createFunctionArgument(argument, i, functionArguments, funcArg);
                    }
                    Collection<FunctionCall> calls = this.functionCalls.get(interceptor);
                    if (calls == null) {
                        calls = new ArrayList<FunctionCall>();
                        this.functionCalls.put(interceptor, calls);
                    }
                    int callOffset = callNode.getFunction().getStart();
                    if (callNode.getFunction() instanceof AccessNode) {
                        AccessNode anode = (AccessNode)callNode.getFunction();
                        callOffset = anode.getFinish() - anode.getProperty().length();
                    }
                    calls.add(new FunctionCall(name, this.modelBuilder.getCurrentDeclarationScope(), funcArg, callOffset));
                }
            }
        }
        return super.leaveCallNode(callNode);
    }

    private void createFunctionArgument(Node argument, int position, Collection<JsObjectImpl> functionArguments, Collection<FunctionArgument> result) {
        if (argument instanceof LiteralNode) {
            LiteralNode ln = (LiteralNode)argument;
            if (ln.isString()) {
                result.add(FunctionArgumentAccessor.getDefault().createForString(position, argument.getStart(), ln.getString()));
            } else if (ln instanceof LiteralNode.ArrayLiteralNode) {
                for (JsObjectImpl jsObject : functionArguments) {
                    if (jsObject.getOffset() != argument.getStart()) continue;
                    result.add(FunctionArgumentAccessor.getDefault().createForArray(position, jsObject.getOffset(), jsObject));
                    break;
                }
            }
        } else if (argument instanceof ObjectNode) {
            for (JsObjectImpl jsObject : functionArguments) {
                if (jsObject.getOffset() != argument.getStart()) continue;
                result.add(FunctionArgumentAccessor.getDefault().createForAnonymousObject(position, jsObject.getOffset(), jsObject));
                break;
            }
        } else if (argument instanceof AccessNode) {
            ArrayList<String> strFqn = new ArrayList<String>();
            if (this.fillName((AccessNode)argument, strFqn)) {
                result.add(FunctionArgumentAccessor.getDefault().createForReference(position, argument.getStart(), strFqn));
            } else {
                result.add(FunctionArgumentAccessor.getDefault().createForUnknown(position));
            }
        } else if (argument instanceof IndexNode) {
            ArrayList<String> strFqn = new ArrayList<String>();
            if (this.fillName((IndexNode)argument, strFqn)) {
                result.add(FunctionArgumentAccessor.getDefault().createForReference(position, argument.getStart(), strFqn));
            } else {
                result.add(FunctionArgumentAccessor.getDefault().createForUnknown(position));
            }
        } else if (argument instanceof IdentNode) {
            IdentNode in = (IdentNode)argument;
            String inName = in.getName();
            result.add(FunctionArgumentAccessor.getDefault().createForReference(position, argument.getStart(), Collections.singletonList(inName)));
        } else if (argument instanceof UnaryNode) {
            UnaryNode un = (UnaryNode)argument;
            if (un.tokenType() == TokenType.NEW) {
                CallNode constructor = (CallNode)un.getExpression();
                this.createFunctionArgument((Node)constructor.getFunction(), position, functionArguments, result);
            }
        } else if (argument instanceof FunctionNode) {
            FunctionNode reference = (FunctionNode)argument;
            result.add(FunctionArgumentAccessor.getDefault().createForReference(position, argument.getStart(), Collections.singletonList(this.modelBuilder.getFunctionName(reference))));
        } else {
            result.add(FunctionArgumentAccessor.getDefault().createForUnknown(position));
        }
    }

    @Override
    public boolean enterCatchNode(CatchNode catchNode) {
        Identifier exception = catchNode.getException() == null ? null : org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, catchNode.getException());
        DeclarationScopeImpl inScope = this.modelBuilder.getCurrentDeclarationScope();
        CatchBlockImpl catchBlock = new CatchBlockImpl(inScope, exception, new OffsetRange(catchNode.getStart(), catchNode.getFinish()), this.parserResult.getSnapshot().getMimeType());
        inScope.addDeclaredScope(catchBlock);
        this.modelBuilder.setCurrentObject(catchBlock);
        return super.enterCatchNode(catchNode);
    }

    @Override
    public Node leaveCatchNode(CatchNode catchNode) {
        if (catchNode.getException() == null || !EmbeddingHelper.containsGeneratedIdentifier(catchNode.getException().getName())) {
            this.modelBuilder.reset();
        }
        return super.leaveCatchNode(catchNode);
    }

    @Override
    public boolean enterClassNode(ClassNode node) {
        IdentNode cnIdent = node.getIdent();
        Node lastNode = this.getPreviousFromPath(1);
        VarNode varNode = lastNode instanceof VarNode ? (VarNode)lastNode : null;
        JsObjectImpl parent = this.modelBuilder.getCurrentObject();
        JsObjectImpl classObject = null;
        Identifier className = null;
        Identifier refName = null;
        if (varNode != null && cnIdent != null && varNode.getName().getName().equals(cnIdent.getName()) || varNode != null && !varNode.isExport() && cnIdent == null) {
            className = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, varNode.getName());
        } else if (varNode != null && cnIdent != null && !varNode.getName().getName().equals(cnIdent.getName())) {
            className = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, varNode.getName());
            refName = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, cnIdent);
        } else if (varNode == null && cnIdent != null) {
            className = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, cnIdent);
        }
        if (className != null) {
            classObject = new JsObjectImpl(parent, className, new OffsetRange(node.getStart(), node.getFinish()), true, parent.getMimeType(), parent.getSourceLabel());
            JsObject origClassObject = parent.getProperty(className.getName());
            if (origClassObject != null) {
                ArrayList<? extends JsObject> properties = new ArrayList<JsObject>(origClassObject.getProperties().values());
                for (JsObject jsObject : properties) {
                    ModelUtils.moveProperty(classObject, jsObject);
                }
            }
            parent.addProperty(className.getName(), classObject);
            classObject.setJsKind(JsElement.Kind.CLASS);
            if (refName != null) {
                JsObjectReference reference = new JsObjectReference((JsObject)classObject, refName, classObject, true, EnumSet.of(Modifier.PRIVATE));
                classObject.addProperty(refName.getName(), reference);
                reference.addOccurrence(refName.getOffsetRange());
            }
        }
        if (classObject != null) {
            Expression classHeritage;
            if (node.getClassHeritage() != null && (classHeritage = node.getClassHeritage()) instanceof IdentNode) {
                JsObjectImpl proto = new JsObjectImpl((JsObject)classObject, "prototype", true, OffsetRange.NONE, EnumSet.of(Modifier.PUBLIC), classObject.getMimeType(), classObject.getSourceLabel());
                classObject.addProperty("prototype", proto);
                IdentNode type = (IdentNode)classHeritage;
                proto.addAssignment(new TypeUsage(type.getName(), type.getStart(), true), type.getStart());
            }
            this.modelBuilder.setCurrentObject(classObject);
            node.getConstructor().accept((NodeVisitor)this);
            for (PropertyNode element : node.getClassElements()) {
                element.accept((NodeVisitor)this);
            }
            this.modelBuilder.reset();
        }
        return false;
    }

    @Override
    public boolean enterIdentNode(IdentNode identNode) {
        Node previousVisited = this.getPath().get(this.getPath().size() - 1);
        if (!(previousVisited instanceof AccessNode || previousVisited instanceof VarNode || previousVisited instanceof BinaryNode || previousVisited instanceof PropertyNode || previousVisited instanceof CatchNode || previousVisited instanceof LabelNode)) {
            this.addOccurence(identNode, false);
        }
        return super.enterIdentNode(identNode);
    }

    @Override
    public Node leaveIndexNode(IndexNode indexNode) {
        if (indexNode.getIndex() instanceof LiteralNode) {
            LiteralNode literal;
            Identifier parentName;
            IdentNode iNode;
            Expression base = indexNode.getBase();
            JsObjectImpl parent = null;
            if (base instanceof AccessNode) {
                parent = (JsObjectImpl)this.createJsObject((AccessNode)base, this.parserResult, this.modelBuilder);
            } else if (base instanceof IdentNode && !"this".equals((iNode = (IdentNode)base).getName()) && (parentName = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, iNode)) != null) {
                ArrayList<Identifier> fqName = new ArrayList<Identifier>();
                fqName.add(parentName);
                parent = ModelUtils.getJsObject(this.modelBuilder, fqName, false);
                parent.addOccurrence(parentName.getOffsetRange());
            }
            if (parent != null && indexNode.getIndex() instanceof LiteralNode && (literal = (LiteralNode)indexNode.getIndex()).isString()) {
                String index = literal.getPropertyName();
                JsObjectImpl property = (JsObjectImpl)parent.getProperty(index);
                if (property != null) {
                    property.addOccurrence(new OffsetRange(indexNode.getIndex().getStart(), indexNode.getIndex().getFinish()));
                } else {
                    Identifier name = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (LiteralNode)indexNode.getIndex());
                    if (name != null) {
                        property = new JsObjectImpl(parent, name, name.getOffsetRange(), this.parserResult.getSnapshot().getMimeType(), null);
                        parent.addProperty(name.getName(), property);
                    }
                }
            }
        }
        return super.leaveIndexNode(indexNode);
    }

    @Override
    public boolean enterImportNode(ImportNode iNode) {
        ImportClauseNode iClause = iNode.getImportClause();
        FromNode from = iNode.getFrom();
        if (iClause != null) {
            Identifier importedAs;
            IdentNode defaultBinding = iClause.getDefaultBinding();
            NameSpaceImportNode nameSpaceImport = iClause.getNameSpaceImport();
            NamedImportsNode namedImports = iClause.getNamedImports();
            if (defaultBinding != null) {
                importedAs = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, defaultBinding);
                JsObjectImpl property = this.createVariableFromImport(importedAs);
                property.addAssignment(new TypeUsage(importedAs.getName()), importedAs.getOffsetRange().getEnd());
            }
            if (nameSpaceImport != null) {
                importedAs = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, nameSpaceImport.getBindingIdentifier());
                this.createVariableFromImport(importedAs);
            }
            if (namedImports != null && namedImports.getImportSpecifiers() != null) {
                List importSpecifiers = namedImports.getImportSpecifiers();
                for (ImportSpecifierNode importSpecifier : importSpecifiers) {
                    Identifier importedAs2 = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, importSpecifier.getBindingIdentifier());
                    JsObjectImpl property = this.createVariableFromImport(importedAs2);
                    property.addOccurrence(importedAs2.getOffsetRange());
                    if (importSpecifier.getIdentifier() == null) continue;
                    Identifier inModuleName = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, importSpecifier.getIdentifier());
                    property.addAssignment(new TypeUsage(inModuleName.getName()), inModuleName.getOffsetRange().getEnd());
                }
            }
        }
        return false;
    }

    private JsObjectImpl createVariableFromImport(Identifier name) {
        JsFunctionImpl scope = this.modelBuilder.getCurrentDeclarationFunction();
        JsObject existingProp = scope.getProperty(name.getName());
        JsObjectImpl property = new JsObjectImpl(scope, name, name.getOffsetRange(), true, scope.getMimeType(), scope.getSourceLabel());
        if (existingProp != null) {
            ModelUtils.copyOccurrences(existingProp, property);
        }
        scope.addProperty(name.getName(), property);
        return property;
    }

    @Override
    public boolean enterExportNode(ExportNode exportNode) {
        boolean result = super.enterExportNode(exportNode);
        ExportClauseNode exportClause = exportNode.getExportClause();
        FromNode from = exportNode.getFrom();
        Expression expression = exportNode.getExpression();
        if (exportClause != null) {
            for (ExportSpecifierNode esNode : exportClause.getExportSpecifiers()) {
                IdentNode exported = esNode.getExportIdentifier();
                IdentNode local = esNode.getIdentifier();
                JsObjectImpl property = (JsObjectImpl)this.modelBuilder.getCurrentDeclarationFunction().getProperty(local.getName());
                if (exported == null) {
                    if (property == null) {
                        property = this.createVariableFromImport(org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, local));
                    }
                    property.addOccurrence(ModelVisitor.getOffsetRange(local));
                } else {
                    this.addOccurence(local, false);
                    property = this.createVariableFromImport(org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, exported));
                }
                if (from == null || property == null) continue;
                TypeUsage type = new TypeUsage(local.getName(), local.getFinish());
                property.addAssignment(type, local.getFinish());
            }
        }
        if (expression != null) {
            this.addToPath((Node)exportNode);
            expression.accept((NodeVisitor)this);
            this.removeFromPathTheLast();
        }
        return result;
    }

    @Override
    public boolean enterForNode(ForNode forNode) {
        if (forNode.getInit() instanceof IdentNode) {
            JsObject parent = this.modelBuilder.getCurrentObject();
            while (parent instanceof JsWith) {
                parent = parent.getParent();
            }
            IdentNode name = (IdentNode)forNode.getInit();
            JsObjectImpl variable = (JsObjectImpl)parent.getProperty(name.getName());
            if (variable != null) {
                Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, (Node)forNode.getModify());
                for (TypeUsage type : types) {
                    String newType;
                    int index;
                    if (type.getType().contains("@var;")) {
                        index = type.getType().lastIndexOf("@var;");
                        newType = type.getType().substring(0, index) + "@arr;" + type.getType().substring(index + "@var;".length());
                        type = new TypeUsage(newType, type.getOffset(), false);
                    } else if (type.getType().contains("@pro;")) {
                        index = type.getType().lastIndexOf("@pro;");
                        newType = type.getType().substring(0, index) + "@arr;" + type.getType().substring(index + "@pro;".length());
                        type = new TypeUsage(newType, type.getOffset(), false);
                    }
                    variable.addAssignment(type, forNode.getModify().getStart());
                }
            }
        }
        return super.enterForNode(forNode);
    }

    @Override
    public boolean enterFunctionNode(FunctionNode functionNode) {
        if (ModelVisitor.isArtificialConstructor(functionNode)) {
            return false;
        }
        this.addToPath((Node)functionNode);
        JsFunctionImpl fncParent = this.modelBuilder.getCurrentDeclarationFunction();
        JsFunctionImpl fncScope = null;
        if (functionNode.isProgram()) {
            fncScope = fncParent;
            if (this.parserResult.getSnapshot().getSource().getFileObject() != null) {
                LOGGER.log(Level.FINE, "Creating model for: {0}", this.parserResult.getSnapshot().getSource().getFileObject().getPath());
            }
        } else {
            JsObject property = fncParent.getProperty(this.modelBuilder.getFunctionName(functionNode));
            if (property == null && functionNode.isStrict()) {
                property = this.modelBuilder.getCurrentDeclarationScope().getProperty(this.modelBuilder.getFunctionName(functionNode));
            }
            if (!(property instanceof JsFunction)) {
                property = fncParent.getProperty(this.modelBuilder.getGlobal().getName() + this.modelBuilder.getFunctionName(functionNode));
            }
            if (property instanceof JsFunction) {
                fncScope = property instanceof JsFunctionReference ? (JsFunctionImpl)((JsFunctionReference)property).getOriginal() : (JsFunctionImpl)property;
            }
            if (property == null) {
                LOGGER.log(Level.FINE, "FunctionNode: {0} is not processed, because parent function {1} doesn''t contain such property.", new Object[]{functionNode.toString(), fncParent.toString()});
                return false;
            }
        }
        this.processDeclarations(fncScope, functionNode);
        fncScope.setStrict(functionNode.isStrict());
        if (!functionNode.isProgram() && !functionNode.isModule()) {
            this.correctNameAndOffsets(fncScope, functionNode);
            this.setParent(fncScope, functionNode);
            this.setModifiers(fncScope, functionNode);
            this.modelBuilder.setCurrentObject(fncScope);
        }
        this.processJsDoc(fncScope, functionNode, JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)this.parserResult));
        if (functionNode.isModule()) {
            List imports = functionNode.getModule().getImports();
            for (ImportNode moduleImport : imports) {
                moduleImport.accept((NodeVisitor)this);
            }
            List exports = functionNode.getModule().getExports();
            for (ExportNode exportNode : exports) {
                exportNode.accept((NodeVisitor)this);
            }
        }
        functionNode.getBody().accept((NodeVisitor)this);
        if (functionNode.getKind() == FunctionNode.Kind.GENERATOR) {
            fncScope.addReturnType(new TypeUsage("Generator", 1, true));
        } else if (fncScope.areReturnTypesEmpty()) {
            fncScope.addReturnType(new TypeUsage("undefined", -1, false));
        }
        if (!functionNode.isProgram() && !functionNode.isModule()) {
            JsObject singleton;
            this.processModifiersFromJsDoc(fncScope, functionNode, JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)this.parserResult));
            if (this.canBeSingletonPattern(1) && (singleton = this.resolveThisInSingletonPattern(fncScope)) != null) {
                fncScope.setJsKind(JsElement.Kind.CONSTRUCTOR);
                if (fncScope.isAnonymous() && !fncScope.getProperties().containsValue(singleton)) {
                    ArrayList<? extends JsObject> properties = new ArrayList<JsObject>(fncScope.getProperties().values());
                    for (JsObject jsObject : properties) {
                        ModelUtils.moveProperty(singleton, jsObject);
                    }
                }
            }
            this.modelBuilder.reset();
        }
        this.removeFromPathTheLast();
        return false;
    }

    private static boolean isArtificialConstructor(FunctionNode functionNode) {
        return functionNode.isClassConstructor() && functionNode.isGenerated();
    }

    private void correctNameAndOffsets(JsFunctionImpl jsFunction, FunctionNode fn) {
        OffsetRange decNameOffset = jsFunction.getDeclarationName().getOffsetRange();
        Node lastVisited = this.getPreviousFromPath(2);
        Identifier newIdentifier = null;
        if (decNameOffset.getLength() == 0) {
            if (lastVisited instanceof PropertyNode && fn.getKind() != FunctionNode.Kind.ARROW && fn.getKind() != FunctionNode.Kind.CLASS_FIELD_INITIALIZER) {
                PropertyNode pNode = (PropertyNode)lastVisited;
                newIdentifier = new Identifier(pNode.getKeyName(), ModelVisitor.getOffsetRange((Node)pNode.getKey()));
            } else if (lastVisited instanceof VarNode && fn.isAnonymous()) {
                VarNode vNode = (VarNode)lastVisited;
                newIdentifier = new Identifier(vNode.getName().getName(), ModelVisitor.getOffsetRange(vNode.getName()));
            } else if (fn.isAnonymous() && lastVisited instanceof JoinPredecessorExpression && this.getPreviousFromPath(3) instanceof BinaryNode && this.getPreviousFromPath(4) instanceof VarNode) {
                VarNode vNode = (VarNode)this.getPreviousFromPath(4);
                newIdentifier = new Identifier(vNode.getName().getName(), ModelVisitor.getOffsetRange(vNode.getName()));
            }
        }
        if (newIdentifier != null) {
            jsFunction.setDeclarationName(newIdentifier);
            jsFunction.addOccurrence(newIdentifier.getOffsetRange());
        }
    }

    private void setModifiers(JsFunctionImpl jsFunction, FunctionNode fn) {
        boolean isPrivate = false;
        boolean isPrivilage = false;
        boolean isStatic = false;
        Node lastVisited = this.getPreviousFromPath(2);
        if (!(this.lc.getParentFunction(fn).isProgram() || lastVisited instanceof PropertyNode || lastVisited instanceof BinaryNode)) {
            isPrivate = true;
        }
        if (lastVisited instanceof PropertyNode) {
            PropertyNode pNode = (PropertyNode)lastVisited;
            isStatic = pNode.isStatic();
            if (fn.isClassConstructor() || fn.isSubclassConstructor()) {
                jsFunction.setJsKind(JsElement.Kind.CONSTRUCTOR);
            } else if (fn.isMethod()) {
                if (fn.equals((Object)pNode.getGetter())) {
                    jsFunction.setJsKind(JsElement.Kind.PROPERTY_GETTER);
                } else if (fn.equals((Object)pNode.getSetter())) {
                    jsFunction.setJsKind(JsElement.Kind.PROPERTY_SETTER);
                } else {
                    jsFunction.setJsKind(JsElement.Kind.METHOD);
                }
                if (pNode.getKey() instanceof IdentNode && ((IdentNode)pNode.getKey()).isPrivate()) {
                    isPrivilage = true;
                }
            }
        } else if (lastVisited instanceof BinaryNode) {
            BinaryNode bNode = (BinaryNode)lastVisited;
            if (bNode.getAssignmentDest() instanceof AccessNode) {
                AccessNode aNode = (AccessNode)bNode.getAssignmentDest();
                List<Identifier> name = ModelVisitor.getName(aNode);
                if (name != null && "this".equals(name.get(0).getName())) {
                    isPrivilage = true;
                } else if (!"prototype".equals(aNode.getProperty()) && jsFunction.getParent().getJSKind().isFunction()) {
                    if (aNode.getBase() instanceof AccessNode) {
                        if (!"prototype".equals(((AccessNode)aNode.getBase()).getProperty())) {
                            isStatic = true;
                        }
                    } else {
                        isStatic = true;
                    }
                }
            }
        } else if (lastVisited instanceof CallNode && this.getPreviousFromPath(3) instanceof UnaryNode && this.getPreviousFromPath(4) instanceof VarNode) {
            isPrivate = true;
        }
        if (fn.getKind() == FunctionNode.Kind.ARROW) {
            jsFunction.setJsKind(JsElement.Kind.ARROW_FUNCTION);
        }
        if (fn.getKind() == FunctionNode.Kind.GENERATOR) {
            jsFunction.setJsKind(JsElement.Kind.GENERATOR);
        }
        Set<Modifier> modifiers = jsFunction.getModifiers();
        if (isPrivate || isPrivilage) {
            modifiers.remove(Modifier.PUBLIC);
            if (isPrivate) {
                modifiers.add(Modifier.PRIVATE);
            } else {
                modifiers.add(Modifier.PROTECTED);
            }
        }
        if (isStatic) {
            modifiers.add(Modifier.STATIC);
        }
        if (this.isFunctionAnonymous(fn)) {
            jsFunction.setAnonymous(true);
        }
    }

    private void setParent(JsFunctionImpl jsFunction, FunctionNode fn) {
        JsFunctionImpl fnScope;
        DeclarationScope parentScope;
        VarNode varNode;
        Node lastVisited = this.getPreviousFromPath(2);
        JsObject parent = jsFunction.getParent();
        if (lastVisited instanceof JoinPredecessorExpression && this.getPreviousFromPath(3) instanceof BinaryNode && this.getPreviousFromPath(4) instanceof VarNode) {
            lastVisited = this.getPreviousFromPath(4);
        }
        if (lastVisited instanceof PropertyNode) {
            parent = this.modelBuilder.getCurrentObject();
        } else if (lastVisited instanceof VarNode) {
            varNode = (VarNode)lastVisited;
            if (fn.isNamedFunctionExpression()) {
                parent.getProperties().remove(this.modelBuilder.getFunctionName(fn));
                JsObject variable = parent.getProperty(varNode.getName().getName());
                Identifier refName = new Identifier(fn.getIdent().getName(), new OffsetRange(fn.getIdent().getStart(), fn.getIdent().getFinish()));
                JsFunctionReference jsRef = new JsFunctionReference((JsObject)jsFunction, refName, jsFunction, true, EnumSet.of(Modifier.PRIVATE));
                jsRef.addOccurrence(jsRef.getDeclarationName().getOffsetRange());
                jsFunction.setDeclarationName(new Identifier(varNode.getName().getName(), ModelVisitor.getOffsetRange(varNode.getName())));
                if (variable != null) {
                    ModelUtils.copyOccurrences(variable, jsFunction);
                }
                parent.addProperty(jsFunction.getName(), jsFunction);
                jsFunction.addProperty(jsRef.getName(), jsRef);
            } else if (varNode.isFunctionDeclaration() || fn.isAnonymous()) {
                parent.getProperties().remove(this.modelBuilder.getFunctionName(fn));
                parent.addProperty(varNode.getName().getName(), jsFunction);
            }
        } else if (lastVisited instanceof BinaryNode) {
            BinaryNode bNode = (BinaryNode)lastVisited;
            List<Identifier> name = ModelVisitor.getName(bNode, this.parserResult);
            boolean isPriviliged = false;
            if (name != null && !name.isEmpty()) {
                JsObject property;
                if ("this".equals(name.get(0).getName())) {
                    name.remove(0);
                    isPriviliged = true;
                    for (JsObject hParent = parent = (JsObjectImpl)this.resolveThis(parent); hParent != null && hParent.getKind() != ElementKind.FILE && hParent.getDeclarationName() != null; hParent = hParent.getParent()) {
                        name.add(0, hParent.getDeclarationName());
                    }
                }
                boolean parentHasSameName = false;
                if (name.size() > 1 && name.get(0).getName().equals(jsFunction.getName()) && (property = parent.getProperty(this.modelBuilder.getFunctionName(fn))) != null && property.equals(jsFunction)) {
                    parent.getProperties().remove(this.modelBuilder.getFunctionName(fn));
                    ((JsObjectImpl)property).clearOccurrences();
                    parentHasSameName = true;
                }
                JsObjectImpl jsObject = ModelUtils.getJsObject(this.modelBuilder, name, !parentHasSameName);
                if (!isPriviliged) {
                    parent = jsObject.getParent();
                }
                if (fn.isNamedFunctionExpression()) {
                    Identifier refName = new Identifier(fn.getIdent().getName(), new OffsetRange(fn.getIdent().getStart(), fn.getIdent().getFinish()));
                    JsFunctionReference jsRef = new JsFunctionReference((JsObject)jsFunction, refName, jsFunction, true, EnumSet.of(Modifier.PRIVATE));
                    jsRef.addOccurrence(jsRef.getDeclarationName().getOffsetRange());
                    jsFunction.addProperty(jsRef.getName(), jsRef);
                }
                jsFunction.setDeclarationName(jsObject.getDeclarationName());
                ModelUtils.copyOccurrences(jsObject, jsFunction);
                if (!parentHasSameName) {
                    String builderName = this.modelBuilder.getFunctionName(fn);
                    if (jsFunction.getParent().getProperties().remove(builderName) == null) {
                        for (JsObject jsObject2 : jsFunction.getParent().getProperties().values()) {
                            if (jsObject2.getJSKind() != JsElement.Kind.BLOCK || jsObject2.getProperties().remove(builderName) == null) continue;
                            if (!jsObject2.getProperties().isEmpty()) break;
                            jsObject2.getParent().getProperties().remove(jsObject2.getName());
                            break;
                        }
                    }
                }
                if (parent == null) {
                    parent = jsObject.getParent();
                }
                parent.addProperty(jsObject.getName(), jsFunction);
                jsFunction.setParent(parent);
            }
        } else if (lastVisited instanceof CallNode && this.getPreviousFromPath(3) instanceof UnaryNode && this.getPreviousFromPath(4) instanceof VarNode) {
            int index;
            varNode = (VarNode)this.getPreviousFromPath(4);
            Expression init = varNode.getInit();
            Identifier varName = new Identifier(varNode.getName().getName(), ModelVisitor.getOffsetRange(varNode.getName()));
            OffsetRange range = varNode.getInit() instanceof ObjectNode ? new OffsetRange(varNode.getName().getStart(), ((ObjectNode)varNode.getInit()).getFinish()) : varName.getOffsetRange();
            JsObject variable = this.handleArrayCreation((Node)varNode.getInit(), parent, varName);
            if (variable == null) {
                JsObjectImpl newObject = new JsObjectImpl(parent, varName, range, jsFunction.getMimeType(), jsFunction.getSourceLabel());
                newObject.setDeclared(true);
                variable = newObject;
            }
            variable.addOccurrence(varName.getOffsetRange());
            parent.getProperties().remove(jsFunction.getName());
            parent.addProperty(varName.getName(), variable);
            variable.addProperty(jsFunction.getName(), jsFunction);
            jsFunction.setParent(variable);
            variable.addAssignment(new TypeUsage("@new;" + variable.getName() + '.' + jsFunction.getName(), jsFunction.getDeclarationName().getOffsetRange().getStart()), init.getStart());
            if (fn.isNamedFunctionExpression() && fn.getName().equals(varName.getName())) {
                ModelUtils.copyOccurrences(jsFunction, variable);
            }
            parent = variable;
            for (index = this.getPath().size() - 5; index > -1 && !(this.getPath().get(index) instanceof FunctionNode); --index) {
            }
            if (index > 0) {
                variable.getModifiers().remove(Modifier.PUBLIC);
                variable.getModifiers().add(Modifier.PRIVATE);
            }
        }
        if (!parent.equals(jsFunction.getParent())) {
            jsFunction.getParent().getProperties().remove(this.modelBuilder.getFunctionName(fn));
            jsFunction.setParent(parent);
            JsObject property = parent.getProperty(jsFunction.getName());
            if (property != null) {
                ModelUtils.copyOccurrences(property, jsFunction);
            }
            parent.addProperty(jsFunction.getName(), jsFunction);
        }
        if ((parentScope = (fnScope = jsFunction).getParentScope()) != null) {
            parentScope.addDeclaredScope((DeclarationScope)fnScope);
        }
    }

    private boolean isFunctionAnonymous(FunctionNode fn) {
        boolean result = false;
        if (fn.isAnonymous()) {
            Node lastVisited = this.getPreviousFromPath(2);
            if (fn.getIdent().getName().startsWith("L:") && !(lastVisited instanceof PropertyNode)) {
                result = true;
            } else if (fn.getIdent().getStart() == fn.getIdent().getFinish() && lastVisited instanceof CallNode) {
                result = true;
            }
        }
        return result;
    }

    private void processJsDoc(JsFunctionImpl jsFunction, FunctionNode fn, JsDocumentationHolder docHolder) {
        if (!fn.isProgram()) {
            List types;
            Documentation documentation = docHolder.getDocumentation((Node)fn);
            jsFunction.setDocumentation(documentation);
            List docParams = docHolder.getParameters((Node)fn);
            for (DocParameter docParameter : docParams) {
                JsObjectImpl param;
                String sParamName;
                Identifier paramName = docParameter.getParamName();
                if (paramName == null || (sParamName = paramName.getName()) == null || sParamName.isEmpty() || (param = (JsObjectImpl)jsFunction.getParameter(sParamName)) == null) continue;
                for (Type type : docParameter.getParamTypes()) {
                    param.addAssignment(new TypeUsage(type.getType(), type.getOffset(), true), param.getOffset());
                }
                this.addDocNameOccurence(param);
            }
            if (docHolder.isClass((Node)fn)) {
                jsFunction.setJsKind(JsElement.Kind.CONSTRUCTOR);
            }
            jsFunction.setDeprecated(docHolder.isDeprecated((Node)fn));
            List extendTypes = docHolder.getExtends((Node)fn);
            if (!extendTypes.isEmpty()) {
                JsObject prototype = jsFunction.getProperty("prototype");
                if (prototype == null) {
                    prototype = new JsObjectImpl((JsObject)jsFunction, "prototype", true, OffsetRange.NONE, EnumSet.of(Modifier.PUBLIC), this.parserResult.getSnapshot().getMimeType(), null);
                    jsFunction.addProperty("prototype", prototype);
                }
                for (Type type : extendTypes) {
                    prototype.addAssignment(new TypeUsage(type.getType(), type.getOffset(), true), type.getOffset());
                }
            }
            if ((types = docHolder.getReturnType((Node)fn)) != null && !types.isEmpty()) {
                for (Type type : types) {
                    jsFunction.addReturnType(new TypeUsage(type.getType(), type.getOffset(), true));
                }
            }
        }
        Map commentBlocks = docHolder.getCommentBlocks();
        for (JsComment comment : commentBlocks.values()) {
            Type callBack;
            ArrayList<Identifier> fqn;
            DocParameter definedType = comment.getDefinedType();
            if (definedType != null) {
                Object type2;
                String typeName = definedType.getParamName().getName();
                fqn = new ArrayList();
                JsObject whereOccurrence = this.getGlobalObject();
                if (typeName.indexOf(46) > -1) {
                    String[] parts = typeName.split("\\.");
                    int offset = definedType.getParamName().getOffsetRange().getStart();
                    int delta = 0;
                    for (int i = 0; i < parts.length; ++i) {
                        fqn.add(new Identifier(parts[i], offset + delta));
                        if (whereOccurrence != null && (whereOccurrence = whereOccurrence.getProperty(parts[i])) != null) {
                            whereOccurrence.addOccurrence(new OffsetRange(offset + delta, offset + delta + parts[i].length()));
                        }
                        delta = delta + parts[i].length() + 1;
                    }
                } else {
                    fqn.add(definedType.getParamName());
                }
                JsObjectImpl object = ModelUtils.getJsObject(this.modelBuilder, fqn, true);
                int assignOffset = definedType.getParamName().getOffsetRange().getEnd();
                List types = definedType.getParamTypes();
                for (Object type2 : types) {
                    object.addAssignment(new TypeUsage(type2.getType(), type2.getOffset()), assignOffset);
                }
                List assignedTypes = comment.getTypes();
                type2 = assignedTypes.iterator();
                while (type2.hasNext()) {
                    Type type3 = (Type)type2.next();
                    object.addAssignment(new TypeUsage(type3.getType(), type3.getOffset()), assignOffset);
                }
                List properties = comment.getProperties();
                for (DocParameter docProperty : properties) {
                    JsObjectImpl jsProperty = new JsObjectImpl(object, docProperty.getParamName(), docProperty.getParamName().getOffsetRange(), true, "text/javascript", null);
                    object.addProperty(jsProperty.getName(), jsProperty);
                    types = docProperty.getParamTypes();
                    jsProperty.setDocumentation(Documentation.create((String)docProperty.getParamDescription()));
                    assignOffset = docProperty.getParamName().getOffsetRange().getEnd();
                    for (Type type4 : types) {
                        jsProperty.addAssignment(new TypeUsage(type4.getType(), type4.getOffset()), assignOffset);
                    }
                }
            }
            if ((callBack = comment.getCallBack()) == null) continue;
            fqn = this.fqnFromType(callBack);
            this.markOccurrences(fqn);
            ArrayList<Identifier> parentFqn = new ArrayList<Identifier>();
            for (int i = 0; i < fqn.size() - 1; ++i) {
                parentFqn.add((Identifier)fqn.get(i));
            }
            JsObject parentObject = parentFqn.isEmpty() ? this.getGlobalObject() : ModelUtils.getJsObject(this.modelBuilder, parentFqn, true);
            JsFunctionImpl callBackFunction = new JsFunctionImpl(parentObject instanceof DeclarationScope ? (DeclarationScope)parentObject : ModelUtils.getDeclarationScope(parentObject), parentObject, (Identifier)fqn.get(fqn.size() - 1), Collections.emptyList(), callBack.getOffset() > -1 ? new OffsetRange(callBack.getOffset(), callBack.getOffset() + callBack.getType().length()) : OffsetRange.NONE, "text/javascript", null);
            parentObject.addProperty(callBackFunction.getName(), callBackFunction);
            callBackFunction.setDocumentation(Documentation.create((String)comment.getDocumentation()));
            callBackFunction.setJsKind(JsElement.Kind.CALLBACK);
            List docParameters = comment.getParameters();
            for (DocParameter docParameter : docParameters) {
                ParameterObject parameter = new ParameterObject(callBackFunction, docParameter.getParamName(), "text/javascript", null);
                for (Type type : docParameter.getParamTypes()) {
                    parameter.addAssignment(new TypeUsage(type.getType(), type.getOffset(), true), parameter.getOffset());
                }
                this.addDocNameOccurence(parameter);
                callBackFunction.addParameter(parameter);
            }
        }
    }

    private void processModifiersFromJsDoc(JsFunctionImpl jsFunction, FunctionNode fn, JsDocumentationHolder docHolder) {
        Set modifiers;
        if (!(fn.isProgram() || fn.isModule() || docHolder == null || (modifiers = docHolder.getModifiers((Node)fn)) == null || modifiers.isEmpty())) {
            Set<Modifier> fnModifiers = jsFunction.getModifiers();
            if (modifiers.contains(JsModifier.PRIVATE)) {
                fnModifiers.remove(Modifier.PUBLIC);
                fnModifiers.remove(Modifier.PROTECTED);
                fnModifiers.add(Modifier.PRIVATE);
            }
            if (modifiers.contains(JsModifier.PUBLIC)) {
                fnModifiers.remove(Modifier.PRIVATE);
                fnModifiers.remove(Modifier.PROTECTED);
                fnModifiers.add(Modifier.PUBLIC);
            }
            if (modifiers.contains(JsModifier.STATIC)) {
                fnModifiers.add(Modifier.STATIC);
            }
        }
    }

    private void processDeclarations(final JsFunctionImpl parentFn, final FunctionNode inNode) {
        LOGGER.log(Level.FINEST, "in function: {0}, ident: {1}", new Object[]{inNode.getName(), inNode.getIdent()});
        final JsDocumentationHolder docHolder = JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)this.parserResult);
        Block block = inNode.getBody();
        PathNodeVisitor visitor = new PathNodeVisitor(this.lc){
            DeclarationScopeImpl currentBlockScope;
            private boolean isParameterBlock;
            private final List<FunctionNode> declaredFunctions;
            private final List<VarNode> declaredVars;
            {
                super(lc);
                this.currentBlockScope = parentFn;
                this.isParameterBlock = false;
                this.declaredFunctions = new ArrayList<FunctionNode>();
                this.declaredVars = new ArrayList<VarNode>();
            }

            private void handleDeclarations() {
                if (!this.declaredFunctions.isEmpty() || !this.declaredVars.isEmpty()) {
                    for (FunctionNode fnNode : this.declaredFunctions) {
                        ModelVisitor.this.handleDeclaredFunction(this.currentBlockScope, parentFn, fnNode);
                    }
                    for (VarNode varNode : this.declaredVars) {
                        if (varNode.isLet()) {
                            ModelVisitor.this.handleDeclaredVariable(this.currentBlockScope, parentFn, varNode, docHolder);
                            continue;
                        }
                        ModelVisitor.this.handleDeclaredVariable(parentFn, parentFn, varNode, docHolder);
                    }
                    this.declaredFunctions.clear();
                    this.declaredVars.clear();
                }
            }

            @Override
            public boolean enterBlock(Block block) {
                this.handleDeclarations();
                if (inNode.isStrict() && !this.getPath().isEmpty()) {
                    this.currentBlockScope = new DeclarationScopeImpl(this.currentBlockScope, this.currentBlockScope, new Identifier(ModelVisitor.BLOCK_OBJECT_NAME_PREFIX + block.getStart(), OffsetRange.NONE), new OffsetRange(block.getStart(), block.getFinish()), this.currentBlockScope.getMimeType(), this.currentBlockScope.getSourceLabel());
                    this.currentBlockScope.setJsKind(JsElement.Kind.BLOCK);
                }
                this.isParameterBlock = block.isParameterBlock();
                return super.enterBlock(block);
            }

            @Override
            public Node leaveBlock(Block block) {
                if (inNode.isStrict() || this.getPath().size() == 1) {
                    this.handleDeclarations();
                    if (this.getPath().size() > 1) {
                        DeclarationScopeImpl parentScope = (DeclarationScopeImpl)this.currentBlockScope.getParentScope();
                        if (!this.currentBlockScope.getProperties().isEmpty()) {
                            parentScope.addDeclaredScope(this.currentBlockScope);
                            parentScope.addProperty(this.currentBlockScope.getName(), this.currentBlockScope);
                        }
                        this.currentBlockScope = parentScope;
                    }
                }
                return super.leaveBlock(block);
            }

            @Override
            public Node leaveExportNode(ExportNode exportNode) {
                this.handleDeclarations();
                return super.leaveExportNode(exportNode);
            }

            @Override
            public boolean enterClassNode(ClassNode classNode) {
                if (classNode.getConstructor() != null) {
                    classNode.getConstructor().accept((NodeVisitor)this);
                }
                if (classNode.getClassElements() != null) {
                    for (PropertyNode pn : classNode.getClassElements()) {
                        pn.accept((NodeVisitor)this);
                    }
                }
                return false;
            }

            @Override
            public boolean enterFunctionNode(FunctionNode fnNode) {
                this.declaredFunctions.add(fnNode);
                return false;
            }

            @Override
            public boolean enterVarNode(VarNode varNode) {
                if (!this.isParameterBlock) {
                    this.declaredVars.add(varNode);
                }
                return super.enterVarNode(varNode);
            }
        };
        if (inNode.isModule() && inNode.getModule().getExports() != null) {
            for (ExportNode export : inNode.getModule().getExports()) {
                if (!export.isDefault()) {
                    export.accept((NodeVisitor)visitor);
                    continue;
                }
                Expression expression = export.getExpression();
                if ((!(expression instanceof ClassNode) || ((ClassNode)expression).getIdent() == null) && (!(expression instanceof FunctionNode) || ((FunctionNode)expression).getIdent() == null)) continue;
                export.accept((NodeVisitor)visitor);
            }
        }
        block.accept((NodeVisitor)visitor);
    }

    private void handleDeclaredFunction(DeclarationScopeImpl inScope, JsObject parent, FunctionNode fnNode) {
        LOGGER.log(Level.FINEST, "       function: {0}", this.debugInfo((Node)fnNode));
        String name = fnNode.isAnonymous() ? this.modelBuilder.getFunctionName(fnNode) : fnNode.getIdent().getName();
        Identifier fnName = new Identifier(name, new OffsetRange(fnNode.getIdent().getStart(), fnNode.getIdent().getFinish()));
        if (ModelVisitor.isArtificialConstructor(fnNode)) {
            return;
        }
        ArrayList<Identifier> parameters = new ArrayList<Identifier>(fnNode.getParameters().size());
        for (IdentNode node : fnNode.getParameters()) {
            Identifier param = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, node);
            if (param == null || node.isDestructuredParameter()) continue;
            parameters.add(param);
        }
        JsFunctionImpl declaredFn = new JsFunctionImpl(inScope, parent, fnName, parameters, ModelVisitor.getOffsetRange(fnNode), inScope.getMimeType(), inScope.getSourceLabel());
        inScope.addProperty(this.modelBuilder.getFunctionName(fnNode), declaredFn);
        if (fnName.getOffsetRange().getLength() > 0 && !fnNode.isNamedFunctionExpression()) {
            declaredFn.addOccurrence(fnName.getOffsetRange());
        }
    }

    private void handleDeclaredVariable(DeclarationScopeImpl parentFn, JsObject parent, VarNode varNode, JsDocumentationHolder docHolder) {
        LOGGER.log(Level.FINEST, "       variable: {0}", this.debugInfo((Node)varNode));
        Expression init = varNode.getInit();
        boolean createVariable = true;
        if (!varNode.isFunctionDeclaration() && !varNode.isExport()) {
            if (init instanceof FunctionNode && !((FunctionNode)init).isNamedFunctionExpression()) {
                createVariable = false;
            } else if (init instanceof BinaryNode) {
                BinaryNode bNode = (BinaryNode)init;
                if (bNode.isLogical() && (bNode.rhs() instanceof JoinPredecessorExpression && ((JoinPredecessorExpression)bNode.rhs()).getExpression() instanceof FunctionNode || bNode.lhs() instanceof JoinPredecessorExpression && ((JoinPredecessorExpression)bNode.lhs()).getExpression() instanceof FunctionNode)) {
                    createVariable = false;
                } else if (bNode.isAssignment()) {
                    createVariable = false;
                    if (parentFn.getProperty(varNode.getName().getName()) == null) {
                        FunctionNode fNode;
                        JsObject original;
                        while (bNode.rhs() instanceof BinaryNode && bNode.rhs().isAssignment()) {
                            bNode = (BinaryNode)bNode.rhs();
                        }
                        if (bNode.rhs() instanceof FunctionNode && (original = parentFn.getProperty(this.modelBuilder.getFunctionName(fNode = (FunctionNode)bNode.rhs()))) != null) {
                            Identifier varName = new Identifier(varNode.getName().getName(), ModelVisitor.getOffsetRange(varNode.getName()));
                            JsFunctionReference variable = new JsFunctionReference((JsObject)parentFn, varName, (JsFunction)original, true, (Set<Modifier>)original.getModifiers());
                            variable.addOccurrence(varName.getOffsetRange());
                            parentFn.addProperty(varName.getName(), variable);
                        }
                    }
                }
            } else if (parentFn.getProperty(varNode.getName().getName()) != null) {
                if (!(init instanceof CallNode) && !(init instanceof UnaryNode)) {
                    parentFn.getProperty(varNode.getName().getName()).addOccurrence(ModelVisitor.getOffsetRange(varNode.getName()));
                }
                createVariable = false;
            }
            if (createVariable) {
                Identifier varName = new Identifier(varNode.getName().getName(), ModelVisitor.getOffsetRange(varNode.getName()));
                OffsetRange range = varNode.getInit() instanceof ObjectNode ? new OffsetRange(varNode.getName().getStart(), ((ObjectNode)varNode.getInit()).getFinish()) : varName.getOffsetRange();
                JsObject variable = this.handleArrayCreation((Node)varNode.getInit(), parentFn, varName);
                if (variable == null) {
                    JsObjectImpl newObject = new JsObjectImpl(parentFn, varName, range, this.parserResult.getSnapshot().getMimeType(), null);
                    variable = newObject;
                }
                variable.addOccurrence(varName.getOffsetRange());
                parentFn.addProperty(varName.getName(), variable);
                variable.addOccurrence(varName.getOffsetRange());
                if (docHolder != null) {
                    ((JsObjectImpl)variable).setDocumentation(docHolder.getDocumentation((Node)varNode));
                    ((JsObjectImpl)variable).setDeprecated(docHolder.isDeprecated((Node)varNode));
                }
            }
        }
    }

    private List<Identifier> fqnFromType(Type type) {
        ArrayList<Identifier> fqn = new ArrayList<Identifier>();
        String typeName = type.getType();
        int offset = type.getOffset();
        if (typeName.indexOf(46) > -1) {
            String[] parts = typeName.split("\\.");
            int delta = 0;
            for (int i = 0; i < parts.length; ++i) {
                fqn.add(new Identifier(parts[i], offset + delta));
                delta = delta + parts[i].length() + 1;
            }
        } else {
            fqn.add(new Identifier(typeName, offset));
        }
        return fqn;
    }

    private void markOccurrences(List<Identifier> fqn) {
        Identifier iden;
        JsObject whereOccurrence = this.getGlobalObject();
        Iterator<Identifier> iterator = fqn.iterator();
        while (iterator.hasNext() && (whereOccurrence = whereOccurrence.getProperty((iden = iterator.next()).getName())) != null) {
            whereOccurrence.addOccurrence(iden.getOffsetRange());
        }
    }

    private JsArray handleArrayCreation(Node initNode, JsObject parent, Identifier name) {
        CallNode cNode;
        UnaryNode uNode;
        if (initNode instanceof UnaryNode && parent != null && (uNode = (UnaryNode)initNode).tokenType() == TokenType.NEW && uNode.getExpression() instanceof CallNode && (cNode = (CallNode)uNode.getExpression()).getFunction() instanceof IdentNode && "Array".equals(((IdentNode)cNode.getFunction()).getName())) {
            ArrayList<TypeUsage> itemTypes = new ArrayList<TypeUsage>();
            for (Node node : cNode.getArgs()) {
                itemTypes.addAll(ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, node));
            }
            EnumSet<Modifier> modifiers = parent.getJSKind() != JsElement.Kind.FILE ? EnumSet.of(Modifier.PRIVATE) : EnumSet.of(Modifier.PUBLIC);
            JsArrayImpl result = new JsArrayImpl(parent, name, name.getOffsetRange(), true, modifiers, this.parserResult.getSnapshot().getMimeType(), null);
            result.addTypesInArray(itemTypes);
            return result;
        }
        return null;
    }

    @Override
    public boolean enterLiteralNode(LiteralNode lNode) {
        Node lastVisited = this.getPreviousFromPath(1);
        if (lNode instanceof LiteralNode.ArrayLiteralNode) {
            LiteralNode.ArrayLiteralNode aNode = (LiteralNode.ArrayLiteralNode)lNode;
            List<Identifier> fqName = null;
            int pathSize = this.getPath().size();
            boolean isDeclaredInParent = false;
            boolean isPrivate = false;
            boolean treatAsAnonymous = false;
            JsObject parent = null;
            if (lastVisited instanceof TernaryNode && pathSize > 1) {
                lastVisited = this.getPath().get(pathSize - 2);
            }
            int pathIndex = 1;
            while (lastVisited instanceof BinaryNode && pathSize > pathIndex && ((BinaryNode)lastVisited).tokenType() != TokenType.ASSIGN) {
                lastVisited = this.getPath().get(pathSize - ++pathIndex);
            }
            if (lastVisited instanceof VarNode) {
                fqName = ModelVisitor.getName((VarNode)lastVisited);
                isDeclaredInParent = true;
                DeclarationScopeImpl declarationScope = ((VarNode)lastVisited).isLet() ? this.modelBuilder.getCurrentDeclarationScope() : this.modelBuilder.getCurrentDeclarationFunction();
                parent = declarationScope;
                if (fqName.size() == 1 && !ModelUtils.isGlobal(declarationScope)) {
                    isPrivate = true;
                }
            } else if (lastVisited instanceof PropertyNode) {
                fqName = this.getName((PropertyNode)lastVisited);
                isDeclaredInParent = true;
            } else if (lastVisited instanceof BinaryNode) {
                Expression index;
                BinaryNode binNode = (BinaryNode)lastVisited;
                if (!(!(binNode.lhs() instanceof IndexNode) || (index = ((IndexNode)binNode.lhs()).getIndex()) instanceof LiteralNode && ((LiteralNode)index).isString())) {
                    treatAsAnonymous = true;
                }
                if (!treatAsAnonymous) {
                    if (this.getPath().size() > 1) {
                        lastVisited = this.getPath().get(this.getPath().size() - pathIndex - 1);
                    }
                    fqName = ModelVisitor.getName(binNode, this.parserResult);
                    if (binNode.lhs() instanceof IdentNode || binNode.lhs() instanceof AccessNode && ((AccessNode)binNode.lhs()).getBase() instanceof IdentNode && ((IdentNode)((AccessNode)binNode.lhs()).getBase()).getName().equals("this")) {
                        if (lastVisited instanceof ExpressionStatement && !fqName.get(0).getName().equals("this")) {
                            List<Identifier> objectName = fqName.size() > 1 ? fqName.subList(0, fqName.size() - 1) : fqName;
                            JsObjectImpl existingArray = ModelUtils.getJsObject(this.modelBuilder, objectName, false);
                            if (existingArray != null) {
                                existingArray.addOccurrence(fqName.get(fqName.size() - 1).getOffsetRange());
                                return super.enterLiteralNode(lNode);
                            }
                        } else {
                            isDeclaredInParent = true;
                            if (!(binNode.lhs() instanceof IdentNode)) {
                                parent = this.resolveThis(this.modelBuilder.getCurrentObject());
                            }
                        }
                    }
                }
            } else if (lastVisited instanceof CallNode || lastVisited instanceof LiteralNode.ArrayLiteralNode || lastVisited instanceof ReturnNode || lastVisited instanceof AccessNode) {
                treatAsAnonymous = true;
            }
            if (!isDeclaredInParent && lastVisited instanceof FunctionNode) {
                isDeclaredInParent = ((FunctionNode)lastVisited).getKind() == FunctionNode.Kind.SCRIPT;
            }
            JsArrayImpl array = null;
            if (!treatAsAnonymous) {
                if (fqName != null && !fqName.isEmpty() && fqName.get(0) != null) {
                    if ("this".equals(fqName.get(0).getName())) {
                        parent = this.resolveThis(this.modelBuilder.getCurrentObject());
                        fqName.remove(0);
                        JsObject tmpObject = parent;
                        while (tmpObject.getParent() != null) {
                            Identifier dName = tmpObject.getDeclarationName();
                            fqName.add(0, dName != null ? tmpObject.getDeclarationName() : new Identifier(tmpObject.getName(), OffsetRange.NONE));
                            tmpObject = tmpObject.getParent();
                        }
                    }
                    if ((array = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, aNode, fqName, this.modelBuilder, isDeclaredInParent, parent)) != null && isPrivate) {
                        array.getModifiers().remove(Modifier.PUBLIC);
                        array.getModifiers().add(Modifier.PRIVATE);
                    }
                }
            } else {
                array = org.netbeans.modules.javascript2.model.ModelElementFactory.createAnonymousObject(this.parserResult, aNode, this.modelBuilder);
            }
            if (array != null) {
                int aOffset = fqName == null ? lastVisited.getStart() : fqName.get(fqName.size() - 1).getOffsetRange().getEnd();
                array.addAssignment(ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, (Node)lNode), aOffset);
                for (Node item : aNode.getElementExpressions()) {
                    array.addTypesInArray(ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, item));
                }
                if (!this.functionArgumentStack.isEmpty()) {
                    this.functionArgumentStack.peek().add(array);
                }
            }
        }
        return super.enterLiteralNode(lNode);
    }

    @Override
    public boolean enterObjectNode(ObjectNode objectNode) {
        Node previousVisited = this.getPath().get(this.getPath().size() - 1);
        if (previousVisited instanceof CallNode || previousVisited instanceof LiteralNode.ArrayLiteralNode || previousVisited instanceof ExpressionStatement) {
            JsObjectImpl object = org.netbeans.modules.javascript2.model.ModelElementFactory.createAnonymousObject(this.parserResult, objectNode, this.modelBuilder);
            this.modelBuilder.setCurrentObject(object);
            object.setJsKind(JsElement.Kind.OBJECT_LITERAL);
            if (!this.functionArgumentStack.isEmpty()) {
                this.functionArgumentStack.peek().add(object);
            }
            return super.enterObjectNode(objectNode);
        }
        if (previousVisited instanceof ReturnNode || previousVisited instanceof BinaryNode && ((BinaryNode)previousVisited).tokenType() == TokenType.COMMARIGHT) {
            JsObjectImpl objectScope = org.netbeans.modules.javascript2.model.ModelElementFactory.createAnonymousObject(this.parserResult, objectNode, this.modelBuilder);
            this.modelBuilder.setCurrentObject(objectScope);
            objectScope.setJsKind(JsElement.Kind.OBJECT_LITERAL);
        } else if (previousVisited instanceof ExportNode && ((ExportNode)previousVisited).isDefault()) {
            ArrayList<Identifier> fqName = new ArrayList<Identifier>(1);
            fqName.add(new Identifier("default", OffsetRange.NONE));
            JsObjectImpl objectScope = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, objectNode, fqName, this.modelBuilder, true);
            this.modelBuilder.setCurrentObject(objectScope);
            objectScope.setJsKind(JsElement.Kind.OBJECT_LITERAL);
        } else {
            JsObjectImpl objectScope;
            List<Identifier> fqName = null;
            int pathSize = this.getPath().size();
            boolean isDeclaredInParent = false;
            boolean isDeclaredThroughThis = false;
            boolean isPrivate = false;
            boolean treatAsAnonymous = false;
            int pathIndex = 1;
            Node lastVisited = this.getPath().get(pathSize - pathIndex);
            VarNode varNode = null;
            if (lastVisited instanceof JoinPredecessorExpression) {
                lastVisited = this.getPath().get(pathSize - ++pathIndex);
            }
            if (lastVisited instanceof TernaryNode && pathSize > 1) {
                TernaryNode tNode = (TernaryNode)lastVisited;
                lastVisited = this.getPath().get(pathSize - pathIndex - 1);
                if (lastVisited instanceof ExpressionStatement || lastVisited instanceof BinaryNode) {
                    JoinPredecessorExpression trueExpression = tNode.getTrueExpression();
                    JoinPredecessorExpression falseExpression = tNode.getFalseExpression();
                    if (trueExpression.getExpression().equals((Object)objectNode) || falseExpression.getExpression().equals((Object)objectNode)) {
                        int blockIndex = pathIndex + 1;
                        Block block = null;
                        while (blockIndex < this.getPath().size() && block == null) {
                            if (!(this.getPreviousFromPath(++blockIndex) instanceof Block)) continue;
                            block = (Block)this.getPreviousFromPath(blockIndex);
                        }
                        boolean bl = treatAsAnonymous = block != null && block.isParameterBlock();
                    }
                }
            }
            if (lastVisited instanceof BinaryNode) {
                BinaryNode bNode = (BinaryNode)lastVisited;
                if (bNode.lhs().equals((Object)objectNode)) {
                    return super.enterObjectNode(objectNode);
                }
                if (bNode.lhs() instanceof ObjectNode && bNode.rhs().equals((Object)objectNode)) {
                    return false;
                }
            }
            while (lastVisited instanceof BinaryNode && pathSize > pathIndex && ((BinaryNode)lastVisited).tokenType() != TokenType.ASSIGN) {
                lastVisited = this.getPath().get(pathSize - ++pathIndex);
            }
            if (lastVisited instanceof VarNode) {
                fqName = ModelVisitor.getName((VarNode)lastVisited);
                isDeclaredInParent = true;
                JsFunctionImpl declarationScope = this.modelBuilder.getCurrentDeclarationFunction();
                varNode = (VarNode)lastVisited;
                if (fqName.size() == 1 && !ModelUtils.isGlobal(declarationScope)) {
                    isPrivate = true;
                }
            } else if (lastVisited instanceof PropertyNode) {
                fqName = this.getName((PropertyNode)lastVisited);
                isDeclaredInParent = true;
            } else if (lastVisited instanceof AccessNode) {
                treatAsAnonymous = true;
            } else if (lastVisited instanceof BinaryNode) {
                Expression index;
                BinaryNode binNode = (BinaryNode)lastVisited;
                Expression binLhs = binNode.lhs();
                if (!(!(binLhs instanceof IndexNode) || (index = ((IndexNode)binLhs).getIndex()) instanceof LiteralNode && ((LiteralNode)index).isString())) {
                    treatAsAnonymous = true;
                }
                if (!treatAsAnonymous) {
                    if (this.getPath().size() > 1 && (lastVisited = this.getPath().get(this.getPath().size() - pathIndex - 1)) instanceof VarNode) {
                        varNode = (VarNode)lastVisited;
                    }
                    fqName = ModelVisitor.getName(binNode, this.parserResult);
                    if (binLhs instanceof IdentNode || binLhs instanceof AccessNode && ((AccessNode)binLhs).getBase() instanceof IdentNode && ((IdentNode)((AccessNode)binLhs).getBase()).getName().equals("this")) {
                        boolean bl = isDeclaredInParent = binLhs instanceof IdentNode && varNode != null;
                        if (binLhs instanceof AccessNode) {
                            isDeclaredInParent = true;
                            isDeclaredThroughThis = true;
                        }
                    }
                }
            }
            if (!isDeclaredInParent && lastVisited instanceof FunctionNode) {
                boolean bl = isDeclaredInParent = ((FunctionNode)lastVisited).getKind() == FunctionNode.Kind.SCRIPT;
            }
            if (!treatAsAnonymous) {
                if (fqName == null || fqName.isEmpty()) {
                    fqName = new ArrayList<Identifier>(1);
                    fqName.add(new Identifier("UNKNOWN", new OffsetRange(objectNode.getStart(), objectNode.getFinish())));
                }
                if (varNode != null) {
                    objectScope = this.modelBuilder.getCurrentObject();
                } else {
                    Identifier name = fqName.get(fqName.size() - 1);
                    JsObject alreadyThere = null;
                    if (isDeclaredThroughThis) {
                        JsObject thisIs = this.resolveThis(this.modelBuilder.getCurrentObject());
                        alreadyThere = thisIs.getProperty(name.getName());
                    } else if (isDeclaredInParent) {
                        alreadyThere = lastVisited instanceof PropertyNode ? this.modelBuilder.getCurrentObject().getProperty(name.getName()) : ModelUtils.getJsObjectByName(this.modelBuilder.getCurrentDeclarationFunction(), name.getName());
                    } else {
                        if (fqName.size() == 1) {
                            alreadyThere = ModelUtils.getScopeVariable(this.modelBuilder.getCurrentDeclarationScope(), name.getName());
                        }
                        if (alreadyThere == null) {
                            alreadyThere = ModelUtils.getJsObject(this.modelBuilder, fqName, true);
                        }
                    }
                    JsObjectImpl jsObjectImpl = objectScope = alreadyThere == null ? org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, objectNode, fqName, this.modelBuilder, isDeclaredInParent) : (JsObjectImpl)alreadyThere;
                    if (alreadyThere != null) {
                        ((JsObjectImpl)alreadyThere).addOccurrence(name.getOffsetRange());
                    }
                }
                if (objectScope != null) {
                    objectScope.setJsKind(JsElement.Kind.OBJECT_LITERAL);
                    if (!objectScope.isDeclared()) {
                        objectScope.setDeclared(true);
                    }
                    this.modelBuilder.setCurrentObject(objectScope);
                    if (isPrivate) {
                        objectScope.getModifiers().remove(Modifier.PUBLIC);
                        objectScope.getModifiers().add(Modifier.PRIVATE);
                    }
                }
            } else {
                objectScope = org.netbeans.modules.javascript2.model.ModelElementFactory.createAnonymousObject(this.parserResult, objectNode, this.modelBuilder);
                this.modelBuilder.setCurrentObject(objectScope);
            }
        }
        return super.enterObjectNode(objectNode);
    }

    @Override
    public Node leaveObjectNode(ObjectNode objectNode) {
        BinaryNode bNode;
        Node lastVisited = this.getPreviousFromPath(2);
        if (lastVisited instanceof BinaryNode && (bNode = (BinaryNode)lastVisited).lhs().equals((Object)objectNode)) {
            return super.leaveObjectNode(objectNode);
        }
        this.modelBuilder.reset();
        return super.leaveObjectNode(objectNode);
    }

    @Override
    public boolean enterPropertyNode(PropertyNode propertyNode) {
        Expression key = propertyNode.getKey();
        Expression value = propertyNode.getValue();
        List decorators = propertyNode.getDecorators();
        if (decorators != null && !decorators.isEmpty()) {
            for (Expression decorator : decorators) {
                if (decorator instanceof IdentNode) {
                    this.addOccurence((IdentNode)decorator, false, true);
                    continue;
                }
                decorator.accept((NodeVisitor)this);
            }
        }
        if (!(!(key instanceof IdentNode) && !(key instanceof LiteralNode) || value instanceof ObjectNode || value instanceof FunctionNode || propertyNode.isComputed())) {
            JsObjectImpl parent = this.modelBuilder.getCurrentObject();
            Identifier name = null;
            if (key instanceof IdentNode) {
                name = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (IdentNode)key);
            } else if (key instanceof LiteralNode) {
                name = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (LiteralNode)key);
            }
            if (name != null) {
                JsObjectImpl property;
                if (key instanceof IdentNode && value instanceof IdentNode) {
                    JsObject variable;
                    IdentNode iKey = (IdentNode)key;
                    IdentNode iValue = (IdentNode)value;
                    if (iKey.getName().equals(iValue.getName()) && iKey.getStart() == iValue.getStart() && iKey.getFinish() == iValue.getFinish() && (variable = ModelUtils.getScopeVariable(this.modelBuilder.getCurrentDeclarationScope(), name.getName())) != null) {
                        parent.addProperty(variable.getName(), variable);
                        variable.addOccurrence(name.getOffsetRange());
                        return false;
                    }
                }
                if ((property = (JsObjectImpl)parent.getProperty(name.getName())) == null) {
                    if (parent.getJSKind() == JsElement.Kind.OBJECT_LITERAL || parent.getJSKind() == JsElement.Kind.ANONYMOUS_OBJECT) {
                        property = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, propertyNode, name, this.modelBuilder, true);
                    } else {
                        Block block;
                        int index = 1;
                        Object node = this.getPreviousFromPath(index);
                        BinaryNode bNode = null;
                        ObjectNode oNode = null;
                        while (index < this.getPath().size() && !(node instanceof Block)) {
                            if (bNode == null && node instanceof BinaryNode) {
                                bNode = (BinaryNode)node;
                            } else if (oNode == null && node instanceof ObjectNode) {
                                oNode = (ObjectNode)node;
                            }
                            node = this.getPreviousFromPath(++index);
                        }
                        boolean isDestructiveParam = false;
                        if (node instanceof Block && (block = (Block)node).isParameterBlock() && oNode != null && bNode != null && bNode.lhs().equals((Object)oNode)) {
                            JsFunctionImpl currentFnImpl = this.modelBuilder.getCurrentDeclarationFunction();
                            property = (JsObjectImpl)currentFnImpl.getParameter(name.getName());
                            isDestructiveParam = true;
                        }
                        if (!isDestructiveParam) {
                            property = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, propertyNode, name, this.modelBuilder, true);
                        }
                    }
                } else {
                    JsObjectImpl newProperty = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, propertyNode, name, this.modelBuilder, true);
                    if (newProperty != null) {
                        newProperty.addOccurrence(property.getDeclarationName().getOffsetRange());
                        for (Occurrence occurrence : property.getOccurrences()) {
                            newProperty.addOccurrence(occurrence.getOffsetRange());
                        }
                        property = newProperty;
                    }
                }
                if (property != null) {
                    property.getParent().addProperty(name.getName(), property);
                    property.setDeclared(true);
                    if (key instanceof IdentNode && ((IdentNode)key).isPrivate() && property.getModifiers().contains(Modifier.PUBLIC)) {
                        property.getModifiers().remove(Modifier.PUBLIC);
                        property.getModifiers().add(Modifier.PROTECTED);
                    }
                    if (propertyNode.isStatic()) {
                        property.getModifiers().add(Modifier.STATIC);
                    }
                    if (!(value instanceof CallNode)) {
                        Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, (Node)value);
                        if (!types.isEmpty()) {
                            property.addAssignment(types, name.getOffsetRange().getStart());
                        }
                        if (value instanceof IdentNode) {
                            IdentNode iNode = (IdentNode)value;
                            if (!iNode.getPropertyName().equals(name.getName())) {
                                this.addOccurence((IdentNode)value, false);
                            } else if (parent.getParent() != null) {
                                this.occurrenceBuilder.addOccurrence(name.getName(), ModelVisitor.getOffsetRange(iNode), this.modelBuilder.getCurrentDeclarationScope(), parent.getParent(), this.modelBuilder.getCurrentWith(), false, false);
                            }
                        }
                    }
                }
            }
        }
        if (propertyNode.isComputed()) {
            propertyNode.getKey().accept((NodeVisitor)this);
        }
        return super.enterPropertyNode(propertyNode);
    }

    @Override
    public boolean enterClassElement(ClassElement classElement) {
        Expression key = classElement.getKey();
        Expression value = classElement.getValue();
        List decorators = classElement.getDecorators();
        if (decorators != null && !decorators.isEmpty()) {
            for (Expression decorator : decorators) {
                if (decorator instanceof IdentNode) {
                    this.addOccurence((IdentNode)decorator, false, true);
                    continue;
                }
                decorator.accept((NodeVisitor)this);
            }
        }
        if (!(!(key instanceof IdentNode) && !(key instanceof LiteralNode) || value instanceof ObjectNode || value instanceof FunctionNode || classElement.isComputed())) {
            JsObjectImpl parent = this.modelBuilder.getCurrentObject();
            Identifier name = null;
            if (key instanceof IdentNode) {
                name = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (IdentNode)key);
            } else if (key instanceof LiteralNode) {
                name = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (LiteralNode)key);
            }
            if (name != null) {
                JsObjectImpl property;
                if (key instanceof IdentNode && value instanceof IdentNode) {
                    JsObject variable;
                    IdentNode iKey = (IdentNode)key;
                    IdentNode iValue = (IdentNode)value;
                    if (iKey.getName().equals(iValue.getName()) && iKey.getStart() == iValue.getStart() && iKey.getFinish() == iValue.getFinish() && (variable = ModelUtils.getScopeVariable(this.modelBuilder.getCurrentDeclarationScope(), name.getName())) != null) {
                        parent.addProperty(variable.getName(), variable);
                        variable.addOccurrence(name.getOffsetRange());
                        return false;
                    }
                }
                if ((property = (JsObjectImpl)parent.getProperty(name.getName())) == null) {
                    if (parent.getJSKind() == JsElement.Kind.OBJECT_LITERAL || parent.getJSKind() == JsElement.Kind.ANONYMOUS_OBJECT) {
                        property = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (PropertyNode)classElement, name, this.modelBuilder, true);
                    } else {
                        Block block;
                        int index = 1;
                        Object node = this.getPreviousFromPath(index);
                        BinaryNode bNode = null;
                        ObjectNode oNode = null;
                        while (index < this.getPath().size() && !(node instanceof Block)) {
                            if (bNode == null && node instanceof BinaryNode) {
                                bNode = (BinaryNode)node;
                            } else if (oNode == null && node instanceof ObjectNode) {
                                oNode = (ObjectNode)node;
                            }
                            node = this.getPreviousFromPath(++index);
                        }
                        boolean isDestructiveParam = false;
                        if (node instanceof Block && (block = (Block)node).isParameterBlock() && oNode != null && bNode != null && bNode.lhs().equals((Object)oNode)) {
                            JsFunctionImpl currentFnImpl = this.modelBuilder.getCurrentDeclarationFunction();
                            property = (JsObjectImpl)currentFnImpl.getParameter(name.getName());
                            isDestructiveParam = true;
                        }
                        if (!isDestructiveParam) {
                            property = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (PropertyNode)classElement, name, this.modelBuilder, true);
                        }
                    }
                } else {
                    JsObjectImpl newProperty = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (PropertyNode)classElement, name, this.modelBuilder, true);
                    if (newProperty != null) {
                        newProperty.addOccurrence(property.getDeclarationName().getOffsetRange());
                        for (Occurrence occurrence : property.getOccurrences()) {
                            newProperty.addOccurrence(occurrence.getOffsetRange());
                        }
                        property = newProperty;
                    }
                }
                if (property != null) {
                    property.getParent().addProperty(name.getName(), property);
                    property.setDeclared(true);
                    if (key instanceof IdentNode && ((IdentNode)key).isPrivate() && property.getModifiers().contains(Modifier.PUBLIC)) {
                        property.getModifiers().remove(Modifier.PUBLIC);
                        property.getModifiers().add(Modifier.PROTECTED);
                    }
                    if (classElement.isStatic()) {
                        property.getModifiers().add(Modifier.STATIC);
                    }
                    if (!(value instanceof CallNode)) {
                        Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, (Node)value);
                        if (!types.isEmpty()) {
                            property.addAssignment(types, name.getOffsetRange().getStart());
                        }
                        if (value instanceof IdentNode) {
                            IdentNode iNode = (IdentNode)value;
                            if (!iNode.getPropertyName().equals(name.getName())) {
                                this.addOccurence((IdentNode)value, false);
                            } else if (parent.getParent() != null) {
                                this.occurrenceBuilder.addOccurrence(name.getName(), ModelVisitor.getOffsetRange(iNode), this.modelBuilder.getCurrentDeclarationScope(), parent.getParent(), this.modelBuilder.getCurrentWith(), false, false);
                            }
                        }
                    }
                }
            }
        }
        if (classElement.isComputed()) {
            classElement.getKey().accept((NodeVisitor)this);
        }
        return super.enterClassElement(classElement);
    }

    @Override
    public boolean enterReturnNode(ReturnNode returnNode) {
        Expression expression = returnNode.getExpression();
        Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, (Node)expression);
        if (expression == null) {
            types.add(new TypeUsage("undefined", returnNode.getStart(), true));
        } else {
            if (expression instanceof IdentNode) {
                this.addOccurence((IdentNode)expression, false);
            }
            if (types.isEmpty()) {
                types.add(new TypeUsage("unresolved", returnNode.getStart(), true));
            }
        }
        JsFunctionImpl function = this.modelBuilder.getCurrentDeclarationFunction();
        function.addReturnType(types);
        return super.enterReturnNode(returnNode);
    }

    @Override
    public boolean enterTernaryNode(TernaryNode ternaryNode) {
        if (ternaryNode.getTest() instanceof IdentNode) {
            this.addOccurence((IdentNode)ternaryNode.getTest(), false);
        }
        if (ternaryNode.getTrueExpression().getExpression() instanceof IdentNode) {
            this.addOccurence((IdentNode)ternaryNode.getTrueExpression().getExpression(), false);
        }
        if (ternaryNode.getFalseExpression().getExpression() instanceof IdentNode) {
            this.addOccurence((IdentNode)ternaryNode.getFalseExpression().getExpression(), false);
        }
        return super.enterTernaryNode(ternaryNode);
    }

    @Override
    public boolean enterUnaryNode(UnaryNode unaryNode) {
        if (unaryNode.getExpression() instanceof IdentNode) {
            this.addOccurence((IdentNode)unaryNode.getExpression(), false);
        }
        return super.enterUnaryNode(unaryNode);
    }

    @Override
    public boolean enterVarNode(VarNode varNode) {
        block37: {
            ClassNode cNode;
            List decorators;
            Expression init;
            block38: {
                block36: {
                    init = varNode.getInit();
                    FunctionNode rNode = null;
                    if (init instanceof FunctionNode) {
                        rNode = (FunctionNode)init;
                    } else if (init instanceof BinaryNode) {
                        BinaryNode bNode = (BinaryNode)init;
                        while (bNode.rhs() instanceof BinaryNode) {
                            bNode = (BinaryNode)bNode.rhs();
                        }
                        if (bNode.rhs() instanceof FunctionNode) {
                            rNode = (FunctionNode)bNode.rhs();
                        }
                    } else if (init instanceof UnaryNode && ((UnaryNode)init).getExpression() instanceof CallNode && ((CallNode)((UnaryNode)init).getExpression()).getFunction() instanceof FunctionNode) {
                        rNode = (FunctionNode)((CallNode)((UnaryNode)init).getExpression()).getFunction();
                    }
                    if (init instanceof ObjectNode || rNode != null || init instanceof LiteralNode.ArrayLiteralNode || init instanceof ClassNode || varNode.isExport()) break block36;
                    JsObject parent = this.modelBuilder.getCurrentObject();
                    if (parent instanceof CatchBlockImpl) {
                        parent = parent.getParent();
                    }
                    while (parent instanceof JsWith) {
                        parent = parent.getParent();
                    }
                    JsObjectImpl variable = (JsObjectImpl)parent.getProperty(varNode.getName().getName());
                    Identifier name = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, varNode.getName());
                    if (name == null) break block37;
                    if (variable == null) {
                        Node lastVisited = this.getPreviousFromPath(1);
                        if (parent instanceof JsFunctionImpl && lastVisited instanceof Block && ((Block)lastVisited).isParameterBlock()) {
                            variable = new ParameterObject(parent, name, parent.getMimeType(), parent.getSourceLabel());
                            ((JsFunctionImpl)parent).addParameter(variable);
                        } else {
                            variable = new JsObjectImpl(parent, name, name.getOffsetRange(), true, this.parserResult.getSnapshot().getMimeType(), null);
                            parent.addProperty(name.getName(), variable);
                        }
                        if (parent.getJSKind() != JsElement.Kind.FILE) {
                            variable.getModifiers().remove(Modifier.PUBLIC);
                            variable.getModifiers().add(Modifier.PRIVATE);
                        }
                        variable.addOccurrence(name.getOffsetRange());
                    } else if (!variable.isDeclared()) {
                        JsObjectImpl newVariable = new JsObjectImpl(parent, name, name.getOffsetRange(), true, this.parserResult.getSnapshot().getMimeType(), null);
                        newVariable.addOccurrence(name.getOffsetRange());
                        for (String string : variable.getProperties().keySet()) {
                            JsObject property = variable.getProperty(string);
                            if (property instanceof JsObjectImpl) {
                                ((JsObjectImpl)property).setParent(newVariable);
                            }
                            newVariable.addProperty(string, property);
                        }
                        if (parent.getJSKind() != JsElement.Kind.FILE) {
                            newVariable.getModifiers().remove(Modifier.PUBLIC);
                            newVariable.getModifiers().add(Modifier.PRIVATE);
                        }
                        for (TypeUsage typeUsage : variable.getAssignments()) {
                            newVariable.addAssignment(typeUsage, typeUsage.getOffset());
                        }
                        for (Occurrence occurrence : variable.getOccurrences()) {
                            newVariable.addOccurrence(occurrence.getOffsetRange());
                        }
                        parent.addProperty(name.getName(), newVariable);
                        variable = newVariable;
                    }
                    JsDocumentationHolder docHolder = JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)this.parserResult);
                    variable.setDeprecated(docHolder.isDeprecated((Node)varNode));
                    variable.setDocumentation(docHolder.getDocumentation((Node)varNode));
                    if (docHolder.isConstant((Node)varNode)) {
                        variable.setJsKind(JsElement.Kind.CONSTANT);
                    }
                    if (init instanceof IdentNode) {
                        IdentNode iNode = (IdentNode)init;
                        if (!iNode.getName().equals(variable.getName())) {
                            this.addOccurrence((IdentNode)init, variable.getName());
                        } else {
                            JsFunctionImpl jsFunctionImpl = this.modelBuilder.getCurrentDeclarationFunction();
                            if (jsFunctionImpl != null && jsFunctionImpl.getParameter(variable.getName()) != null) {
                                this.addOccurrence((IdentNode)init, variable.getName());
                            } else {
                                variable.addOccurrence(ModelVisitor.getOffsetRange(iNode));
                            }
                        }
                    }
                    this.varNodeScopes.put(variable, varNode);
                    this.modelBuilder.setCurrentObject(variable);
                    Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, (Node)init);
                    if (this.modelBuilder.getCurrentWith() != null) {
                        ((JsWithObjectImpl)this.modelBuilder.getCurrentWith()).addObjectWithAssignment(variable);
                    }
                    for (TypeUsage type : types) {
                        variable.addAssignment(type, varNode.getName().getFinish());
                    }
                    List list = docHolder.getReturnType((Node)varNode);
                    if (list != null && !list.isEmpty()) {
                        for (Type type : list) {
                            variable.addAssignment(new TypeUsage(type.getType(), type.getOffset(), true), varNode.getName().getFinish());
                        }
                    }
                    if (!varNode.isConst()) break block37;
                    variable.setJsKind(JsElement.Kind.CONSTANT);
                    break block37;
                }
                if (!(init instanceof ObjectNode) || varNode.isExport()) break block38;
                JsFunctionImpl function = this.modelBuilder.getCurrentDeclarationFunction();
                Identifier name = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, varNode.getName());
                if (name == null) break block37;
                JsObjectImpl variable = (JsObjectImpl)function.getProperty(name.getName());
                if (variable != null) {
                    variable.setDeclared(true);
                } else {
                    List<Identifier> fqName = ModelVisitor.getName(varNode);
                    variable = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, (ObjectNode)varNode.getInit(), fqName, this.modelBuilder, true);
                }
                if (variable == null) break block37;
                variable.setJsKind(JsElement.Kind.OBJECT_LITERAL);
                this.varNodeScopes.put(variable, varNode);
                this.modelBuilder.setCurrentObject(variable);
                break block37;
            }
            if (init instanceof ObjectNode && varNode.isExport()) {
                return false;
            }
            if (init instanceof ClassNode && (decorators = (cNode = (ClassNode)init).getDecorators()) != null && !decorators.isEmpty()) {
                for (Expression decorator : decorators) {
                    if (decorator instanceof IdentNode) {
                        this.addOccurence((IdentNode)decorator, false, true);
                        continue;
                    }
                    decorator.accept((NodeVisitor)this);
                }
            }
        }
        return super.enterVarNode(varNode);
    }

    @Override
    public Node leaveVarNode(VarNode varNode) {
        Expression init = varNode.getInit();
        FunctionNode rNode = null;
        if (init instanceof BinaryNode) {
            BinaryNode bNode = (BinaryNode)init;
            while (bNode.rhs() instanceof BinaryNode) {
                bNode = (BinaryNode)bNode.rhs();
            }
            if (bNode.rhs() instanceof FunctionNode) {
                rNode = (FunctionNode)bNode.rhs();
                List<Identifier> name = ModelVisitor.getNodeName((Node)bNode.lhs(), this.parserResult);
                if (name != null && !name.isEmpty()) {
                    JsObject parent;
                    boolean isPriviliged;
                    int i;
                    int n = i = isPriviliged ? 1 : 0;
                    for (parent = (isPriviliged = name.get(0).getName().equals("this")) ? this.resolveThis(this.modelBuilder.getCurrentObject()) : this.modelBuilder.getCurrentObject(); parent != null && i < name.size(); parent = parent.getProperty(name.get(i).getName()), ++i) {
                    }
                    if (parent instanceof JsFunction) {
                        Identifier propertyName = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, varNode.getName());
                        EnumSet<Modifier> modifiers = isPriviliged ? EnumSet.of(Modifier.PROTECTED) : (this.modelBuilder.getCurrentDeclarationFunction().getJSKind() == JsElement.Kind.FILE ? EnumSet.of(Modifier.PUBLIC) : EnumSet.of(Modifier.PRIVATE));
                        JsFunctionReference property = new JsFunctionReference((JsObject)this.modelBuilder.getCurrentObject(), propertyName, (JsFunction)parent, true, modifiers);
                        this.modelBuilder.getCurrentObject().addProperty(propertyName.getName(), property);
                        property.addOccurrence(propertyName.getOffsetRange());
                    }
                }
            }
        } else if (init instanceof FunctionNode) {
            rNode = (FunctionNode)init;
        } else if (init instanceof UnaryNode && ((UnaryNode)init).getExpression() instanceof CallNode && ((CallNode)((UnaryNode)init).getExpression()).getFunction() instanceof FunctionNode) {
            rNode = (FunctionNode)((CallNode)((UnaryNode)init).getExpression()).getFunction();
        }
        if (rNode == null && !(init instanceof LiteralNode.ArrayLiteralNode) && org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, varNode.getName()) != null) {
            JsDocumentationHolder docHolder = JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)this.parserResult);
            List properties = docHolder.getProperties((Node)varNode);
            for (DocParameter docProperty : properties) {
                String propertyName = docProperty.getParamName().getName();
                int delta = 0;
                String[] names = propertyName.indexOf(46) > 0 ? propertyName.split("\\.") : new String[]{propertyName};
                JsObject parent = this.modelBuilder.getCurrentObject();
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    JsObject property = parent.getProperty(name);
                    int startOffset = docProperty.getParamName().getOffsetRange().getStart() + delta;
                    int endOffset = startOffset + name.length();
                    OffsetRange offsetRange = new OffsetRange(startOffset, endOffset);
                    if (property == null) {
                        Identifier iden = new Identifier(name, offsetRange);
                        property = new JsObjectImpl(parent, iden, offsetRange, true, "text/javascript", null);
                        parent.addProperty(name, property);
                    }
                    property.addOccurrence(offsetRange);
                    if (i == names.length - 1) {
                        for (Type type : docProperty.getParamTypes()) {
                            property.addAssignment(new TypeUsage(type.getType(), endOffset), endOffset);
                        }
                    }
                    delta = delta + name.length() + 1;
                    parent = property;
                }
            }
        }
        if (this.varNodeScopes.containsKey(this.modelBuilder.getCurrentObject())) {
            this.varNodeScopes.remove(this.modelBuilder.getCurrentObject());
            this.modelBuilder.reset();
        }
        return super.leaveVarNode(varNode);
    }

    @Override
    public boolean enterWithNode(WithNode withNode) {
        JsObjectImpl currentObject = this.modelBuilder.getCurrentObject();
        Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.modelBuilder, (Node)withNode.getExpression());
        JsWithObjectImpl withObject = new JsWithObjectImpl(currentObject, this.modelBuilder.getUnigueNameForWithObject(), types, new OffsetRange(withNode.getStart(), withNode.getFinish()), new OffsetRange(withNode.getExpression().getStart(), withNode.getExpression().getFinish()), this.modelBuilder.getCurrentWith(), this.parserResult.getSnapshot().getMimeType(), null);
        currentObject.addProperty(withObject.getName(), withObject);
        this.modelBuilder.setCurrentObject(withObject);
        withNode.getBody().accept((NodeVisitor)this);
        this.modelBuilder.reset();
        return false;
    }

    public Map<FunctionInterceptor, Collection<FunctionCall>> getCallsForProcessing() {
        return this.functionCalls;
    }

    private boolean fillName(AccessNode node, List<String> result) {
        List<Identifier> fqn = ModelVisitor.getName(node);
        if (fqn != null) {
            for (int i = fqn.size() - 1; i >= 0; --i) {
                result.add(0, fqn.get(i).getName());
            }
        }
        for (JsObject current = this.modelBuilder.getCurrentObject(); current != null && current.getDeclarationName() != null; current = current.getParent()) {
            if (current == this.modelBuilder.getGlobal()) continue;
            result.add(0, current.getDeclarationName().getName());
        }
        return true;
    }

    private boolean fillName(IndexNode node, List<String> result) {
        LiteralNode literal;
        Expression index = node.getIndex();
        Expression base = node.getBase();
        if (index instanceof LiteralNode && base instanceof AccessNode && (literal = (LiteralNode)index).isString()) {
            result.add(0, literal.getString());
            List<Identifier> fqn = ModelVisitor.getName((AccessNode)base);
            for (int i = fqn.size() - 1; i >= 0; --i) {
                result.add(0, fqn.get(i).getName());
            }
            return true;
        }
        return false;
    }

    private List<Identifier> getName(PropertyNode propertyNode) {
        FunctionNode fNode;
        String fName;
        Node previousNode;
        ArrayList<Identifier> name = new ArrayList<Identifier>(1);
        if ((propertyNode.getGetter() != null || propertyNode.getSetter() != null) && (previousNode = this.getPreviousFromPath(1)) instanceof FunctionNode && ((fName = (fNode = (FunctionNode)previousNode).getIdent().getName()).startsWith("get ") || fName.startsWith("set "))) {
            name.add(new Identifier(fName, new OffsetRange(fNode.getIdent().getStart(), fNode.getIdent().getFinish())));
            return name;
        }
        return ModelVisitor.getName(propertyNode, this.parserResult);
    }

    private static List<Identifier> getName(PropertyNode propertyNode, org.netbeans.modules.javascript2.types.spi.ParserResult parserResult) {
        ArrayList<Identifier> name = new ArrayList<Identifier>(1);
        if (propertyNode.getKey() instanceof IdentNode) {
            IdentNode ident = (IdentNode)propertyNode.getKey();
            name.add(new Identifier(ident.getName(), ModelVisitor.getOffsetRange(ident)));
        } else if (propertyNode.getKey() instanceof LiteralNode) {
            LiteralNode lNode = (LiteralNode)propertyNode.getKey();
            name.add(new Identifier(lNode.getString(), new OffsetRange(lNode.getStart(), lNode.getFinish())));
        }
        return name;
    }

    private static List<Identifier> getName(VarNode varNode) {
        ArrayList<Identifier> name = new ArrayList<Identifier>();
        name.add(new Identifier(varNode.getName().getName(), new OffsetRange(varNode.getName().getStart(), varNode.getName().getFinish())));
        return name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Identifier> getName(BinaryNode binaryNode, org.netbeans.modules.javascript2.types.spi.ParserResult parserResult) {
        ArrayList<Identifier> name = new ArrayList();
        Expression lhs = binaryNode.lhs();
        if (lhs instanceof AccessNode) {
            return ModelVisitor.getName((AccessNode)lhs);
        }
        if (lhs instanceof IdentNode) {
            IdentNode ident = (IdentNode)lhs;
            name.add(new Identifier(ident.getName(), ModelVisitor.getOffsetRange(ident)));
            return name;
        } else {
            if (!(lhs instanceof IndexNode)) return name;
            IndexNode indexNode = (IndexNode)lhs;
            if (indexNode.getBase() instanceof AccessNode) {
                List<Identifier> aName = ModelVisitor.getName((AccessNode)indexNode.getBase());
                if (aName == null) return null;
                name.addAll(ModelVisitor.getName((AccessNode)indexNode.getBase()));
            } else if (indexNode.getBase() instanceof IdentNode) {
                name.add(org.netbeans.modules.javascript2.model.ModelElementFactory.create(parserResult, (IdentNode)indexNode.getBase()));
            }
            if (!(indexNode.getIndex() instanceof LiteralNode)) return null;
            LiteralNode lNode = (LiteralNode)indexNode.getIndex();
            name.add(new Identifier(lNode.getPropertyName(), new OffsetRange(lNode.getStart(), lNode.getFinish())));
        }
        return name;
    }

    private static List<Identifier> getName(AccessNode aNode) {
        LiteralNode lNode;
        ArrayList<Identifier> name = new ArrayList<Identifier>();
        name.add(new Identifier(aNode.getProperty(), new OffsetRange(aNode.getFinish() - aNode.getProperty().length(), aNode.getFinish())));
        Expression base = aNode.getBase();
        while (base instanceof AccessNode || base instanceof CallNode || base instanceof IndexNode) {
            if (base instanceof CallNode) {
                CallNode cNode = (CallNode)base;
                base = cNode.getFunction();
            } else if (base instanceof IndexNode) {
                IndexNode iNode = (IndexNode)base;
                if (iNode.getIndex() instanceof LiteralNode) {
                    lNode = (LiteralNode)iNode.getIndex();
                    if (lNode.isString()) {
                        name.add(new Identifier(lNode.getPropertyName(), new OffsetRange(lNode.getStart(), lNode.getFinish())));
                    }
                } else {
                    return null;
                }
                base = iNode.getBase();
            }
            if (!(base instanceof AccessNode)) continue;
            AccessNode aaNode = (AccessNode)base;
            base = aaNode.getBase();
            name.add(new Identifier(aaNode.getProperty(), new OffsetRange(aaNode.getFinish() - aaNode.getProperty().length(), aaNode.getFinish())));
        }
        Identifier baseIdent = null;
        if (base instanceof IdentNode) {
            IdentNode ident = (IdentNode)base;
            baseIdent = new Identifier(ident.getName(), ModelVisitor.getOffsetRange(ident));
        } else if (base instanceof LiteralNode && (lNode = (LiteralNode)base).isNumeric()) {
            baseIdent = new Identifier("Number", OffsetRange.NONE);
        }
        if (baseIdent != null) {
            name.add(baseIdent);
            Collections.reverse(name);
            return name;
        }
        return null;
    }

    private JsObject createJsObject(AccessNode accessNode, org.netbeans.modules.javascript2.types.spi.ParserResult parserResult, ModelBuilder modelBuilder) {
        BinaryNode bNode;
        List<Identifier> fqn = ModelVisitor.getName(accessNode);
        if (fqn == null) {
            return null;
        }
        JsObject object = null;
        Identifier name = fqn.get(0);
        if (!"this".equals(fqn.get(0).getName())) {
            if (modelBuilder.getCurrentWith() == null) {
                JsObjectImpl global;
                DeclarationScopeImpl currentDS = modelBuilder.getCurrentDeclarationScope();
                JsObject variable = ModelUtils.getScopeVariable(currentDS, name.getName());
                if (variable != null) {
                    if (variable instanceof ParameterObject || variable.getModifiers().contains(Modifier.PRIVATE)) {
                        object = (JsObjectImpl)variable;
                    } else {
                        Node lastNode;
                        DeclarationScope variableDS = ModelUtils.getDeclarationScope(variable);
                        if (!variableDS.equals(currentDS)) {
                            object = (JsObjectImpl)variable;
                        } else if (currentDS.getProperty(name.getName()) != null && (lastNode = this.getPreviousFromPath(2)) instanceof BinaryNode && (bNode = (BinaryNode)lastNode).lhs().equals((Object)accessNode)) {
                            object = (JsObjectImpl)variable;
                        }
                    }
                }
                if (object == null && (object = (JsObjectImpl)(global = modelBuilder.getGlobal()).getProperty(name.getName())) == null) {
                    object = new JsObjectImpl(global, name, name.getOffsetRange(), false, global.getMimeType(), global.getSourceLabel());
                    global.addProperty(name.getName(), object);
                }
            } else {
                JsWith withObject = modelBuilder.getCurrentWith();
                object = (JsObjectImpl)withObject.getProperty(name.getName());
                if (object == null) {
                    object = new JsObjectImpl(withObject, name, name.getOffsetRange(), false, parserResult.getSnapshot().getMimeType(), null);
                    withObject.addProperty(name.getName(), object);
                }
            }
            object.addOccurrence(name.getOffsetRange());
        } else {
            JsObject prototype;
            JsObjectImpl current = modelBuilder.getCurrentObject();
            object = (JsObjectImpl)this.resolveThis(current);
            if (object != null && object.getProperty(fqn.get(1).getName()) == null && (prototype = object.getProperty("prototype")) != null && prototype.getProperty(fqn.get(1).getName()) != null) {
                object = prototype;
            }
            if (object != null && fqn.size() == 2) {
                String lastName = fqn.get(1).getName();
                JsObjectImpl property = (JsObjectImpl)object.getProperty(lastName);
                Node lastVisited = this.getPreviousFromPath(2);
                if (property != null && lastName.equals(property.getName()) && property.getModifiers().contains(Modifier.PRIVATE) && property.getModifiers().size() == 1 && !(lastVisited instanceof CallNode)) {
                    property.getModifiers().remove(Modifier.PRIVATE);
                    property.getModifiers().add(Modifier.PROTECTED);
                }
            }
        }
        if (object != null) {
            JsObjectImpl property = null;
            for (int i = 1; i < fqn.size(); ++i) {
                property = (JsObjectImpl)object.getProperty(fqn.get(i).getName());
                if (property == null) continue;
                object = property;
            }
            int pathSize = this.getPath().size();
            Node lastVisited = pathSize > 1 ? this.getPath().get(pathSize - 2) : this.getPath().get(0);
            boolean onLeftSite = false;
            if (lastVisited instanceof BinaryNode) {
                bNode = (BinaryNode)lastVisited;
                onLeftSite = bNode.tokenType() == TokenType.ASSIGN && bNode.lhs().equals((Object)accessNode);
            }
            String propertyName = accessNode.getProperty();
            int propertyOffsetStart = accessNode.getBase().getFinish() + 1;
            int propertyOffsetEnd = propertyOffsetStart + propertyName.length();
            if (property != null) {
                OffsetRange range = new OffsetRange(propertyOffsetStart, propertyOffsetEnd);
                if (onLeftSite && !property.isDeclared()) {
                    property.setDeclared(true);
                    property.setDeclarationName(new Identifier(property.getName(), range));
                }
                property.addOccurrence(range);
            } else {
                name = org.netbeans.modules.javascript2.model.ModelElementFactory.create(parserResult, propertyName, propertyOffsetStart, propertyOffsetEnd);
                if (name != null) {
                    if (pathSize > 1 && this.getPath().get(pathSize - 2) instanceof CallNode) {
                        CallNode cNode = (CallNode)this.getPath().get(pathSize - 2);
                        if (!cNode.getArgs().contains(accessNode)) {
                            property = org.netbeans.modules.javascript2.model.ModelElementFactory.createVirtualFunction(parserResult, object, name, cNode.getArgs().size());
                        } else {
                            property = new JsObjectImpl(object, name, name.getOffsetRange(), onLeftSite, parserResult.getSnapshot().getMimeType(), null);
                            property.addOccurrence(name.getOffsetRange());
                        }
                    } else {
                        JsDocumentationHolder docHolder;
                        boolean setDocumentation = false;
                        if (this.isPriviliged(accessNode) && this.getPath().size() > 1 && (this.getPreviousFromPath(2) instanceof ExpressionStatement || this.getPreviousFromPath(1) instanceof ExpressionStatement)) {
                            onLeftSite = true;
                            setDocumentation = true;
                        }
                        property = new JsObjectImpl(object, name, name.getOffsetRange(), onLeftSite, parserResult.getSnapshot().getMimeType(), null);
                        property.addOccurrence(name.getOffsetRange());
                        if (setDocumentation && (docHolder = JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)parserResult)) != null) {
                            property.setDocumentation(docHolder.getDocumentation((Node)accessNode));
                            property.setDeprecated(docHolder.isDeprecated((Node)accessNode));
                            List returnTypes = docHolder.getReturnType((Node)accessNode);
                            if (!returnTypes.isEmpty()) {
                                for (Type type : returnTypes) {
                                    property.addAssignment(new TypeUsage(type.getType(), type.getOffset(), true), accessNode.getFinish());
                                }
                            }
                            this.setModifiersFromDoc(property, docHolder.getModifiers((Node)accessNode));
                        }
                    }
                    object.addProperty(name.getName(), property);
                    object = property;
                }
            }
        }
        return object;
    }

    public static List<Identifier> getNodeName(Node node, org.netbeans.modules.javascript2.types.spi.ParserResult parserResult) {
        if (node instanceof AccessNode) {
            return ModelVisitor.getName((AccessNode)node);
        }
        if (node instanceof BinaryNode) {
            return ModelVisitor.getName((BinaryNode)node, parserResult);
        }
        if (node instanceof VarNode) {
            return ModelVisitor.getName((VarNode)node);
        }
        if (node instanceof PropertyNode) {
            return ModelVisitor.getName((PropertyNode)node, parserResult);
        }
        if (node instanceof IdentNode) {
            IdentNode ident = (IdentNode)node;
            return Arrays.asList(new Identifier(ident.getName(), ModelVisitor.getOffsetRange(ident)));
        }
        if (node instanceof FunctionNode) {
            if (((FunctionNode)node).getKind() == FunctionNode.Kind.SCRIPT) {
                return Collections.emptyList();
            }
            IdentNode ident = ((FunctionNode)node).getIdent();
            return Arrays.asList(new Identifier(ident.getName(), ModelVisitor.getOffsetRange(ident)));
        }
        return Collections.emptyList();
    }

    private boolean isInPropertyNode() {
        boolean inFunction = false;
        for (int i = this.getPath().size() - 1; i > 0; --i) {
            Node node = this.getPath().get(i);
            if (node instanceof FunctionNode) {
                if (!inFunction) {
                    inFunction = true;
                    continue;
                }
                return false;
            }
            if (!(node instanceof PropertyNode)) continue;
            return true;
        }
        return false;
    }

    private void addOccurence(IdentNode iNode, boolean leftSite) {
        this.addOccurence(iNode, leftSite, false);
    }

    private void addOccurence(IdentNode iNode, boolean leftSite, boolean isFunction) {
        if (!iNode.isDestructuredParameter()) {
            this.addOccurrence(iNode.getName(), ModelVisitor.getOffsetRange(iNode), leftSite, isFunction);
        }
    }

    private void addOccurrence(String name, OffsetRange range, boolean leftSite, boolean isFunction) {
        if ("this".equals(name) || "undefined".equals(name)) {
            return;
        }
        this.occurrenceBuilder.addOccurrence(name, range, this.modelBuilder.getCurrentDeclarationScope(), this.modelBuilder.getCurrentObject(), this.modelBuilder.getCurrentWith(), isFunction, leftSite);
    }

    private void addOccurrence(IdentNode iNode, String name) {
        String valueName = iNode.getName();
        if (!name.equals(valueName)) {
            this.addOccurence(iNode, false);
        } else {
            DeclarationScopeImpl scope = this.modelBuilder.getCurrentDeclarationScope();
            JsObject parameter = null;
            if (scope instanceof JsFunction) {
                JsFunction function = (JsFunction)((Object)scope);
                parameter = function.getParameter(iNode.getName());
            }
            if (parameter != null) {
                parameter.addOccurrence(ModelVisitor.getOffsetRange(iNode));
            } else {
                Identifier nameI;
                boolean found = false;
                JsObject jsProperty = ((JsObject)scope).getProperty(valueName);
                if (jsProperty != null && jsProperty.isDeclared()) {
                    found = true;
                    jsProperty.addOccurrence(new OffsetRange(iNode.getStart(), iNode.getFinish()));
                } else {
                    JsObject jsObject = ModelUtils.getScopeVariable(scope.getParentScope(), valueName);
                    if (jsObject != null) {
                        jsObject.addOccurrence(new OffsetRange(iNode.getStart(), iNode.getFinish()));
                        found = true;
                    }
                }
                if (!found && (nameI = org.netbeans.modules.javascript2.model.ModelElementFactory.create(this.parserResult, iNode)) != null) {
                    JsObjectImpl newObject = new JsObjectImpl(this.modelBuilder.getGlobal(), nameI, nameI.getOffsetRange(), false, this.parserResult.getSnapshot().getMimeType(), null);
                    newObject.addOccurrence(nameI.getOffsetRange());
                    this.modelBuilder.getGlobal().addProperty(nameI.getName(), newObject);
                }
            }
        }
    }

    private void addDocNameOccurence(JsObjectImpl jsObject) {
        JsDocumentationHolder holder = JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)this.parserResult);
        JsComment comment = holder.getCommentForOffset(jsObject.getOffset(), holder.getCommentBlocks());
        if (comment != null) {
            for (DocParameter docParameter : comment.getParameters()) {
                Identifier paramName = docParameter.getParamName();
                String name = docParameter.getParamName() == null ? "" : docParameter.getParamName().getName();
                if (!name.equals(jsObject.getName())) continue;
                jsObject.addOccurrence(paramName.getOffsetRange());
            }
        }
    }

    private boolean belongsTo(JsObject parent, String property) {
        boolean result;
        boolean bl = result = parent.getProperty(property) != null;
        if (!result && parent instanceof JsFunction) {
            result = ((JsFunction)parent).getParameter(property) != null;
        }
        return result;
    }

    private JsObject processLhs(Identifier name, JsObject parent, boolean lastOnLeft) {
        JsObject lObject = null;
        if (name != null) {
            boolean hasGrandParent;
            if ("this".equals(name.getName())) {
                return null;
            }
            String newVarName = name.getName();
            boolean hasParent = this.belongsTo(parent, newVarName);
            boolean bl = hasGrandParent = parent.getJSKind() == JsElement.Kind.METHOD && this.belongsTo(parent.getParent(), newVarName);
            if (!hasParent && !hasGrandParent && this.modelBuilder.getGlobal().getProperty(newVarName) == null) {
                this.addOccurrence(name.getName(), name.getOffsetRange(), lastOnLeft, false);
            } else {
                if (hasParent) {
                    lObject = parent.getProperty(newVarName);
                    if (lObject == null && parent instanceof JsFunction) {
                        lObject = ((JsFunction)parent).getParameter(newVarName);
                    }
                } else if (hasGrandParent && (lObject = parent.getParent().getProperty(newVarName)) == null && parent.getParent() instanceof JsFunction) {
                    lObject = ((JsFunction)parent.getParent()).getParameter(newVarName);
                }
                if (lObject != null) {
                    ((JsObjectImpl)lObject).addOccurrence(name.getOffsetRange());
                } else {
                    this.addOccurrence(name.getName(), name.getOffsetRange(), lastOnLeft, false);
                }
            }
            if (lObject == null) {
                Model model = Model.getModel((ParserResult)this.parserResult, false);
                Collection<? extends JsObject> variables = model.getVariables(name.getOffsetRange().getStart());
                for (JsObject jsObject : variables) {
                    if (!jsObject.getName().equals(newVarName)) continue;
                    lObject = (JsObjectImpl)jsObject;
                    break;
                }
                if (lObject == null) {
                    JsObject where = this.modelBuilder.getCurrentWith() == null ? model.getGlobalObject() : this.modelBuilder.getCurrentWith();
                    lObject = new JsObjectImpl(where, name, name.getOffsetRange(), lastOnLeft, this.parserResult.getSnapshot().getMimeType(), null);
                    where.addProperty(name.getName(), lObject);
                }
            }
        }
        return lObject;
    }

    public static OffsetRange getOffsetRange(IdentNode node) {
        return new OffsetRange(node.getStart(), node.getStart() + node.getName().length());
    }

    public static OffsetRange getOffsetRange(Node node) {
        return new OffsetRange(node.getStart(), node.getFinish());
    }

    public static OffsetRange getOffsetRange(FunctionNode node) {
        return new OffsetRange(Token.descPosition((long)node.getFirstToken()), Token.descPosition((long)node.getLastToken()) + Token.descLength((long)node.getLastToken()));
    }

    @Override
    public JsObject resolveThis(JsObject where) {
        while (!(where instanceof JsFunction && where.getJSKind() != JsElement.Kind.ARROW_FUNCTION || where == null || where.getJSKind() == JsElement.Kind.CLASS)) {
            where = where.getParent();
        }
        JsElement.Kind whereKind = where.getJSKind();
        if (whereKind == JsElement.Kind.FILE) {
            return where;
        }
        if (whereKind == JsElement.Kind.CLASS) {
            return where;
        }
        if (whereKind.isFunction() && where.getModifiers().contains(Modifier.PRIVATE)) {
            return where;
        }
        JsObject parent = where.getParent();
        if (parent == null) {
            return where;
        }
        JsElement.Kind parentKind = parent.getJSKind();
        if (parentKind == JsElement.Kind.FILE && !where.isAnonymous()) {
            return where;
        }
        if ("prototype".equals(parent.getName())) {
            return where.getParent().getParent();
        }
        if (whereKind == JsElement.Kind.CONSTRUCTOR) {
            if (parentKind == JsElement.Kind.CLASS) {
                return parent;
            }
            return where;
        }
        if (whereKind.isFunction() && !where.getModifiers().contains(Modifier.PRIVATE) && !where.isAnonymous()) {
            if (parent.getJSKind() == JsElement.Kind.OBJECT_LITERAL) {
                if (Character.isUpperCase(where.getName().charAt(0))) {
                    return where;
                }
                if (Character.isUpperCase(parent.getName().charAt(0))) {
                    return parent;
                }
            } else {
                if (parent.isDeclared() || this.modelBuilder.getCurrentWith() != null) {
                    return parent;
                }
                return where;
            }
        }
        if (this.isInPropertyNode()) {
            return parent;
        }
        return where;
    }

    private JsObject resolveThisInSingletonPattern(JsObject where) {
        UnaryNode uNode;
        int pathIndex = 1;
        Node lastNode = this.getPreviousFromPath(1);
        if (lastNode instanceof FunctionNode && !this.canBeSingletonPattern(pathIndex)) {
            ++pathIndex;
        }
        while (pathIndex < this.getPath().size() && !(this.getPreviousFromPath(pathIndex) instanceof FunctionNode)) {
            ++pathIndex;
        }
        if (this.canBeSingletonPattern(pathIndex) && (uNode = (UnaryNode)this.getPreviousFromPath(pathIndex + 2)).tokenType() == TokenType.NEW) {
            JsObject parent;
            String name = null;
            boolean simpleName = true;
            if (this.getPreviousFromPath(pathIndex + 3) instanceof BinaryNode) {
                BinaryNode bNode = (BinaryNode)this.getPreviousFromPath(pathIndex + 3);
                if (bNode.tokenType() == TokenType.ASSIGN) {
                    if (bNode.lhs() instanceof AccessNode) {
                        List<Identifier> identifier = ModelVisitor.getName((AccessNode)bNode.lhs());
                        if (identifier != null) {
                            if (!identifier.isEmpty() && "this".equals(identifier.get(0).getName())) {
                                identifier.remove(0);
                            }
                            if (identifier.size() == 1) {
                                name = identifier.get(0).getName();
                            } else {
                                StringBuilder sb = new StringBuilder();
                                for (Identifier part : identifier) {
                                    sb.append(part.getName()).append('.');
                                }
                                name = sb.toString().substring(0, sb.length() - 1);
                                simpleName = false;
                            }
                        }
                    } else if (bNode.lhs() instanceof IdentNode) {
                        name = ((IdentNode)bNode.lhs()).getName();
                    }
                }
            } else if (this.getPreviousFromPath(pathIndex + 3) instanceof VarNode) {
                VarNode vNode = (VarNode)this.getPreviousFromPath(pathIndex + 3);
                name = vNode.getName().getName();
            }
            JsObject jsObject = parent = where.getParent() == null ? where : where.getParent();
            if (name != null) {
                if (simpleName) {
                    for (parent = where; parent != null && parent.getProperty(name) == null; parent = parent.getParent()) {
                    }
                    if (parent != null && parent.getProperty(name) != null) {
                        if (parent.getName().equals(name) && parent.getProperty(name).getJSKind().isFunction()) {
                            return parent;
                        }
                        return parent.getProperty(name);
                    }
                } else {
                    JsObject property = ModelUtils.findJsObjectByName(ModelUtils.getGlobalObject(parent), name);
                    if (property != null) {
                        return property;
                    }
                }
            }
        }
        return null;
    }

    private boolean canBeSingletonPattern(int pathIndex) {
        return this.getPath().size() > pathIndex + 3 && this.getPreviousFromPath(pathIndex) instanceof FunctionNode && this.getPreviousFromPath(pathIndex + 1) instanceof CallNode && ((CallNode)this.getPreviousFromPath(pathIndex + 1)).getFunction().equals((Object)this.getPreviousFromPath(pathIndex)) && this.getPreviousFromPath(pathIndex + 2) instanceof UnaryNode && (this.getPreviousFromPath(pathIndex + 3) instanceof BinaryNode || this.getPreviousFromPath(pathIndex + 3) instanceof VarNode);
    }

    private boolean isPriviliged(AccessNode aNode) {
        Expression node = aNode.getBase();
        while (node instanceof AccessNode) {
            node = ((AccessNode)node).getBase();
        }
        return node instanceof IdentNode && "this".endsWith(((IdentNode)node).getName());
    }

    private void setModifiersFromDoc(JsObject object, Set<JsModifier> modifiers) {
        if (modifiers != null && !modifiers.isEmpty()) {
            for (JsModifier jsModifier : modifiers) {
                switch (jsModifier) {
                    case PRIVATE: {
                        object.getModifiers().add(Modifier.PRIVATE);
                        break;
                    }
                    case PUBLIC: {
                        object.getModifiers().remove(Modifier.PROTECTED);
                        object.getModifiers().remove(Modifier.PRIVATE);
                        object.getModifiers().add(Modifier.PUBLIC);
                        break;
                    }
                    case STATIC: {
                        object.getModifiers().add(Modifier.STATIC);
                    }
                }
            }
        }
    }

    private void processObjectPropertyAssignment(CallNode cNode) {
        JsObjectImpl targetObject;
        List<Identifier> targetName;
        List args;
        if (!(cNode.getFunction() instanceof AccessNode)) {
            return;
        }
        AccessNode aNode = (AccessNode)cNode.getFunction();
        if ("assign".equals(aNode.getProperty()) && aNode.getBase() instanceof IdentNode && "Object".equals(((IdentNode)aNode.getBase()).getName()) && (args = cNode.getArgs()) != null && !args.isEmpty() && (targetName = ModelVisitor.getNodeName((Node)args.get(0), this.parserResult)) != null && !targetName.isEmpty() && (targetObject = ModelUtils.getJsObject(this.modelBuilder, targetName, false)) != null) {
            for (int i = 1; i < args.size(); ++i) {
                JsObjectImpl argObject;
                Expression expression = (Expression)args.get(i);
                List<Identifier> argName = ModelVisitor.getNodeName((Node)expression, this.parserResult);
                if (argName == null || argName.isEmpty() || (argObject = ModelUtils.getJsObject(this.modelBuilder, argName, false)) == null) continue;
                for (JsObject jsObject : argObject.getProperties().values()) {
                    JsObjectReference copyProperty = jsObject.getJSKind().isFunction() ? new JsFunctionReference((JsObject)targetObject, jsObject.getDeclarationName(), (JsFunction)jsObject, true, (Set<Modifier>)jsObject.getModifiers()) : new JsObjectReference((JsObject)targetObject, jsObject.getDeclarationName(), jsObject, true, jsObject.getModifiers());
                    targetObject.addProperty(copyProperty.getName(), copyProperty);
                }
            }
        }
    }

    private String debugInfo(Node node) {
        StringBuilder sb = new StringBuilder();
        if (node instanceof FunctionNode) {
            FunctionNode fn = (FunctionNode)node;
            sb.append("FunctionNode name: ").append(fn.getName());
            sb.append(", Ident: ").append(fn.getIdent());
            if (fn.allVarsInScope()) {
                sb.append(", allVarsInScope");
            }
            if (fn.isAnonymous()) {
                sb.append(", isAnonymous");
            }
            if (fn.isDeclared()) {
                sb.append(", isDeclared");
            }
            if (fn.isMethod()) {
                sb.append(", isMethod");
            }
            if (fn.isNamedFunctionExpression()) {
                sb.append(", isNamedFunctionExpression");
            }
            if (fn.isVarArg()) {
                sb.append(", isVarArg");
            }
            if (fn.hasDeclaredFunctions()) {
                sb.append(", hasDeclaredFunctions");
            }
            if (fn.hasDirectSuper()) {
                sb.append(", hasDirectSuper");
            }
        } else if (node instanceof VarNode) {
            VarNode vn = (VarNode)node;
            sb.append("VarNode ").append(vn.getName());
            if (vn.isBlockScoped()) {
                sb.append(", isBlockScoped");
            }
            if (vn.isConst()) {
                sb.append(", isConst");
            }
            if (vn.isFunctionDeclaration()) {
                sb.append(", isFunctionDeclaration");
            }
            if (vn.isLet()) {
                sb.append(", isLet");
            }
        } else {
            sb.append(node.getClass().getName());
        }
        return sb.toString();
    }

    public static final class Provider
    implements ModelResolver.Provider {
        @Override
        public ModelResolver create(org.netbeans.modules.javascript2.types.spi.ParserResult result, OccurrenceBuilder occurrenceBuilder) {
            ModelVisitor visitor = new ModelVisitor(result, occurrenceBuilder);
            return visitor;
        }
    }

    public static class FunctionCall {
        private final String name;
        private final DeclarationScope scope;
        private final Collection<FunctionArgument> arguments;
        private final int callOffset;

        public FunctionCall(String name, DeclarationScope scope, Collection<FunctionArgument> arguments, int callOffset) {
            this.name = name;
            this.scope = scope;
            this.arguments = arguments;
            this.callOffset = callOffset;
        }

        public String getName() {
            return this.name;
        }

        public DeclarationScope getScope() {
            return this.scope;
        }

        public Collection<FunctionArgument> getArguments() {
            return this.arguments;
        }

        public int getCallOffset() {
            return this.callOffset;
        }
    }
}

