/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ko4j.debugging;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.netbeans.modules.ko4j.debugging.MessageDispatcherImpl;
import org.netbeans.modules.ko4j.debugging.Transport;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.spi.Factory;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

final class Server {
    private static final Server INSTANCE = new Server();
    private ServerSocket socket;

    Server() {
    }

    public static Server getInstance() {
        return INSTANCE;
    }

    public int acceptClient() {
        this.ensureStarted();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Socket client = Server.this.socket.accept();
                    MessageDispatcherImpl dispatcher = new MessageDispatcherImpl();
                    Transport transport = new Transport(client, dispatcher);
                    WebKitDebugging webKit = Factory.createWebKitDebugging((TransportImplementation)transport);
                    Lookup context = Lookups.fixed((Object[])new Object[]{transport, webKit, dispatcher});
                    PageInspector.getDefault().inspectPage(context);
                }
                catch (IOException ioex) {
                    Exceptions.printStackTrace((Throwable)ioex);
                }
            }
        });
        t.start();
        return this.socket.getLocalPort();
    }

    private synchronized void ensureStarted() {
        if (this.socket != null) {
            return;
        }
        try {
            this.socket = new ServerSocket();
            this.socket.bind(null);
        }
        catch (IOException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
        }
    }
}

