/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Position;
import jdk.jshell.Snippet;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.GuardedException;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.nbjshell.SnippetWrapping;
import org.netbeans.modules.jshell.model.ConsoleContents;
import org.netbeans.modules.jshell.model.ConsoleEvent;
import org.netbeans.modules.jshell.model.ConsoleListener;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.JShellToken;
import org.netbeans.modules.jshell.model.Rng;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.parsing.JShellParser;
import org.netbeans.modules.jshell.parsing.ModelAccessor;
import org.netbeans.modules.jshell.parsing.ShellAccessBridge;
import org.netbeans.modules.jshell.parsing.SnippetRegistry;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class ConsoleModel {
    private static Logger LOG = Logger.getLogger(ConsoleModel.class.getName());
    private volatile boolean valid;
    private final ShellAccessBridge shellBridge;
    private final LineDocument document;
    private int processed;
    private Position inputEndPos = null;
    private volatile ConsoleSection executingSection;
    private List<ConsoleSection> scrollbackSections = new ArrayList<ConsoleSection>();
    private ConsoleSection lastSection = null;
    private ConsoleSection inputSection;
    private final RequestProcessor evaluator;
    private int progressPos = -1;
    private volatile boolean executing;
    private Position inputOffset;
    private boolean writingResponse;
    private volatile boolean inputValid = false;
    private RequestProcessor.Task inputTask;
    private volatile List<ConsoleListener> listeners = Collections.emptyList();
    private ThreadLocal<Boolean> refreshPending = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final RequestProcessor RP = new RequestProcessor(ConsoleModel.class);
    private List<ConsoleSection> allSections = null;
    private Map<Snippet, SnippetHandle> sections = new HashMap<Snippet, SnippetHandle>();
    private Map<ConsoleSection, List<SnippetHandle>> snippets = new HashMap<ConsoleSection, List<SnippetHandle>>();
    private DocumentFilter.FilterBypass bypass = new DocumentFilter.FilterBypass(){

        @Override
        public Document getDocument() {
            return ConsoleModel.this.document;
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            if (ConsoleModel.this.bypass != this) {
                ConsoleModel.this.bypass.remove(offset, length);
            } else {
                ConsoleModel.this.document.remove(offset, length);
            }
        }

        @Override
        public void insertString(int offset, String string, AttributeSet attr) throws BadLocationException {
            if (ConsoleModel.this.bypass != this) {
                ConsoleModel.this.bypass.insertString(offset, string, attr);
            } else {
                ConsoleModel.this.document.insertString(offset, string, attr);
            }
        }

        @Override
        public void replace(int offset, int length, String string, AttributeSet attrs) throws BadLocationException {
            if (ConsoleModel.this.bypass != this) {
                ConsoleModel.this.bypass.replace(offset, length, string, attrs);
            } else {
                ConsoleModel.this.document.remove(offset, length);
                ConsoleModel.this.document.insertString(offset, string, attrs);
            }
        }
    };
    private DocFilter f;
    private DocL l;

    public synchronized int getInputEndOffset() {
        Position p = this.inputEndPos;
        return p == null ? this.document.getLength() : p.getOffset();
    }

    private ConsoleModel(ConsoleModel orig, ConsoleSection replaceInput) {
        this.scrollbackSections = new ArrayList<ConsoleSection>(orig.scrollbackSections);
        if (orig.lastSection != null) {
            this.scrollbackSections.add(orig.lastSection);
        }
        this.inputSection = replaceInput != null ? replaceInput : orig.inputSection;
        this.executingSection = orig.executingSection;
        this.document = orig.document;
        this.evaluator = orig.evaluator;
        this.progressPos = orig.progressPos;
        this.sections = new HashMap<Snippet, SnippetHandle>(orig.sections);
        this.snippets = new HashMap<ConsoleSection, List<SnippetHandle>>(orig.snippets);
        this.inputValid = true;
        this.shellBridge = orig.shellBridge;
    }

    public boolean isWritingResponse() {
        return this.writingResponse;
    }

    public int getWritablePos() {
        ConsoleSection s = this.getInputSection();
        return s == null ? this.document.getLength() + 1 : s.getPartBegin();
    }

    public int getInputOffset() {
        ConsoleSection s = this.getInputSection();
        return this.isExecute() || s == null ? -1 : s.getStart();
    }

    private int getScrollbackEnd() {
        if (this.isExecute()) {
            if (this.executingSection == null) {
                if (this.lastSection != null) {
                    return this.lastSection.getEnd();
                }
                ConsoleSection s = this.getInputSection();
                if (s != null) {
                    return s.getStart();
                }
            }
            return this.document.getLength();
        }
        ConsoleSection s = this.getInputSection();
        if (this.inputOffset == null) {
            return s != null ? s.getStart() : this.document.getLength();
        }
        return this.inputOffset.getOffset();
    }

    public synchronized void addConsoleListener(ConsoleListener l) {
        ArrayList<ConsoleListener> ll = new ArrayList<ConsoleListener>(this.listeners);
        ll.add(l);
        this.listeners = ll;
    }

    public synchronized void removeConsoleListener(ConsoleListener l) {
        ArrayList<ConsoleListener> ll = new ArrayList<ConsoleListener>(this.listeners);
        ll.remove(l);
        this.listeners = ll;
    }

    public void setProgressPos(int pos) {
        this.progressPos = pos;
    }

    public boolean isExecute() {
        return this.executing;
    }

    public synchronized ConsoleSection getExecutingSection() {
        return this.executingSection;
    }

    public synchronized ConsoleSection getLastInputSection() {
        return this.isExecute() ? this.executingSection : this.getInputSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIfIdle() {
        ConsoleModel consoleModel = this;
        synchronized (consoleModel) {
            if (this.isExecute()) {
                return;
            }
        }
        this.processInputSection(false);
    }

    public ConsoleSection parseInputSection(CharSequence snap) {
        InputReader rdr = new InputReader(snap);
        rdr.run();
        return rdr.newSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsoleSection processInputSection(boolean force) {
        ConsoleModel consoleModel = this;
        synchronized (consoleModel) {
            if (!this.shouldRefresh() && !force) {
                return this.getInputSection();
            }
        }
        this.refreshInput(force, true).waitFinished();
        return this.inputSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsoleSection getInputSection() {
        ConsoleModel consoleModel = this;
        synchronized (consoleModel) {
            if (this.isExecute()) {
                return null;
            }
        }
        if (this.shouldRefresh()) {
            this.refreshInput(false, false);
        }
        return this.inputSection;
    }

    private boolean isRefreshPending() {
        return this.refreshPending.get();
    }

    private synchronized boolean shouldRefresh() {
        return !this.inputValid && this.inputTask == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task refreshInput(boolean force, boolean now) {
        boolean wait;
        RequestProcessor.Task t;
        ConsoleModel consoleModel = this;
        synchronized (consoleModel) {
            boolean sched;
            boolean rp = this.isRefreshPending();
            if (rp || this.executing) {
                return Task.EMPTY;
            }
            this.inputValid = false;
            boolean bl = sched = this.inputTask == null;
            if (this.inputTask != null) {
                if (!force) {
                    return this.inputTask;
                }
                if (this.inputTask.cancel()) {
                    this.inputTask.schedule(now ? 0 : 200);
                    sched = true;
                }
            }
            if (sched) {
                InputReader r = new InputReader();
                this.inputTask = this.evaluator.post((Runnable)r, now ? 0 : 200);
                r.myTask = this.inputTask;
            }
            t = this.inputTask;
            wait = now && !rp && this.evaluator.isRequestProcessorThread();
        }
        if (wait) {
            t.waitFinished();
        }
        return t;
    }

    private synchronized void clearInputTask(Task t) {
        if (t == this.inputTask) {
            this.inputTask = null;
        }
    }

    private synchronized void discardSection(ConsoleSection section) {
        if (section == null) {
            return;
        }
        Collection snips = this.snippets.remove(section);
        if (snips != null) {
            this.sections.keySet().removeAll(snips.stream().filter(h -> h.getSnippet() != null).map(h -> h.getSnippet()).collect(Collectors.toList()));
        }
    }

    private void notifyUpdated(ConsoleSection s) {
        ConsoleEvent e = new ConsoleEvent(this, s);
        this.listeners.stream().forEach(l -> l.sectionUpdated(e));
    }

    private void notifyUpdated(List<ConsoleSection> s) {
        ConsoleEvent e = new ConsoleEvent(this, s);
        this.listeners.stream().forEach(l -> l.sectionUpdated(e));
    }

    public Document getDocument() {
        return this.document;
    }

    private void notifyCreated(List<ConsoleSection> s) {
        ConsoleEvent e = new ConsoleEvent(this, s);
        this.listeners.stream().forEach(l -> l.sectionCreated(e));
    }

    private synchronized ConsoleSection getOpenSection() {
        if (this.lastSection != null) {
            return this.lastSection;
        }
        if (this.executingSection != null) {
            return this.executingSection;
        }
        return this.inputSection;
    }

    public synchronized ConsoleSection getLastSection() {
        ConsoleSection s = this.getOpenSection();
        if (s != null) {
            return s;
        }
        if (!this.scrollbackSections.isEmpty()) {
            return this.scrollbackSections.get(this.scrollbackSections.size() - 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void textAppended(int end) {
        int start;
        ConsoleModel consoleModel = this;
        synchronized (consoleModel) {
            ConsoleSection last = this.lastSection;
            start = last != null ? last.getStart() : (this.executingSection != null ? this.executingSection.getEnd() : (this.inputSection != null ? this.inputSection.getStart() : this.processed));
        }
        TokenHierarchy th = TokenHierarchy.get((Document)this.getDocument());
        TokenSequence seq = th.tokenSequence();
        assert (seq != null);
        seq.move(start);
        JShellParser parser2 = new JShellParser(this.shellBridge, (TokenSequence<JShellToken>)seq, 0, this.document.getLength());
        parser2.execute();
        final List<ConsoleSection> sections = parser2.sections();
        if (sections.isEmpty()) {
            return;
        }
        ConsoleModel consoleModel2 = this;
        synchronized (consoleModel2) {
            new EventBuffer(){

                @Override
                protected void doUpdates() {
                    for (ConsoleSection s : sections) {
                        if (ConsoleModel.this.lastSection != null && s.getStart() < ConsoleModel.this.lastSection.getStart()) continue;
                        this.addOrUpdate(s);
                    }
                }
            }.runUpdate();
        }
        this.invalidate();
    }

    private synchronized void setInputSection(ConsoleSection s) {
        this.executingSection = null;
        if (s != null) {
            this.executing = false;
        }
        this.inputSection = s;
        this.inputValid = true;
        this.invalidate();
    }

    private void change(DocumentEvent e) {
        int s = e.getOffset();
        int l = e.getLength();
        ConsoleSection i = this.getInputSection();
        if (this.isExecute()) {
            if (this.progressPos != -1 && s >= this.progressPos) {
                return;
            }
            this.textAppended(this.document.getLength() + 1);
        } else if (this.inputSection != null && this.inputSection.getStart() < s) {
            this.refreshInput(true, false);
        }
    }

    private synchronized void invalidate() {
        this.allSections = null;
    }

    public synchronized List<ConsoleSection> getSections() {
        ConsoleSection is;
        if (this.allSections != null) {
            return this.allSections;
        }
        ArrayList<ConsoleSection> res = new ArrayList<ConsoleSection>(this.scrollbackSections);
        if (this.lastSection != null) {
            res.add(this.lastSection);
        }
        if ((is = this.getInputSection()) != null) {
            res.add(is);
        }
        this.allSections = res;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beforeExecution(boolean external) {
        ConsoleModel consoleModel;
        RequestProcessor.Task t = null;
        ConsoleSection is = null;
        while (true) {
            consoleModel = this;
            synchronized (consoleModel) {
                assert (!this.isExecute());
                t = this.inputTask;
            }
            if (t != null) {
                t.waitFinished();
            }
            is = this.getInputSection();
            consoleModel = this;
            synchronized (consoleModel) {
                if (this.inputTask == null) {
                    this.executingSection = is;
                    this.executing = true;
                    break;
                }
            }
        }
        consoleModel = this;
        synchronized (consoleModel) {
            ConsoleSection finIs = is;
            if (finIs != null && this.executingSection != null) {
                if (this.lastSection != null) {
                    this.scrollbackSections.add(this.lastSection);
                }
                this.lastSection = null;
                this.scrollbackSections.add(this.executingSection);
            }
            if (is != null) {
                RP.post(() -> {
                    this.notifyUpdated(finIs);
                    ConsoleEvent e = new ConsoleEvent(this, finIs, true);
                    this.listeners.stream().forEach(l -> l.executing(e));
                });
            }
        }
    }

    synchronized void afterExecution() {
        ConsoleSection s = this.executingSection;
        if (s != null) {
            RP.post(() -> {
                ConsoleEvent e = new ConsoleEvent(this, s, false);
                this.listeners.stream().forEach(l -> l.executing(e));
            });
        }
        this.executingSection = null;
        if (this.inputSection == null) {
            // empty if block
        }
    }

    public static ConsoleModel get(Document d) {
        return (ConsoleModel)d.getProperty(ConsoleModel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ConsoleModel create(Document d, ShellAccessBridge shellBridge, RequestProcessor evaluator) {
        ConsoleModel mdl;
        LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)d, LineDocument.class);
        if (ld == null) {
            return null;
        }
        Document document = d;
        synchronized (document) {
            mdl = (ConsoleModel)ld.getProperty(ConsoleModel.class);
            if (mdl != null) {
                return mdl;
            }
            mdl = new ConsoleModel(ld, evaluator, shellBridge);
            d.putProperty(ConsoleModel.class, mdl);
            mdl.init();
        }
        return mdl;
    }

    public ConsoleModel(LineDocument document, RequestProcessor evaluator, ShellAccessBridge shellBridge) {
        this.document = document;
        this.evaluator = evaluator;
        this.shellBridge = shellBridge;
    }

    private void init() {
        AbstractDocument ad = (AbstractDocument)LineDocumentUtils.asRequired((Document)this.document, AbstractDocument.class);
        this.valid = true;
        ad.setDocumentFilter(new DocFilter());
        try {
            ad.replace(0, 0, "", null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.l = new DocL();
        DocumentUtilities.addPriorityDocumentListener((Document)this.document, (DocumentListener)this.l, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
    }

    public String getInputText() {
        int wr = this.getWritablePos();
        if (wr != -1) {
            String[] res = new String[1];
            this.document.render(() -> {
                try {
                    res[0] = this.document.getText(wr, this.document.getLength() - wr);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
            if (res[0] != null) {
                return res[0];
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertResponseString(int offset, String text, AttributeSet attrs) throws BadLocationException {
        boolean saveResponse = this.writingResponse;
        try {
            this.writingResponse = true;
            this.getProtectionBypass().insertString(offset, text, null);
        }
        finally {
            this.writingResponse = saveResponse;
        }
    }

    public void writeToShellDocument(String text) {
        AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)this.document, AtomicLockDocument.class);
        boolean saveResponse = this.writingResponse;
        ald.runAtomic(() -> {
            this.writingResponse = true;
            try {
                int offset = this.getInputOffset();
                if (offset == -1) {
                    offset = this.document.getLength();
                }
                this.getProtectionBypass().insertString(offset, text, null);
                this.textAppended(offset);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                this.writingResponse = saveResponse;
            }
        });
    }

    public DocumentFilter.FilterBypass getProtectionBypass() {
        return this.bypass;
    }

    public List<String> history() {
        return this.scrollbackSections.stream().filter(s -> s.getType().input).map(s -> s.getContents((Document)this.document)).collect(Collectors.toList());
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() {
        ConsoleModel consoleModel = this;
        synchronized (consoleModel) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        this.document.putProperty(ConsoleModel.class, null);
        this.document.removeDocumentListener((DocumentListener)this.l);
        ConsoleEvent ev = new ConsoleEvent(this, Collections.emptyList());
        this.listeners.stream().forEach(l -> l.closed(ev));
    }

    void ensureInputSectionAvailable(Supplier<String> promptSupplier) {
        ConsoleSection s = this.processInputSection(true);
        if (s != null) {
            return;
        }
        String promptText = "\n" + promptSupplier.get();
        this.writeToShellDocument(promptText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConsoleModel snapshot(CharSequence s) {
        ConsoleSection input = this.parseInputSection(s);
        ConsoleModel consoleModel = this;
        synchronized (consoleModel) {
            return new ConsoleModel(this, input);
        }
    }

    public static void initModel() {
    }

    static {
        ModelAccessor.impl(new ModelAccImpl());
    }

    static class ModelAccImpl
    extends ModelAccessor {
        ModelAccImpl() {
        }

        @Override
        public ConsoleModel createModel(LineDocument document, RequestProcessor evaluator, ShellAccessBridge shellBridge) {
            return ConsoleModel.create((Document)document, shellBridge, evaluator);
        }

        @Override
        public SnippetHandle createHandle(SnippetRegistry r, ConsoleSection s, Rng[] fragments, SnippetWrapping wrap, boolean transientSnippet) {
            return new SnippetHandle(r, s, fragments, wrap, transientSnippet);
        }

        @Override
        public void setFile(SnippetHandle h, FileObject f) {
            h.setFile(f);
        }

        @Override
        public ConsoleContents copyModel(ShellSession session, ConsoleModel m, Snapshot snapshot) {
            ConsoleContents c = new ConsoleContents(session, m.snapshot(snapshot.getText()), snapshot);
            return c;
        }

        @Override
        public void installSnippets(ConsoleContents contents, ConsoleSection s, List<SnippetHandle> snippets) {
            contents.installSnippetHandles(s, snippets);
        }

        @Override
        public void extendSection(ConsoleSection section, int start, int end, List<Rng> ranges, List<Rng> snippets) {
            if (ranges == null || ranges.isEmpty()) {
                section.extendWithPart(start, end);
            } else {
                section.extendToWithRanges(ranges);
            }
            if (snippets != null && snippets.size() > 1) {
                section.setSnippetRanges(snippets);
            }
        }

        @Override
        public void setSectionComplete(ConsoleSection target, boolean complete) {
            target.setComplete(complete);
        }

        public void beforeExecution(ConsoleModel model) {
            model.beforeExecution(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(ConsoleModel model, boolean external, Runnable c, Supplier<String> prompt) {
            model.beforeExecution(external);
            try {
                c.run();
            }
            finally {
                model.ensureInputSectionAvailable(prompt);
                model.afterExecution();
            }
        }

        public void afterExecution(ConsoleModel model) {
            model.afterExecution();
        }
    }

    private class DocFilter
    extends DocumentFilter {
        private DocFilter() {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (!ConsoleModel.this.isValid()) {
                super.replace(fb, offset, length, text, attrs);
                return;
            }
            ConsoleModel.this.bypass = fb;
            int wr = ConsoleModel.this.getWritablePos();
            if (offset >= wr) {
                super.replace(fb, offset, length, text, attrs);
                return;
            }
            int endPos = offset + length;
            if (endPos < wr) {
                return;
            }
            int remainder = offset + length - wr;
            int prefix = wr - offset;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (!ConsoleModel.this.isValid()) {
                super.insertString(fb, offset, string, attr);
                return;
            }
            ConsoleModel.this.bypass = fb;
            if (offset < ConsoleModel.this.getWritablePos()) {
                throw new GuardedException(string, offset);
            }
            super.insertString(fb, offset, string, attr);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            if (!ConsoleModel.this.isValid()) {
                super.remove(fb, offset, length);
                return;
            }
            ConsoleModel.this.bypass = fb;
            if (offset < ConsoleModel.this.getWritablePos() && length != 0) {
                throw new GuardedException(null, offset);
            }
            super.remove(fb, offset, length);
        }
    }

    private class DocL
    implements DocumentListener {
        private DocL() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ConsoleModel.this.change(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private abstract class EventBuffer {
        private List<ConsoleSection> created;
        private List<ConsoleSection> updated;
        ConsoleSection prevInput;

        private EventBuffer() {
        }

        protected abstract void doUpdates();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runUpdate() {
            boolean myInput;
            List<ConsoleSection> myUpdated;
            List<ConsoleSection> myCreated;
            ConsoleSection executing = ConsoleModel.this.executingSection;
            boolean wasInput = executing == null && ConsoleModel.this.inputSection != null;
            boolean same = true;
            ConsoleModel consoleModel = ConsoleModel.this;
            synchronized (consoleModel) {
                this.created = new ArrayList<ConsoleSection>();
                this.updated = new ArrayList<ConsoleSection>();
                try {
                    this.doUpdates();
                    myCreated = this.created;
                    myUpdated = this.updated;
                    myInput = ConsoleModel.this.inputSection != null;
                }
                catch (Throwable throwable) {
                    List<ConsoleSection> myCreated2 = this.created;
                    List<ConsoleSection> myUpdated2 = this.updated;
                    boolean myInput2 = ConsoleModel.this.inputSection != null;
                    this.created = null;
                    this.updated = null;
                    ConsoleModel.this.discardSection(this.prevInput);
                    throw throwable;
                }
                this.created = null;
                this.updated = null;
                ConsoleModel.this.discardSection(this.prevInput);
            }
            if (same &= myUpdated.isEmpty() && myCreated.isEmpty() && myInput != wasInput) {
                return;
            }
            ConsoleModel.this.invalidate();
            RP.post(() -> {
                if (!myUpdated.isEmpty()) {
                    ConsoleModel.this.notifyUpdated(myUpdated);
                }
                if (!myCreated.isEmpty()) {
                    ConsoleModel.this.notifyCreated(myCreated);
                }
                if (!wasInput && myInput && executing != null) {
                    ConsoleEvent e = new ConsoleEvent(ConsoleModel.this, executing, wasInput);
                    ConsoleModel.this.listeners.stream().forEach(t -> t.executing(e));
                }
            });
        }

        protected void addOrUpdate(ConsoleSection s) {
            if (s.getType().input) {
                if (ConsoleModel.this.isExecute() || ConsoleModel.this.inputSection == null) {
                    this.created.add(s);
                } else {
                    this.updated.add(s);
                    this.prevInput = ConsoleModel.this.inputSection;
                }
                ConsoleModel.this.setInputSection(s);
            } else {
                int start = s.getStart();
                if (ConsoleModel.this.lastSection != null) {
                    if (start >= ConsoleModel.this.lastSection.getStart() && start <= ConsoleModel.this.lastSection.getEnd()) {
                        this.updated.add(s);
                    } else {
                        if (start < ConsoleModel.this.lastSection.getEnd()) {
                            throw new IllegalStateException();
                        }
                        ConsoleModel.this.scrollbackSections.add(ConsoleModel.this.lastSection);
                    }
                    ConsoleModel.this.lastSection = s;
                } else {
                    ConsoleSection last;
                    if (!ConsoleModel.this.scrollbackSections.isEmpty() && (last = ConsoleModel.this.scrollbackSections.get(ConsoleModel.this.scrollbackSections.size() - 1)).getEnd() > start) {
                        throw new IllegalStateException();
                    }
                    ConsoleModel.this.lastSection = s;
                    this.created.add(s);
                }
            }
        }
    }

    private class InputReader
    extends EventBuffer
    implements Runnable {
        private int stage;
        private long docSerial;
        private CharSequence contents;
        private ConsoleSection newSection;
        private int inputStart;
        private long endSerial;
        private Position endPos;
        private int stalledInput;
        private Task myTask;
        private CharSequence processSnapshot;
        private List<ConsoleSection> updateSections;

        private InputReader(CharSequence snapshot) {
            this.processSnapshot = snapshot;
        }

        private InputReader() {
        }

        @Override
        public void run() {
            switch (this.stage++) {
                case 0: {
                    LOG.log(Level.FINER, "InputReader starting");
                    this.doIt();
                    break;
                }
                case 1: {
                    try {
                        this.readContents();
                        if (this.contents == null) break;
                        this.parseInput();
                        this.propagateResults();
                        break;
                    }
                    finally {
                        ConsoleModel.this.clearInputTask(this.myTask);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doIt() {
            ConsoleModel consoleModel = ConsoleModel.this;
            synchronized (consoleModel) {
                ConsoleModel.this.refreshPending.set(true);
            }
            try {
                if (this.processSnapshot != null) {
                    this.run();
                } else {
                    ConsoleModel.this.document.render((Runnable)this);
                }
            }
            finally {
                consoleModel = ConsoleModel.this;
                synchronized (consoleModel) {
                    ConsoleModel.this.refreshPending.set(false);
                }
                this.stage = 0;
            }
        }

        private void readContents() {
            this.stalledInput = ConsoleModel.this.getInputOffset();
            if (ConsoleModel.this.isExecute()) {
                return;
            }
            int is = ConsoleModel.this.getScrollbackEnd();
            if (this.stalledInput >= 0 && this.stalledInput < is) {
                this.inputStart = ConsoleModel.this.lastSection != null ? ConsoleModel.this.lastSection.getStart() : this.stalledInput;
                LOG.log(Level.FINER, "Detected stale input. Know input at {0} while anchor moved to {1}. LastSection = {2}, inputStart = {3}", new Object[]{this.stalledInput, is, ConsoleModel.this.lastSection, this.inputStart});
            } else {
                this.inputStart = is;
            }
            try {
                if (this.processSnapshot != null) {
                    this.contents = this.processSnapshot.subSequence(this.inputStart, this.processSnapshot.length()).toString();
                } else {
                    this.contents = DocumentUtilities.getText((Document)ConsoleModel.this.document, (int)this.inputStart, (int)(ConsoleModel.this.document.getLength() - this.inputStart));
                    this.docSerial = DocumentUtilities.getDocumentVersion((Document)ConsoleModel.this.document);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void getPositionAndSerial() {
            if (this.newSection != null) {
                try {
                    if (this.newSection.getEnd() <= ConsoleModel.this.document.getLength()) {
                        this.endPos = ConsoleModel.this.document.createPosition(this.newSection.getEnd(), Position.Bias.Forward);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.endSerial = DocumentUtilities.getDocumentVersion((Document)ConsoleModel.this.document);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void propagateResults() {
            ConsoleModel consoleModel = ConsoleModel.this;
            synchronized (consoleModel) {
                this.runUpdate();
            }
        }

        @Override
        protected void doUpdates() {
            this.getPositionAndSerial();
            if (this.endSerial != this.docSerial) {
                LOG.log(Level.FINER, "Input has changed, discarding....");
                ConsoleModel.this.discardSection(this.newSection);
                return;
            }
            ConsoleModel.this.inputEndPos = this.endPos;
            ConsoleModel.this.inputValid = true;
            if (this.newSection != null) {
                try {
                    ConsoleModel.this.inputOffset = ConsoleModel.this.document.createPosition(this.newSection.getStart(), Position.Bias.Forward);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (this.updateSections != null) {
                for (ConsoleSection s : this.updateSections) {
                    if (ConsoleModel.this.lastSection != null && ConsoleModel.this.lastSection.getStart() > s.getStart()) continue;
                    this.addOrUpdate(s);
                }
            }
        }

        private void parseInput() {
            TokenSequence seq;
            int limit = this.contents.length();
            int initPos = 0;
            if (this.processSnapshot == null) {
                TokenHierarchy th = TokenHierarchy.get((Document)ConsoleModel.this.getDocument());
                seq = th.tokenSequence();
                seq.move(this.inputStart);
                limit += this.inputStart;
            } else {
                TokenHierarchy th = TokenHierarchy.create((CharSequence)this.contents, (Language)Language.find((String)"text/x-repl"));
                seq = th.tokenSequence();
                seq.move(0);
                initPos = this.inputStart;
            }
            JShellParser parser2 = new JShellParser(ConsoleModel.this.shellBridge, (TokenSequence<JShellToken>)seq, initPos, limit);
            parser2.execute();
            ArrayList<ConsoleSection> newSections = new ArrayList<ConsoleSection>(parser2.sections());
            if (newSections.isEmpty()) {
                return;
            }
            LOG.log(Level.FINER, "Read sections: {0}", newSections);
            int iindex = newSections.size() - 1;
            ConsoleSection newInput = (ConsoleSection)newSections.get(iindex);
            if (!newInput.getType().input) {
                LOG.log(Level.FINER, "Last section was not input - bail out");
                return;
            }
            this.updateSections = newSections;
            this.newSection = newInput;
        }
    }
}

