/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.encoding;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public abstract class Decoder
extends CharsetDecoder {
    protected boolean report = true;

    protected Decoder(Charset cs, float averageCharsPerByte, float maxCharsPerByte) {
        super(cs, averageCharsPerByte, maxCharsPerByte);
    }

    protected final void implOnMalformedInput(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("The argument must not be null.");
        }
        if (newAction == CodingErrorAction.IGNORE) {
            throw new IllegalArgumentException("The Encoding Standard does not allow errors to be ignored.");
        }
        if (newAction == CodingErrorAction.REPLACE) {
            this.report = false;
            return;
        }
        if (newAction == CodingErrorAction.REPORT) {
            this.report = true;
            return;
        }
        assert (false) : "Unreachable.";
        throw new IllegalArgumentException("Unknown CodingErrorAction.");
    }

    protected final void implOnUnmappableCharacter(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("The argument must not be null.");
        }
        if (newAction == CodingErrorAction.IGNORE) {
            throw new IllegalArgumentException("The Encoding Standard does not allow errors to be ignored.");
        }
        if (newAction == CodingErrorAction.REPLACE) {
            return;
        }
        if (newAction == CodingErrorAction.REPORT) {
            return;
        }
        assert (false) : "Unreachable.";
        throw new IllegalArgumentException("Unknown CodingErrorAction.");
    }

    protected final void implReplaceWith(String newReplacement) {
        if (!"\ufffd".equals(newReplacement)) {
            throw new IllegalArgumentException("Only U+FFFD is allowed as the replacement.");
        }
    }
}

