/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.JPAParseUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataLoader;
import org.netbeans.modules.j2ee.persistence.unit.PUDataNode;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.XmlMultiViewElement;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PUDataObject
extends XmlMultiViewDataObject {
    public static final String HELP_ID_DESIGN_PERSISTENCE_UNIT = "persistence_multiview_design_persistenceUnitNode";
    private final ModelSynchronizer modelSynchronizer;
    public static final int UPDATE_DELAY = 200;
    private static final int TYPE_TOOLBAR = 0;
    private org.netbeans.modules.j2ee.persistence.dd.common.Persistence persistence;
    private static final String DESIGN_VIEW_ID = "persistence_multiview_design";
    private static final Logger LOG = Logger.getLogger(PUDataObject.class.getName());
    public static final String NO_UI_PU_CLASSES_CHANGED = "non ui pu classes modified";
    public static final String ICON = "org/netbeans/modules/j2ee/persistence/unit/PersistenceIcon.gif";
    public static final String PREFERRED_ID_SOURCE = "persistence_multiview_source";
    public static final String PREFERRED_ID_DESIGN = "persistence_multiview_design";
    static final String PERSISTENCE_UNIT_ADDED_OR_REMOVED = "persistence_unit_added_or_removed";
    protected boolean changedFromUI;

    public PUDataObject(FileObject pf, PUDataLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        this.getEditorSupport().setMIMEType("text/x-persistence1.0+xml");
        this.modelSynchronizer = new ModelSynchronizer(this);
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)validateCookie);
        this.parseDocument();
    }

    protected Node createNodeDelegate() {
        return new PUDataNode(this);
    }

    protected String getEditorMimeType() {
        return "text/x-persistence1.0+xml";
    }

    protected int getXMLMultiViewIndex() {
        return 1;
    }

    public static XmlMultiViewElement createXmlMultiViewElement(Lookup lookup) {
        return new XmlMultiViewElement((XmlMultiViewDataObject)lookup.lookup(XmlMultiViewDataObject.class));
    }

    protected int associateLookup() {
        return 1;
    }

    public void save() {
        EditorCookie edit = (EditorCookie)this.getLookup().lookup(EditorCookie.class);
        if (edit != null) {
            try {
                edit.saveDocument();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean parseDocument() {
        block37: {
            if (this.persistence == null) {
                try {
                    this.persistence = this.getPersistence();
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.INFO, null, ex);
                    return false;
                }
            }
            if (this.isModified()) {
                try {
                    BaseBean cleanPersistence;
                    BaseBean newPersistence;
                    String oldVersion = this.persistence.getVersion();
                    String version = "1.0";
                    try (InputStream is = this.getEditorSupport().getInputStream();){
                        version = JPAParseUtils.getVersion(is);
                    }
                    catch (SAXException ex) {
                        LOG.log(Level.INFO, null, ex);
                    }
                    try (InputStream is = this.getEditorSupport().getInputStream();){
                        if ("3.1".equals(version)) {
                            newPersistence = org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.Persistence.createGraph(is);
                            cleanPersistence = new org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_1.Persistence();
                        } else if ("3.0".equals(version)) {
                            newPersistence = org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.Persistence.createGraph(is);
                            cleanPersistence = new org.netbeans.modules.j2ee.persistence.dd.persistence.model_3_0.Persistence();
                        } else if ("2.2".equals(version)) {
                            newPersistence = org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.Persistence.createGraph(is);
                            cleanPersistence = new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_2.Persistence();
                        } else if ("2.1".equals(version)) {
                            newPersistence = org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.Persistence.createGraph(is);
                            cleanPersistence = new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.Persistence();
                        } else if ("2.0".equals(version)) {
                            newPersistence = org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.Persistence.createGraph(is);
                            cleanPersistence = new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.Persistence();
                        } else {
                            newPersistence = Persistence.createGraph(is);
                            cleanPersistence = new Persistence();
                        }
                    }
                    catch (RuntimeException ex) {
                        LOG.log(Level.INFO, null, ex);
                        return false;
                    }
                    if (newPersistence == null) break block37;
                    try {
                        ((BaseBean)this.persistence).merge(cleanPersistence, 3);
                        ((BaseBean)this.persistence).merge(newPersistence, 3);
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.log(Level.FINE, "IAE thrown during merge, see #104180.", iae);
                        if (!oldVersion.equals(newPersistence.getVersion())) {
                            this.persistence = null;
                            PersistenceMetadata.getDefault().refresh(this.getPrimaryFile());
                            return true;
                        }
                        return false;
                    }
                }
                catch (IOException | IllegalStateException ex) {
                    LOG.log(Level.INFO, null, ex);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean viewCanBeDisplayed() {
        boolean switchView = false;
        NotifyDescriptor.Message nd = null;
        if (FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile()) == null) {
            nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PUDataObject.class, (String)"TXT_StandAlonePersistence", (Object)this.getPrimaryFile().getNameExt()), 2);
            switchView = true;
        } else if (!this.parseDocument() && this.getSelectedPerspective().preferredID().startsWith("persistence_multiview_design")) {
            nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PUDataObject.class, (String)"TXT_DocumentUnparsable", (Object)this.getPrimaryFile().getNameExt()), 2);
            switchView = true;
        } else if (!ProviderUtil.isValidServerInstanceOrNone(FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile())) && this.getSelectedPerspective().preferredID().startsWith("persistence_multiview_design")) {
            nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PUDataObject.class, (String)"TXT_ServerMissing"), 2);
            switchView = true;
        }
        if (switchView) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            SwingUtilities.invokeLater(() -> this.goToXmlView());
        }
        return !switchView;
    }

    public org.netbeans.modules.j2ee.persistence.dd.common.Persistence getPersistence() {
        if (this.persistence == null) {
            try {
                this.persistence = PersistenceMetadata.getDefault().getRoot(this.getPrimaryFile());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        assert (this.persistence != null);
        return this.persistence;
    }

    public void addPersistenceUnit(PersistenceUnit persistenceUnit) {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (project != null) {
            ProviderUtil.makePortableIfPossible(project, persistenceUnit);
        }
        this.getPersistence().addPersistenceUnit(persistenceUnit);
        this.modelUpdated();
        this.firePropertyChange(PERSISTENCE_UNIT_ADDED_OR_REMOVED, false, true);
    }

    public void removePersistenceUnit(PersistenceUnit persistenceUnit) {
        this.getPersistence().removePersistenceUnit(persistenceUnit);
        this.modelUpdated();
        this.firePropertyChange(PERSISTENCE_UNIT_ADDED_OR_REMOVED, false, true);
    }

    public boolean addClass(PersistenceUnit persistenceUnit, String clazz, boolean fromPanel) {
        String[] existing = persistenceUnit.getClass2();
        for (int i = 0; i < existing.length; ++i) {
            if (!clazz.equals(existing[i])) continue;
            return false;
        }
        persistenceUnit.addClass2(clazz);
        this.modelUpdated();
        if (!fromPanel) {
            this.updateUIPanels(persistenceUnit, NO_UI_PU_CLASSES_CHANGED);
        }
        return true;
    }

    public void removeClass(PersistenceUnit persistenceUnit, String clazz, boolean fromPanel) {
        persistenceUnit.removeClass2(clazz);
        this.modelUpdated();
        if (!fromPanel) {
            this.updateUIPanels(persistenceUnit, NO_UI_PU_CLASSES_CHANGED);
        }
    }

    public void showElement(Object element) {
        Object target = null;
        if (element instanceof PersistenceUnit) {
            this.openView(0);
            target = element;
        }
        if (target != null) {
            Object key = target;
            Utils.runInAwtDispatchThread(() -> this.getActiveMultiViewElement0().getSectionView().openPanel(key));
        }
    }

    protected String getPrefixMark() {
        return null;
    }

    public ToolBarMultiViewElement getActiveMultiViewElement0() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    public void modelUpdated() {
        this.setModified(true);
        this.modelSynchronizer.requestUpdateData();
    }

    public boolean isChangedFromUI() {
        return this.changedFromUI;
    }

    public void setChangedFromUI(boolean changedFromUI) {
        this.changedFromUI = changedFromUI;
    }

    private void updateUIPanels(PersistenceUnit unit, String kind) {
        this.firePropertyChange(NO_UI_PU_CLASSES_CHANGED, null, unit);
    }

    public void modelUpdatedFromUI() {
        this.modelSynchronizer.requestUpdateData();
    }

    public void updateDataFromModel(FileLock lock) throws IOException {
        this.modelSynchronizer.updateDataFromModel(this.getPersistence(), lock, true);
    }

    public boolean isDeleteAllowed() {
        return true;
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return true;
    }

    protected Image getXmlViewIcon() {
        return ImageUtilities.loadImage((String)ICON);
    }

    private class ModelSynchronizer
    extends XmlMultiViewDataSynchronizer {
        public ModelSynchronizer(XmlMultiViewDataObject dataObject) {
            super(dataObject, 200);
        }

        protected boolean mayUpdateData(boolean allowDialog) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateDataFromModel(Object model, FileLock lock, boolean modify) {
            if (model == null) {
                return;
            }
            try (StringWriter out = new StringWriter();){
                ((BaseBean)model).write((Writer)out);
                PUDataObject.this.getDataCache().setData(lock, ((Object)out).toString(), modify);
            }
            catch (IOException | Schema2BeansException e) {
                LOG.log(Level.INFO, null, e);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }

        protected Object getModel() {
            try {
                return PUDataObject.this.getPersistence();
            }
            catch (RuntimeException ex) {
                LOG.log(Level.INFO, null, ex);
                return null;
            }
        }

        protected void reloadModelFromData() {
            PUDataObject.this.parseDocument();
        }
    }
}

