/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cloud.oracle.actions.AbstractPasswordPanel;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletAction;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

final class DownloadWalletDialog
extends AbstractPasswordPanel {
    public static final String WALLETS_PATH = "Databases/Wallets";
    private static final String LAST_USED_DIR = "lastUsedDir";
    private JCheckBox addDBCheckbox;
    private JPasswordField dbPasswordField;
    private JLabel dbPasswordLabel;
    private JTextField dbUserField;
    private JLabel dbUserLabel;
    private JButton jButtonBrowse;
    private JLabel jLabel3;
    private JTextArea jTextArea1;
    private JTextField jTextFieldLocation;

    DownloadWalletDialog() {
        this.initComponents();
        TextFieldListener docListener = new TextFieldListener();
        this.jTextFieldLocation.getDocument().addDocumentListener(docListener);
        this.dbUserField.getDocument().addDocumentListener(docListener);
        this.dbPasswordField.getDocument().addDocumentListener(docListener);
    }

    static Optional<WalletInfo> showDialog(OCIItem db) {
        File home = new File(System.getProperty("user.home"));
        String lastUsedDir = NbPreferences.forModule(DownloadWalletAction.class).get(LAST_USED_DIR, home.getAbsolutePath());
        if (!GraphicsEnvironment.isHeadless()) {
            DownloadWalletDialog dlgPanel = new DownloadWalletDialog();
            DialogDescriptor descriptor = new DialogDescriptor((Object)dlgPanel, Bundle.DownloadTitle());
            dlgPanel.setDescriptor(descriptor);
            descriptor.createNotificationLineSupport();
            Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            dialog.setMinimumSize(dlgPanel.getPreferredSize());
            dlgPanel.jTextFieldLocation.setText(lastUsedDir);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION == descriptor.getValue()) {
                String path = dlgPanel.jTextFieldLocation.getText();
                String dbUser = dlgPanel.dbUserField.getText();
                char[] dbPasswd = dlgPanel.dbPasswordField.getPassword();
                NbPreferences.forModule(DownloadWalletAction.class).put(LAST_USED_DIR, path);
                return Optional.of(new WalletInfo(path, DownloadWalletDialog.generatePassword(), dbUser, dbPasswd, db.getKey().getValue()));
            }
        } else {
            try {
                File walletsDir = DownloadWalletDialog.getWalletsDir();
                NotifyDescriptor.InputLine inp = new NotifyDescriptor.InputLine(Bundle.JDBCUsername(), Bundle.JDBCUsername());
                Object selected = DialogDisplayer.getDefault().notify((NotifyDescriptor)inp);
                if (DialogDescriptor.OK_OPTION != selected) {
                    return Optional.empty();
                }
                String username = inp.getInputText().toUpperCase(Locale.US);
                inp = new NotifyDescriptor.PasswordLine(Bundle.JDBCPassword(), Bundle.JDBCPassword());
                selected = DialogDisplayer.getDefault().notify((NotifyDescriptor)inp);
                if (DialogDescriptor.OK_OPTION != selected) {
                    return Optional.empty();
                }
                char[] password = inp.getInputText().toCharArray();
                return Optional.of(new WalletInfo(walletsDir.getAbsolutePath(), DownloadWalletDialog.generatePassword(), username, password, db.getKey().getValue()));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return Optional.empty();
    }

    private void initComponents() {
        this.jTextArea1 = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jTextFieldLocation = new JTextField();
        this.jButtonBrowse = new JButton();
        this.dbUserLabel = new JLabel();
        this.dbPasswordLabel = new JLabel();
        this.dbPasswordField = new JPasswordField();
        this.dbUserField = new JTextField();
        this.addDBCheckbox = new JCheckBox();
        this.setMaximumSize(null);
        this.setMinimumSize(new Dimension(714, 234));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(1);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(null);
        this.jTextArea1.setFocusTraversalKeysEnabled(false);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setMinimumSize(new Dimension(702, 113));
        this.jTextArea1.setOpaque(false);
        this.jTextArea1.setPreferredSize(new Dimension(702, 113));
        this.jTextArea1.setRequestFocusEnabled(false);
        this.jLabel3.setLabelFor(this.jTextFieldLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jLabel3.text"));
        this.jTextFieldLocation.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jTextFieldLocation.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBrowse, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.jButtonBrowse.text"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadWalletDialog.this.jButtonBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.dbUserLabel, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.dbUserLabel.text"));
        this.dbUserLabel.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.dbPasswordLabel, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.dbPasswordLabel.text"));
        this.dbPasswordLabel.setEnabled(false);
        this.dbPasswordField.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.dbPasswordField.text"));
        this.dbPasswordField.setEnabled(false);
        this.dbUserField.setText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.dbUserField.text"));
        this.dbUserField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.addDBCheckbox, (String)NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.addDBCheckbox.text"));
        this.addDBCheckbox.setToolTipText(NbBundle.getMessage(DownloadWalletDialog.class, (String)"DownloadWalletDialog.addDBCheckbox.toolltip"));
        this.addDBCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadWalletDialog.this.addDBCheckboxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextArea1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.dbUserLabel).addComponent(this.dbPasswordLabel)).addGap(27, 27, 27).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldLocation, GroupLayout.Alignment.LEADING).addComponent(this.dbPasswordField).addComponent(this.dbUserField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBrowse)).addGroup(layout.createSequentialGroup().addComponent(this.addDBCheckbox, -2, 344, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTextArea1, -2, 113, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldLocation, -2, -1, -2).addComponent(this.jButtonBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addDBCheckbox, -2, 17, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbUserLabel).addComponent(this.dbUserField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbPasswordLabel).addComponent(this.dbPasswordField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Bundle.LBL_SaveWallet());
        File folder = new File(this.jTextFieldLocation.getText());
        if (!folder.exists()) {
            folder = folder.getParentFile();
        }
        chooser.setCurrentDirectory(folder);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (0 == chooser.showDialog(WindowManager.getDefault().getMainWindow(), Bundle.SelectButton())) {
            this.jTextFieldLocation.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void addDBCheckboxActionPerformed(ActionEvent evt) {
        boolean selected = this.addDBCheckbox.isSelected();
        this.dbUserLabel.setEnabled(selected);
        this.dbUserField.setEnabled(selected);
        this.dbPasswordLabel.setEnabled(selected);
        this.dbPasswordField.setEnabled(selected);
        this.validateDialog();
    }

    @Override
    protected void checkPassword() {
    }

    private boolean isValidDialog() {
        if (this.jTextFieldLocation.getText().isEmpty()) {
            return false;
        }
        if (!this.addDBCheckbox.isSelected()) {
            return true;
        }
        if (this.dbUserField.getText().isEmpty()) {
            return false;
        }
        if (this.dbPasswordField.getPassword() == null) {
            return false;
        }
        return this.dbPasswordField.getPassword().length != 0;
    }

    private void validateDialog() {
        this.descriptor.setValid(this.isValidDialog());
    }

    static File getWalletsDir() throws IOException {
        FileObject fo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)WALLETS_PATH);
        return FileUtil.toFile((FileObject)fo);
    }

    static class WalletInfo {
        private String path;
        private char[] walletPassword;
        private String dbUser;
        private char[] dbPassword;
        private String ocid;

        public WalletInfo(String path, char[] walletPassword, String dbUser, char[] dbPassword, String ocid) {
            this.path = path;
            this.walletPassword = walletPassword;
            this.dbUser = dbUser;
            this.dbPassword = dbPassword;
            this.ocid = ocid;
        }

        public String getPath() {
            return this.path;
        }

        public char[] getWalletPassword() {
            return this.walletPassword;
        }

        public String getDbUser() {
            return this.dbUser;
        }

        public char[] getDbPassword() {
            return this.dbPassword;
        }

        public String getOcid() {
            return this.ocid;
        }
    }

    protected class TextFieldListener
    implements DocumentListener {
        protected TextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DownloadWalletDialog.this.validateDialog();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DownloadWalletDialog.this.validateDialog();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DownloadWalletDialog.this.validateDialog();
        }
    }
}

