/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.json;

public class JSONFilter {
    private JSONFilter() {
    }

    public static String escape(String input) {
        char[] chars = input.toCharArray();
        StringBuffer escaped = null;
        int lastUnescapedStart = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= ' ' && chars[i] != '\"' && chars[i] != '\\') continue;
            if (escaped == null) {
                escaped = new StringBuffer(chars.length + 20);
            }
            if (lastUnescapedStart < i) {
                escaped.append(input.subSequence(lastUnescapedStart, i));
            }
            lastUnescapedStart = i + 1;
            escaped.append("\\u");
            escaped.append(String.format("%04X", chars[i]));
        }
        if (escaped == null) {
            return input;
        }
        if (lastUnescapedStart < chars.length) {
            escaped.append(input.subSequence(lastUnescapedStart, chars.length));
        }
        return escaped.toString();
    }
}

