/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html2md.converter;

import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.html2md.converter.DelegatingNodeRendererFactoryWrapper;
import com.vladsch.flexmark.html2md.converter.ExtensionConversion;
import com.vladsch.flexmark.html2md.converter.HtmlConverterCoreNodeRendererFactory;
import com.vladsch.flexmark.html2md.converter.HtmlConverterOptions;
import com.vladsch.flexmark.html2md.converter.HtmlConverterPhase;
import com.vladsch.flexmark.html2md.converter.HtmlConverterState;
import com.vladsch.flexmark.html2md.converter.HtmlLinkResolver;
import com.vladsch.flexmark.html2md.converter.HtmlLinkResolverFactory;
import com.vladsch.flexmark.html2md.converter.HtmlMarkdownWriter;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterSubContext;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRenderer;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRendererFactory;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRendererHandler;
import com.vladsch.flexmark.html2md.converter.LinkConversion;
import com.vladsch.flexmark.html2md.converter.NodeRenderingHandlerWrapper;
import com.vladsch.flexmark.html2md.converter.PhasedHtmlNodeRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.builder.BuilderBase;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.ScopedDataSet;
import com.vladsch.flexmark.util.dependency.DependencyResolver;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.options.TableCaptionHandling;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.html.MutableAttributes;
import com.vladsch.flexmark.util.misc.Extension;
import com.vladsch.flexmark.util.misc.Ref;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.LineAppendableImpl;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import com.vladsch.flexmark.util.sequence.builder.StringSequenceBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;

public class FlexmarkHtmlConverter {
    public static final DataKey<Integer> FORMAT_FLAGS = new DataKey("FORMAT_FLAGS", (Object)(LineAppendable.F_TRIM_TRAILING_WHITESPACE | LineAppendable.F_TRIM_LEADING_WHITESPACE | LineAppendable.F_COLLAPSE_WHITESPACE | LineAppendable.F_TRIM_LEADING_EOL | LineAppendable.F_PREFIX_PRE_FORMATTED));
    public static final DataKey<Integer> MAX_BLANK_LINES = new DataKey("MAX_BLANK_LINES", (Object)2);
    public static final DataKey<Integer> MAX_TRAILING_BLANK_LINES = new DataKey("MAX_TRAILING_BLANK_LINES", (Object)1);
    public static final DataKey<Boolean> LIST_CONTENT_INDENT = new DataKey("LIST_CONTENT_INDENT", (Object)true);
    public static final DataKey<Boolean> SETEXT_HEADINGS = new DataKey("SETEXT_HEADINGS", (Object)true);
    public static final DataKey<Boolean> OUTPUT_UNKNOWN_TAGS = new DataKey("OUTPUT_UNKNOWN_TAGS", (Object)false);
    public static final DataKey<Boolean> TYPOGRAPHIC_QUOTES = new DataKey("TYPOGRAPHIC_QUOTES", (Object)true);
    public static final DataKey<Boolean> TYPOGRAPHIC_SMARTS = new DataKey("TYPOGRAPHIC_SMARTS", (Object)true);
    public static final DataKey<Boolean> EXTRACT_AUTO_LINKS = new DataKey("EXTRACT_AUTO_LINKS", (Object)true);
    public static final DataKey<Boolean> OUTPUT_ATTRIBUTES_ID = new DataKey("OUTPUT_ATTRIBUTES_ID", (Object)true);
    public static final DataKey<String> OUTPUT_ATTRIBUTES_NAMES_REGEX = new DataKey("OUTPUT_ATTRIBUTES_NAMES_REGEX", (Object)"");
    public static final DataKey<Boolean> WRAP_AUTO_LINKS = new DataKey("WRAP_AUTO_LINKS", (Object)true);
    public static final DataKey<Boolean> RENDER_COMMENTS = new DataKey("RENDER_COMMENTS", (Object)false);
    public static final DataKey<Boolean> DOT_ONLY_NUMERIC_LISTS = new DataKey("DOT_ONLY_NUMERIC_LISTS", (Object)true);
    public static final DataKey<Boolean> COMMENT_ORIGINAL_NON_NUMERIC_LIST_ITEM = new DataKey("COMMENT_ORIGINAL_NON_NUMERIC_LIST_ITEM", (Object)false);
    public static final DataKey<Boolean> PRE_CODE_PRESERVE_EMPHASIS = new DataKey("PRE_CODE_PRESERVE_EMPHASIS", (Object)false);
    public static final DataKey<Character> ORDERED_LIST_DELIMITER = new DataKey("ORDERED_LIST_DELIMITER", (Object)Character.valueOf('.'));
    public static final DataKey<Character> UNORDERED_LIST_DELIMITER = new DataKey("UNORDERED_LIST_DELIMITER", (Object)Character.valueOf('*'));
    public static final DataKey<Integer> DEFINITION_MARKER_SPACES = new DataKey("DEFINITION_MARKER_SPACES", (Object)3);
    public static final DataKey<Integer> MIN_SETEXT_HEADING_MARKER_LENGTH = new DataKey("MIN_SETEXT_HEADING_MARKER_LENGTH", (Object)3);
    public static final DataKey<Integer> LIST_ITEM_INDENT = new DataKey("LIST_ITEM_INDENT", (Object)4);
    public static final DataKey<String> CODE_INDENT = new DataKey("CODE_INDENT", (Object)"    ");
    public static final DataKey<String> NBSP_TEXT = new DataKey("NBSP_TEXT", (Object)" ");
    public static final DataKey<String> EOL_IN_TITLE_ATTRIBUTE = new DataKey("EOL_IN_TITLE_ATTRIBUTE", (Object)" ");
    public static final DataKey<String> THEMATIC_BREAK = new DataKey("THEMATIC_BREAK", (Object)"*** ** * ** ***");
    public static final DataKey<BiFunction<String, Integer, String>> UNIQUE_LINK_REF_ID_GENERATOR = new DataKey("UNIQUE_LINK_REF_ID_GENERATOR", (refId, index) -> String.format("%s_%d", refId, index));
    public static final DataKey<String[]> UNWRAPPED_TAGS = new DataKey("UNWRAPPED_TAGS", (Object)new String[]{"article", "address", "frameset", "section", "small", "iframe"});
    public static final DataKey<String[]> WRAPPED_TAGS = new DataKey("WRAPPED_TAGS", (Object)new String[]{"kbd", "var"});
    public static final DataKey<String> OUTPUT_ID_ATTRIBUTE_REGEX = new DataKey("OUTPUT_ID_ATTRIBUTE_REGEX", (Object)"^user-content-(.*)$");
    @Deprecated
    public static final DataKey<Integer> TABLE_MIN_SEPARATOR_COLUMN_WIDTH = TableFormatOptions.FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH;
    @Deprecated
    public static final DataKey<Integer> TABLE_MIN_SEPARATOR_DASHES = TableFormatOptions.FORMAT_TABLE_MIN_SEPARATOR_DASHES;
    @Deprecated
    public static final DataKey<Boolean> TABLE_LEAD_TRAIL_PIPES = TableFormatOptions.FORMAT_TABLE_LEAD_TRAIL_PIPES;
    @Deprecated
    public static final DataKey<Boolean> TABLE_SPACE_AROUND_PIPES = TableFormatOptions.FORMAT_TABLE_SPACE_AROUND_PIPES;
    @Deprecated
    public static final DataKey<TableCaptionHandling> TABLE_CAPTION = TableFormatOptions.FORMAT_TABLE_CAPTION;
    public static final DataKey<Boolean> LISTS_END_ON_DOUBLE_BLANK = new DataKey("LISTS_END_ON_DOUBLE_BLANK", (Object)false);
    public static final DataKey<Boolean> DIV_AS_PARAGRAPH = new DataKey("DIV_AS_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> BR_AS_PARA_BREAKS = new DataKey("BR_AS_PARA_BREAKS", (Object)true);
    public static final DataKey<Boolean> BR_AS_EXTRA_BLANK_LINES = new DataKey("BR_AS_EXTRA_BLANK_LINES", (Object)true);
    public static final DataKey<Boolean> DIV_TABLE_PROCESSING = new DataKey("DIV_TABLE_PROCESSING", (Object)false);
    public static final DataKey<String[]> DIV_TABLE_HDR_CLASSES = new DataKey("DIV_TABLE_HDR_CLASSES", (Object)new String[]{"wt-data-grid__row_header"});
    public static final DataKey<String[]> DIV_TABLE_ROW_CLASSES = new DataKey("DIV_TABLE_ROW_CLASSES", (Object)new String[]{"wt-data-grid__row"});
    public static final DataKey<String[]> DIV_TABLE_CELL_CLASSES = new DataKey("DIV_TABLE_CELL_CLASSES", (Object)new String[]{"wt-data-grid__cell"});
    public static final DataKey<Boolean> ADD_TRAILING_EOL = new DataKey("ADD_TRAILING_EOL", (Object)true);
    public static final DataKey<Boolean> SKIP_HEADING_1 = new DataKey("SKIP_HEADING_1", (Object)false);
    public static final DataKey<Boolean> SKIP_HEADING_2 = new DataKey("SKIP_HEADING_2", (Object)false);
    public static final DataKey<Boolean> SKIP_HEADING_3 = new DataKey("SKIP_HEADING_3", (Object)false);
    public static final DataKey<Boolean> SKIP_HEADING_4 = new DataKey("SKIP_HEADING_4", (Object)false);
    public static final DataKey<Boolean> SKIP_HEADING_5 = new DataKey("SKIP_HEADING_5", (Object)false);
    public static final DataKey<Boolean> SKIP_HEADING_6 = new DataKey("SKIP_HEADING_6", (Object)false);
    public static final DataKey<Boolean> SKIP_ATTRIBUTES = new DataKey("SKIP_ATTRIBUTES", (Object)false);
    public static final DataKey<Boolean> SKIP_FENCED_CODE = new DataKey("SKIP_FENCED_CODE", (Object)false);
    public static final DataKey<Boolean> SKIP_CHAR_ESCAPE = new DataKey("SKIP_CHAR_ESCAPE", (Object)false);
    public static final DataKey<ExtensionConversion> EXT_INLINE_STRONG = new DataKey("EXT_INLINE_STRONG", (Object)ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_EMPHASIS = new DataKey("EXT_INLINE_EMPHASIS", (Object)ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_CODE = new DataKey("EXT_INLINE_CODE", (Object)ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_DEL = new DataKey("EXT_INLINE_DEL", (Object)ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_INS = new DataKey("EXT_INLINE_INS", (Object)ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_SUB = new DataKey("EXT_INLINE_SUB", (Object)ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_INLINE_SUP = new DataKey("EXT_INLINE_SUP", (Object)ExtensionConversion.MARKDOWN);
    public static final DataKey<ExtensionConversion> EXT_MATH = new DataKey("EXT_MATH", (Object)ExtensionConversion.HTML);
    public static final DataKey<ExtensionConversion> EXT_TABLES = new DataKey("EXT_TABLES", (Object)ExtensionConversion.MARKDOWN);
    public static final DataKey<LinkConversion> EXT_INLINE_LINK = new DataKey("EXT_INLINE_LINK", (Object)LinkConversion.MARKDOWN_EXPLICIT);
    public static final DataKey<LinkConversion> EXT_INLINE_IMAGE = new DataKey("EXT_INLINE_IMAGE", (Object)LinkConversion.MARKDOWN_EXPLICIT);
    public static final DataKey<Ref<Document>> FOR_DOCUMENT = new DataKey("FOR_DOCUMENT", (Object)new Ref(null));
    public static final DataKey<Map<String, String>> TYPOGRAPHIC_REPLACEMENT_MAP = new DataKey("TYPOGRAPHIC_REPLACEMENT_MAP", new HashMap());
    public static final DataKey<Boolean> DUMP_HTML_TREE = new DataKey("DUMP_HTML_TREE", (Object)false);
    public static final DataKey<Boolean> IGNORE_TABLE_HEADING_AFTER_ROWS = new DataKey("IGNORE_TABLE_HEADING_AFTER_ROWS", (Object)true);
    public static final String A_NODE = "a";
    public static final String ABBR_NODE = "abbr";
    public static final String ASIDE_NODE = "aside";
    public static final String BR_NODE = "br";
    public static final String BLOCKQUOTE_NODE = "blockquote";
    public static final String CODE_NODE = "code";
    public static final String IMG_NODE = "img";
    public static final String DEL_NODE = "del";
    public static final String STRIKE_NODE = "strike";
    public static final String DIV_NODE = "div";
    public static final String DD_NODE = "dd";
    public static final String DL_NODE = "dl";
    public static final String DT_NODE = "dt";
    public static final String I_NODE = "i";
    public static final String EM_NODE = "em";
    public static final String B_NODE = "b";
    public static final String STRONG_NODE = "strong";
    public static final String EMOJI_NODE = "g-emoji";
    public static final String INPUT_NODE = "input";
    public static final String INS_NODE = "ins";
    public static final String U_NODE = "u";
    public static final String SUB_NODE = "sub";
    public static final String SUP_NODE = "sup";
    public static final String HR_NODE = "hr";
    public static final String OL_NODE = "ol";
    public static final String UL_NODE = "ul";
    public static final String LI_NODE = "li";
    public static final String TABLE_NODE = "table";
    public static final String TBODY_NODE = "tbody";
    public static final String TD_NODE = "td";
    public static final String TH_NODE = "th";
    public static final String THEAD_NODE = "thead";
    public static final String TR_NODE = "tr";
    public static final String CAPTION_NODE = "caption";
    public static final String SVG_NODE = "svg";
    public static final String P_NODE = "p";
    public static final String PRE_NODE = "pre";
    public static final String MATH_NODE = "math";
    public static final String SPAN_NODE = "span";
    public static final String TEXT_NODE = "#text";
    public static final String COMMENT_NODE = "#comment";
    public static final String H1_NODE = "h1";
    public static final String H2_NODE = "h2";
    public static final String H3_NODE = "h3";
    public static final String H4_NODE = "h4";
    public static final String H5_NODE = "h5";
    public static final String H6_NODE = "h6";
    public static final String DEFAULT_NODE = "";
    public static final String[] HEADING_NODES = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    public static String[] EXPLICIT_LINK_TEXT_TAGS = new String[]{"img"};
    private static final Map<Object, CellAlignment> TABLE_CELL_ALIGNMENTS = new LinkedHashMap<Object, CellAlignment>();
    static final Map<String, String> SPECIAL_CHARS_MAP;
    private static final String TYPOGRAPHIC_QUOTES_PIPED = "\u201c|\u201d|\u2018|\u2019|\u00ab|\u00bb|&ldquo;|&rdquo;|&lsquo;|&rsquo;|&apos;|&laquo;|&raquo;";
    private static final String TYPOGRAPHIC_SMARTS_PIPED = "\u2026|\u2013|\u2014|&hellip;|&endash;|&emdash;";
    public static final DataKey<Map<Object, CellAlignment>> TABLE_CELL_ALIGNMENT_MAP;
    final HtmlConverterOptions htmlConverterOptions;
    private final DataHolder options;
    final List<DelegatingNodeRendererFactoryWrapper> nodeRendererFactories;
    final List<HtmlLinkResolverFactory> linkResolverFactories;
    private static final Iterator<org.jsoup.nodes.Node> NULL_ITERATOR;
    public static final Iterable<org.jsoup.nodes.Node> NULL_ITERABLE;

    FlexmarkHtmlConverter(Builder builder) {
        this.options = builder.toImmutable();
        this.htmlConverterOptions = new HtmlConverterOptions(this.options);
        ArrayList<HtmlNodeRendererFactory> nodeConverterFactories = new ArrayList<HtmlNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        nodeConverterFactories.addAll(builder.nodeRendererFactories);
        ArrayList<DelegatingNodeRendererFactoryWrapper> nodeRenderers = new ArrayList<DelegatingNodeRendererFactoryWrapper>(nodeConverterFactories.size());
        for (int i = nodeConverterFactories.size() - 1; i >= 0; --i) {
            HtmlNodeRendererFactory nodeRendererFactory = (HtmlNodeRendererFactory)nodeConverterFactories.get(i);
            nodeRenderers.add(new DelegatingNodeRendererFactoryWrapper(nodeRenderers, nodeRendererFactory));
        }
        HtmlConverterCoreNodeRendererFactory nodeRendererFactory = new HtmlConverterCoreNodeRendererFactory();
        nodeRenderers.add(new DelegatingNodeRendererFactoryWrapper(nodeRenderers, nodeRendererFactory));
        this.nodeRendererFactories = DependencyResolver.resolveFlatDependencies(nodeRenderers, null, dependent -> dependent.getFactory().getClass());
        this.linkResolverFactories = DependencyResolver.resolveFlatDependencies(builder.linkResolverFactories, null, null);
    }

    public DataHolder getOptions() {
        return this.options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    public void convert(@NotNull String html, @NotNull Appendable output) {
        org.jsoup.nodes.Document document = Jsoup.parse((String)html);
        if (((Boolean)DUMP_HTML_TREE.get(this.getOptions())).booleanValue()) {
            LineAppendableImpl trace = new LineAppendableImpl(LineAppendable.F_TRIM_LEADING_EOL);
            trace.setIndentPrefix((CharSequence)"  ");
            FlexmarkHtmlConverter.dumpHtmlTree((LineAppendable)trace, (org.jsoup.nodes.Node)document.body());
            System.out.println(trace.toString(0, 0));
        }
        MainHtmlConverter converter = new MainHtmlConverter(this.options, new HtmlMarkdownWriter(this.htmlConverterOptions.formatFlags), document, null);
        converter.render((org.jsoup.nodes.Node)document);
        converter.flushTo(output, this.htmlConverterOptions.maxBlankLines, this.htmlConverterOptions.maxTrailingBlankLines);
    }

    public String convert(@NotNull String html) {
        return this.convert(html, 1);
    }

    public String convert(@NotNull String html, int maxTrailingBlankLines) {
        org.jsoup.nodes.Document document = Jsoup.parse((String)html);
        if (((Boolean)DUMP_HTML_TREE.get(this.getOptions())).booleanValue()) {
            LineAppendableImpl trace = new LineAppendableImpl(LineAppendable.F_TRIM_LEADING_EOL);
            trace.setIndentPrefix((CharSequence)"  ");
            FlexmarkHtmlConverter.dumpHtmlTree((LineAppendable)trace, (org.jsoup.nodes.Node)document.body());
            System.out.println(trace.toString(0, 0));
        }
        MainHtmlConverter converter = new MainHtmlConverter(this.options, new HtmlMarkdownWriter(this.htmlConverterOptions.formatFlags), document, null);
        converter.render((org.jsoup.nodes.Node)document);
        return converter.getMarkdown().toString(this.htmlConverterOptions.maxBlankLines, maxTrailingBlankLines);
    }

    public static void dumpHtmlTree(LineAppendable out, org.jsoup.nodes.Node node) {
        out.line().append((CharSequence)node.nodeName());
        for (Attribute attribute : node.attributes().asList()) {
            out.append(' ').append((CharSequence)attribute.getKey()).append((CharSequence)"=\"").append((CharSequence)attribute.getValue()).append((CharSequence)"\"");
        }
        out.line().indent();
        for (org.jsoup.nodes.Node child : node.childNodes()) {
            FlexmarkHtmlConverter.dumpHtmlTree(out, child);
        }
        out.unIndent();
    }

    public void convert(org.jsoup.nodes.Node node, Appendable output, int maxTrailingBlankLines) {
        MainHtmlConverter renderer = new MainHtmlConverter(this.options, new HtmlMarkdownWriter(this.htmlConverterOptions.formatFlags), node.ownerDocument(), null);
        renderer.render(node);
        renderer.flushTo(output, this.htmlConverterOptions.maxBlankLines, maxTrailingBlankLines);
    }

    public String convert(org.jsoup.nodes.Node node) {
        StringBuilder sb = new StringBuilder();
        this.convert(node, sb, 0);
        return sb.toString();
    }

    static void processTextNodes(@NotNull HtmlNodeConverterContext context, @NotNull org.jsoup.nodes.Node node, boolean stripIdAttribute, @Nullable CharSequence textPrefix, @Nullable CharSequence textSuffix) {
        org.jsoup.nodes.Node child;
        context.pushState(node);
        HtmlMarkdownWriter markdown = context.getMarkdown();
        while ((child = context.next()) != null) {
            if (child instanceof TextNode) {
                if (textPrefix != null && textPrefix.length() > 0) {
                    markdown.append(textPrefix);
                }
                String text = ((TextNode)child).getWholeText();
                String preparedText = context.prepareText(text);
                markdown.append(preparedText);
                if (textSuffix == null || textSuffix.length() <= 0) continue;
                markdown.append(textSuffix);
                continue;
            }
            if (!(child instanceof Element)) continue;
            context.render(child);
        }
        if (stripIdAttribute) {
            context.excludeAttributes("id");
        }
        int nodeCount = node.parent().childNodeSize();
        if (node.parent().childNode(nodeCount - 1) == node) {
            context.transferIdToParent();
        }
        context.popState((LineAppendable)markdown);
    }

    static void wrapTextNodes(@NotNull HtmlNodeConverterContext context, @NotNull org.jsoup.nodes.Node node, @NotNull CharSequence wrapText, boolean needSpaceAround) {
        String text = context.processTextNodes(node);
        String prefixBefore = null;
        String appendAfter = null;
        boolean addSpaceBefore = false;
        boolean addSpaceAfter = false;
        HtmlMarkdownWriter out = context.getMarkdown();
        if (!text.isEmpty() && needSpaceAround) {
            if ("\u00a0 \t\n".indexOf(text.charAt(0)) != -1) {
                prefixBefore = context.prepareText(text.substring(0, 1));
                text = text.substring(1);
            } else if (text.startsWith("&nbsp;")) {
                prefixBefore = "&nbsp;";
                text = text.substring(prefixBefore.length());
            } else {
                boolean bl = addSpaceBefore = out.getPendingEOL() != 0 && !out.isPendingSpace() && out.offsetWithPending() != 0 && out.getPendingEOL() <= 0;
            }
            if (!text.isEmpty() && "\u00a0 \t\n".indexOf(text.charAt(text.length() - 1)) != -1) {
                appendAfter = context.prepareText(text.substring(text.length() - 1));
                text = text.substring(0, text.length() - 1);
            } else if (text.endsWith("&nbsp;")) {
                appendAfter = "&nbsp;";
                text = text.substring(0, text.length() - appendAfter.length());
            } else {
                String nextText;
                org.jsoup.nodes.Node next = context.peek();
                addSpaceAfter = true;
                if (next instanceof TextNode && !(nextText = ((TextNode)next).getWholeText()).isEmpty() && Character.isWhitespace(nextText.charAt(0))) {
                    addSpaceAfter = false;
                }
            }
        }
        if (!text.isEmpty()) {
            int pos;
            for (pos = text.length() - 1; pos >= 0 && Character.isWhitespace(text.charAt(pos)); --pos) {
            }
            if (++pos > 0) {
                if (prefixBefore != null) {
                    out.append(prefixBefore);
                }
                if (addSpaceBefore) {
                    out.append(' ');
                }
                text = text.substring(0, pos);
                out.append(wrapText);
                out.append(text);
                out.append(wrapText);
                if (appendAfter != null) {
                    out.append(appendAfter);
                }
                if (addSpaceAfter) {
                    out.append(' ');
                }
            }
        }
    }

    static void processConditional(@NotNull HtmlNodeConverterContext context, @NotNull ExtensionConversion extensionConversion, @NotNull org.jsoup.nodes.Node node, @NotNull Runnable processNode) {
        if (extensionConversion.isParsed()) {
            if (!extensionConversion.isSuppressed()) {
                processNode.run();
            }
        } else {
            context.processWrapped(node, null, true);
        }
    }

    static void appendOuterHtml(@NotNull HtmlNodeConverterSubContext context, @NotNull org.jsoup.nodes.Node node) {
        String text = node.outerHtml();
        int head = text.indexOf(">");
        int tail = text.lastIndexOf("</");
        if (head != -1 && tail != -1) {
            context.markdown.append(text.substring(0, head + 1));
            int iMax = node.childNodeSize();
            if (iMax > 0) {
                for (int i = 0; i < iMax; ++i) {
                    FlexmarkHtmlConverter.appendOuterHtml(context, node.childNode(i));
                }
            } else {
                context.markdown.append(context.escapeSpecialChars(text.substring(head + 1, tail)));
            }
            context.markdown.append(text.substring(tail));
        } else if (head == -1) {
            context.markdown.append(context.escapeSpecialChars(text));
        } else {
            context.markdown.append(text);
        }
    }

    public static void processWrapped(@NotNull HtmlNodeConverterSubContext context, @NotNull org.jsoup.nodes.Node node, @Nullable Boolean isBlock, boolean escapeMarkdown) {
        if (node instanceof Element && (isBlock == null && ((Element)node).isBlock() || isBlock != null && isBlock.booleanValue())) {
            String s = node.toString();
            int pos = s.indexOf(">");
            ((HtmlMarkdownWriter)((HtmlMarkdownWriter)context.markdown.lineIf(isBlock != null)).append(s.substring(0, pos + 1))).lineIf(isBlock != null);
            FlexmarkHtmlConverter.processHtmlTree(context, node, false, null);
            int endPos = s.lastIndexOf("<");
            ((HtmlMarkdownWriter)((HtmlMarkdownWriter)context.markdown.lineIf(isBlock != null)).append(s.substring(endPos))).lineIf(isBlock != null);
        } else if (escapeMarkdown) {
            FlexmarkHtmlConverter.appendOuterHtml(context, node);
        } else {
            context.markdown.append(node.toString());
        }
    }

    static void processHtmlTree(@NotNull HtmlNodeConverterSubContext context, @NotNull org.jsoup.nodes.Node parent, boolean outputAttributes, @Nullable Runnable prePopAction) {
        org.jsoup.nodes.Node node;
        context.pushState(parent);
        HtmlConverterState oldState = context.getState();
        assert (oldState != null);
        if (prePopAction != null) {
            oldState.addPrePopAction(prePopAction);
        }
        while ((node = context.next()) != null) {
            context.render(node);
        }
        if (oldState != context.getState()) {
            throw new IllegalStateException("State not equal after process " + FlexmarkHtmlConverter.dumpState(context));
        }
        oldState.runPrePopActions();
        context.popState((LineAppendable)(outputAttributes ? context.markdown : null));
    }

    static String dumpState(@NotNull HtmlNodeConverterContext context) {
        Stack<HtmlConverterState> stateStack = context.getStateStack();
        if (!stateStack.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            while (!stateStack.isEmpty()) {
                HtmlConverterState state = stateStack.pop();
                sb.append("\n").append(state == null ? "null" : state.toString());
            }
            return sb.toString();
        }
        return DEFAULT_NODE;
    }

    static void processDefault(@NotNull HtmlNodeConverterSubContext subContext, @NotNull org.jsoup.nodes.Node node, boolean outputUnknownTags) {
        if (outputUnknownTags) {
            subContext.processWrapped(node, null, false);
        } else {
            subContext.processUnwrapped(node);
        }
    }

    static {
        TABLE_CELL_ALIGNMENTS.put(Pattern.compile("\\bleft\\b"), CellAlignment.LEFT);
        TABLE_CELL_ALIGNMENTS.put(Pattern.compile("\\bcenter\\b"), CellAlignment.CENTER);
        TABLE_CELL_ALIGNMENTS.put(Pattern.compile("\\bright\\b"), CellAlignment.RIGHT);
        TABLE_CELL_ALIGNMENTS.put("text-left", CellAlignment.LEFT);
        TABLE_CELL_ALIGNMENTS.put("text-center", CellAlignment.CENTER);
        TABLE_CELL_ALIGNMENTS.put("text-right", CellAlignment.RIGHT);
        SPECIAL_CHARS_MAP = new HashMap<String, String>();
        SPECIAL_CHARS_MAP.put("\u201c", "\"");
        SPECIAL_CHARS_MAP.put("\u201d", "\"");
        SPECIAL_CHARS_MAP.put("&ldquo;", "\"");
        SPECIAL_CHARS_MAP.put("&rdquo;", "\"");
        SPECIAL_CHARS_MAP.put("\u2018", "'");
        SPECIAL_CHARS_MAP.put("\u2019", "'");
        SPECIAL_CHARS_MAP.put("&lsquo;", "'");
        SPECIAL_CHARS_MAP.put("&rsquo;", "'");
        SPECIAL_CHARS_MAP.put("&apos;", "'");
        SPECIAL_CHARS_MAP.put("\u00ab", "<<");
        SPECIAL_CHARS_MAP.put("&laquo;", "<<");
        SPECIAL_CHARS_MAP.put("\u00bb", ">>");
        SPECIAL_CHARS_MAP.put("&raquo;", ">>");
        SPECIAL_CHARS_MAP.put("\u2026", "...");
        SPECIAL_CHARS_MAP.put("&hellip;", "...");
        SPECIAL_CHARS_MAP.put("\u2013", "--");
        SPECIAL_CHARS_MAP.put("&endash;", "--");
        SPECIAL_CHARS_MAP.put("\u2014", "---");
        SPECIAL_CHARS_MAP.put("&emdash;", "---");
        TABLE_CELL_ALIGNMENT_MAP = new DataKey("TABLE_CELL_ALIGNMENT_MAP", TABLE_CELL_ALIGNMENTS);
        NULL_ITERATOR = new Iterator<org.jsoup.nodes.Node>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public org.jsoup.nodes.Node next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
        NULL_ITERABLE = () -> NULL_ITERATOR;
    }

    private class MainHtmlConverter
    extends HtmlNodeConverterSubContext {
        @NotNull
        private final org.jsoup.nodes.Document document;
        @NotNull
        private final Document myForDocument;
        @NotNull
        private final Map<String, HtmlNodeRendererHandler<?>> renderers;
        @NotNull
        private final List<PhasedHtmlNodeRenderer> phasedFormatters;
        @NotNull
        private final Set<HtmlConverterPhase> renderingPhases;
        @NotNull
        private final DataHolder myOptions;
        private HtmlConverterPhase phase;
        @NotNull
        private final HtmlConverterOptions myHtmlConverterOptions;
        @Nullable
        private final Pattern specialCharsPattern;
        @NotNull
        private final Stack<HtmlConverterState> myStateStack;
        @NotNull
        private final Map<String, String> mySpecialCharsMap;
        @Nullable
        private HtmlConverterState myState;
        private boolean myTrace;
        private boolean myInlineCode;
        @Nullable
        private Parser myParser;
        @NotNull
        private final HtmlLinkResolver[] myHtmlLinkResolvers;
        @NotNull
        private final HashMap<String, Reference> myReferenceUrlToReferenceMap;
        @NotNull
        private final HashMap<String, Reference> myReferenceIdToReferenceMap;
        @NotNull
        private final HashSet<Reference> myExternalReferences;

        @Override
        public HtmlConverterState getState() {
            return this.myState;
        }

        MainHtmlConverter(@NotNull DataHolder options, @NotNull HtmlMarkdownWriter out, @Nullable org.jsoup.nodes.Document document, DataHolder parentOptions) {
            int i;
            super(out);
            this.myParser = null;
            this.myOptions = new ScopedDataSet(parentOptions, options);
            this.renderers = new HashMap(32);
            this.renderingPhases = new HashSet<HtmlConverterPhase>(HtmlConverterPhase.values().length);
            this.phasedFormatters = new ArrayList<PhasedHtmlNodeRenderer>(FlexmarkHtmlConverter.this.nodeRendererFactories.size());
            this.myHtmlLinkResolvers = new HtmlLinkResolver[FlexmarkHtmlConverter.this.linkResolverFactories.size()];
            out.setContext(this);
            this.myHtmlConverterOptions = new HtmlConverterOptions(this.myOptions);
            this.specialCharsPattern = this.myHtmlConverterOptions.typographicQuotes && this.myHtmlConverterOptions.typographicSmarts ? Pattern.compile("\u201c|\u201d|\u2018|\u2019|\u00ab|\u00bb|&ldquo;|&rdquo;|&lsquo;|&rsquo;|&apos;|&laquo;|&raquo;|\u2026|\u2013|\u2014|&hellip;|&endash;|&emdash;") : (this.myHtmlConverterOptions.typographicQuotes ? Pattern.compile(FlexmarkHtmlConverter.TYPOGRAPHIC_QUOTES_PIPED) : (this.myHtmlConverterOptions.typographicSmarts ? Pattern.compile(FlexmarkHtmlConverter.TYPOGRAPHIC_SMARTS_PIPED) : null));
            this.myStateStack = new Stack();
            this.myReferenceUrlToReferenceMap = new HashMap();
            this.myReferenceIdToReferenceMap = new HashMap();
            this.myExternalReferences = new HashSet();
            this.myState = null;
            Map<Object, Object> typographicReplacementMap = (Map<Object, Object>)TYPOGRAPHIC_REPLACEMENT_MAP.get(this.myOptions);
            this.mySpecialCharsMap = !typographicReplacementMap.isEmpty() ? typographicReplacementMap : SPECIAL_CHARS_MAP;
            for (i = FlexmarkHtmlConverter.this.nodeRendererFactories.size() - 1; i >= 0; --i) {
                HtmlNodeRendererFactory htmlNodeRendererFactory = FlexmarkHtmlConverter.this.nodeRendererFactories.get(i);
                HtmlNodeRenderer htmlNodeRenderer = htmlNodeRendererFactory.apply(this.myOptions);
                Set<HtmlNodeRendererHandler<?>> formattingHandlers = htmlNodeRenderer.getHtmlNodeRendererHandlers();
                if (formattingHandlers == null) continue;
                for (HtmlNodeRendererHandler<?> nodeType : formattingHandlers) {
                    this.renderers.put(nodeType.getTagName(), nodeType);
                }
                if (!(htmlNodeRenderer instanceof PhasedHtmlNodeRenderer)) continue;
                Set<HtmlConverterPhase> phases = ((PhasedHtmlNodeRenderer)htmlNodeRenderer).getHtmlConverterPhases();
                if (phases != null) {
                    if (phases.isEmpty()) {
                        throw new IllegalStateException("PhasedNodeFormatter with empty Phases");
                    }
                    this.renderingPhases.addAll(phases);
                    this.phasedFormatters.add((PhasedHtmlNodeRenderer)htmlNodeRenderer);
                    continue;
                }
                throw new IllegalStateException("PhasedNodeFormatter with null Phases");
            }
            for (i = 0; i < FlexmarkHtmlConverter.this.linkResolverFactories.size(); ++i) {
                this.myHtmlLinkResolvers[i] = FlexmarkHtmlConverter.this.linkResolverFactories.get(i).apply(this);
            }
            this.document = document;
            this.myForDocument = (Document)((Ref)FlexmarkHtmlConverter.FOR_DOCUMENT.get((DataHolder)options)).value;
        }

        @Override
        @NotNull
        public HashMap<String, Reference> getReferenceUrlToReferenceMap() {
            return this.myReferenceUrlToReferenceMap;
        }

        @Override
        @NotNull
        public HashMap<String, Reference> getReferenceIdToReferenceMap() {
            return this.myReferenceIdToReferenceMap;
        }

        @Override
        @NotNull
        public HashSet<Reference> getExternalReferences() {
            return this.myExternalReferences;
        }

        @Override
        public boolean isTrace() {
            return this.myTrace;
        }

        @Override
        @NotNull
        public Stack<HtmlConverterState> getStateStack() {
            return this.myStateStack;
        }

        @Override
        public void setTrace(boolean trace) {
            this.myTrace = trace;
        }

        @Override
        public @NotNull Node parseMarkdown(@NotNull String markdown) {
            if (this.myParser == null) {
                this.myParser = Parser.builder((DataHolder)this.myOptions).build();
            }
            return this.myParser.parse(markdown);
        }

        @Override
        public Reference getOrCreateReference(@NotNull String url, @NotNull String text, @Nullable String title) {
            Node document;
            Node firstChild;
            Reference reference = this.myReferenceUrlToReferenceMap.get(url);
            if (reference != null) {
                if (title != null && !title.trim().isEmpty()) {
                    if (reference.getTitle().isBlank()) {
                        reference.setTitle(BasedSequence.of((CharSequence)title).subSequence(0, title.length()));
                        return reference;
                    }
                    if (reference.getTitle().equals(title.trim())) {
                        return reference;
                    }
                }
                return reference;
            }
            String referenceId = text;
            if (this.myReferenceIdToReferenceMap.containsKey(referenceId)) {
                int i = 1;
                while (this.myReferenceIdToReferenceMap.containsKey(referenceId = this.myHtmlConverterOptions.uniqueLinkRefIdGenerator.apply(text, i))) {
                    ++i;
                }
            }
            StringBuilder sb = new StringBuilder().append("[").append(referenceId).append("]: ").append(url);
            if (title != null && !title.trim().isEmpty()) {
                sb.append(" '").append(title.replace("'", "\\'")).append("'");
            }
            if ((firstChild = (document = this.parseMarkdown(sb.toString())).getFirstChild()) instanceof Reference) {
                reference = (Reference)firstChild;
                this.myReferenceUrlToReferenceMap.put(url, reference);
                this.myReferenceIdToReferenceMap.put(referenceId, reference);
                return reference;
            }
            return null;
        }

        @Override
        @NotNull
        public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Boolean urlEncode) {
            return this.resolveLink(linkType, url, null, urlEncode);
        }

        @Override
        @NotNull
        public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Attributes attributes, Boolean urlEncode) {
            String urlSeq = String.valueOf(url);
            ResolvedLink resolvedLink = new ResolvedLink(linkType, (CharSequence)urlSeq, attributes);
            if (!urlSeq.isEmpty()) {
                HtmlLinkResolver htmlLinkResolver;
                org.jsoup.nodes.Node currentNode = this.getCurrentNode();
                HtmlLinkResolver[] htmlLinkResolverArray = this.myHtmlLinkResolvers;
                int n = htmlLinkResolverArray.length;
                for (int i = 0; i < n && (resolvedLink = (htmlLinkResolver = htmlLinkResolverArray[i]).resolveLink(currentNode, this, resolvedLink)).getStatus() == LinkStatus.UNKNOWN; ++i) {
                }
            }
            return resolvedLink;
        }

        @Override
        @Nullable
        public org.jsoup.nodes.Node getCurrentNode() {
            return this.myRenderingNode;
        }

        @Override
        @NotNull
        public DataHolder getOptions() {
            return this.myOptions;
        }

        @Override
        @NotNull
        public HtmlConverterOptions getHtmlConverterOptions() {
            return FlexmarkHtmlConverter.this.htmlConverterOptions;
        }

        @Override
        @NotNull
        public org.jsoup.nodes.Document getDocument() {
            return this.document;
        }

        @Override
        @Nullable
        public Document getForDocument() {
            return this.myForDocument;
        }

        @Override
        public HtmlConverterPhase getFormattingPhase() {
            return this.phase;
        }

        @Override
        public void render(@NotNull org.jsoup.nodes.Node node) {
            this.renderNode(node, this);
        }

        @Override
        public void delegateRender() {
            this.renderByPreviousHandler(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderByPreviousHandler(HtmlNodeConverterSubContext subContext) {
            if (subContext.getRenderingNode() != null) {
                NodeRenderingHandlerWrapper nodeRenderer = subContext.renderingHandlerWrapper.myPreviousRenderingHandler;
                if (nodeRenderer != null) {
                    org.jsoup.nodes.Node oldNode = subContext.getRenderingNode();
                    NodeRenderingHandlerWrapper<?> prevWrapper = subContext.renderingHandlerWrapper;
                    try {
                        subContext.renderingHandlerWrapper = nodeRenderer;
                        nodeRenderer.myRenderingHandler.render(oldNode, (HtmlNodeConverterContext)subContext, subContext.getMarkdown());
                    }
                    finally {
                        subContext.setRenderingNode(oldNode);
                        subContext.renderingHandlerWrapper = prevWrapper;
                    }
                }
            } else {
                throw new IllegalStateException("renderingByPreviousHandler called outside node rendering code");
            }
        }

        @Override
        @NotNull
        public HtmlNodeConverterContext getSubContext() {
            return this.getSubContext(null);
        }

        @Override
        @NotNull
        public HtmlNodeConverterContext getSubContext(@Nullable DataHolder options) {
            return this.getSubContext(options, this.markdown.getBuilder());
        }

        @Override
        @NotNull
        public HtmlNodeConverterContext getSubContext(@Nullable DataHolder options, @NotNull ISequenceBuilder<?, ?> builder) {
            HtmlMarkdownWriter writer = new HtmlMarkdownWriter((Appendable)builder, this.markdown.getOptions());
            writer.setContext(this);
            return new SubHtmlNodeConverter(this, writer, (DataHolder)(options == null || options == this.myOptions ? this.myOptions : new ScopedDataSet(this.myOptions, options)));
        }

        void renderNode(org.jsoup.nodes.Node node, HtmlNodeConverterSubContext subContext) {
            if (node instanceof org.jsoup.nodes.Document) {
                for (HtmlConverterPhase phase : HtmlConverterPhase.values()) {
                    if (phase != HtmlConverterPhase.DOCUMENT && !this.renderingPhases.contains((Object)phase)) continue;
                    this.phase = phase;
                    if (this.phase == HtmlConverterPhase.DOCUMENT) {
                        FlexmarkHtmlConverter.processHtmlTree(subContext, (org.jsoup.nodes.Node)this.document.body(), false, null);
                        continue;
                    }
                    for (PhasedHtmlNodeRenderer phasedFormatter : this.phasedFormatters) {
                        if (!phasedFormatter.getHtmlConverterPhases().contains((Object)phase)) continue;
                        subContext.myRenderingNode = node;
                        phasedFormatter.renderDocument(subContext, (LineAppendable)subContext.markdown, (org.jsoup.nodes.Document)node, phase);
                        subContext.myRenderingNode = null;
                    }
                }
            } else {
                HtmlNodeRendererHandler<?> nodeRenderer = this.renderers.get(node.nodeName().toLowerCase());
                if (nodeRenderer == null) {
                    nodeRenderer = this.renderers.get(FlexmarkHtmlConverter.DEFAULT_NODE);
                }
                if (nodeRenderer != null) {
                    org.jsoup.nodes.Node oldNode = this.myRenderingNode;
                    subContext.myRenderingNode = node;
                    nodeRenderer.render(node, (HtmlNodeConverterContext)subContext, subContext.markdown);
                    subContext.myRenderingNode = oldNode;
                } else {
                    throw new IllegalStateException("Core Node Formatter should implement generic empty tag renderer");
                }
            }
        }

        @Override
        public void renderChildren(@NotNull org.jsoup.nodes.Node parent, boolean outputAttributes, Runnable prePopAction) {
            FlexmarkHtmlConverter.processHtmlTree(this, parent, outputAttributes, prePopAction);
        }

        @Override
        public void pushState(@NotNull org.jsoup.nodes.Node parent) {
            this.myStateStack.push(this.myState);
            this.myState = new HtmlConverterState(parent);
            this.processAttributes(parent);
        }

        @Override
        public void excludeAttributes(String ... excludes) {
            assert (this.myState != null);
            for (String exclude : excludes) {
                this.myState.myAttributes.remove((CharSequence)exclude);
            }
        }

        @Override
        public void processAttributes(@NotNull org.jsoup.nodes.Node node) {
            assert (this.myState != null);
            MutableAttributes attributes = this.myState.myAttributes;
            if (this.myHtmlConverterOptions.outputAttributesIdAttr || !this.myHtmlConverterOptions.outputAttributesNamesRegex.isEmpty()) {
                org.jsoup.nodes.Attributes nodeAttributes = node.attributes();
                boolean idDone = false;
                if (this.myHtmlConverterOptions.outputAttributesIdAttr) {
                    String id = nodeAttributes.get("id");
                    if (id == null || id.isEmpty()) {
                        id = nodeAttributes.get("name");
                    }
                    if (id != null && !id.isEmpty()) {
                        attributes.replaceValue((CharSequence)"id", (CharSequence)id);
                        idDone = true;
                    }
                }
                if (!this.myHtmlConverterOptions.outputAttributesNamesRegex.isEmpty()) {
                    for (Attribute attribute : nodeAttributes) {
                        if (idDone && (attribute.getKey().equals("id") || attribute.getKey().equals("name")) || !attribute.getKey().matches(this.myHtmlConverterOptions.outputAttributesNamesRegex)) continue;
                        attributes.replaceValue((CharSequence)attribute.getKey(), (CharSequence)attribute.getValue());
                    }
                }
            }
        }

        @Override
        public int outputAttributes(@NotNull LineAppendable out, @NotNull String initialSep) {
            assert (this.myState != null);
            MutableAttributes attributes = this.myState.myAttributes;
            int startOffset = out.offsetWithPending();
            if (!attributes.isEmpty() && !this.myHtmlConverterOptions.skipAttributes) {
                String sep = FlexmarkHtmlConverter.DEFAULT_NODE;
                out.append((CharSequence)initialSep);
                out.append((CharSequence)"{");
                for (String attrName : attributes.keySet()) {
                    String value = attributes.getValue((CharSequence)attrName);
                    out.append((CharSequence)sep);
                    if (attrName.equals("id") || attrName.equals("name")) {
                        Matcher matcher;
                        boolean handled = false;
                        if (!this.myHtmlConverterOptions.outputIdAttributeRegex.isEmpty() && (matcher = this.myHtmlConverterOptions.outputIdAttributeRegexPattern.matcher(value)).matches()) {
                            StringBuilder sb = new StringBuilder();
                            int iMax = matcher.groupCount();
                            for (int i = 0; i < iMax; ++i) {
                                String group = matcher.group(i + 1);
                                if (group == null || group.isEmpty()) continue;
                                sb.append(group);
                            }
                            value = sb.toString().trim();
                            handled = value.isEmpty();
                        }
                        if (!handled) {
                            out.append((CharSequence)"#").append((CharSequence)value);
                        }
                    } else if (attrName.equals("class")) {
                        out.append((CharSequence)".").append((CharSequence)value);
                    } else {
                        out.append((CharSequence)attrName).append((CharSequence)"=");
                        if (!value.contains("\"")) {
                            out.append('\"').append((CharSequence)value).append('\"');
                        } else if (!value.contains("'")) {
                            out.append('\'').append((CharSequence)value).append('\'');
                        } else {
                            out.append('\"').append((CharSequence)value.replace("\"", "\\\"")).append('\"');
                        }
                    }
                    sep = " ";
                }
                out.append((CharSequence)"}");
                this.myState.myAttributes.clear();
            }
            return out.offsetWithPending() - startOffset;
        }

        @Override
        public void transferIdToParent() {
            HtmlConverterState state;
            assert (this.myState != null);
            if (this.myStateStack.isEmpty()) {
                throw new IllegalStateException("transferIdToParent with an empty stack");
            }
            com.vladsch.flexmark.util.html.Attribute attribute = this.myState.myAttributes.get((CharSequence)"id");
            this.myState.myAttributes.remove((CharSequence)"id");
            if (attribute != null && !attribute.getValue().isEmpty() && (state = this.myStateStack.peek()) != null) {
                state.myAttributes.addValue((CharSequence)"id", (CharSequence)attribute.getValue());
            }
        }

        @Override
        public void transferToParentExcept(String ... excludes) {
            assert (this.myState != null);
            if (this.myStateStack.isEmpty()) {
                throw new IllegalStateException("transferIdToParent with an empty stack");
            }
            MutableAttributes attributes = new MutableAttributes((Attributes)this.myState.myAttributes);
            this.myState.myAttributes.clear();
            for (String exclude : excludes) {
                this.myState.myAttributes.addValue(attributes.get((CharSequence)exclude));
                attributes.remove((CharSequence)exclude);
            }
            if (!attributes.isEmpty()) {
                HtmlConverterState parentState = this.myStateStack.peek();
                for (String attrName : attributes.keySet()) {
                    parentState.myAttributes.addValue(attributes.get((CharSequence)attrName));
                }
            }
        }

        @Override
        public void transferToParentOnly(String ... includes) {
            assert (this.myState != null);
            if (this.myStateStack.isEmpty()) {
                throw new IllegalStateException("transferIdToParent with an empty stack");
            }
            MutableAttributes attributes = new MutableAttributes();
            for (String include : includes) {
                com.vladsch.flexmark.util.html.Attribute attribute = this.myState.myAttributes.get((CharSequence)include);
                if (attribute == null) continue;
                this.myState.myAttributes.remove((CharSequence)include);
                attributes.addValue(attribute);
            }
            if (!attributes.isEmpty()) {
                HtmlConverterState parentState = this.myStateStack.peek();
                for (String attrName : attributes.keySet()) {
                    parentState.myAttributes.addValue(attributes.get((CharSequence)attrName));
                }
            }
        }

        @Override
        public void popState(@Nullable LineAppendable out) {
            if (this.myStateStack.isEmpty()) {
                throw new IllegalStateException("popState with an empty stack");
            }
            if (out != null) {
                this.outputAttributes(out, FlexmarkHtmlConverter.DEFAULT_NODE);
            }
            this.myState = this.myStateStack.pop();
        }

        @Override
        @Nullable
        public org.jsoup.nodes.Node peek() {
            assert (this.myState != null);
            if (this.myState.myIndex < this.myState.myElements.size()) {
                return this.myState.myElements.get(this.myState.myIndex);
            }
            return null;
        }

        @Override
        @Nullable
        public org.jsoup.nodes.Node peek(int skip) {
            assert (this.myState != null);
            if (this.myState.myIndex + skip >= 0 && this.myState.myIndex + skip < this.myState.myElements.size()) {
                return this.myState.myElements.get(this.myState.myIndex + skip);
            }
            return null;
        }

        @Override
        @Nullable
        public org.jsoup.nodes.Node next() {
            assert (this.myState != null);
            org.jsoup.nodes.Node next = this.peek();
            if (next != null) {
                ++this.myState.myIndex;
            }
            return next;
        }

        @Override
        public void skip() {
            assert (this.myState != null);
            org.jsoup.nodes.Node next = this.peek();
            if (next != null) {
                ++this.myState.myIndex;
            }
        }

        @Override
        @Nullable
        public org.jsoup.nodes.Node next(int skip) {
            assert (this.myState != null);
            if (skip > 0) {
                org.jsoup.nodes.Node next = this.peek(skip - 1);
                if (next != null) {
                    this.myState.myIndex += skip;
                }
                return next;
            }
            return this.peek();
        }

        @Override
        public void skip(int skip) {
            org.jsoup.nodes.Node next;
            assert (this.myState != null);
            if (skip > 0 && (next = this.peek(skip - 1)) != null) {
                this.myState.myIndex += skip;
            }
        }

        private String dumpState() {
            if (!this.myStateStack.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                while (!this.myStateStack.isEmpty()) {
                    HtmlConverterState state = this.myStateStack.pop();
                    sb.append("\n").append(state == null ? "null" : state.toString());
                }
                return sb.toString();
            }
            return FlexmarkHtmlConverter.DEFAULT_NODE;
        }

        @Override
        public void processUnwrapped(@NotNull org.jsoup.nodes.Node element) {
            this.processUnwrapped(this, element);
        }

        void processUnwrapped(HtmlNodeConverterSubContext context, org.jsoup.nodes.Node element) {
            FlexmarkHtmlConverter.processHtmlTree(context, element, false, null);
        }

        @Override
        public void processWrapped(@NotNull org.jsoup.nodes.Node node, @Nullable Boolean isBlock, boolean escapeMarkdown) {
            FlexmarkHtmlConverter.processWrapped(this, node, isBlock, escapeMarkdown);
        }

        @Override
        public void processTextNodes(@NotNull org.jsoup.nodes.Node node, boolean stripIdAttribute) {
            this.processTextNodes(node, stripIdAttribute, null, null);
        }

        @Override
        public void processTextNodes(@NotNull org.jsoup.nodes.Node node, boolean stripIdAttribute, @NotNull CharSequence wrapText) {
            this.processTextNodes(node, stripIdAttribute, wrapText, wrapText);
        }

        @Override
        public void processTextNodes(@NotNull org.jsoup.nodes.Node node, boolean stripIdAttribute, @Nullable CharSequence textPrefix, @Nullable CharSequence textSuffix) {
            FlexmarkHtmlConverter.processTextNodes(this, node, stripIdAttribute, textPrefix, textSuffix);
        }

        @Override
        public void wrapTextNodes(@NotNull org.jsoup.nodes.Node node, @NotNull CharSequence wrapText, boolean needSpaceAround) {
            FlexmarkHtmlConverter.wrapTextNodes(this, node, wrapText, needSpaceAround);
        }

        @Override
        @NotNull
        public String processTextNodes(@NotNull org.jsoup.nodes.Node node) {
            org.jsoup.nodes.Node child;
            this.pushState(node);
            HtmlNodeConverterContext subContext = this.getSubContext();
            while ((child = this.next()) != null) {
                if (child instanceof TextNode) {
                    String text = ((TextNode)child).getWholeText();
                    subContext.getMarkdown().append(this.prepareText(text));
                    continue;
                }
                if (!(child instanceof Element)) continue;
                subContext.render(child);
            }
            this.transferIdToParent();
            this.popState(null);
            return subContext.getMarkdown().toString(-1, -1);
        }

        @Override
        public void appendOuterHtml(@NotNull org.jsoup.nodes.Node node) {
            FlexmarkHtmlConverter.appendOuterHtml(this, node);
        }

        @Override
        public boolean isInlineCode() {
            return this.myInlineCode;
        }

        @Override
        public void setInlineCode(boolean inlineCode) {
            this.myInlineCode = inlineCode;
        }

        @Override
        public void inlineCode(@NotNull Runnable inlineRunnable) {
            boolean oldInlineCode = this.myInlineCode;
            this.myInlineCode = true;
            try {
                inlineRunnable.run();
            }
            finally {
                this.myInlineCode = oldInlineCode;
            }
        }

        @Override
        @NotNull
        public String prepareText(@NotNull String text) {
            return this.prepareText(text, this.myInlineCode);
        }

        @Override
        @NotNull
        public String prepareText(@NotNull String text, boolean inCode) {
            if (this.specialCharsPattern != null) {
                Matcher matcher = this.specialCharsPattern.matcher(text);
                int length = text.length();
                StringBuilder sb = new StringBuilder(length * 2);
                int lastPos = 0;
                while (matcher.find()) {
                    String raw;
                    String mapped;
                    if (lastPos < matcher.start()) {
                        sb.append(text, lastPos, matcher.start());
                    }
                    if ((mapped = this.mySpecialCharsMap.get(raw = matcher.group())) != null) {
                        sb.append(mapped);
                    } else {
                        sb.append(raw);
                    }
                    lastPos = matcher.end();
                }
                if (lastPos < length) {
                    sb.append(text, lastPos, length);
                }
                text = sb.toString();
            }
            text = !inCode ? this.escapeSpecialChars(text) : text.replace("\u00a0", " ");
            return text;
        }

        @Override
        @NotNull
        public String escapeSpecialChars(@NotNull String text) {
            if (!this.myHtmlConverterOptions.skipCharEscape) {
                text = text.replace("\\", "\\\\");
                text = text.replace("*", "\\*");
                text = text.replace("~", "\\~");
                text = text.replace("^", "\\^");
                text = text.replace("&", "\\&");
                text = text.replace("<", "\\<").replace(">", "\\>");
                text = text.replace("[", "\\[").replace("]", "\\]");
                text = text.replace("|", "\\|").replace("`", "\\`");
                text = text.replace("\u00a0", this.myHtmlConverterOptions.nbspText);
            }
            return text;
        }

        @Override
        public void processConditional(@NotNull ExtensionConversion extensionConversion, @NotNull org.jsoup.nodes.Node node, @NotNull Runnable processNode) {
            FlexmarkHtmlConverter.processConditional(this, extensionConversion, node, processNode);
        }

        @Override
        public void renderDefault(@NotNull org.jsoup.nodes.Node node) {
            FlexmarkHtmlConverter.processDefault(this, node, this.getHtmlConverterOptions().outputUnknownTags);
        }

        private class SubHtmlNodeConverter
        extends HtmlNodeConverterSubContext
        implements HtmlNodeConverterContext {
            private final MainHtmlConverter myMainNodeRenderer;
            private final DataHolder myOptions;

            SubHtmlNodeConverter(@NotNull MainHtmlConverter mainNodeRenderer, @Nullable HtmlMarkdownWriter out, DataHolder options) {
                super(out);
                this.myMainNodeRenderer = mainNodeRenderer;
                this.myOptions = options == null || options == this.myMainNodeRenderer.getOptions() ? this.myMainNodeRenderer.getOptions() : new ScopedDataSet(this.myMainNodeRenderer.getOptions(), options);
            }

            @Override
            @NotNull
            public DataHolder getOptions() {
                return this.myOptions;
            }

            @Override
            @NotNull
            public HtmlConverterOptions getHtmlConverterOptions() {
                return this.myMainNodeRenderer.getHtmlConverterOptions();
            }

            @Override
            @NotNull
            public org.jsoup.nodes.Document getDocument() {
                return this.myMainNodeRenderer.getDocument();
            }

            @Override
            public HtmlConverterPhase getFormattingPhase() {
                return this.myMainNodeRenderer.getFormattingPhase();
            }

            @Override
            public void render(@NotNull org.jsoup.nodes.Node node) {
                this.myMainNodeRenderer.renderNode(node, this);
            }

            @Override
            public org.jsoup.nodes.Node getCurrentNode() {
                return this.myRenderingNode;
            }

            @Override
            @NotNull
            public HtmlNodeConverterContext getSubContext() {
                return this.getSubContext(this.myOptions, (ISequenceBuilder)StringSequenceBuilder.emptyBuilder());
            }

            @Override
            @NotNull
            public HtmlNodeConverterContext getSubContext(@Nullable DataHolder options) {
                return this.getSubContext(options, (ISequenceBuilder)StringSequenceBuilder.emptyBuilder());
            }

            @Override
            @NotNull
            public HtmlNodeConverterContext getSubContext(@Nullable DataHolder options, @NotNull ISequenceBuilder<?, ?> builder) {
                HtmlMarkdownWriter writer = new HtmlMarkdownWriter((Appendable)builder, this.markdown.getOptions());
                writer.setContext(this);
                return new SubHtmlNodeConverter(this.myMainNodeRenderer, writer, (DataHolder)(options == null || options == this.myOptions ? this.myOptions : new ScopedDataSet(this.myOptions, options)));
            }

            @Override
            public void renderChildren(@NotNull org.jsoup.nodes.Node parent, boolean outputAttributes, Runnable prePopAction) {
                FlexmarkHtmlConverter.processHtmlTree(this, parent, outputAttributes, prePopAction);
            }

            @Override
            @Nullable
            public Document getForDocument() {
                return this.myMainNodeRenderer.getForDocument();
            }

            @Override
            @NotNull
            public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(linkType, url, urlEncode);
            }

            @Override
            @NotNull
            public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Attributes attributes, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(linkType, url, attributes, urlEncode);
            }

            @Override
            public void pushState(@NotNull org.jsoup.nodes.Node parent) {
                this.myMainNodeRenderer.pushState(parent);
            }

            @Override
            public void popState(@Nullable LineAppendable out) {
                this.myMainNodeRenderer.popState(out);
            }

            @Override
            public void processAttributes(@NotNull org.jsoup.nodes.Node node) {
                this.myMainNodeRenderer.processAttributes(node);
            }

            @Override
            public int outputAttributes(@NotNull LineAppendable out, @NotNull String initialSep) {
                return this.myMainNodeRenderer.outputAttributes(out, initialSep);
            }

            @Override
            public void transferIdToParent() {
                this.myMainNodeRenderer.transferIdToParent();
            }

            @Override
            public void transferToParentExcept(String ... excludes) {
                this.myMainNodeRenderer.transferToParentExcept(excludes);
            }

            @Override
            public void transferToParentOnly(String ... includes) {
                this.myMainNodeRenderer.transferToParentOnly(includes);
            }

            @Override
            @Nullable
            public org.jsoup.nodes.Node peek() {
                return this.myMainNodeRenderer.peek();
            }

            @Override
            @Nullable
            public org.jsoup.nodes.Node peek(int skip) {
                return this.myMainNodeRenderer.peek(skip);
            }

            @Override
            @Nullable
            public org.jsoup.nodes.Node next() {
                return this.myMainNodeRenderer.next();
            }

            @Override
            public void skip() {
                this.myMainNodeRenderer.skip();
            }

            @Override
            @Nullable
            public org.jsoup.nodes.Node next(int skip) {
                return this.myMainNodeRenderer.next(skip);
            }

            @Override
            public void skip(int skip) {
                this.myMainNodeRenderer.skip(skip);
            }

            @Override
            public void delegateRender() {
                this.myMainNodeRenderer.renderByPreviousHandler(this);
            }

            @Override
            @NotNull
            public HashMap<String, Reference> getReferenceUrlToReferenceMap() {
                return this.myMainNodeRenderer.getReferenceUrlToReferenceMap();
            }

            @Override
            @NotNull
            public HashMap<String, Reference> getReferenceIdToReferenceMap() {
                return this.myMainNodeRenderer.getReferenceIdToReferenceMap();
            }

            @Override
            @NotNull
            public HashSet<Reference> getExternalReferences() {
                return this.myMainNodeRenderer.getExternalReferences();
            }

            @Override
            public Reference getOrCreateReference(@NotNull String url, @NotNull String text, @Nullable String title) {
                return this.myMainNodeRenderer.getOrCreateReference(url, text, title);
            }

            @Override
            public @NotNull Node parseMarkdown(@NotNull String markdown) {
                return this.myMainNodeRenderer.parseMarkdown(markdown);
            }

            @Override
            public void processUnwrapped(@NotNull org.jsoup.nodes.Node element) {
                this.myMainNodeRenderer.processUnwrapped(this, element);
            }

            @Override
            public void processWrapped(@NotNull org.jsoup.nodes.Node node, @Nullable Boolean isBlock, boolean escapeMarkdown) {
                FlexmarkHtmlConverter.processWrapped(this, node, isBlock, escapeMarkdown);
            }

            @Override
            public void appendOuterHtml(@NotNull org.jsoup.nodes.Node node) {
                FlexmarkHtmlConverter.appendOuterHtml(this, node);
            }

            @Override
            public boolean isInlineCode() {
                return this.myMainNodeRenderer.isInlineCode();
            }

            @Override
            public void setInlineCode(boolean inlineCode) {
                this.myMainNodeRenderer.setInlineCode(inlineCode);
            }

            @Override
            public void inlineCode(@NotNull Runnable inlineRunnable) {
                this.myMainNodeRenderer.inlineCode(inlineRunnable);
            }

            @Override
            @NotNull
            public String escapeSpecialChars(@NotNull String text) {
                return this.myMainNodeRenderer.escapeSpecialChars(text);
            }

            @Override
            @NotNull
            public String prepareText(@NotNull String text) {
                return this.myMainNodeRenderer.prepareText(text);
            }

            @Override
            @NotNull
            public String prepareText(@NotNull String text, boolean inCode) {
                return this.myMainNodeRenderer.prepareText(text, inCode);
            }

            @Override
            @NotNull
            public String processTextNodes(@NotNull org.jsoup.nodes.Node node) {
                return this.myMainNodeRenderer.processTextNodes(node);
            }

            @Override
            public void excludeAttributes(String ... excludes) {
                this.myMainNodeRenderer.excludeAttributes(excludes);
            }

            @Override
            public void processTextNodes(@NotNull org.jsoup.nodes.Node node, boolean stripIdAttribute) {
                this.processTextNodes(node, stripIdAttribute, null, null);
            }

            @Override
            public void processTextNodes(@NotNull org.jsoup.nodes.Node node, boolean stripIdAttribute, @NotNull CharSequence wrapText) {
                this.processTextNodes(node, stripIdAttribute, wrapText, wrapText);
            }

            @Override
            public void processTextNodes(@NotNull org.jsoup.nodes.Node node, boolean stripIdAttribute, @Nullable CharSequence textPrefix, @Nullable CharSequence textSuffix) {
                FlexmarkHtmlConverter.processTextNodes(this, node, stripIdAttribute, textPrefix, textSuffix);
            }

            @Override
            public void wrapTextNodes(@NotNull org.jsoup.nodes.Node node, @NotNull CharSequence wrapText, boolean needSpaceAround) {
                FlexmarkHtmlConverter.wrapTextNodes(this, node, wrapText, needSpaceAround);
            }

            @Override
            public void processConditional(@NotNull ExtensionConversion extensionConversion, @NotNull org.jsoup.nodes.Node node, @NotNull Runnable processNode) {
                FlexmarkHtmlConverter.processConditional(this, extensionConversion, node, processNode);
            }

            @Override
            public void renderDefault(@NotNull org.jsoup.nodes.Node node) {
                FlexmarkHtmlConverter.processDefault(this, node, this.getHtmlConverterOptions().outputUnknownTags);
            }

            @Override
            public HtmlConverterState getState() {
                return this.myMainNodeRenderer.getState();
            }

            @Override
            public boolean isTrace() {
                return this.myMainNodeRenderer.isTrace();
            }

            @Override
            public void setTrace(boolean trace) {
                this.myMainNodeRenderer.setTrace(trace);
            }

            @Override
            @NotNull
            public Stack<HtmlConverterState> getStateStack() {
                return this.myMainNodeRenderer.getStateStack();
            }
        }
    }

    public static interface HtmlConverterExtension
    extends Extension {
        public void rendererOptions(@NotNull MutableDataHolder var1);

        public void extend(@NotNull Builder var1);
    }

    public static class Builder
    extends BuilderBase<Builder> {
        List<HtmlNodeRendererFactory> nodeRendererFactories = new ArrayList<HtmlNodeRendererFactory>();
        List<HtmlLinkResolverFactory> linkResolverFactories = new ArrayList<HtmlLinkResolverFactory>();
        HeaderIdGeneratorFactory htmlIdGeneratorFactory = null;

        public Builder() {
        }

        public Builder(@Nullable DataHolder options) {
            super(options);
            this.loadExtensions();
        }

        @NotNull
        public FlexmarkHtmlConverter build() {
            return new FlexmarkHtmlConverter(this);
        }

        protected void removeApiPoint(@NotNull Object apiPoint) {
            if (apiPoint instanceof HtmlNodeRendererFactory) {
                this.nodeRendererFactories.remove(apiPoint);
            } else if (apiPoint instanceof HtmlLinkResolverFactory) {
                this.linkResolverFactories.remove(apiPoint);
            } else if (apiPoint instanceof HeaderIdGeneratorFactory) {
                this.htmlIdGeneratorFactory = null;
            } else {
                throw new IllegalStateException("Unknown data point type: " + apiPoint.getClass().getName());
            }
        }

        protected void preloadExtension(@NotNull Extension extension) {
            if (extension instanceof HtmlConverterExtension) {
                HtmlConverterExtension htmlConverterExtension = (HtmlConverterExtension)extension;
                htmlConverterExtension.rendererOptions((MutableDataHolder)this);
            }
        }

        protected boolean loadExtension(@NotNull Extension extension) {
            if (extension instanceof HtmlConverterExtension) {
                HtmlConverterExtension htmlConverterExtension = (HtmlConverterExtension)extension;
                htmlConverterExtension.extend(this);
                return true;
            }
            return false;
        }

        public Builder htmlNodeRendererFactory(@NotNull HtmlNodeRendererFactory htmlNodeRendererFactory) {
            this.nodeRendererFactories.add(htmlNodeRendererFactory);
            return this;
        }

        public Builder linkResolverFactory(@NotNull HtmlLinkResolverFactory linkResolverFactory) {
            this.linkResolverFactories.add(linkResolverFactory);
            this.addExtensionApiPoint(linkResolverFactory);
            return this;
        }
    }
}

