/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency.reload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.netbeans.modules.project.dependency.reload.Bundle;
import org.netbeans.modules.project.dependency.reload.Forwarder;
import org.netbeans.modules.project.dependency.reload.ProjectReloadInternal;
import org.netbeans.modules.project.dependency.reload.ProjectStateListener;
import org.netbeans.modules.project.dependency.reload.ReloadApiAccessor;
import org.netbeans.modules.project.dependency.reload.ReloadSpiAccessor;
import org.netbeans.modules.project.dependency.spi.ProjectReloadImplementation;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class Reloader {
    public static final Logger LOG = Logger.getLogger(Reloader.class.getName());
    final Project project;
    final ProjectReload.StateRequest request;
    final ProjectReload.ProjectState originalState;
    final Throwable originTrace;
    final CompletableFuture<ProjectReload.ProjectState> completePending = new CompletableFuture();
    final CompletableFuture<ProjectReload.ProjectState> clientFuture;
    private final Collection<LoadContextImpl> loadData = new ArrayList<LoadContextImpl>();
    private final ProjectReloadInternal registry;
    private final Collection variantKey;
    private RequestProcessor reloadProcessor;
    private Executor reloadExecutor;
    private volatile Throwable cancelled;
    private volatile CompletableFuture<ProjectReloadImplementation.ProjectStateData<?>> currentStage;
    private volatile LoadContextImpl currentStageContext;
    private ProjectReloadInternal.StateParts parts;
    private volatile boolean ownCompleted = false;
    private boolean forced;
    private boolean forcedRound;
    private int reloadRound = 1;
    private Iterator<LoadContextImpl> implIter;
    private Collection<LoadContextImpl> lastRetries = Collections.emptyList();
    private Collection<LoadContextImpl> lastInconsistent = Collections.emptyList();
    private Collection<Pair<ProjectReloadImplementation<?>, ProjectReloadImplementation.ProjectStateData>> reportedStates = new ArrayList();
    private static final ProjectReloadImplementation.ProjectStateData CANCEL = ProjectReloadImplementation.ProjectStateData.builder(ProjectReload.Quality.NONE).build();

    public Reloader(Project p, ProjectReload.StateRequest request, ProjectReloadInternal.StateRef currentRef, Collection<? extends ProjectReloadImplementation> impls, ProjectReloadInternal registry, Throwable origin) {
        this.originTrace = origin;
        this.registry = registry;
        this.project = p;
        this.request = request;
        this.originalState = currentRef == null ? null : (ProjectReload.ProjectState)currentRef.get();
        this.forced = request.isForceReload();
        this.variantKey = currentRef == null ? null : currentRef.variantKey;
        for (ProjectReloadImplementation projectReloadImplementation : impls) {
            this.loadData.add(new LoadContextImpl(projectReloadImplementation, this.originalState));
        }
        this.clientFuture = this.completePending.copy();
        this.clientFuture.exceptionally(t -> {
            if (t instanceof CompletionException) {
                t = t.getCause();
            }
            if (t instanceof CancellationException) {
                this.cancel((CancellationException)t);
            }
            return null;
        });
    }

    public Throwable getOriginTrace() {
        return this.originTrace;
    }

    public String toString() {
        return "Reload[" + (this.variantKey == null ? this.project : this.variantKey) + "]@" + Integer.toHexString(System.identityHashCode(this)) + " #" + this.reloadRound;
    }

    public CompletableFuture<ProjectReload.ProjectState> getPending() {
        return this.completePending;
    }

    private void markInconsistentParts() {
        ProjectReloadImplementation.ProjectStateData d;
        for (LoadContextImpl ctx : this.loadData) {
            d = ctx.loadedData;
            if (d == null || d.isValid() && (d.isConsistent() || !this.request.isConsistent())) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0}: part {1} loaded inconsistent, implies reload", new Object[]{this, d.toString()});
            }
            ctx.reloadRequested = true;
        }
        for (LoadContextImpl ctx : this.loadData) {
            d = ctx.loadedData;
            Set<Class> inc = ctx.inconsistencies;
            if (inc != null) {
                LOG.log(Level.FINE, "{0}: loader reports inconsistencies", new Object[]{this, inc});
            }
            if (!Reloader.markInconsistencies(d, inc, this.parts, this)) continue;
            ctx.reloadRequested = true;
        }
    }

    public static boolean markInconsistencies(ProjectReloadImplementation.ProjectStateData d, Collection<Class> inc, ProjectReloadInternal.StateParts parts, Object logMe) {
        boolean requested = false;
        if (d != null) {
            Set<Class> inc2 = ReloadSpiAccessor.get().getInconsistencies(d);
            if (inc != null) {
                if (inc2 != null) {
                    inc.addAll(inc2);
                }
                LOG.log(Level.FINE, "{0}: part {1} reports inconsistencies", new Object[]{logMe, inc2});
            } else {
                inc = inc2;
            }
        }
        if (inc != null && !inc.isEmpty()) {
            for (Class c : inc) {
                Lookup.Template t = new Lookup.Template(c);
                for (ProjectReloadImplementation.ProjectStateData d2 : parts.values()) {
                    if (d2 == null || !d2.isConsistent() || !d2.isValid() || !c.isInstance(d2.getProjectData()) && (d2.getLookup() == null || d2.getLookup().lookupItem(t) == null)) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "{0}: part {1} provides {2}, mark inconsistent and reload", new Object[]{logMe, d2.toString(), c});
                    }
                    requested = true;
                    d2.fireChanged(false, true);
                }
            }
        }
        return requested;
    }

    private CompletableFuture<ProjectReload.ProjectState> maybeMakeRetry(Collection variant) {
        boolean inconsistentRetry;
        if (this.loadData.stream().anyMatch(ctx -> ctx.reportLoadError)) {
            return null;
        }
        boolean forceReload = this.loadData.stream().anyMatch(d -> d.reloadRequested);
        Collection retries = this.loadData.stream().filter(d -> d.reloadRequested).collect(Collectors.toList());
        HashSet<LoadContextImpl> fileInconsistencies = new HashSet<LoadContextImpl>();
        this.checkFileTimestamps(fileInconsistencies);
        boolean bl = inconsistentRetry = this.request.isConsistent() && !fileInconsistencies.isEmpty();
        if (inconsistentRetry) {
            if (!this.lastInconsistent.isEmpty() && fileInconsistencies.containsAll(this.lastInconsistent)) {
                ProjectOperationException ex = new ProjectOperationException(this.project, ProjectOperationException.State.OUT_OF_SYNC, Bundle.ERR_ProjectModifiedWhileLoading(ProjectUtils.getInformation((Project)this.project).getDisplayName()));
                this.registry.createState(this.originalState, this.project, variant, this.parts, false, this.request);
                return CompletableFuture.failedFuture(ex);
            }
        } else {
            if (retries.isEmpty()) {
                return null;
            }
            if (!this.lastRetries.isEmpty() && retries.containsAll(this.lastRetries)) {
                LOG.log(Level.WARNING, "Project {0} is reloading repetadely. The following provider(s) reload in a loop: {1}", new Object[]{this.project.getProjectDirectory(), this.lastRetries});
                ProjectOperationException ex = new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_ReloadingLoop(ProjectUtils.getInformation((Project)this.project).getDisplayName(), this.lastRetries));
                this.registry.createState(this.originalState, this.project, variant, this.parts, false, this.request);
                return CompletableFuture.failedFuture(ex);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            String s = Stream.concat(fileInconsistencies.stream(), retries.stream()).map(c -> c.impl.getClass().getName()).collect(Collectors.joining(", "));
            LOG.log(Level.FINE, "{0} reloads again because of {1}", new Object[]{this.toString(), s});
        }
        this.lastRetries = retries;
        this.lastInconsistent = fileInconsistencies;
        this.initRound();
        this.forcedRound = forceReload;
        ++this.reloadRound;
        return this.processOne();
    }

    private void checkFileTimestamps(Collection<LoadContextImpl> impls) {
        HashMap<FileObject, Collection<ProjectReloadImplementation.ProjectStateData>> wf = new HashMap<FileObject, Collection<ProjectReloadImplementation.ProjectStateData>>();
        for (LoadContextImpl ctx : this.loadData) {
            ProjectReloadImplementation.ProjectStateData d = ctx.loadedData;
            if (d == null) continue;
            Collection<FileObject> files = d.getFiles();
            files.forEach(f -> wf.computeIfAbsent((FileObject)f, x -> new ArrayList()).add(d));
        }
        for (ProjectReloadImplementation.ProjectStateData d : Reloader.checkFileTimestamps(this, wf)) {
            this.loadData.stream().filter(x -> x.loadedData == d).forEach(i -> impls.add((LoadContextImpl)i));
        }
    }

    public static Collection<ProjectReloadImplementation.ProjectStateData> checkFileTimestamps(Object s, Map<FileObject, Collection<ProjectReloadImplementation.ProjectStateData>> wf) {
        ArrayList<ProjectReloadImplementation.ProjectStateData> inconsistent = new ArrayList<ProjectReloadImplementation.ProjectStateData>();
        for (Map.Entry<FileObject, Collection<ProjectReloadImplementation.ProjectStateData>> e : wf.entrySet()) {
            FileObject f = e.getKey();
            f.refresh();
            long t = f.lastModified().getTime();
            boolean modified = f.getLookup().lookup(SaveCookie.class) != null;
            for (ProjectReloadImplementation.ProjectStateData d : e.getValue()) {
                if (!modified && d.getTimestamp() >= t) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINER, "CHECK {0}: StateData not consistent: {1}. Modified={2}, file={3}, state={4}", new Object[]{s, d.toString(), modified, t, d.getTimestamp()});
                }
                d.fireChanged(false, true);
                inconsistent.add(d);
            }
        }
        return inconsistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized CompletableFuture<ProjectReload.ProjectState> finishLoadingRound() {
        CompletableFuture<ProjectReload.ProjectState> completableFuture;
        block44: {
            Object it2;
            ProjectReload.ProjectState result;
            boolean finished;
            block42: {
                block43: {
                    Throwable error;
                    block40: {
                        CompletableFuture<ProjectReload.ProjectState> completableFuture2;
                        block41: {
                            CompletableFuture<ProjectReload.ProjectState> f;
                            this.markInconsistentParts();
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "{0} load round completed.", this.toString());
                            }
                            Collection variant = ProjectReloadInternal.variantKey(this.project, this.parts, this.request.getContext());
                            if (this.variantKey != null && !this.variantKey.equals(variant)) {
                                LOG.log(Level.WARNING, "Variant key formed for {0} differs from cache key: {1}/{2}", new Object[]{this.request, variant, this.variantKey});
                            }
                            if ((f = this.maybeMakeRetry(variant)) != null) {
                                return f;
                            }
                            error = null;
                            finished = false;
                            result = (ProjectReload.ProjectState)this.registry.createState(this.originalState, this.project, variant, this.parts, this.request.isConsistent(), this.request).second();
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "{0} load round completed.", this.toString());
                            }
                            if ((f = this.maybeMakeRetry(variant)) == null) break block40;
                            completableFuture2 = f;
                            if (!finished) break block41;
                            this.loadData.forEach(ctx -> {
                                ctx.reinit(ProjectReloadInternal.EMPTY_PARTS);
                                ReloadSpiAccessor.get().clear(ctx.clientContext);
                            });
                            Iterator<Pair<ProjectReloadImplementation<?>, ProjectReloadImplementation.ProjectStateData>> it2 = this.reportedStates.iterator();
                            while (it2.hasNext()) {
                                Pair<ProjectReloadImplementation<?>, ProjectReloadImplementation.ProjectStateData> pair = it2.next();
                                if (this.parts.get(pair.first()) != pair.second()) {
                                    if (LOG.isLoggable(Level.FINE)) {
                                        LOG.log(Level.FINE, "{0}: Invalidating state {1}, final state has different instance", new Object[]{this.toString(), ((ProjectReloadImplementation.ProjectStateData)pair.second()).toString()});
                                    }
                                    ((ProjectReloadImplementation.ProjectStateData)pair.second()).fireChanged(true, false);
                                }
                                if (!this.registry.hasIdentity((ProjectReloadImplementation.ProjectStateData)pair.second())) continue;
                                it2.remove();
                            }
                            if (!this.reportedStates.isEmpty()) {
                                if (LOG.isLoggable(Level.FINE) && LOG.isLoggable(Level.FINE)) {
                                    LOG.log(Level.FINE, "{0}: Scheduling cleanup of dangling states", new Object[]{this.toString(), this.reportedStates.stream().map(p -> ((ProjectReloadImplementation.ProjectStateData)p.second()).toString()).collect(Collectors.joining(", "))});
                                }
                                this.registry.runProjectAction(this.project, () -> this.reportedStates.forEach(pair -> {
                                    if (LOG.isLoggable(Level.FINE)) {
                                        LOG.log(Level.FINE, "{0}: Releasing dangling states", this.toString());
                                        ((ProjectReloadImplementation)pair.first()).projectDataReleased((ProjectReloadImplementation.ProjectStateData)pair.second());
                                        ReloadSpiAccessor.get().release((ProjectReloadImplementation.ProjectStateData)pair.second());
                                    }
                                }));
                            }
                        }
                        return completableFuture2;
                    }
                    finished = true;
                    if (result.getQuality().isWorseThan(this.request.getMinQuality())) {
                        ex = null;
                        for (LoadContextImpl d : this.loadData) {
                            Throwable t;
                            if (d.reloadError == null || !((t = d.reloadError) instanceof ProjectOperationException)) continue;
                            ex = (ProjectOperationException)t;
                            break;
                        }
                        if (ex == null) {
                            ex = new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_ProjectQualityLow(ProjectUtils.getInformation((Project)this.project).getDisplayName()));
                        }
                        error = ex;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "{0} loaded as low quality ({1}/{2}), failing operation", new Object[]{this.toString(), result.getQuality(), this.request.getMinQuality()});
                        }
                    } else if (!result.isConsistent() && this.request.isConsistent()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "{0} loaded as inconsistent, failing operation", this.toString());
                        }
                        error = ex = new ProjectOperationException(this.project, ProjectOperationException.State.OUT_OF_SYNC, Bundle.ERR_ProjectModifiedWhileLoading(ProjectUtils.getInformation((Project)this.project).getDisplayName()));
                    }
                    if (error == null) break block42;
                    LOG.log(Level.FINE, "{0}: Resulted in errors: {1}", new Object[]{this, error.getMessage()});
                    LOG.log(Level.FINE, "Stacktrace: ", error);
                    boolean first = true;
                    for (LoadContextImpl d : this.loadData) {
                        Throwable e = d.reloadError;
                        if (e == null || error == e) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Additional error:", e);
                        }
                        if (first && error.getCause() == null || error.getCause() != error) {
                            error.initCause(e);
                        } else {
                            error.addSuppressed(e);
                        }
                        first = false;
                    }
                    it2 = CompletableFuture.failedFuture(error);
                    if (!finished) break block43;
                    this.loadData.forEach(ctx -> {
                        ctx.reinit(ProjectReloadInternal.EMPTY_PARTS);
                        ReloadSpiAccessor.get().clear(ctx.clientContext);
                    });
                    Iterator<Pair<ProjectReloadImplementation<?>, ProjectReloadImplementation.ProjectStateData>> it3 = this.reportedStates.iterator();
                    while (it3.hasNext()) {
                        Pair<ProjectReloadImplementation<?>, ProjectReloadImplementation.ProjectStateData> pair = it3.next();
                        if (this.parts.get(pair.first()) != pair.second()) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "{0}: Invalidating state {1}, final state has different instance", new Object[]{this.toString(), ((ProjectReloadImplementation.ProjectStateData)pair.second()).toString()});
                            }
                            ((ProjectReloadImplementation.ProjectStateData)pair.second()).fireChanged(true, false);
                        }
                        if (!this.registry.hasIdentity((ProjectReloadImplementation.ProjectStateData)pair.second())) continue;
                        it3.remove();
                    }
                    if (!this.reportedStates.isEmpty()) {
                        if (LOG.isLoggable(Level.FINE) && LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "{0}: Scheduling cleanup of dangling states", new Object[]{this.toString(), this.reportedStates.stream().map(p -> ((ProjectReloadImplementation.ProjectStateData)p.second()).toString()).collect(Collectors.joining(", "))});
                        }
                        this.registry.runProjectAction(this.project, () -> this.reportedStates.forEach(pair -> {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "{0}: Releasing dangling states", this.toString());
                                ((ProjectReloadImplementation)pair.first()).projectDataReleased((ProjectReloadImplementation.ProjectStateData)pair.second());
                                ReloadSpiAccessor.get().release((ProjectReloadImplementation.ProjectStateData)pair.second());
                            }
                        }));
                    }
                }
                return it2;
            }
            try {
                completableFuture = CompletableFuture.completedFuture(result);
                if (!finished) break block44;
            }
            catch (Throwable throwable) {
                if (finished) {
                    this.loadData.forEach(ctx -> {
                        ctx.reinit(ProjectReloadInternal.EMPTY_PARTS);
                        ReloadSpiAccessor.get().clear(ctx.clientContext);
                    });
                    Iterator<Pair<ProjectReloadImplementation<?>, ProjectReloadImplementation.ProjectStateData>> it4 = this.reportedStates.iterator();
                    while (it4.hasNext()) {
                        Pair<ProjectReloadImplementation<?>, ProjectReloadImplementation.ProjectStateData> pair = it4.next();
                        if (this.parts.get(pair.first()) != pair.second()) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "{0}: Invalidating state {1}, final state has different instance", new Object[]{this.toString(), ((ProjectReloadImplementation.ProjectStateData)pair.second()).toString()});
                            }
                            ((ProjectReloadImplementation.ProjectStateData)pair.second()).fireChanged(true, false);
                        }
                        if (!this.registry.hasIdentity((ProjectReloadImplementation.ProjectStateData)pair.second())) continue;
                        it4.remove();
                    }
                    if (!this.reportedStates.isEmpty()) {
                        if (LOG.isLoggable(Level.FINE) && LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "{0}: Scheduling cleanup of dangling states", new Object[]{this.toString(), this.reportedStates.stream().map(p -> ((ProjectReloadImplementation.ProjectStateData)p.second()).toString()).collect(Collectors.joining(", "))});
                        }
                        this.registry.runProjectAction(this.project, () -> this.reportedStates.forEach(pair -> {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "{0}: Releasing dangling states", this.toString());
                                ((ProjectReloadImplementation)pair.first()).projectDataReleased((ProjectReloadImplementation.ProjectStateData)pair.second());
                                ReloadSpiAccessor.get().release((ProjectReloadImplementation.ProjectStateData)pair.second());
                            }
                        }));
                    }
                }
                throw throwable;
            }
            this.loadData.forEach(ctx -> {
                ctx.reinit(ProjectReloadInternal.EMPTY_PARTS);
                ReloadSpiAccessor.get().clear(ctx.clientContext);
            });
            it2 = this.reportedStates.iterator();
            while (it2.hasNext()) {
                Pair pair = (Pair)it2.next();
                if (this.parts.get(pair.first()) != pair.second()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "{0}: Invalidating state {1}, final state has different instance", new Object[]{this.toString(), ((ProjectReloadImplementation.ProjectStateData)pair.second()).toString()});
                    }
                    ((ProjectReloadImplementation.ProjectStateData)pair.second()).fireChanged(true, false);
                }
                if (!this.registry.hasIdentity((ProjectReloadImplementation.ProjectStateData)pair.second())) continue;
                it2.remove();
            }
            if (!this.reportedStates.isEmpty()) {
                if (LOG.isLoggable(Level.FINE) && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "{0}: Scheduling cleanup of dangling states", new Object[]{this.toString(), this.reportedStates.stream().map(p -> ((ProjectReloadImplementation.ProjectStateData)p.second()).toString()).collect(Collectors.joining(", "))});
                }
                this.registry.runProjectAction(this.project, () -> this.reportedStates.forEach(pair -> {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "{0}: Releasing dangling states", this.toString());
                        ((ProjectReloadImplementation)pair.first()).projectDataReleased((ProjectReloadImplementation.ProjectStateData)pair.second());
                        ReloadSpiAccessor.get().release((ProjectReloadImplementation.ProjectStateData)pair.second());
                    }
                }));
            }
        }
        return completableFuture;
    }

    synchronized void initRound() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing loader {0}", this.toString());
        }
        this.implIter = this.loadData.iterator();
        this.parts = new ProjectReloadInternal.StatePartsImpl();
        this.loadData.forEach(c -> c.reinit(this.parts));
        this.forcedRound = false;
        Thread.currentThread().setName(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(CancellationException cancelled) {
        LoadContextImpl c;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0}: Cancelled", this.toString());
            LOG.log(Level.FINE, "Stacktrace: ", cancelled);
        }
        Reloader reloader = this;
        synchronized (reloader) {
            if (this.cancelled != null) {
                return;
            }
            this.cancelled = cancelled;
            c = this.currentStageContext;
        }
        if (c != null) {
            c.cancel(cancelled);
        }
    }

    private CompletableFuture<ProjectReload.ProjectState> loadStepDone(ProjectReloadImplementation.ProjectStateData<?> state, LoadContextImpl fd, Throwable t) {
        this.loadStepDone1(state, fd, t);
        return this.processOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStepDone1(ProjectReloadImplementation.ProjectStateData<?> state, LoadContextImpl fd, Throwable t) {
        if (t != null) {
            fd.reloadError = t;
        }
        if (fd.clientContext != null) {
            fd.contextData = fd.clientContext.getLoadContext(Object.class);
        }
        fd.loadedData = state;
        fd.loadedOnce = true;
        Reloader reloader = this;
        synchronized (reloader) {
            this.parts.put(fd.impl, state);
            if (state != null) {
                this.reportedStates.add(Pair.of((Object)fd.impl, state));
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} {1} loaded {2} with load-private data {3}", new Object[]{this.toString(), fd.impl, state == null ? "null" : state.toString(), fd.contextData});
        }
        this.currentStage = null;
        this.currentStageContext = null;
    }

    private CompletableFuture<ProjectReload.ProjectState> cancelLoadInProgress() {
        if (this.currentStageContext != null) {
            this.currentStageContext.reinit(null);
        }
        this.currentStage = null;
        this.currentStageContext = null;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0}: got cancel", this.toString());
            LOG.log(Level.FINE, "Stacktrace: ", this.cancelled);
        }
        Forwarder.create(this.originalState, this.parts, null, false);
        return CompletableFuture.failedFuture(this.cancelled);
    }

    private <T, U> CompletableFuture<U> composeMaybeAsync(CompletableFuture<T> f, Function<T, CompletableFuture<U>> handler) {
        return f.thenComposeAsync(handler, this.reloadExecutor);
    }

    private <T> CompletableFuture<T> exceptionallyMaybeAsync(CompletableFuture<T> f, Function<Throwable, T> handler) {
        return f.exceptionallyAsync((Function)handler, this.reloadExecutor);
    }

    public CompletableFuture<ProjectReload.ProjectState> start(RequestProcessor processor) {
        this.reloadProcessor = processor;
        this.reloadExecutor = new RPExecutor(processor);
        return this.processOne();
    }

    private ProjectReloadImplementation.ProjectStateData processGeneralError(LoadContextImpl fd, Throwable t) {
        ProjectReloadImplementation.ProjectStateData fakeD;
        ProjectReloadImplementation.ProjectStateBuilder b = ProjectReloadImplementation.ProjectStateData.builder(fd.loadedData == null ? ProjectReload.Quality.NONE : ProjectReload.Quality.BROKEN);
        if (fd.loadedData != null) {
            b.files(fd.loadedData.getFiles());
            b.state(fd.loadedData.isConsistent(), true);
            b.timestamp(fd.loadedData.getTimestamp());
            class ForwardDataChanges
            implements ProjectStateListener {
                volatile ProjectReloadImplementation.ProjectStateData toFire;

                ForwardDataChanges() {
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    ProjectReloadImplementation.ProjectStateData orig = (ProjectReloadImplementation.ProjectStateData)e.getSource();
                    this.toFire.fireFileSetChanged(orig.getChangedFiles());
                    this.toFire.fireChanged(!orig.isValid(), !orig.isConsistent());
                }

                @Override
                public void fireDataInconsistent(ProjectReloadImplementation.ProjectStateData d, Class<?> dataClass) {
                    this.toFire.fireDataInconsistent(dataClass);
                }
            }
            ForwardDataChanges cl = new ForwardDataChanges();
            b.attachLookup(Lookups.fixed((Object[])new Object[]{cl}));
            cl.toFire = fakeD = b.build();
            ReloadSpiAccessor.get().addProjectStateListener(fd.loadedData, cl);
        } else {
            fakeD = b.build();
        }
        fd.reportLoadError = !(t instanceof ProjectOperationException);
        fd.reloadError = t;
        return fakeD;
    }

    synchronized CompletableFuture<ProjectReload.ProjectState> processOne() {
        LoadContextImpl d;
        if (this.cancelled != null) {
            return this.cancelLoadInProgress();
        }
        while (true) {
            if (!this.implIter.hasNext()) {
                return this.finishLoadingRound();
            }
            d = this.implIter.next();
            if (this.forcedRound) {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, "{0}: This round is forced: loading {0}", new Object[]{this.toString(), d.impl});
                break;
            }
            if (d.loadedData == null || this.forced && !d.loadedOnce) {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, "{0}: need to execute: {1} prev data: {2}, once: {3}, force: {4}", new Object[]{this.toString(), d.impl, Objects.toString(d.loadedData), d.loadedOnce, this.forced});
                break;
            }
            ProjectReload.Quality q = d.loadedData.getQuality();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "CHECK: {0}: cached data {1}, request {2}", new Object[]{this.toString(), Objects.toString(d.loadedData), this.request});
            }
            if (q != null && q.isWorseThan(this.request.getMinQuality()) || !d.loadedData.isValid()) break;
            long ts = d.loadedData.getTimestamp();
            Collection<FileObject> fos = d.loadedData.getFiles();
            for (FileObject f : fos) {
                f.refresh();
                if (f.lastModified().getTime() <= ts) continue;
                d.loadedData.fireChanged(false, true);
                break;
            }
            if (!d.loadedData.isConsistent() && this.request.isConsistent()) break;
            if (this.lastRetries.contains(d)) {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, "CHECK: {0}: implementation requested load retry {1}", new Object[]{this.toString(), d.impl});
                break;
            }
            if (d.impl instanceof ProjectReloadImplementation.ExtendedQuery && !((ProjectReloadImplementation.ExtendedQuery)((Object)d.impl)).checkState(this.request, d.loadedData)) {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, "{0}: {1} rejected by {2}", new Object[]{this.toString(), Objects.toString(d.loadedData), d.impl});
                break;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "CHECK: {0}: cached data {1} accepted", new Object[]{this.toString(), Objects.toString(d.loadedData), this.request});
            }
            this.loadStepDone1(d.loadedData, d, null);
        }
        LoadContextImpl fd = d;
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0} loading through {1}, last data {2}, context {3}", new Object[]{this.toString(), d.impl, Objects.toString(d.loadedData), d.contextData});
            }
            this.currentStageContext = d;
            if (this.cancelled != null) {
                return this.cancelLoadInProgress();
            }
            if (fd.clientContext == null) {
                fd.clientContext = ReloadSpiAccessor.get().createLoadContext(fd);
            }
            CompletableFuture newData = d.impl.reload(this.project, this.request, fd.clientContext);
            this.currentStage = newData;
            if (newData == null) {
                return this.loadStepDone(null, fd, null);
            }
            CompletableFuture<ProjectReloadImplementation.ProjectStateData> res = this.exceptionallyMaybeAsync(newData, t -> {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "{0} got exceptional result from {1}", new Object[]{this.toString(), fd.impl});
                    LOG.log(Level.FINE, "Stacktrace: ", (Throwable)t);
                }
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                if (t instanceof CancellationException) {
                    return CANCEL;
                }
                if (t instanceof ProjectReloadImplementation.PartialLoadException) {
                    ProjectReloadImplementation.PartialLoadException ple = (ProjectReloadImplementation.PartialLoadException)t;
                    Throwable cause = ple.getCause();
                    if (cause == null) {
                        cause = ple;
                    }
                    fd.reloadError = cause;
                    return ple.getPartialData();
                }
                return this.processGeneralError(fd, (Throwable)t);
            });
            CompletableFuture<ProjectReload.ProjectState> res2 = this.composeMaybeAsync(res, data -> {
                if (data != CANCEL) {
                    return this.loadStepDone((ProjectReloadImplementation.ProjectStateData<?>)data, fd, null);
                }
                return this.cancelLoadInProgress();
            });
            return res2;
        }
        catch (ProjectReloadImplementation.PartialLoadException ex) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0} got PartialLoadException", this.toString());
                LOG.log(Level.FINE, "Stacktrace", ex);
            }
            ProjectReloadImplementation.PartialLoadException ple = ex;
            return this.loadStepDone(ple.getPartialData(), fd, ple);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            ProjectReloadImplementation.ProjectStateData data2 = this.processGeneralError(fd, ex);
            return this.loadStepDone(data2, fd, ex);
        }
    }

    public class LoadContextImpl {
        final ProjectReloadImplementation impl;
        final ProjectReloadImplementation.ProjectStateData origData;
        ProjectReloadImplementation.LoadContext clientContext;
        private Cancellable cancellable;
        private volatile CancellationException cancel;
        ProjectReloadImplementation.ProjectStateData loadedData;
        Object contextData;
        boolean loadedOnce;
        ProjectReloadInternal.StateParts parts;
        volatile boolean reloadRequested;
        volatile Throwable reloadError;
        volatile boolean reportLoadError;
        ProjectReload.ProjectState partialState;
        Set<Class> inconsistencies;

        public LoadContextImpl(ProjectReloadImplementation impl, ProjectReload.ProjectState previousState) {
            this.impl = impl;
            this.loadedData = this.origData = previousState == null ? null : (ProjectReloadImplementation.ProjectStateData)ReloadApiAccessor.get().getParts(previousState).get(impl);
        }

        public Project getProject() {
            return Reloader.this.project;
        }

        public ProjectReload.StateRequest getRequest() {
            return Reloader.this.request;
        }

        public void reinit(ProjectReloadInternal.StateParts parts) {
            this.parts = parts;
            this.partialState = null;
            this.reloadRequested = false;
            this.reloadError = null;
            this.reportLoadError = false;
            this.inconsistencies = null;
            this.cancel = null;
            this.cancellable = null;
            LOG.log(Level.FINER, "{0}: Load context reset for {1}", new Object[]{this, this.impl});
        }

        public CancellationException getCancelled() {
            return this.cancel;
        }

        public <T> T getLoadContext() {
            return (T)this.contextData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCancellable(Cancellable c) throws CancellationException {
            CancellationException t;
            LoadContextImpl loadContextImpl = this;
            synchronized (loadContextImpl) {
                t = this.cancel;
                if (t == null) {
                    this.cancellable = c;
                    return;
                }
            }
            if (t instanceof CancellationException) {
                throw t;
            }
            CancellationException e = new CancellationException();
            e.initCause(t);
            throw e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(CancellationException t) {
            Cancellable c;
            LoadContextImpl loadContextImpl = this;
            synchronized (loadContextImpl) {
                if (this.cancel != null) {
                    return false;
                }
                this.cancel = t;
                c = this.cancellable;
                if (c == null) {
                    return false;
                }
            }
            return c.cancel();
        }

        public ProjectReload.ProjectState getOriginalState() {
            return Reloader.this.originalState;
        }

        public ProjectReloadImplementation.ProjectStateData getProjectData() {
            return this.loadedData;
        }

        public ProjectReloadImplementation.ProjectStateData getOriginalData() {
            return this.origData;
        }

        public ProjectReload.ProjectState partialStateImpl() {
            if (this.partialState != null) {
                return this.partialState;
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "{0}: Partial state created for {1}", new Object[]{this, this.parts.keySet().stream().map(i -> i.getClass().getName()).collect(Collectors.joining(", "))});
            }
            this.partialState = Reloader.this.registry.doCreateState(Reloader.this.project, this.parts, Reloader.this.request);
            return this.partialState;
        }

        public void retryReloadImpl() {
            this.reloadRequested = true;
            LOG.log(Level.FINE, "{0}: Reload requested by {1}", new Object[]{this, this.impl});
        }

        public void markForReload(Class c) {
            if (this.inconsistencies == null) {
                this.inconsistencies = new HashSet<Class>();
            }
            this.inconsistencies.add(c);
            LOG.log(Level.FINE, "{0}: Inconsistency {1} recorded by {2}", new Object[]{this, c, this.impl});
        }
    }

    static class RPExecutor
    implements Executor {
        private final RequestProcessor rp;

        public RPExecutor(RequestProcessor rp) {
            this.rp = rp;
        }

        @Override
        public void execute(Runnable command) {
            if (this.rp.isRequestProcessorThread()) {
                command.run();
            } else {
                this.rp.post(command);
            }
        }
    }
}

