/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.spi.LayerUtil;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCDATASection;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeText;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class WritableXMLFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Attr,
AbstractFileSystem.Change,
AbstractFileSystem.Info,
AbstractFileSystem.List,
FileChangeListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(WritableXMLFileSystem.class.getName());
    private static RequestProcessor RP = new RequestProcessor(WritableXMLFileSystem.class.getName());
    private final TreeEditorCookie cookie;
    private TreeDocumentRoot doc;
    private URL location;
    private String suffix;
    private final FileChangeListener fileChangeListener;
    @NullAllowed
    private ClassPath classpath;
    private static final int INDENT_STEP = 4;

    public WritableXMLFileSystem(URL location, TreeEditorCookie cookie, ClassPath classpath) {
        this.attr = this;
        this.change = this;
        this.info = this;
        this.list = this;
        this.cookie = cookie;
        this.suffix = "";
        try {
            this.doc = cookie.openDocumentRoot();
        }
        catch (TreeException e) {
            Util.err.notify(1, (Throwable)e);
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
        this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        cookie.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cookie));
        this.setLocation(location);
        this.setClasspath(classpath);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("WritableXMLFileSystem is not persistent");
    }

    private void setLocation(URL location) {
        String u = location.toExternalForm();
        if (u.endsWith("/")) {
            throw new IllegalArgumentException(u);
        }
        this.location = location;
    }

    private void setClasspath(ClassPath classpath) {
        this.classpath = classpath;
    }

    public String getDisplayName() {
        FileObject fo = URLMapper.findFileObject((URL)this.location);
        if (fo != null) {
            return FileUtil.getFileDisplayName((FileObject)fo);
        }
        return this.location.toExternalForm();
    }

    public boolean isReadOnly() {
        return false;
    }

    private TreeElement getRootElement() {
        if (this.doc == null) {
            return null;
        }
        for (Object next : this.doc.getChildNodes()) {
            if (!(next instanceof TreeElement)) continue;
            return (TreeElement)next;
        }
        return null;
    }

    private TreeElement findElement(String name) {
        return WritableXMLFileSystem.findElementIn(this.getRootElement(), name);
    }

    private static TreeElement findElementIn(TreeElement el, String name) {
        String remainder;
        String nextName;
        if (el == null) {
            return null;
        }
        if (name.equals("")) {
            return el;
        }
        int idx = name.indexOf(47);
        if (idx == -1) {
            nextName = name;
            remainder = "";
        } else {
            nextName = name.substring(0, idx);
            remainder = name.substring(idx + 1);
        }
        TreeElement subel = null;
        for (TreeElement e : el.getChildNodes(TreeElement.class)) {
            TreeAttribute nameAttr;
            if (!e.getLocalName().equals("file") && !e.getLocalName().equals("folder") || (nameAttr = e.getAttribute("name")) == null || !nameAttr.getValue().equals(nextName)) continue;
            subel = e;
            break;
        }
        return WritableXMLFileSystem.findElementIn(subel, remainder);
    }

    public boolean folder(String name) {
        TreeElement el = this.findElement(name);
        if (el == null) {
            return false;
        }
        boolean res = el.getLocalName().equals("folder");
        return res;
    }

    public String[] children(String f) {
        TreeElement el = this.findElement(f);
        if (el == null) {
            return new String[0];
        }
        ArrayList<String> kids = new ArrayList<String>();
        HashSet<String> allNames = new HashSet<String>();
        for (TreeElement sub : el.getChildNodes(TreeElement.class)) {
            String name;
            TreeAttribute childName;
            if (!sub.getLocalName().equals("file") && !sub.getLocalName().equals("folder") || (childName = sub.getAttribute("name")) == null || !allNames.add(name = childName.getValue())) continue;
            kids.add(name);
        }
        return kids.toArray(new String[0]);
    }

    private byte[] getContentsOf(String name) throws FileNotFoundException {
        TreeElement el = this.findElement(name);
        if (el == null) {
            throw new FileNotFoundException(name);
        }
        TreeAttribute urlAttr = el.getAttribute("url");
        if (urlAttr != null) {
            try {
                String sURL = urlAttr.getValue();
                URI uri = new URI(null, sURL, null);
                boolean nbmRelative = sURL.startsWith("nbres:") || sURL.startsWith("nbresloc:");
                URL url = nbmRelative ? uri.toURL() : new URL(this.location, uri.getRawPath());
                URL[] u = LayerUtils.currentify(url, this.suffix, this.classpath);
                URLConnection conn = u[0].openConnection();
                conn.connect();
                InputStream is = conn.getInputStream();
                byte[] buf = new byte[conn.getContentLength()];
                if (is.read(buf) != buf.length) {
                    throw new IOException("wrong content length");
                }
                FileObject fo = URLMapper.findFileObject((URL)u[0]);
                if (fo != null) {
                    fo.removeFileChangeListener(this.fileChangeListener);
                    fo.addFileChangeListener(this.fileChangeListener);
                }
                return buf;
            }
            catch (IOException ioe) {
                throw new FileNotFoundException(ioe.getMessage());
            }
            catch (URISyntaxException use) {
                throw new FileNotFoundException(use.getMessage());
            }
        }
        StringBuffer buf = new StringBuffer();
        for (Object o : el.getChildNodes()) {
            if (o instanceof TreeCDATASection) {
                buf.append(((TreeCDATASection)o).getData());
                continue;
            }
            if (!(o instanceof TreeText)) continue;
            buf.append(((TreeText)o).getData().trim());
        }
        return buf.toString().getBytes(StandardCharsets.UTF_8);
    }

    public InputStream inputStream(String name) throws FileNotFoundException {
        return new ByteArrayInputStream(this.getContentsOf(name));
    }

    public OutputStream outputStream(final String name) throws IOException {
        final TreeElement el = this.findElement(name);
        if (el == null) {
            throw new FileNotFoundException(name);
        }
        TreeAttribute urlAttr = el.getAttribute("url");
        if (urlAttr != null) {
            String u = urlAttr.getValue();
            if (URI.create(u).isAbsolute()) {
                throw new IOException(name);
            }
            FileObject external = URLMapper.findFileObject((URL)new URL(this.location, u));
            if (external == null) {
                throw new FileNotFoundException(name);
            }
            return external.getOutputStream();
        }
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                block5: {
                    super.close();
                    final byte[] contents = this.toByteArray();
                    if (contents.length == 0) {
                        return;
                    }
                    final FileObject parent = WritableXMLFileSystem.this.findLayerParent();
                    final String externalName = LayerUtil.findGeneratedName(parent, name);
                    assert (externalName.indexOf(47) == -1) : externalName;
                    parent.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        public void run() throws IOException {
                            FileObject externalFile = parent.createData(externalName);
                            try (OutputStream os = externalFile.getOutputStream();){
                                os.write(contents);
                            }
                            externalFile.addFileChangeListener(WritableXMLFileSystem.this.fileChangeListener);
                        }
                    });
                    try {
                        el.addAttribute("url", externalName);
                    }
                    catch (ReadOnlyException e) {
                        throw (IOException)new IOException(e.toString()).initCause(e);
                    }
                    catch (InvalidArgumentException e) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError((Object)e);
                    }
                }
            }
        };
    }

    private FileObject findLayerParent() throws IOException {
        String loc = this.location.toExternalForm();
        int slash = loc.lastIndexOf(47);
        assert (slash != -1) : loc;
        FileObject parent = URLMapper.findFileObject((URL)new URL(loc.substring(0, slash + 1)));
        if (parent == null) {
            throw new IOException(loc);
        }
        return parent;
    }

    private void createFileOrFolder(String name, boolean folder) throws IOException {
        String baseName;
        String parentName;
        int idx = name.lastIndexOf(47);
        if (idx == -1) {
            parentName = "";
            baseName = name;
        } else {
            parentName = name.substring(0, idx);
            baseName = name.substring(idx + 1);
        }
        TreeElement el = this.findElement(parentName);
        if (el == null) {
            throw new FileNotFoundException(parentName);
        }
        try {
            TreeElement nue = new TreeElement(folder ? "folder" : "file", true);
            nue.addAttribute("name", baseName);
            WritableXMLFileSystem.appendWithIndent(el, (TreeChild)nue);
        }
        catch (InvalidArgumentException e) {
            assert (false) : e;
        }
        catch (ReadOnlyException e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
    }

    public void createFolder(String name) throws IOException {
        this.createFileOrFolder(name, true);
    }

    public void createData(String name) throws IOException {
        this.createFileOrFolder(name, false);
    }

    public void delete(String name) throws IOException {
        TreeElement el = this.findElement(name);
        if (el == null) {
            throw new FileNotFoundException(name);
        }
        try {
            WritableXMLFileSystem.deleteWithIndent((TreeChild)el);
        }
        catch (ReadOnlyException e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
    }

    public void rename(String oldName, String newName) throws IOException {
        block7: {
            TreeElement el = this.findElement(oldName);
            if (el == null) {
                throw new FileNotFoundException(oldName);
            }
            int idx = newName.lastIndexOf(47) + 1;
            if (idx != oldName.lastIndexOf(47) + 1 || !oldName.substring(0, idx).equals(newName.substring(0, idx))) {
                throw new IOException("Cannot rename to a different dir: " + oldName + " -> " + newName);
            }
            String newBaseName = newName.substring(idx);
            assert (newBaseName.indexOf(47) == -1);
            assert (newBaseName.length() > 0);
            try {
                el.getAttribute("name").setValue(newBaseName);
            }
            catch (ReadOnlyException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            catch (InvalidArgumentException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)e);
            }
        }
    }

    public Enumeration<String> attributes(String name) {
        TreeElement el = this.findElement(name);
        if (el == null) {
            return Enumerations.empty();
        }
        ArrayList<String> l = new ArrayList<String>(10);
        for (TreeElement sub : el.getChildNodes(TreeElement.class)) {
            TreeAttribute nameAttr;
            if (!sub.getLocalName().equals("attr") || (nameAttr = sub.getAttribute("name")) == null) continue;
            l.add(nameAttr.getValue());
        }
        return Collections.enumeration(l);
    }

    public Object readAttribute(String name, String attrName) {
        if (attrName.equals("WritableXMLFileSystem.cp")) {
            return this.classpath;
        }
        if (attrName.equals("layers")) {
            return new URL[]{this.location};
        }
        if (attrName.equals("DataFolder.Index.reorderable")) {
            return Boolean.TRUE;
        }
        TreeElement el = this.findElement(name);
        if (el == null) {
            return null;
        }
        if (attrName.equals("WritableXMLFileSystem.url")) {
            TreeAttribute urlAttr = el.getAttribute("url");
            return urlAttr != null ? urlAttr.getValue() : null;
        }
        boolean literal = false;
        if (attrName.startsWith("literal:")) {
            attrName = attrName.substring("literal:".length());
            literal = true;
        }
        boolean raw = false;
        if (attrName.startsWith("raw:")) {
            attrName = attrName.substring("raw:".length());
            raw = true;
        }
        for (TreeElement sub : el.getChildNodes(TreeElement.class)) {
            TreeAttribute nameAttr;
            if (!sub.getLocalName().equals("attr") || (nameAttr = sub.getAttribute("name")) == null || !attrName.equals(nameAttr.getValue())) continue;
            try {
                String clazz;
                nameAttr = sub.getAttribute("stringvalue");
                if (nameAttr != null) {
                    String inStr = nameAttr.getValue();
                    StringBuilder outStr = new StringBuilder(inStr.length());
                    for (int j = 0; j < inStr.length(); ++j) {
                        char ch = inStr.charAt(j);
                        if (ch == '\\' && inStr.charAt(j + 1) == 'u' && j + 5 < inStr.length()) {
                            String hex = inStr.substring(j + 2, j + 6);
                            try {
                                outStr.append((char)Integer.parseInt(hex, 16));
                                j += 5;
                            }
                            catch (NumberFormatException e) {
                                outStr.append(ch);
                            }
                            continue;
                        }
                        outStr.append(ch);
                    }
                    return outStr.toString();
                }
                nameAttr = sub.getAttribute("boolvalue");
                if (nameAttr != null) {
                    return Boolean.valueOf(nameAttr.getValue());
                }
                nameAttr = sub.getAttribute("urlvalue");
                if (nameAttr != null) {
                    return new URL(nameAttr.getValue());
                }
                nameAttr = sub.getAttribute("charvalue");
                if (nameAttr != null) {
                    return Character.valueOf(nameAttr.getValue().charAt(0));
                }
                nameAttr = sub.getAttribute("bytevalue");
                if (nameAttr != null) {
                    return Byte.valueOf(nameAttr.getValue());
                }
                nameAttr = sub.getAttribute("shortvalue");
                if (nameAttr != null) {
                    return Short.valueOf(nameAttr.getValue());
                }
                nameAttr = sub.getAttribute("intvalue");
                if (nameAttr != null) {
                    return Integer.valueOf(nameAttr.getValue());
                }
                nameAttr = sub.getAttribute("longvalue");
                if (nameAttr != null) {
                    return Long.valueOf(nameAttr.getValue());
                }
                nameAttr = sub.getAttribute("floatvalue");
                if (nameAttr != null) {
                    return Float.valueOf(nameAttr.getValue());
                }
                nameAttr = sub.getAttribute("doublevalue");
                if (nameAttr != null) {
                    return Double.valueOf(nameAttr.getValue());
                }
                nameAttr = sub.getAttribute("newvalue");
                if (nameAttr != null) {
                    clazz = nameAttr.getValue();
                    if (literal) {
                        return "new:" + clazz;
                    }
                    if (raw && this.classpath != null) {
                        return Class.forName(clazz, false, this.classpath.getClassLoader(true));
                    }
                    throw new UnsupportedOperationException("instantiation not currently supported");
                }
                nameAttr = sub.getAttribute("methodvalue");
                if (nameAttr != null) {
                    String clazzMeth = nameAttr.getValue();
                    if (literal) {
                        return "method:" + clazzMeth;
                    }
                    if (raw && this.classpath != null) {
                        int dot = clazzMeth.lastIndexOf(46);
                        String clazz2 = clazzMeth.substring(0, dot);
                        String meth = clazzMeth.substring(dot + 1);
                        Class<?> c = Class.forName(clazz2, false, this.classpath.getClassLoader(true));
                        for (Method m : c.getDeclaredMethods()) {
                            if (!m.getName().equals(meth)) continue;
                            return m;
                        }
                        throw new NoSuchMethodException("no method named " + meth + " in " + clazz2);
                    }
                    throw new UnsupportedOperationException("instantiation not currently supported");
                }
                nameAttr = sub.getAttribute("bundlevalue");
                if (nameAttr != null) {
                    String bundle = nameAttr.getValue();
                    if (!literal) continue;
                    return "bundle:" + bundle;
                }
                nameAttr = sub.getAttribute("serialvalue");
                if (nameAttr != null) {
                    clazz = nameAttr.getValue();
                    if (literal) {
                        return "serial:" + clazz;
                    }
                    throw new UnsupportedOperationException("instantiation not currently supported");
                }
                LOG.log(Level.FINE, "no recognized value for {0} on {1}", new Object[]{attrName, name});
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "could not read " + attrName + " on " + name, e);
                return null;
            }
        }
        return null;
    }

    public void writeAttribute(String name, String attrName, Object v) throws IOException {
        if (attrName.indexOf(92) != -1) {
            throw new IOException("illegal attribute name for leaf layer: " + attrName);
        }
        TreeElement el = this.findElement(name);
        if (el == null) {
            throw new FileNotFoundException(name);
        }
        TreeElement existingAttr = null;
        for (TreeElement sub : el.getChildNodes(TreeElement.class)) {
            TreeAttribute attr;
            if (!sub.getLocalName().equals("attr") || (attr = sub.getAttribute("name")) == null || !attr.getValue().equals(attrName)) continue;
            existingAttr = sub;
            break;
        }
        if (v == null) {
            if (existingAttr != null) {
                try {
                    WritableXMLFileSystem.deleteWithIndent(existingAttr);
                }
                catch (ReadOnlyException x) {
                    throw new IOException(x);
                }
            }
            return;
        }
        try {
            String val;
            String type;
            TreeElement attrEl = new TreeElement("attr", true);
            String newValueMagic = "newvalue:";
            String methodValueMagic = "methodvalue:";
            if (v instanceof String) {
                String inStr = (String)v;
                String bundleValueMagic = "bundlevalue:";
                if (inStr.startsWith("newvalue:")) {
                    type = "newvalue";
                    val = inStr.substring("newvalue:".length());
                } else if (inStr.startsWith("methodvalue:")) {
                    type = "methodvalue";
                    val = inStr.substring("methodvalue:".length());
                } else if (inStr.startsWith("bundlevalue:")) {
                    type = "bundlevalue";
                    val = inStr.substring("bundlevalue:".length());
                    TreeObjectList nodes = this.doc.getChildNodes();
                    for (int i = 0; i < nodes.size(); ++i) {
                        Object object = nodes.get(i);
                        if (!(object instanceof TreeDocumentType)) continue;
                        TreeDocumentType tdt = (TreeDocumentType)object;
                        tdt.setPublicId("-//NetBeans//DTD Filesystem 1.2//EN");
                        tdt.setSystemId("http://www.netbeans.org/dtds/filesystem-1_2.dtd");
                        break;
                    }
                } else {
                    StringBuilder outStr = new StringBuilder();
                    for (int i = 0; i < inStr.length(); ++i) {
                        char c = inStr.charAt(i);
                        if (Character.isISOControl(c) || c == '&' || c == '<' || c == '>' || c == '\"' || c == '\'') {
                            outStr.append(WritableXMLFileSystem.encodeChar(c));
                            continue;
                        }
                        outStr.append(c);
                    }
                    type = "stringvalue";
                    val = outStr.toString();
                }
            } else if (v instanceof URL) {
                type = "urlvalue";
                val = ((URL)v).toExternalForm();
            } else if (v instanceof Boolean) {
                type = "boolvalue";
                val = v.toString();
            } else if (v instanceof Character) {
                type = "charvalue";
                val = v.toString();
            } else if (v instanceof Integer) {
                type = "intvalue";
                val = v.toString();
            } else if (v instanceof Class && attrName.startsWith("newvalue:")) {
                attrName = attrName.substring("newvalue:".length());
                type = "newvalue";
                val = ((Class)v).getName();
            } else if (v instanceof Method && attrName.startsWith("methodvalue:")) {
                attrName = attrName.substring("methodvalue:".length());
                Method m = (Method)v;
                type = "methodvalue";
                val = m.getDeclaringClass().getName() + '.' + m.getName();
            } else {
                throw new IOException("cannot write arbitrary object " + v + " to " + attrName + " attr of " + name);
            }
            attrEl.addAttribute("name", attrName);
            attrEl.addAttribute(type, val);
            if (existingAttr == null) {
                WritableXMLFileSystem.appendWithIndent(el, (TreeChild)attrEl);
            } else {
                el.replaceChild((TreeChild)existingAttr, (TreeChild)attrEl);
            }
        }
        catch (InvalidArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (ReadOnlyException e) {
            throw new IOException(e);
        }
    }

    private static String encodeChar(char ch) {
        String encChar = Integer.toString(ch, 16);
        return "\\u" + "0000".substring(0, "0000".length() - encChar.length()).concat(encChar);
    }

    public void renameAttributes(String oldName, String newName) {
    }

    public void deleteAttributes(String name) {
    }

    public boolean readOnly(String name) {
        return false;
    }

    public String mimeType(String name) {
        return null;
    }

    public long size(String name) {
        try {
            return this.getContentsOf(name).length;
        }
        catch (FileNotFoundException fnfe) {
            return 0L;
        }
    }

    public void markUnimportant(String name) {
    }

    public Date lastModified(String name) {
        FileObject external;
        TreeElement el = this.findElement(name);
        if (el == null) {
            return new Date(0L);
        }
        TreeAttribute attr = el.getAttribute("url");
        if (attr == null) {
            return new Date(0L);
        }
        String u = attr.getValue();
        URI uri = null;
        try {
            uri = new URI(null, u, null);
            if (uri.isAbsolute()) {
                return new Date(0L);
            }
        }
        catch (URISyntaxException e) {
            assert (false) : e;
            return new Date(0L);
        }
        try {
            external = URLMapper.findFileObject((URL)new URL(this.location, uri == null ? u : uri.getRawPath()));
        }
        catch (MalformedURLException e) {
            assert (false) : e;
            return new Date(0L);
        }
        if (external == null) {
            return new Date(0L);
        }
        return external.lastModified();
    }

    public void lock(String name) throws IOException {
    }

    public void unlock(String name) {
    }

    private static void appendWithIndent(TreeElement parent, TreeChild child) throws ReadOnlyException {
        block7: {
            TreeElement doc = parent;
            int depth = -2;
            while (doc != null) {
                doc = doc.getParentNode();
                ++depth;
            }
            TreeChild position = WritableXMLFileSystem.insertBefore(parent, child);
            try {
                if (position != null) {
                    parent.insertBefore(child, position);
                    parent.insertBefore((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces((depth + 1) * 4)), position);
                } else {
                    if (parent.hasChildNodes()) {
                        parent.appendChild((TreeChild)new TreeText(WritableXMLFileSystem.spaces(4)));
                    } else {
                        parent.appendChild((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces((depth + 1) * 4)));
                    }
                    parent.appendChild(child);
                    parent.appendChild((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces(depth * 4)));
                }
                parent.normalize();
            }
            catch (InvalidArgumentException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)e);
            }
        }
    }

    private static TreeChild insertBefore(TreeElement parent, TreeChild child) throws ReadOnlyException {
        if (!(child instanceof TreeElement)) {
            return null;
        }
        TreeElement childe = (TreeElement)child;
        if (childe.getQName().equals("file") || childe.getQName().equals("folder")) {
            String name = childe.getAttribute("name").getValue();
            for (TreeElement kid : parent.getChildNodes(TreeElement.class)) {
                String kidname;
                TreeAttribute attr;
                if (!kid.getQName().equals("file") && !kid.getQName().equals("folder") || (attr = kid.getAttribute("name")) == null || (kidname = attr.getValue()).compareTo(name) <= 0) continue;
                return kid;
            }
            return null;
        }
        if (childe.getQName().equals("attr")) {
            String name = childe.getAttribute("name").getValue();
            for (TreeElement kid : parent.getChildNodes(TreeElement.class)) {
                if (kid.getQName().equals("file") || kid.getQName().equals("folder")) {
                    return kid;
                }
                if (kid.getQName().equals("attr")) {
                    String kidname;
                    TreeAttribute attr = kid.getAttribute("name");
                    if (attr == null || (kidname = attr.getValue()).compareTo(name) <= 0) continue;
                    return kid;
                }
                throw new AssertionError((Object)("Weird child: " + kid.getQName()));
            }
            return null;
        }
        throw new AssertionError((Object)("Weird child: " + childe.getQName()));
    }

    private static String spaces(int size) {
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            chars[i] = 32;
        }
        return new String(chars);
    }

    private static void deleteWithIndent(TreeChild child) throws ReadOnlyException {
        TreeElement parent;
        block12: {
            TreeChild next = child.getNextSibling();
            TreeChild previous = child.getPreviousSibling();
            if (previous instanceof TreeText && ((TreeText)previous).getData().matches("(\r|\n|\r\n)[ \t]+")) {
                previous.removeFromContext();
            } else if (next instanceof TreeText && ((TreeText)next).getData().matches("(\r|\n|\r\n)[ \t]+")) {
                next.removeFromContext();
            }
            parent = (TreeElement)child.getParentNode();
            TreeObjectList list = parent.getChildNodes();
            boolean kill = true;
            for (Object o : list) {
                if (o == child) continue;
                if (!(o instanceof TreeText)) {
                    kill = false;
                    break;
                }
                if (((TreeText)o).getData().trim().length() <= 0) continue;
                kill = false;
                break;
            }
            if (kill) {
                try {
                    if (parent.getParentNode() instanceof TreeDocumentRoot) {
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            ((TreeChild)it.next()).removeFromContext();
                        }
                        parent.appendChild((TreeChild)new TreeText("\n"));
                    } else {
                        TreeElement parent2 = new TreeElement(parent.getQName(), true);
                        TreeAttribute attr = parent.getAttribute("name");
                        if (attr != null) {
                            parent2.addAttribute("name", attr.getValue());
                        }
                        TreeParentNode grandparent = parent.getParentNode();
                        grandparent.replaceChild((TreeChild)parent, (TreeChild)parent2);
                        parent = parent2;
                    }
                }
                catch (InvalidArgumentException e) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError((Object)e);
                }
            }
        }
        child.removeFromContext();
        parent.normalize();
    }

    public void fileDeleted(FileEvent fe) {
        this.someFileChange();
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.someFileChange();
    }

    public void fileChanged(FileEvent fe) {
        this.someFileChange();
    }

    private void someFileChange() {
        this.refreshResource("", true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("documentRoot")) {
            return;
        }
        if (this.cookie.getStatus() == 1 || this.cookie.getStatus() == 0) {
            try {
                this.doc = this.cookie.openDocumentRoot();
                Enumeration e = this.existingFileObjects(this.getRoot());
                while (e.hasMoreElements()) {
                    FileObject fo = (FileObject)e.nextElement();
                    this.refreshResource(fo.getPath(), true);
                }
            }
            catch (TreeException e) {
                Util.err.notify(1, (Throwable)e);
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
    }
}

