/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.ReinstateDataGuardAssociationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ReinstateDataGuardAssociationRequest
extends BmcRequest<ReinstateDataGuardAssociationDetails> {
    private String databaseId;
    private String dataGuardAssociationId;
    private ReinstateDataGuardAssociationDetails reinstateDataGuardAssociationDetails;
    private String ifMatch;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDataGuardAssociationId() {
        return this.dataGuardAssociationId;
    }

    public ReinstateDataGuardAssociationDetails getReinstateDataGuardAssociationDetails() {
        return this.reinstateDataGuardAssociationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ReinstateDataGuardAssociationDetails getBody$() {
        return this.reinstateDataGuardAssociationDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).dataGuardAssociationId(this.dataGuardAssociationId).reinstateDataGuardAssociationDetails(this.reinstateDataGuardAssociationDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",dataGuardAssociationId=").append(String.valueOf(this.dataGuardAssociationId));
        sb.append(",reinstateDataGuardAssociationDetails=").append(String.valueOf((Object)this.reinstateDataGuardAssociationDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReinstateDataGuardAssociationRequest)) {
            return false;
        }
        ReinstateDataGuardAssociationRequest other = (ReinstateDataGuardAssociationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.dataGuardAssociationId, other.dataGuardAssociationId) && Objects.equals((Object)this.reinstateDataGuardAssociationDetails, (Object)other.reinstateDataGuardAssociationDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.dataGuardAssociationId == null ? 43 : this.dataGuardAssociationId.hashCode());
        result = result * 59 + (this.reinstateDataGuardAssociationDetails == null ? 43 : this.reinstateDataGuardAssociationDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ReinstateDataGuardAssociationRequest, ReinstateDataGuardAssociationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private String dataGuardAssociationId = null;
        private ReinstateDataGuardAssociationDetails reinstateDataGuardAssociationDetails = null;
        private String ifMatch = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder dataGuardAssociationId(String dataGuardAssociationId) {
            this.dataGuardAssociationId = dataGuardAssociationId;
            return this;
        }

        public Builder reinstateDataGuardAssociationDetails(ReinstateDataGuardAssociationDetails reinstateDataGuardAssociationDetails) {
            this.reinstateDataGuardAssociationDetails = reinstateDataGuardAssociationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ReinstateDataGuardAssociationRequest o) {
            this.databaseId(o.getDatabaseId());
            this.dataGuardAssociationId(o.getDataGuardAssociationId());
            this.reinstateDataGuardAssociationDetails(o.getReinstateDataGuardAssociationDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ReinstateDataGuardAssociationRequest build() {
            ReinstateDataGuardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ReinstateDataGuardAssociationDetails body) {
            this.reinstateDataGuardAssociationDetails(body);
            return this;
        }

        public ReinstateDataGuardAssociationRequest buildWithoutInvocationCallback() {
            ReinstateDataGuardAssociationRequest request = new ReinstateDataGuardAssociationRequest();
            request.databaseId = this.databaseId;
            request.dataGuardAssociationId = this.dataGuardAssociationId;
            request.reinstateDataGuardAssociationDetails = this.reinstateDataGuardAssociationDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

