/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server;

import java.io.IOException;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.java.lsp.server.ConnectionSpec;
import org.netbeans.modules.java.lsp.server.LspSession;
import org.netbeans.modules.java.lsp.server.debugging.Debugger;
import org.netbeans.modules.java.lsp.server.protocol.Server;
import org.netbeans.spi.sendopts.Arg;
import org.netbeans.spi.sendopts.ArgsProcessor;
import org.netbeans.spi.sendopts.Description;
import org.netbeans.spi.sendopts.Env;

public final class LspArgsProcessor
implements ArgsProcessor {
    @Arg(longName="start-java-language-server", defaultValue="")
    @Description(shortDescription="#DESC_StartJavaLanguageServer")
    public String lsPort;
    @Arg(longName="start-java-debug-adapter-server")
    @Description(shortDescription="#DESC_StartJavaDebugAdapterServer")
    public String debugPort;

    public void process(Env env) throws CommandException {
        ConnectionSpec connectTo;
        LspSession session = new LspSession();
        if (this.lsPort != null) {
            try {
                connectTo = ConnectionSpec.parse(this.lsPort);
                connectTo.prepare("Java Language Server", env.getInputStream(), env.getOutputStream(), session, LspSession::setLspServer, Server::launchServer);
            }
            catch (IOException ex) {
                throw (CommandException)new CommandException(554).initCause((Throwable)ex);
            }
        }
        if (this.debugPort != null) {
            try {
                connectTo = ConnectionSpec.parse(this.debugPort);
                connectTo.prepare("Java Debug Server Adapter", env.getInputStream(), env.getOutputStream(), session, LspSession::setDapServer, Debugger::startDebugger);
            }
            catch (IOException ex) {
                throw (CommandException)new CommandException(554).initCause((Throwable)ex);
            }
        }
    }
}

