/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.objectstorage.model.ObjectSummary;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ListObjects
extends ExplicitlySetBmcModel {
    @JsonProperty(value="objects")
    private final List<ObjectSummary> objects;
    @JsonProperty(value="prefixes")
    private final List<String> prefixes;
    @JsonProperty(value="nextStartWith")
    private final String nextStartWith;

    @Deprecated
    @ConstructorProperties(value={"objects", "prefixes", "nextStartWith"})
    public ListObjects(List<ObjectSummary> objects, List<String> prefixes, String nextStartWith) {
        this.objects = objects;
        this.prefixes = prefixes;
        this.nextStartWith = nextStartWith;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<ObjectSummary> getObjects() {
        return this.objects;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public String getNextStartWith() {
        return this.nextStartWith;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ListObjects(");
        sb.append("super=").append(super.toString());
        sb.append("objects=").append(String.valueOf(this.objects));
        sb.append(", prefixes=").append(String.valueOf(this.prefixes));
        sb.append(", nextStartWith=").append(String.valueOf(this.nextStartWith));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListObjects)) {
            return false;
        }
        ListObjects other = (ListObjects)((Object)o);
        return Objects.equals(this.objects, other.objects) && Objects.equals(this.prefixes, other.prefixes) && Objects.equals(this.nextStartWith, other.nextStartWith) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.objects == null ? 43 : this.objects.hashCode());
        result = result * 59 + (this.prefixes == null ? 43 : this.prefixes.hashCode());
        result = result * 59 + (this.nextStartWith == null ? 43 : this.nextStartWith.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="objects")
        private List<ObjectSummary> objects;
        @JsonProperty(value="prefixes")
        private List<String> prefixes;
        @JsonProperty(value="nextStartWith")
        private String nextStartWith;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder objects(List<ObjectSummary> objects) {
            this.objects = objects;
            this.__explicitlySet__.add("objects");
            return this;
        }

        public Builder prefixes(List<String> prefixes) {
            this.prefixes = prefixes;
            this.__explicitlySet__.add("prefixes");
            return this;
        }

        public Builder nextStartWith(String nextStartWith) {
            this.nextStartWith = nextStartWith;
            this.__explicitlySet__.add("nextStartWith");
            return this;
        }

        public ListObjects build() {
            ListObjects model = new ListObjects(this.objects, this.prefixes, this.nextStartWith);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ListObjects model) {
            if (model.wasPropertyExplicitlySet("objects")) {
                this.objects(model.getObjects());
            }
            if (model.wasPropertyExplicitlySet("prefixes")) {
                this.prefixes(model.getPrefixes());
            }
            if (model.wasPropertyExplicitlySet("nextStartWith")) {
                this.nextStartWith(model.getNextStartWith());
            }
            return this;
        }
    }
}

