/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.DeferredCompletionFailureHandler;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeMetadata;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.jvm.PoolReader;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.nio.file.ClosedFileSystemException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class ClassReader {
    protected static final Context.Key<ClassReader> classReaderKey = new Context.Key();
    public static final int INITIAL_BUFFER_SIZE = 65520;
    private final Annotate annotate;
    boolean verbose;
    boolean allowModules;
    boolean allowSealedTypes;
    boolean allowRecords;
    boolean lintClassfile;
    boolean warnOnIllegalUtf8;
    public boolean saveParameterNames;
    public final Profile profile;
    final Log log;
    Symtab syms;
    Types types;
    final Names names;
    private final JavaFileManager fileManager;
    JCDiagnostic.Factory diagFactory;
    DeferredCompletionFailureHandler dcfh;
    Preview preview;
    protected Scope.WriteableScope typevars;
    private List<InterimUsesDirective> interimUses = List.nil();
    private List<InterimProvidesDirective> interimProvides = List.nil();
    protected JavaFileObject currentClassFile = null;
    protected Symbol currentOwner = null;
    protected Symbol.ModuleSymbol currentModule = null;
    ByteBuffer buf = new ByteBuffer(65520);
    protected int bp;
    PoolReader poolReader;
    int majorVersion;
    int minorVersion;
    Convert.Validation utf8validation;
    int[] parameterNameIndicesLvt;
    int[] parameterNameIndicesMp;
    int[] parameterAccessFlags;
    ParameterAnnotations[] parameterAnnotations;
    Set<Name> warnedAttrs = new HashSet<Name>();
    CompoundAnnotationProxy target;
    CompoundAnnotationProxy repeatable;
    byte[] signature;
    int sigp;
    int siglimit;
    boolean sigEnterPhase = false;
    byte[] signatureBuffer = new byte[0];
    int sbp = 0;
    protected Set<AttributeKind> CLASS_ATTRIBUTE = EnumSet.of(AttributeKind.CLASS);
    protected Set<AttributeKind> MEMBER_ATTRIBUTE = EnumSet.of(AttributeKind.MEMBER);
    protected Set<AttributeKind> CLASS_OR_MEMBER_ATTRIBUTE = EnumSet.of(AttributeKind.CLASS, AttributeKind.MEMBER);
    protected Map<Name, AttributeReader> attributeReaders = new HashMap<Name, AttributeReader>();
    private boolean readingClassAttr = false;
    private List<Type> missingTypeVariables = List.nil();
    private List<Type> foundTypeVariables = List.nil();
    public boolean filling = false;

    public static ClassReader instance(Context context) {
        ClassReader instance = context.get(classReaderKey);
        if (instance == null) {
            instance = new ClassReader(context);
        }
        return instance;
    }

    protected ClassReader(Context context) {
        context.put(classReaderKey, this);
        this.annotate = Annotate.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        if (this.fileManager == null) {
            throw new AssertionError((Object)"FileManager initialization error");
        }
        this.diagFactory = JCDiagnostic.Factory.instance(context);
        this.dcfh = DeferredCompletionFailureHandler.instance(context);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        Source source = Source.instance(context);
        this.preview = Preview.instance(context);
        this.allowModules = Source.Feature.MODULES.allowedInSource(source);
        this.allowRecords = Source.Feature.RECORDS.allowedInSource(source);
        this.allowSealedTypes = Source.Feature.SEALED_CLASSES.allowedInSource(source);
        this.warnOnIllegalUtf8 = Source.Feature.WARN_ON_ILLEGAL_UTF8.allowedInSource(source);
        this.saveParameterNames = options.isSet(Option.PARAMETERS);
        this.profile = Profile.instance(context);
        this.typevars = Scope.WriteableScope.create(this.syms.noSymbol);
        this.lintClassfile = Lint.instance(context).isEnabled(Lint.LintCategory.CLASSFILE);
        this.initAttributeReaders();
    }

    private void enterMember(Symbol.ClassSymbol c, Symbol sym) {
        if ((sym.flags_field & 0x80001000L) != 4096L || sym.name.startsWith(this.names.lambda)) {
            c.members_field.enter(sym);
        }
    }

    public ClassFinder.BadClassFile badClassFile(String key, Object ... args) {
        return this.badClassFile(this.diagFactory.fragment(key, args));
    }

    public ClassFinder.BadClassFile badClassFile(JCDiagnostic.Fragment fragment) {
        return this.badClassFile(this.diagFactory.fragment(fragment));
    }

    public ClassFinder.BadClassFile badClassFile(JCDiagnostic diagnostic) {
        return new ClassFinder.BadClassFile(this.currentOwner.enclClass(), this.currentClassFile, diagnostic, this.diagFactory, this.dcfh);
    }

    public ClassFinder.BadEnclosingMethodAttr badEnclosingMethod(Symbol sym) {
        return new ClassFinder.BadEnclosingMethodAttr(this.currentOwner.enclClass(), this.currentClassFile, this.diagFactory.fragment(CompilerProperties.Fragments.BadEnclosingMethod(sym)), this.diagFactory, this.dcfh);
    }

    char nextChar() {
        char res;
        try {
            res = this.buf.getChar(this.bp);
        }
        catch (ByteBuffer.UnderflowException e) {
            throw this.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(e.getLength()));
        }
        this.bp += 2;
        return res;
    }

    int nextByte() {
        try {
            return this.buf.getByte(this.bp++) & 0xFF;
        }
        catch (ByteBuffer.UnderflowException e) {
            throw this.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(e.getLength()));
        }
    }

    int nextInt() {
        int res;
        try {
            res = this.buf.getInt(this.bp);
        }
        catch (ByteBuffer.UnderflowException e) {
            throw this.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(e.getLength()));
        }
        this.bp += 4;
        return res;
    }

    Set<Symbol.ModuleFlags> readModuleFlags(int flags) {
        EnumSet<Symbol.ModuleFlags> set = EnumSet.noneOf(Symbol.ModuleFlags.class);
        for (Symbol.ModuleFlags f : Symbol.ModuleFlags.values()) {
            if ((flags & f.value) == 0) continue;
            set.add(f);
        }
        return set;
    }

    Set<Symbol.ModuleResolutionFlags> readModuleResolutionFlags(int flags) {
        EnumSet<Symbol.ModuleResolutionFlags> set = EnumSet.noneOf(Symbol.ModuleResolutionFlags.class);
        for (Symbol.ModuleResolutionFlags f : Symbol.ModuleResolutionFlags.values()) {
            if ((flags & f.value) == 0) continue;
            set.add(f);
        }
        return set;
    }

    Set<Directive.ExportsFlag> readExportsFlags(int flags) {
        EnumSet<Directive.ExportsFlag> set = EnumSet.noneOf(Directive.ExportsFlag.class);
        for (Directive.ExportsFlag f : Directive.ExportsFlag.values()) {
            if ((flags & f.value) == 0) continue;
            set.add(f);
        }
        return set;
    }

    Set<Directive.OpensFlag> readOpensFlags(int flags) {
        EnumSet<Directive.OpensFlag> set = EnumSet.noneOf(Directive.OpensFlag.class);
        for (Directive.OpensFlag f : Directive.OpensFlag.values()) {
            if ((flags & f.value) == 0) continue;
            set.add(f);
        }
        return set;
    }

    Set<Directive.RequiresFlag> readRequiresFlags(int flags) {
        EnumSet<Directive.RequiresFlag> set = EnumSet.noneOf(Directive.RequiresFlag.class);
        for (Directive.RequiresFlag f : Directive.RequiresFlag.values()) {
            if ((flags & f.value) == 0) continue;
            set.add(f);
        }
        return set;
    }

    Type sigToType(byte[] sig, int offset, int len) {
        this.signature = sig;
        this.sigp = offset;
        this.siglimit = offset + len;
        return this.sigToType();
    }

    Type sigToType() {
        switch ((char)this.signature[this.sigp]) {
            case 'T': {
                ++this.sigp;
                int start = this.sigp;
                while (this.signature[this.sigp] != 59) {
                    ++this.sigp;
                }
                ++this.sigp;
                return this.sigEnterPhase ? Type.noType : this.findTypeVar(this.readName(this.signature, start, this.sigp - 1 - start));
            }
            case '+': {
                ++this.sigp;
                Type t = this.sigToType();
                return new Type.WildcardType(t, BoundKind.EXTENDS, this.syms.boundClass);
            }
            case '*': {
                ++this.sigp;
                return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
            }
            case '-': {
                ++this.sigp;
                Type t = this.sigToType();
                return new Type.WildcardType(t, BoundKind.SUPER, this.syms.boundClass);
            }
            case 'B': {
                ++this.sigp;
                return this.syms.byteType;
            }
            case 'C': {
                ++this.sigp;
                return this.syms.charType;
            }
            case 'D': {
                ++this.sigp;
                return this.syms.doubleType;
            }
            case 'F': {
                ++this.sigp;
                return this.syms.floatType;
            }
            case 'I': {
                ++this.sigp;
                return this.syms.intType;
            }
            case 'J': {
                ++this.sigp;
                return this.syms.longType;
            }
            case 'L': {
                Type t = this.classSigToType();
                if (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                    throw this.badClassFile("deprecated inner class signature syntax (please recompile from source)", new Object[0]);
                }
                return t;
            }
            case 'S': {
                ++this.sigp;
                return this.syms.shortType;
            }
            case 'V': {
                ++this.sigp;
                return this.syms.voidType;
            }
            case 'Z': {
                ++this.sigp;
                return this.syms.booleanType;
            }
            case '[': {
                ++this.sigp;
                return new Type.ArrayType(this.sigToType(), this.syms.arrayClass);
            }
            case '(': {
                ++this.sigp;
                List<Type> argtypes = this.sigToTypes(')');
                Type restype = this.sigToType();
                List<Type> thrown = List.nil();
                while (this.sigp < this.siglimit && this.signature[this.sigp] == 94) {
                    ++this.sigp;
                    thrown = thrown.prepend(this.sigToType());
                }
                List<Type> l = thrown;
                while (l.nonEmpty()) {
                    if (((Type)l.head).hasTag(TypeTag.TYPEVAR)) {
                        ((Type)l.head).tsym.flags_field |= 0x800000000000L;
                    }
                    l = l.tail;
                }
                return new Type.MethodType(argtypes, restype, thrown.reverse(), this.syms.methodClass);
            }
            case '<': {
                this.typevars = this.typevars.dup(this.currentOwner);
                Type.ForAll poly = new Type.ForAll(this.sigToTypeParams(), this.sigToType());
                this.typevars = this.typevars.leave();
                return poly;
            }
        }
        throw this.badClassFile("bad.signature", this.quoteBadSignature());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type classSigToType() {
        if (this.signature[this.sigp] != 76) {
            throw this.badClassFile("bad.class.signature", this.quoteBadSignature());
        }
        ++this.sigp;
        Type outer = Type.noType;
        int startSbp = this.sbp;
        block13: while (true) {
            byte c = this.signature[this.sigp++];
            switch (c) {
                case 59: {
                    final Symbol.ClassSymbol t = this.enterClass(this.readName(this.signatureBuffer, startSbp, this.sbp - startSbp));
                    try {
                        Type type = outer == Type.noType ? t.erasure(this.types) : new Type.ClassType(outer, List.nil(), t);
                        return type;
                    }
                    finally {
                        this.sbp = startSbp;
                    }
                }
                case 60: {
                    final Symbol.ClassSymbol t = this.enterClass(this.readName(this.signatureBuffer, startSbp, this.sbp - startSbp));
                    List<Type> actuals = this.sigToTypes('>');
                    List<Type> formals = ((Type.ClassType)t.type.tsym.type).typarams_field;
                    if (formals != null && actuals.isEmpty()) {
                        actuals = formals;
                    }
                    final List<Type> actualsCp = actuals;
                    outer = new Type.ClassType(outer, actuals, t){
                        boolean completed;
                        boolean typeArgsSet;
                        {
                            super(outer, typarams, tsym);
                            this.completed = false;
                            this.typeArgsSet = false;
                        }

                        @Override
                        public Type getEnclosingType() {
                            if (!this.completed) {
                                this.completed = true;
                                this.tsym.apiComplete();
                                Type enclosingType = this.tsym.type.getEnclosingType();
                                if (enclosingType != Type.noType) {
                                    List<Type> typeArgs = super.getEnclosingType().allparams();
                                    List<Type> typeParams = enclosingType.allparams();
                                    if (typeParams.length() != typeArgs.length()) {
                                        super.setEnclosingType(ClassReader.this.types.erasure(enclosingType));
                                    } else {
                                        super.setEnclosingType(ClassReader.this.types.subst(enclosingType, typeParams, typeArgs));
                                    }
                                } else {
                                    super.setEnclosingType(Type.noType);
                                }
                            }
                            return super.getEnclosingType();
                        }

                        @Override
                        public void setEnclosingType(Type outer) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public List<Type> getTypeArguments() {
                            if (!this.typeArgsSet) {
                                this.typeArgsSet = true;
                                List<Type> formalsCp = ((Type.ClassType)t.type.tsym.type).typarams_field;
                                if (formalsCp != null && !formalsCp.isEmpty() && actualsCp.length() == formalsCp.length()) {
                                    List a = actualsCp;
                                    List<Type> f = formalsCp;
                                    while (a.nonEmpty()) {
                                        a.head = ((Type)a.head).withTypeVar((Type)f.head);
                                        a = a.tail;
                                        f = f.tail;
                                    }
                                }
                            }
                            return super.getTypeArguments();
                        }
                    };
                    switch (this.signature[this.sigp++]) {
                        case 59: {
                            if (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                                this.sigp += this.sbp - startSbp + 3;
                                this.signatureBuffer[this.sbp++] = 36;
                                continue block13;
                            }
                            this.sbp = startSbp;
                            return outer;
                        }
                        case 46: {
                            this.signatureBuffer[this.sbp++] = 36;
                            continue block13;
                        }
                    }
                    throw new AssertionError(this.signature[this.sigp - 1]);
                }
                case 46: {
                    Symbol.ClassSymbol t;
                    if (outer != Type.noType) {
                        t = this.enterClass(this.readName(this.signatureBuffer, startSbp, this.sbp - startSbp));
                        outer = new Type.ClassType(outer, List.nil(), t);
                    }
                    this.signatureBuffer[this.sbp++] = 36;
                    continue block13;
                }
                case 47: {
                    this.signatureBuffer[this.sbp++] = 46;
                    continue block13;
                }
            }
            this.signatureBuffer[this.sbp++] = c;
        }
    }

    String quoteBadSignature() {
        String sigString;
        try {
            sigString = Convert.utf2string(this.signature, this.sigp, this.siglimit - this.sigp, Convert.Validation.NONE);
        }
        catch (InvalidUtfException e) {
            throw new AssertionError((Object)e);
        }
        if (sigString.length() > 32) {
            sigString = sigString.substring(0, 32) + "...";
        }
        return "\"" + sigString + "\"";
    }

    List<Type> sigToTypes(char terminator) {
        List<Object> head;
        List<Object> tail = head = List.of(null);
        while (this.signature[this.sigp] != terminator) {
            tail = tail.setTail(List.of(this.sigToType()));
        }
        ++this.sigp;
        return head.tail;
    }

    List<Type> sigToTypeParams(byte[] sig, int offset, int len) {
        this.signature = sig;
        this.sigp = offset;
        this.siglimit = offset + len;
        return this.sigToTypeParams();
    }

    List<Type> sigToTypeParams() {
        List<Type> tvars = List.nil();
        if (this.signature[this.sigp] == 60) {
            ++this.sigp;
            int start = this.sigp;
            this.sigEnterPhase = true;
            while (this.signature[this.sigp] != 62) {
                tvars = tvars.prepend(this.sigToTypeParam());
            }
            this.sigEnterPhase = false;
            this.sigp = start;
            while (this.signature[this.sigp] != 62) {
                this.sigToTypeParam();
            }
            ++this.sigp;
        }
        return tvars.reverse();
    }

    Type sigToTypeParam() {
        Type.TypeVar tvar;
        int start = this.sigp;
        while (this.signature[this.sigp] != 58) {
            ++this.sigp;
        }
        Name name = this.readName(this.signature, start, this.sigp - start);
        if (this.sigEnterPhase) {
            tvar = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.typevars.enter(tvar.tsym);
        } else {
            tvar = (Type.TypeVar)this.findTypeVar(name);
        }
        List<Type> bounds = List.nil();
        boolean allInterfaces = false;
        if (this.signature[this.sigp] == 58 && this.signature[this.sigp + 1] == 58) {
            ++this.sigp;
            allInterfaces = true;
        }
        while (this.signature[this.sigp] == 58) {
            ++this.sigp;
            bounds = bounds.prepend(this.sigToType());
        }
        if (!this.sigEnterPhase) {
            this.types.setBounds(tvar, bounds.reverse(), allInterfaces);
        }
        return tvar;
    }

    Type findTypeVar(Name name) {
        Symbol s = this.typevars.findFirst(name);
        if (s != null) {
            return s.type;
        }
        if (this.readingClassAttr) {
            Type.TypeVar t = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.missingTypeVariables = this.missingTypeVariables.prepend(t);
            return t;
        }
        throw this.badClassFile("undecl.type.var", name);
    }

    private Name readName(byte[] buf, int off, int len) {
        try {
            return this.names.fromUtf(buf, off, len, this.utf8validation);
        }
        catch (InvalidUtfException e) {
            if (this.warnOnIllegalUtf8) {
                this.log.warning(CompilerProperties.Warnings.InvalidUtf8InClassfile(this.currentClassFile, CompilerProperties.Fragments.BadUtf8ByteSequenceAt(this.sigp)));
                return this.names.fromUtfLax(buf, off, len);
            }
            throw this.badClassFile(CompilerProperties.Fragments.BadUtf8ByteSequenceAt(this.sigp));
        }
    }

    private void initAttributeReaders() {
        AttributeReader[] readers;
        for (AttributeReader r : readers = new AttributeReader[]{new AttributeReader(this.names.Code, ClassFile.Version.V45_3, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                if (ClassReader.this.saveParameterNames) {
                    ((Symbol.MethodSymbol)sym).code = ClassReader.this.readCode(sym);
                } else {
                    ClassReader.this.bp += attrLen;
                }
            }
        }, new AttributeReader(this.names.ConstantValue, ClassFile.Version.V45_3, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                Object v = ClassReader.this.poolReader.getConstant(ClassReader.this.nextChar());
                if ((sym.flags() & 0x10L) == 0L) {
                    return;
                }
                Symbol.VarSymbol var = (Symbol.VarSymbol)sym;
                switch (var.type.getTag()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case CHAR: 
                    case SHORT: 
                    case INT: {
                        this.checkType(var, Integer.class, v);
                        break;
                    }
                    case LONG: {
                        this.checkType(var, Long.class, v);
                        break;
                    }
                    case FLOAT: {
                        this.checkType(var, Float.class, v);
                        break;
                    }
                    case DOUBLE: {
                        this.checkType(var, Double.class, v);
                        break;
                    }
                    case CLASS: {
                        if (var.type.tsym == ClassReader.this.syms.stringType.tsym) {
                            this.checkType(var, String.class, v);
                            break;
                        }
                        throw ClassReader.this.badClassFile("bad.constant.value.type", var.type);
                    }
                    default: {
                        return;
                    }
                }
                if (v instanceof Integer) {
                    Integer intVal = (Integer)v;
                    if (!var.type.getTag().checkRange(intVal)) {
                        throw ClassReader.this.badClassFile("bad.constant.range", v, var, var.type);
                    }
                }
                var.setData(v);
            }

            void checkType(Symbol var, Class<?> clazz, Object value) {
                if (!clazz.isInstance(value)) {
                    throw ClassReader.this.badClassFile("bad.constant.value", value, var, clazz.getSimpleName());
                }
            }
        }, new AttributeReader(this.names.Deprecated, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                Symbol s = sym.owner.kind == Kinds.Kind.MDL ? sym.owner : sym;
                s.flags_field |= 0x20000L;
            }
        }, new AttributeReader(this.names.Exceptions, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                int nexceptions = ClassReader.this.nextChar();
                List<Type> thrown = List.nil();
                for (int j = 0; j < nexceptions; ++j) {
                    thrown = thrown.prepend(ClassReader.this.poolReader.getClass((int)ClassReader.this.nextChar()).type);
                }
                if (sym.type.getThrownTypes().isEmpty()) {
                    sym.type.asMethodType().thrown = thrown.reverse();
                }
            }
        }, new AttributeReader(this.names.InnerClasses, ClassFile.Version.V45_3, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
                if (ClassReader.this.currentModule.module_info == c) {
                    ClassReader.this.skipInnerClasses();
                } else {
                    ClassReader.this.readInnerClasses(c);
                }
            }
        }, new AttributeReader(this.names.LocalVariableTable, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                int newbp = ClassReader.this.bp + attrLen;
                if (ClassReader.this.saveParameterNames) {
                    int numEntries = ClassReader.this.nextChar();
                    for (int i = 0; i < numEntries; ++i) {
                        char start_pc = ClassReader.this.nextChar();
                        char length = ClassReader.this.nextChar();
                        char nameIndex = ClassReader.this.nextChar();
                        char sigIndex = ClassReader.this.nextChar();
                        char register = ClassReader.this.nextChar();
                        if (start_pc != '\u0000') continue;
                        if (register >= ClassReader.this.parameterNameIndicesLvt.length) {
                            int newSize = Math.max(register + '\u0001', ClassReader.this.parameterNameIndicesLvt.length + 8);
                            ClassReader.this.parameterNameIndicesLvt = Arrays.copyOf(ClassReader.this.parameterNameIndicesLvt, newSize);
                        }
                        ClassReader.this.parameterNameIndicesLvt[register] = nameIndex;
                    }
                }
                ClassReader.this.bp = newbp;
            }
        }, new AttributeReader(this.names.SourceFile, ClassFile.Version.V45_3, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
                Name n = ClassReader.this.poolReader.getName(ClassReader.this.nextChar());
                c.sourcefile = new SourceFileObject(n);
                String sn = n.toString();
                if (c.owner.kind == Kinds.Kind.PCK && sn.endsWith(".java") && !sn.equals(c.name.toString() + ".java")) {
                    c.flags_field |= 0x100000000000L;
                }
            }
        }, new AttributeReader(this.names.Synthetic, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                sym.flags_field |= 0x1000L;
            }
        }, new AttributeReader(this.names.EnclosingMethod, ClassFile.Version.V49, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                int newbp = ClassReader.this.bp + attrLen;
                ClassReader.this.readEnclosingMethodAttr(sym);
                ClassReader.this.bp = newbp;
            }
        }, new AttributeReader(this.names.Signature, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void read(Symbol sym, int attrLen) {
                if (sym.kind == Kinds.Kind.TYP) {
                    Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
                    ClassReader.this.readingClassAttr = true;
                    try {
                        Type.ClassType ct1 = (Type.ClassType)c.type;
                        Assert.check(c == ClassReader.this.currentOwner);
                        ct1.typarams_field = ClassReader.this.poolReader.getName(ClassReader.this.nextChar()).map(ClassReader.this::sigToTypeParams);
                        ct1.supertype_field = ClassReader.this.sigToType();
                        ListBuffer<Type> is = new ListBuffer<Type>();
                        while (ClassReader.this.sigp != ClassReader.this.siglimit) {
                            is.append(ClassReader.this.sigToType());
                        }
                        ct1.interfaces_field = is.toList();
                    }
                    finally {
                        ClassReader.this.readingClassAttr = false;
                    }
                } else {
                    List<Type> thrown = sym.type.getThrownTypes();
                    sym.type = ClassReader.this.poolReader.getType(ClassReader.this.nextChar());
                    if (sym.kind == Kinds.Kind.MTH && sym.type.getThrownTypes().isEmpty()) {
                        sym.type.asMethodType().thrown = thrown;
                    }
                }
            }
        }, new AttributeReader(this.names.AnnotationDefault, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                ClassReader.this.attachAnnotationDefault(sym);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                ClassReader.this.attachAnnotations(sym);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleParameterAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                ClassReader.this.readParameterAnnotations(sym);
            }
        }, new AttributeReader(this.names.RuntimeVisibleAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                ClassReader.this.attachAnnotations(sym);
            }
        }, new AttributeReader(this.names.RuntimeVisibleParameterAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                ClassReader.this.readParameterAnnotations(sym);
            }
        }, new AttributeReader(this.names.Annotation, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                sym.flags_field |= 0x2000L;
            }
        }, new AttributeReader(this.names.Bridge, ClassFile.Version.V49, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                sym.flags_field |= 0x80000000L;
            }
        }, new AttributeReader(this.names.Enum, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                sym.flags_field |= 0x4000L;
            }
        }, new AttributeReader(this.names.Varargs, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                sym.flags_field |= 0x400000000L;
            }
        }, new AttributeReader(this.names.RuntimeVisibleTypeAnnotations, ClassFile.Version.V52, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                ClassReader.this.attachTypeAnnotations(sym);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleTypeAnnotations, ClassFile.Version.V52, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                ClassReader.this.attachTypeAnnotations(sym);
            }
        }, new AttributeReader(this.names.MethodParameters, ClassFile.Version.V52, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrlen) {
                int newbp = ClassReader.this.bp + attrlen;
                if (ClassReader.this.saveParameterNames) {
                    int numEntries = ClassReader.this.nextByte();
                    ClassReader.this.parameterNameIndicesMp = new int[numEntries];
                    ClassReader.this.parameterAccessFlags = new int[numEntries];
                    int index = 0;
                    for (int i = 0; i < numEntries; ++i) {
                        char nameIndex = ClassReader.this.nextChar();
                        char flags = ClassReader.this.nextChar();
                        if ((flags & 0x9000) != 0) continue;
                        ClassReader.this.parameterNameIndicesMp[index] = nameIndex;
                        ClassReader.this.parameterAccessFlags[index] = flags;
                        ++index;
                    }
                }
                ClassReader.this.bp = newbp;
            }
        }, new AttributeReader(this.names.Module, ClassFile.Version.V53, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected boolean accepts(AttributeKind kind) {
                return super.accepts(kind) && ClassReader.this.allowModules;
            }

            @Override
            protected void read(Symbol sym, int attrLen) {
                if (sym.kind == Kinds.Kind.TYP && sym.owner.kind == Kinds.Kind.MDL) {
                    Symbol.ModuleSymbol msym = (Symbol.ModuleSymbol)sym.owner;
                    ListBuffer<Directive> directives = new ListBuffer<Directive>();
                    Name moduleName = ClassReader.this.poolReader.peekModuleName(ClassReader.this.nextChar(), (x$0, x$1, x$2) -> ClassReader.this.readName(x$0, x$1, x$2));
                    if (ClassReader.this.currentModule.name != moduleName) {
                        throw ClassReader.this.badClassFile("module.name.mismatch", moduleName, ClassReader.this.currentModule.name);
                    }
                    Set<Symbol.ModuleFlags> moduleFlags = ClassReader.this.readModuleFlags(ClassReader.this.nextChar());
                    msym.flags.addAll(moduleFlags);
                    msym.version = ClassReader.this.optPoolEntry(ClassReader.this.nextChar(), ClassReader.this.poolReader::getName, null);
                    ListBuffer<Directive.RequiresDirective> requires = new ListBuffer<Directive.RequiresDirective>();
                    int nrequires = ClassReader.this.nextChar();
                    for (int i = 0; i < nrequires; ++i) {
                        Symbol.ModuleSymbol rsym = ClassReader.this.poolReader.getModule(ClassReader.this.nextChar());
                        Set<Directive.RequiresFlag> flags = ClassReader.this.readRequiresFlags(ClassReader.this.nextChar());
                        if (rsym == ClassReader.this.syms.java_base && ClassReader.this.majorVersion >= ClassFile.Version.V54.major) {
                            if (flags.contains((Object)Directive.RequiresFlag.TRANSITIVE)) {
                                throw ClassReader.this.badClassFile("bad.requires.flag", new Object[]{Directive.RequiresFlag.TRANSITIVE});
                            }
                            if (flags.contains((Object)Directive.RequiresFlag.STATIC_PHASE)) {
                                throw ClassReader.this.badClassFile("bad.requires.flag", new Object[]{Directive.RequiresFlag.STATIC_PHASE});
                            }
                        }
                        ClassReader.this.nextChar();
                        requires.add(new Directive.RequiresDirective(rsym, flags));
                    }
                    msym.requires = requires.toList();
                    directives.addAll((Collection<Directive>)msym.requires);
                    ListBuffer<Directive.ExportsDirective> exports = new ListBuffer<Directive.ExportsDirective>();
                    int nexports = ClassReader.this.nextChar();
                    for (int i = 0; i < nexports; ++i) {
                        List to;
                        Symbol.PackageSymbol p = ClassReader.this.poolReader.getPackage(ClassReader.this.nextChar());
                        Set<Directive.ExportsFlag> flags = ClassReader.this.readExportsFlags(ClassReader.this.nextChar());
                        int nto = ClassReader.this.nextChar();
                        if (nto == 0) {
                            to = null;
                        } else {
                            ListBuffer<Symbol.ModuleSymbol> lb = new ListBuffer<Symbol.ModuleSymbol>();
                            for (int t = 0; t < nto; ++t) {
                                lb.append(ClassReader.this.poolReader.getModule(ClassReader.this.nextChar()));
                            }
                            to = lb.toList();
                        }
                        exports.add(new Directive.ExportsDirective(p, to, flags));
                    }
                    msym.exports = exports.toList();
                    directives.addAll((Collection<Directive>)msym.exports);
                    ListBuffer<Directive.OpensDirective> opens = new ListBuffer<Directive.OpensDirective>();
                    int nopens = ClassReader.this.nextChar();
                    if (nopens != 0 && msym.flags.contains((Object)Symbol.ModuleFlags.OPEN)) {
                        throw ClassReader.this.badClassFile("module.non.zero.opens", ClassReader.this.currentModule.name);
                    }
                    for (int i = 0; i < nopens; ++i) {
                        List to;
                        Symbol.PackageSymbol p = ClassReader.this.poolReader.getPackage(ClassReader.this.nextChar());
                        Set<Directive.OpensFlag> flags = ClassReader.this.readOpensFlags(ClassReader.this.nextChar());
                        int nto = ClassReader.this.nextChar();
                        if (nto == 0) {
                            to = null;
                        } else {
                            ListBuffer<Symbol.ModuleSymbol> lb = new ListBuffer<Symbol.ModuleSymbol>();
                            for (int t = 0; t < nto; ++t) {
                                lb.append(ClassReader.this.poolReader.getModule(ClassReader.this.nextChar()));
                            }
                            to = lb.toList();
                        }
                        opens.add(new Directive.OpensDirective(p, to, flags));
                    }
                    msym.opens = opens.toList();
                    directives.addAll((Collection<Directive>)msym.opens);
                    msym.directives = directives.toList();
                    ListBuffer<InterimUsesDirective> uses = new ListBuffer<InterimUsesDirective>();
                    int nuses = ClassReader.this.nextChar();
                    for (int i = 0; i < nuses; ++i) {
                        Name srvc = ClassReader.this.poolReader.peekClassName(ClassReader.this.nextChar(), this::classNameMapper);
                        uses.add(new InterimUsesDirective(srvc));
                    }
                    ClassReader.this.interimUses = uses.toList();
                    ListBuffer<InterimProvidesDirective> provides = new ListBuffer<InterimProvidesDirective>();
                    int nprovides = ClassReader.this.nextChar();
                    for (int p = 0; p < nprovides; ++p) {
                        Name srvc = ClassReader.this.poolReader.peekClassName(ClassReader.this.nextChar(), this::classNameMapper);
                        int nimpls = ClassReader.this.nextChar();
                        ListBuffer<Name> impls = new ListBuffer<Name>();
                        for (int i = 0; i < nimpls; ++i) {
                            impls.append(ClassReader.this.poolReader.peekClassName(ClassReader.this.nextChar(), this::classNameMapper));
                            provides.add(new InterimProvidesDirective(srvc, impls.toList()));
                        }
                    }
                    ClassReader.this.interimProvides = provides.toList();
                }
            }

            private Name classNameMapper(byte[] arr, int offset, int length) throws InvalidUtfException {
                byte[] buf = ClassFile.internalize(arr, offset, length);
                try {
                    return ClassReader.this.names.fromUtf(buf, 0, buf.length, ClassReader.this.utf8validation);
                }
                catch (InvalidUtfException e) {
                    if (ClassReader.this.warnOnIllegalUtf8) {
                        ClassReader.this.log.warning(CompilerProperties.Warnings.InvalidUtf8InClassfile(ClassReader.this.currentClassFile, CompilerProperties.Fragments.BadUtf8ByteSequenceAt(e.getOffset())));
                        return ClassReader.this.names.fromUtfLax(buf, 0, buf.length);
                    }
                    throw e;
                }
            }
        }, new AttributeReader(this.names.ModuleResolution, ClassFile.Version.V53, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected boolean accepts(AttributeKind kind) {
                return super.accepts(kind) && ClassReader.this.allowModules;
            }

            @Override
            protected void read(Symbol sym, int attrLen) {
                if (sym.kind == Kinds.Kind.TYP && sym.owner.kind == Kinds.Kind.MDL) {
                    Symbol.ModuleSymbol msym = (Symbol.ModuleSymbol)sym.owner;
                    msym.resolutionFlags.addAll(ClassReader.this.readModuleResolutionFlags(ClassReader.this.nextChar()));
                }
            }
        }, new AttributeReader(this.names.Record, ClassFile.Version.V58, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected boolean accepts(AttributeKind kind) {
                return super.accepts(kind) && ClassReader.this.allowRecords;
            }

            @Override
            protected void read(Symbol sym, int attrLen) {
                if (sym.kind == Kinds.Kind.TYP) {
                    sym.flags_field |= 0x2000000000000000L;
                }
                int componentCount = ClassReader.this.nextChar();
                ListBuffer<Symbol.RecordComponent> components = new ListBuffer<Symbol.RecordComponent>();
                for (int i = 0; i < componentCount; ++i) {
                    Name name = ClassReader.this.poolReader.getName(ClassReader.this.nextChar());
                    Type type = ClassReader.this.poolReader.getType(ClassReader.this.nextChar());
                    Symbol.RecordComponent c = new Symbol.RecordComponent(name, type, sym);
                    ClassReader.this.readAttrs(c, AttributeKind.MEMBER);
                    components.add(c);
                }
                ((Symbol.ClassSymbol)sym).setRecordComponents(components.toList());
            }
        }, new AttributeReader(this.names.PermittedSubclasses, ClassFile.Version.V59, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected boolean accepts(AttributeKind kind) {
                return super.accepts(kind) && ClassReader.this.allowSealedTypes;
            }

            @Override
            protected void read(Symbol sym, int attrLen) {
                if (sym.kind == Kinds.Kind.TYP) {
                    ListBuffer<Symbol.ClassSymbol> subtypes = new ListBuffer<Symbol.ClassSymbol>();
                    int numberOfPermittedSubtypes = ClassReader.this.nextChar();
                    for (int i = 0; i < numberOfPermittedSubtypes; ++i) {
                        subtypes.add(ClassReader.this.poolReader.getClass(ClassReader.this.nextChar()));
                    }
                    ((Symbol.ClassSymbol)sym).setPermittedSubclasses(subtypes.toList());
                }
            }
        }}) {
            this.attributeReaders.put(r.name, r);
        }
    }

    protected void readEnclosingMethodAttr(Symbol sym) {
        sym.owner.members().remove(sym);
        Symbol.ClassSymbol self = (Symbol.ClassSymbol)sym;
        Symbol.ClassSymbol c = this.poolReader.getClass(this.nextChar());
        PoolConstant.NameAndType nt = this.optPoolEntry(this.nextChar(), this.poolReader::getNameAndType, null);
        if (c.members_field == null || c.kind != Kinds.Kind.TYP) {
            throw this.badClassFile("bad.enclosing.class", self, c);
        }
        Symbol.MethodSymbol m = this.findMethod(nt, c.members_field, self.flags());
        if (nt != null && m == null) {
            throw this.badEnclosingMethod(self);
        }
        self.name = this.simpleBinaryName(self.flatname, c.flatname);
        self.owner = m != null ? m : c;
        self.fullname = self.name.length() == 0 ? this.names.empty : Symbol.ClassSymbol.formFullName(self.name, self.owner);
        if (m != null) {
            ((Type.ClassType)sym.type).setEnclosingType(m.type);
        } else if ((self.flags_field & 8L) == 0L) {
            ((Type.ClassType)sym.type).setEnclosingType(c.type);
        } else {
            ((Type.ClassType)sym.type).setEnclosingType(Type.noType);
        }
        this.enterTypevars(self, self.type);
        if (!this.missingTypeVariables.isEmpty()) {
            ListBuffer<Type> typeVars = new ListBuffer<Type>();
            for (Type typevar : this.missingTypeVariables) {
                typeVars.append(this.findTypeVar(typevar.tsym.name));
            }
            this.foundTypeVariables = typeVars.toList();
        } else {
            this.foundTypeVariables = List.nil();
        }
    }

    private Name simpleBinaryName(Name self, Name enclosing) {
        int index;
        if (!self.startsWith(enclosing)) {
            throw this.badClassFile("bad.enclosing.method", self);
        }
        String simpleBinaryName = self.toString().substring(enclosing.toString().length());
        if (simpleBinaryName.length() < 1 || simpleBinaryName.charAt(0) != '$') {
            throw this.badClassFile("bad.enclosing.method", self);
        }
        for (index = 1; index < simpleBinaryName.length() && ClassReader.isAsciiDigit(simpleBinaryName.charAt(index)); ++index) {
        }
        return this.names.fromString(simpleBinaryName.substring(index));
    }

    private Symbol.MethodSymbol findMethod(PoolConstant.NameAndType nt, Scope scope, long flags) {
        if (nt == null) {
            return null;
        }
        Type.MethodType type = nt.type.asMethodType();
        for (Symbol sym : scope.getSymbolsByName(nt.name)) {
            if (sym.kind != Kinds.Kind.MTH || !this.isSameBinaryType(sym.type.asMethodType(), type)) continue;
            return (Symbol.MethodSymbol)sym;
        }
        if (nt.name != this.names.init) {
            return null;
        }
        if ((flags & 0x200L) != 0L) {
            return null;
        }
        if (nt.type.getParameterTypes().isEmpty()) {
            return null;
        }
        nt = new PoolConstant.NameAndType(nt.name, new Type.MethodType(nt.type.getParameterTypes().tail, nt.type.getReturnType(), nt.type.getThrownTypes(), this.syms.methodClass));
        return this.findMethod(nt, scope, flags);
    }

    private boolean isSameBinaryType(Type.MethodType mt1, Type.MethodType mt2) {
        List<Type> types1 = this.types.erasure((List<Type>)mt1.getParameterTypes()).prepend(this.types.erasure(mt1.getReturnType()));
        List<Type> types2 = ((List)mt2.getParameterTypes()).prepend(mt2.getReturnType());
        while (!types1.isEmpty() && !types2.isEmpty()) {
            if (((Type)types1.head).tsym != ((Type)types2.head).tsym) {
                return false;
            }
            types1 = types1.tail;
            types2 = types2.tail;
        }
        return types1.isEmpty() && types2.isEmpty();
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    void readMemberAttrs(Symbol sym) {
        this.readAttrs(sym, AttributeKind.MEMBER);
    }

    void readAttrs(Symbol sym, AttributeKind kind) {
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            Name attrName = this.poolReader.getName(this.nextChar());
            int attrLen = this.nextInt();
            AttributeReader r = this.attributeReaders.get(attrName);
            if (r != null && r.accepts(kind)) {
                r.read(sym, attrLen);
                continue;
            }
            this.bp += attrLen;
        }
    }

    void readClassAttrs(Symbol.ClassSymbol c) {
        this.readAttrs(c, AttributeKind.CLASS);
    }

    Code readCode(Symbol owner) {
        this.nextChar();
        this.nextChar();
        int code_length = this.nextInt();
        this.bp += code_length;
        char exception_table_length = this.nextChar();
        this.bp += exception_table_length * 8;
        this.readMemberAttrs(owner);
        return null;
    }

    List<CompoundAnnotationProxy> readAnnotations() {
        int numAttributes = this.nextChar();
        ListBuffer<CompoundAnnotationProxy> annotations = new ListBuffer<CompoundAnnotationProxy>();
        for (int i = 0; i < numAttributes; ++i) {
            annotations.append(this.readCompoundAnnotation());
        }
        return annotations.toList();
    }

    void attachAnnotations(Symbol sym) {
        this.attachAnnotations(sym, this.readAnnotations());
    }

    void attachAnnotations(Symbol sym, List<CompoundAnnotationProxy> annotations) {
        if (annotations.isEmpty()) {
            return;
        }
        ListBuffer<CompoundAnnotationProxy> proxies = new ListBuffer<CompoundAnnotationProxy>();
        for (CompoundAnnotationProxy proxy : annotations) {
            if (proxy.type.tsym.flatName() == this.syms.proprietaryType.tsym.flatName()) {
                sym.flags_field |= 0x4000000000L;
                continue;
            }
            if (proxy.type.tsym.flatName() == this.syms.profileType.tsym.flatName()) {
                if (this.profile == Profile.DEFAULT) continue;
                for (Pair<Name, Attribute> v : proxy.values) {
                    Object b;
                    if (v.fst != this.names.value || !((b = v.snd) instanceof Attribute.Constant)) continue;
                    Attribute.Constant constant = (Attribute.Constant)b;
                    if (constant.type != this.syms.intType || (Integer)constant.value <= this.profile.value) continue;
                    sym.flags_field |= 0x200000000000L;
                }
                continue;
            }
            if (proxy.type.tsym.flatName() == this.syms.previewFeatureInternalType.tsym.flatName()) {
                sym.flags_field |= 0x100000000000000L;
                this.setFlagIfAttributeTrue(proxy, sym, this.names.reflective, 0x400000000000000L);
                continue;
            }
            if (proxy.type.tsym.flatName() == this.syms.valueBasedInternalType.tsym.flatName()) {
                Assert.check(sym.kind == Kinds.Kind.TYP);
                sym.flags_field |= 0x20000000000000L;
                continue;
            }
            if (proxy.type.tsym.flatName() == this.syms.restrictedInternalType.tsym.flatName()) {
                Assert.check(sym.kind == Kinds.Kind.MTH);
                sym.flags_field |= 0x4000000000000000L;
                continue;
            }
            if (proxy.type.tsym == this.syms.annotationTargetType.tsym) {
                this.target = proxy;
            } else if (proxy.type.tsym == this.syms.repeatableType.tsym) {
                this.repeatable = proxy;
            } else if (proxy.type.tsym == this.syms.deprecatedType.tsym) {
                sym.flags_field |= 0x40000000020000L;
                this.setFlagIfAttributeTrue(proxy, sym, this.names.forRemoval, 0x80000000000000L);
            } else if (proxy.type.tsym == this.syms.previewFeatureType.tsym) {
                sym.flags_field |= 0x100000000000000L;
                this.setFlagIfAttributeTrue(proxy, sym, this.names.reflective, 0x400000000000000L);
            } else if (proxy.type.tsym == this.syms.valueBasedType.tsym && sym.kind == Kinds.Kind.TYP) {
                sym.flags_field |= 0x20000000000000L;
            } else if (proxy.type.tsym == this.syms.restrictedType.tsym) {
                Assert.check(sym.kind == Kinds.Kind.MTH);
                sym.flags_field |= 0x4000000000000000L;
            }
            proxies.append(proxy);
        }
        this.annotate.normal(new AnnotationCompleter(sym, proxies.toList()));
    }

    private void setFlagIfAttributeTrue(CompoundAnnotationProxy proxy, Symbol sym, Name attribute, long flag) {
        for (Pair<Name, Attribute> v : proxy.values) {
            Object b;
            if (v.fst != attribute || !((b = v.snd) instanceof Attribute.Constant)) continue;
            Attribute.Constant constant = (Attribute.Constant)b;
            if (constant.type != this.syms.booleanType || (Integer)constant.value == 0) continue;
            sym.flags_field |= flag;
        }
    }

    void readParameterAnnotations(Symbol meth) {
        int numParameters;
        try {
            numParameters = this.buf.getByte(this.bp++) & 0xFF;
        }
        catch (ByteBuffer.UnderflowException e) {
            throw this.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(e.getLength()));
        }
        if (this.parameterAnnotations == null) {
            this.parameterAnnotations = new ParameterAnnotations[numParameters];
        } else if (this.parameterAnnotations.length != numParameters) {
            throw this.badClassFile("bad.runtime.invisible.param.annotations", meth);
        }
        for (int pnum = 0; pnum < numParameters; ++pnum) {
            if (this.parameterAnnotations[pnum] == null) {
                this.parameterAnnotations[pnum] = new ParameterAnnotations();
            }
            this.parameterAnnotations[pnum].add(this.readAnnotations());
        }
    }

    void attachTypeAnnotations(Symbol sym) {
        int numAttributes = this.nextChar();
        if (numAttributes != 0) {
            ListBuffer<TypeAnnotationProxy> proxies = new ListBuffer<TypeAnnotationProxy>();
            for (int i = 0; i < numAttributes; ++i) {
                proxies.append(this.readTypeAnnotation());
            }
            this.annotate.normal(new TypeAnnotationCompleter(sym, proxies.toList()));
        }
    }

    void attachAnnotationDefault(Symbol sym) {
        Attribute value;
        Symbol.MethodSymbol meth = (Symbol.MethodSymbol)sym;
        meth.defaultValue = value = this.readAttributeValue();
        this.annotate.normal(new AnnotationDefaultCompleter(meth, value));
    }

    Type readTypeOrClassSymbol(int i) {
        return this.readTypeToProxy(i);
    }

    Type readTypeToProxy(int i) {
        if (this.currentModule.module_info == this.currentOwner) {
            return new ProxyType(i);
        }
        return this.poolReader.getType(i);
    }

    CompoundAnnotationProxy readCompoundAnnotation() {
        Type t;
        if (this.currentModule.module_info == this.currentOwner) {
            char cpIndex = this.nextChar();
            t = new ProxyType(cpIndex);
        } else {
            t = this.readTypeOrClassSymbol(this.nextChar());
        }
        int numFields = this.nextChar();
        ListBuffer<Pair<Name, Attribute>> pairs = new ListBuffer<Pair<Name, Attribute>>();
        for (int i = 0; i < numFields; ++i) {
            Name name = this.poolReader.getName(this.nextChar());
            Attribute value = this.readAttributeValue();
            pairs.append(new Pair<Name, Attribute>(name, value));
        }
        return new CompoundAnnotationProxy(t, pairs.toList());
    }

    TypeAnnotationProxy readTypeAnnotation() {
        TypeAnnotationPosition position = this.readPosition();
        CompoundAnnotationProxy proxy = this.readCompoundAnnotation();
        return new TypeAnnotationProxy(proxy, position);
    }

    TypeAnnotationPosition readPosition() {
        int tag = this.nextByte();
        if (!TargetType.isValidTargetTypeValue(tag)) {
            throw this.badClassFile("bad.type.annotation.value", String.format("0x%02X", tag));
        }
        TargetType type = TargetType.fromTargetTypeValue(tag);
        switch (type) {
            case INSTANCEOF: {
                char offset = this.nextChar();
                TypeAnnotationPosition position = TypeAnnotationPosition.instanceOf(this.readTypePath());
                position.offset = offset;
                return position;
            }
            case NEW: {
                char offset = this.nextChar();
                TypeAnnotationPosition position = TypeAnnotationPosition.newObj(this.readTypePath());
                position.offset = offset;
                return position;
            }
            case CONSTRUCTOR_REFERENCE: {
                char offset = this.nextChar();
                TypeAnnotationPosition position = TypeAnnotationPosition.constructorRef(this.readTypePath());
                position.offset = offset;
                return position;
            }
            case METHOD_REFERENCE: {
                char offset = this.nextChar();
                TypeAnnotationPosition position = TypeAnnotationPosition.methodRef(this.readTypePath());
                position.offset = offset;
                return position;
            }
            case LOCAL_VARIABLE: {
                int table_length = this.nextChar();
                int[] newLvarOffset = new int[table_length];
                int[] newLvarLength = new int[table_length];
                int[] newLvarIndex = new int[table_length];
                for (int i = 0; i < table_length; ++i) {
                    newLvarOffset[i] = this.nextChar();
                    newLvarLength[i] = this.nextChar();
                    newLvarIndex[i] = this.nextChar();
                }
                TypeAnnotationPosition position = TypeAnnotationPosition.localVariable(this.readTypePath());
                position.lvarOffset = newLvarOffset;
                position.lvarLength = newLvarLength;
                position.lvarIndex = newLvarIndex;
                return position;
            }
            case RESOURCE_VARIABLE: {
                int table_length = this.nextChar();
                int[] newLvarOffset = new int[table_length];
                int[] newLvarLength = new int[table_length];
                int[] newLvarIndex = new int[table_length];
                for (int i = 0; i < table_length; ++i) {
                    newLvarOffset[i] = this.nextChar();
                    newLvarLength[i] = this.nextChar();
                    newLvarIndex[i] = this.nextChar();
                }
                TypeAnnotationPosition position = TypeAnnotationPosition.resourceVariable(this.readTypePath());
                position.lvarOffset = newLvarOffset;
                position.lvarLength = newLvarLength;
                position.lvarIndex = newLvarIndex;
                return position;
            }
            case EXCEPTION_PARAMETER: {
                char exception_index = this.nextChar();
                TypeAnnotationPosition position = TypeAnnotationPosition.exceptionParameter(this.readTypePath());
                position.setExceptionIndex(exception_index);
                return position;
            }
            case METHOD_RECEIVER: {
                return TypeAnnotationPosition.methodReceiver(this.readTypePath());
            }
            case CLASS_TYPE_PARAMETER: {
                int parameter_index = this.nextByte();
                return TypeAnnotationPosition.typeParameter(this.readTypePath(), parameter_index);
            }
            case METHOD_TYPE_PARAMETER: {
                int parameter_index = this.nextByte();
                return TypeAnnotationPosition.methodTypeParameter(this.readTypePath(), parameter_index);
            }
            case CLASS_TYPE_PARAMETER_BOUND: {
                int parameter_index = this.nextByte();
                int bound_index = this.nextByte();
                return TypeAnnotationPosition.typeParameterBound(this.readTypePath(), parameter_index, bound_index);
            }
            case METHOD_TYPE_PARAMETER_BOUND: {
                int parameter_index = this.nextByte();
                int bound_index = this.nextByte();
                return TypeAnnotationPosition.methodTypeParameterBound(this.readTypePath(), parameter_index, bound_index);
            }
            case CLASS_EXTENDS: {
                char type_index = this.nextChar();
                return TypeAnnotationPosition.classExtends(this.readTypePath(), (int)type_index);
            }
            case THROWS: {
                char type_index = this.nextChar();
                return TypeAnnotationPosition.methodThrows(this.readTypePath(), type_index);
            }
            case METHOD_FORMAL_PARAMETER: {
                int parameter_index = this.nextByte();
                return TypeAnnotationPosition.methodParameter(this.readTypePath(), parameter_index);
            }
            case CAST: {
                char offset = this.nextChar();
                int type_index = this.nextByte();
                TypeAnnotationPosition position = TypeAnnotationPosition.typeCast(this.readTypePath(), type_index);
                position.offset = offset;
                return position;
            }
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: {
                char offset = this.nextChar();
                int type_index = this.nextByte();
                TypeAnnotationPosition position = TypeAnnotationPosition.constructorInvocationTypeArg(this.readTypePath(), type_index);
                position.offset = offset;
                return position;
            }
            case METHOD_INVOCATION_TYPE_ARGUMENT: {
                char offset = this.nextChar();
                int type_index = this.nextByte();
                TypeAnnotationPosition position = TypeAnnotationPosition.methodInvocationTypeArg(this.readTypePath(), type_index);
                position.offset = offset;
                return position;
            }
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: {
                char offset = this.nextChar();
                int type_index = this.nextByte();
                TypeAnnotationPosition position = TypeAnnotationPosition.constructorRefTypeArg(this.readTypePath(), type_index);
                position.offset = offset;
                return position;
            }
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                char offset = this.nextChar();
                int type_index = this.nextByte();
                TypeAnnotationPosition position = TypeAnnotationPosition.methodRefTypeArg(this.readTypePath(), type_index);
                position.offset = offset;
                return position;
            }
            case METHOD_RETURN: {
                return TypeAnnotationPosition.methodReturn(this.readTypePath());
            }
            case FIELD: {
                return TypeAnnotationPosition.field(this.readTypePath());
            }
            case UNKNOWN: {
                throw new AssertionError((Object)"jvm.ClassReader: UNKNOWN target type should never occur!");
            }
        }
        throw new AssertionError((Object)("jvm.ClassReader: Unknown target type for position: " + (Object)((Object)type)));
    }

    List<TypeAnnotationPosition.TypePathEntry> readTypePath() {
        int len = this.nextByte();
        ListBuffer<Integer> loc = new ListBuffer<Integer>();
        for (int i = 0; i < len * 2; ++i) {
            loc = loc.append(this.nextByte());
        }
        return TypeAnnotationPosition.getTypePathFromBinary(loc.toList());
    }

    <Z> Z optPoolEntry(int index, IntFunction<Z> poolFunc, Z defaultValue) {
        return index == 0 ? defaultValue : poolFunc.apply(index);
    }

    Attribute readAttributeValue() {
        char c;
        try {
            c = (char)this.buf.getByte(this.bp++);
        }
        catch (ByteBuffer.UnderflowException e) {
            throw this.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(e.getLength()));
        }
        switch (c) {
            case 'B': {
                return new Attribute.Constant(this.syms.byteType, this.poolReader.getConstant(this.nextChar()));
            }
            case 'C': {
                return new Attribute.Constant(this.syms.charType, this.poolReader.getConstant(this.nextChar()));
            }
            case 'D': {
                return new Attribute.Constant(this.syms.doubleType, this.poolReader.getConstant(this.nextChar()));
            }
            case 'F': {
                return new Attribute.Constant(this.syms.floatType, this.poolReader.getConstant(this.nextChar()));
            }
            case 'I': {
                return new Attribute.Constant(this.syms.intType, this.poolReader.getConstant(this.nextChar()));
            }
            case 'J': {
                return new Attribute.Constant(this.syms.longType, this.poolReader.getConstant(this.nextChar()));
            }
            case 'S': {
                return new Attribute.Constant(this.syms.shortType, this.poolReader.getConstant(this.nextChar()));
            }
            case 'Z': {
                return new Attribute.Constant(this.syms.booleanType, this.poolReader.getConstant(this.nextChar()));
            }
            case 's': {
                return new Attribute.Constant(this.syms.stringType, this.poolReader.getName(this.nextChar()).toString());
            }
            case 'e': {
                return new EnumAttributeProxy(this.readTypeToProxy(this.nextChar()), this.poolReader.getName(this.nextChar()));
            }
            case 'c': {
                return new ClassAttributeProxy(this.readTypeOrClassSymbol(this.nextChar()));
            }
            case '[': {
                int n = this.nextChar();
                ListBuffer<Attribute> l = new ListBuffer<Attribute>();
                for (int i = 0; i < n; ++i) {
                    l.append(this.readAttributeValue());
                }
                return new ArrayAttributeProxy(l.toList());
            }
            case '@': {
                return this.readCompoundAnnotation();
            }
        }
        throw new AssertionError((Object)("unknown annotation tag '" + c + "'"));
    }

    private static void addTypeAnnotationsToSymbol(Symbol s, List<Attribute.TypeCompound> attributes) {
        new TypeAnnotationSymbolVisitor(attributes).visit(s, null);
    }

    Symbol.VarSymbol readField() {
        char rawFlags = this.nextChar();
        long flags = this.adjustFieldFlags(rawFlags);
        Name name = this.poolReader.getName(this.nextChar());
        Type type = this.poolReader.getType(this.nextChar());
        Symbol.VarSymbol v = new Symbol.VarSymbol(flags, name, type, this.currentOwner);
        this.readMemberAttrs(v);
        if (Integer.bitCount(rawFlags & 7) > 1 || Integer.bitCount(rawFlags & 0x50) > 1) {
            throw this.badClassFile("illegal.flag.combo", Flags.toString(rawFlags), "field", v);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol.MethodSymbol readMethod() {
        Type last;
        Symbol.MethodSymbol m;
        char rawFlags = this.nextChar();
        long flags = this.adjustMethodFlags(rawFlags);
        Name name = this.poolReader.getName(this.nextChar());
        Type type = this.poolReader.getType(this.nextChar());
        if (this.currentOwner.isInterface() && (flags & 0x400L) == 0L && !name.equals(this.names.clinit)) {
            if (this.majorVersion > ClassFile.Version.V52.major || this.majorVersion == ClassFile.Version.V52.major && this.minorVersion >= ClassFile.Version.V52.minor) {
                if ((flags & 0xAL) == 0L) {
                    this.currentOwner.flags_field |= 0x80000000000L;
                    flags |= 0x80000000400L;
                }
            } else {
                throw this.badClassFile((flags & 8L) == 0L ? "invalid.default.interface" : "invalid.static.interface", Integer.toString(this.majorVersion), Integer.toString(this.minorVersion));
            }
        }
        this.validateMethodType(name, type);
        if (name == this.names.init && this.currentOwner.hasOuterInstance()) {
            boolean local;
            boolean bl = local = !this.currentOwner.owner.members().includes(this.currentOwner, Scope.LookupKind.NON_RECURSIVE);
            if (this.currentOwner.name.length() != 0 && !local) {
                type = new Type.MethodType(this.adjustMethodParams(flags, type.getParameterTypes()), type.getReturnType(), type.getThrownTypes(), this.syms.methodClass);
            }
        }
        if (this.types.isSignaturePolymorphic(m = new Symbol.MethodSymbol(flags, name, type, this.currentOwner))) {
            m.flags_field |= 0x400000000000L;
        }
        if (this.saveParameterNames) {
            this.initParameterNames(m);
        }
        Symbol prevOwner = this.currentOwner;
        this.currentOwner = m;
        try {
            this.readMemberAttrs(m);
        }
        finally {
            this.currentOwner = prevOwner;
        }
        this.validateMethodType(name, m.type);
        this.setParameters(m, type);
        if (Integer.bitCount(rawFlags & 7) > 1) {
            throw this.badClassFile("illegal.flag.combo", Flags.toString(rawFlags), "method", m);
        }
        if (!((flags & 0x400000000L) == 0L || (last = type.getParameterTypes().last()) != null && last.hasTag(TypeTag.ARRAY))) {
            m.flags_field &= 0xFFFFFFFBFFFFFFFFL;
            throw this.badClassFile("malformed.vararg.method", m);
        }
        return m;
    }

    void validateMethodType(Name name, Type t) {
        if (!t.hasTag(TypeTag.METHOD) && !t.hasTag(TypeTag.FORALL) || name == this.names.init && !t.getReturnType().hasTag(TypeTag.VOID)) {
            throw this.badClassFile("method.descriptor.invalid", name);
        }
    }

    private List<Type> adjustMethodParams(long flags, List<Type> args) {
        boolean isVarargs;
        if (args.isEmpty()) {
            return args;
        }
        boolean bl = isVarargs = (flags & 0x400000000L) != 0L;
        if (isVarargs) {
            Type varargsElem = args.last();
            ListBuffer<Type> adjustedArgs = new ListBuffer<Type>();
            for (Type t : args) {
                adjustedArgs.append(t != varargsElem ? t : ((Type.ArrayType)t).makeVarargs());
            }
            args = adjustedArgs.toList();
        }
        return args.tail;
    }

    void initParameterNames(Symbol.MethodSymbol sym) {
        int excessSlots = 4;
        int expectedParameterSlots = Code.width(sym.type.getParameterTypes()) + 4;
        if (this.parameterNameIndicesLvt == null || this.parameterNameIndicesLvt.length < expectedParameterSlots) {
            this.parameterNameIndicesLvt = new int[expectedParameterSlots];
        } else {
            Arrays.fill(this.parameterNameIndicesLvt, 0);
        }
    }

    void setParameters(Symbol.MethodSymbol sym, Type jvmType) {
        int firstParamLvt;
        int n = firstParamLvt = (sym.flags() & 8L) == 0L ? 1 : 0;
        if (sym.name == this.names.init && this.currentOwner.hasOuterInstance() && this.currentOwner.name.length() != 0) {
            ++firstParamLvt;
        }
        if (sym.type != jvmType) {
            int skip = Code.width(jvmType.getParameterTypes()) - Code.width(sym.type.getParameterTypes());
            firstParamLvt += skip;
        }
        HashSet<Name> paramNames = new HashSet<Name>();
        ListBuffer<Symbol.VarSymbol> params = new ListBuffer<Symbol.VarSymbol>();
        int nameIndexLvt = firstParamLvt;
        int nameIndexMp = 0;
        int annotationIndex = 0;
        for (Type t : sym.type.getParameterTypes()) {
            ParameterAnnotations annotations;
            Symbol.VarSymbol param = this.parameter(nameIndexMp, nameIndexLvt, t, sym, paramNames);
            params.append(param);
            if (this.parameterAnnotations != null && (annotations = this.parameterAnnotations[annotationIndex]) != null && annotations.proxies != null && !annotations.proxies.isEmpty()) {
                this.annotate.normal(new AnnotationCompleter(param, annotations.proxies));
            }
            nameIndexLvt += Code.width(t);
            ++nameIndexMp;
            ++annotationIndex;
        }
        if (this.parameterAnnotations != null && this.parameterAnnotations.length != annotationIndex) {
            throw this.badClassFile("bad.runtime.invisible.param.annotations", sym);
        }
        Assert.checkNull(sym.params);
        sym.params = params.toList();
        this.parameterAnnotations = null;
        this.parameterNameIndicesLvt = null;
        this.parameterNameIndicesMp = null;
        this.parameterAccessFlags = null;
    }

    private Symbol.VarSymbol parameter(int mpIndex, int lvtIndex, Type t, Symbol.MethodSymbol owner, Set<Name> exclude) {
        Name argName;
        long flags = 0x200000000L;
        if (this.parameterAccessFlags != null && mpIndex < this.parameterAccessFlags.length && this.parameterAccessFlags[mpIndex] != 0) {
            flags |= (long)this.parameterAccessFlags[mpIndex];
        }
        if (this.parameterNameIndicesMp != null && mpIndex < this.parameterNameIndicesMp.length && this.parameterNameIndicesMp[mpIndex] != 0) {
            argName = this.optPoolEntry(this.parameterNameIndicesMp[mpIndex], this.poolReader::getName, this.names.empty);
            flags |= 0x10000000000000L;
        } else if (this.parameterNameIndicesLvt != null && lvtIndex < this.parameterNameIndicesLvt.length && this.parameterNameIndicesLvt[lvtIndex] != 0) {
            argName = this.optPoolEntry(this.parameterNameIndicesLvt[lvtIndex], this.poolReader::getName, this.names.empty);
            flags |= 0x10000000000000L;
        } else {
            String prefix = "arg";
            while (exclude.contains(argName = this.names.fromString(prefix + exclude.size()))) {
                prefix = prefix + "$";
            }
        }
        exclude.add(argName);
        return new Symbol.ParamSymbol(flags, argName, t, owner);
    }

    void skipBytes(int n) {
        this.bp += n;
    }

    void skipMember() {
        this.bp += 6;
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            this.bp += 2;
            int attrLen = this.nextInt();
            this.bp += attrLen;
        }
    }

    void skipInnerClasses() {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            this.nextChar();
            this.nextChar();
            this.nextChar();
        }
    }

    protected void enterTypevars(Symbol sym, Type t) {
        if (t.getEnclosingType() != null) {
            if (!t.getEnclosingType().hasTag(TypeTag.NONE)) {
                this.enterTypevars(sym.owner, t.getEnclosingType());
            }
        } else if (sym.kind == Kinds.Kind.MTH && !sym.isStatic()) {
            this.enterTypevars(sym.owner, sym.owner.type);
        }
        List<Type> xs = t.getTypeArguments();
        while (xs.nonEmpty()) {
            this.typevars.enter(((Type)xs.head).tsym);
            xs = xs.tail;
        }
    }

    protected Symbol.ClassSymbol enterClass(Name name) {
        return this.syms.enterClass(this.currentModule, name);
    }

    protected Symbol.ClassSymbol enterClass(Name name, Symbol.TypeSymbol owner) {
        return this.syms.enterClass(this.currentModule, name, owner);
    }

    void readClass(Symbol.ClassSymbol c) {
        int i;
        long f;
        long flags;
        Type.ClassType ct = (Type.ClassType)c.type;
        c.members_field = Scope.WriteableScope.create(c);
        this.typevars = this.typevars.dup(this.currentOwner);
        if (ct.getEnclosingType().hasTag(TypeTag.CLASS)) {
            this.enterTypevars(c.owner, ct.getEnclosingType());
        }
        if (((flags = this.adjustClassFlags(f = (long)this.nextChar())) & 0x8000000000000L) == 0L) {
            if (c.owner.kind == Kinds.Kind.PCK || c.owner.kind == Kinds.Kind.ERR) {
                c.flags_field = flags;
            }
            this.currentModule = c.packge().modle;
            Symbol.ClassSymbol self = this.poolReader.getClass(this.nextChar());
            if (c != self) {
                throw this.badClassFile("class.file.wrong.class", self.flatname);
            }
        } else {
            if (this.majorVersion < ClassFile.Version.V53.major) {
                throw this.badClassFile("anachronistic.module.info", Integer.toString(this.majorVersion), Integer.toString(this.minorVersion));
            }
            c.flags_field = flags;
            if (c.owner.kind != Kinds.Kind.MDL) {
                throw this.badClassFile("module.info.definition.expected", new Object[0]);
            }
            this.currentModule = (Symbol.ModuleSymbol)c.owner;
            char self = this.nextChar();
        }
        int startbp = this.bp;
        this.nextChar();
        char interfaceCount = this.nextChar();
        this.bp += interfaceCount * 2;
        int fieldCount = this.nextChar();
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            this.skipMember();
        }
        int methodCount = this.nextChar();
        for (int i3 = 0; i3 < methodCount; ++i3) {
            this.skipMember();
        }
        this.readClassAttrs(c);
        if (!((List)c.getPermittedSubclasses()).isEmpty()) {
            c.flags_field |= 0x4000000000000000L;
        }
        this.bp = startbp;
        int n = this.nextChar();
        if ((flags & 0x8000000000000L) != 0L && n > 0) {
            throw this.badClassFile("module.info.invalid.super.class", new Object[0]);
        }
        if (ct.supertype_field == null) {
            ct.supertype_field = this.optPoolEntry(n, idx -> this.poolReader.getClass(idx).erasure(this.types), Type.noType);
        }
        n = this.nextChar();
        List<Type> is = List.nil();
        for (i = 0; i < n; ++i) {
            Type _inter = this.poolReader.getClass(this.nextChar()).erasure(this.types);
            is = is.prepend(_inter);
        }
        if (ct.interfaces_field == null) {
            ct.interfaces_field = is.reverse();
        }
        Assert.check(fieldCount == this.nextChar());
        for (i = 0; i < fieldCount; ++i) {
            this.enterMember(c, this.readField());
        }
        Assert.check(methodCount == this.nextChar());
        for (i = 0; i < methodCount; ++i) {
            this.enterMember(c, this.readMethod());
        }
        if (c.isRecord()) {
            for (Symbol.RecordComponent rc : c.getRecordComponents()) {
                rc.accessor = this.lookupMethod(c, rc.name, List.nil());
            }
        }
        this.typevars = this.typevars.leave();
    }

    private Symbol.MethodSymbol lookupMethod(Symbol.TypeSymbol tsym, Name name, List<Type> argtypes) {
        for (Symbol s2 : tsym.members().getSymbolsByName(name, s -> s.kind == Kinds.Kind.MTH)) {
            if (!this.types.isSameTypes(s2.type.getParameterTypes(), argtypes)) continue;
            return (Symbol.MethodSymbol)s2;
        }
        return null;
    }

    void readInnerClasses(Symbol.ClassSymbol c) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            char outerIdx = this.nextChar();
            char nameIdx = this.nextChar();
            Symbol.ClassSymbol outer = this.optPoolEntry(outerIdx, this.poolReader::getClass, null);
            Name name = this.optPoolEntry(nameIdx, this.poolReader::getName, this.names.empty);
            if (name == null) {
                name = this.names.empty;
            }
            long flags = this.adjustClassFlags(this.nextChar());
            if (outer == null) continue;
            if (name == this.names.empty) {
                name = this.names.one;
            }
            Symbol.ClassSymbol member = this.enterClass(name, outer);
            if ((flags & 8L) == 0L) {
                ((Type.ClassType)member.type).setEnclosingType(outer.type);
                if (member.erasure_field != null) {
                    ((Type.ClassType)member.erasure_field).setEnclosingType(this.types.erasure(outer.type));
                }
            }
            if (c != outer || member.owner != c) continue;
            member.flags_field = flags;
            this.enterMember(c, member);
        }
    }

    private void readClassBuffer(Symbol.ClassSymbol c) throws IOException {
        boolean previewClassFile;
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw this.badClassFile("illegal.start.of.class.file", new Object[0]);
        }
        this.minorVersion = this.nextChar();
        this.majorVersion = this.nextChar();
        int maxMajor = ClassFile.Version.MAX().major;
        int maxMinor = ClassFile.Version.MAX().minor;
        boolean bl = previewClassFile = this.minorVersion == 65535;
        if (this.majorVersion > maxMajor || this.majorVersion * 1000 + this.minorVersion < ClassFile.Version.MIN().major * 1000 + ClassFile.Version.MIN().minor) {
            if (this.majorVersion == maxMajor + 1 && !previewClassFile) {
                this.log.warning(CompilerProperties.Warnings.BigMajorVersion(this.currentClassFile, this.majorVersion, maxMajor));
            } else {
                throw this.badClassFile("wrong.version", Integer.toString(this.majorVersion), Integer.toString(this.minorVersion), Integer.toString(maxMajor), Integer.toString(maxMinor));
            }
        }
        Convert.Validation validation = this.utf8validation = this.majorVersion < ClassFile.Version.V48.major ? Convert.Validation.PREJDK14 : Convert.Validation.STRICT;
        if (previewClassFile) {
            if (!this.preview.isEnabled()) {
                this.log.error(this.preview.disabledError(this.currentClassFile, this.majorVersion));
            } else {
                this.preview.warnPreview(c.classfile, this.majorVersion);
            }
        }
        this.poolReader = new PoolReader(this, this.names, this.syms);
        this.bp = this.poolReader.readPool(this.buf, this.bp);
        if (this.signatureBuffer.length < this.bp) {
            int ns = Integer.highestOneBit(this.bp) << 1;
            this.signatureBuffer = new byte[ns];
        }
        this.readClass(c);
    }

    public void readClassFile(Symbol.ClassSymbol c) {
        this.currentOwner = c;
        this.currentClassFile = c.classfile;
        this.warnedAttrs.clear();
        this.filling = true;
        this.target = null;
        this.repeatable = null;
        try {
            this.bp = 0;
            this.buf.reset();
            try (InputStream input = c.classfile.openInputStream();){
                this.buf.appendStream(input);
            }
            this.readClassBuffer(c);
            if (!this.missingTypeVariables.isEmpty() && !this.foundTypeVariables.isEmpty()) {
                List<Type> missing = this.missingTypeVariables;
                List<Type> found = this.foundTypeVariables;
                this.missingTypeVariables = List.nil();
                this.foundTypeVariables = List.nil();
                this.interimUses = List.nil();
                this.interimProvides = List.nil();
                this.filling = false;
                Type.ClassType ct = (Type.ClassType)this.currentOwner.type;
                ct.supertype_field = this.types.subst(ct.supertype_field, missing, found);
                ct.interfaces_field = this.types.subst(ct.interfaces_field, missing, found);
                List<Type> types = ct.typarams_field = this.types.substBounds(ct.typarams_field, missing, found);
                while (types.nonEmpty()) {
                    ((Type)types.head).tsym.type = (Type)types.head;
                    types = types.tail;
                }
            } else if (this.missingTypeVariables.isEmpty() != this.foundTypeVariables.isEmpty()) {
                Name name = ((Type)this.missingTypeVariables.head).tsym.name;
                throw this.badClassFile("undecl.type.var", name);
            }
            if ((c.flags_field & 0x2000L) != 0L) {
                c.setAnnotationTypeMetadata(new Annotate.AnnotationTypeMetadata(c, new CompleterDeproxy(c, this.target, this.repeatable)));
            } else {
                c.setAnnotationTypeMetadata(Annotate.AnnotationTypeMetadata.notAnAnnotationType());
            }
            if (c == this.currentModule.module_info) {
                if (this.interimUses.nonEmpty() || this.interimProvides.nonEmpty()) {
                    Assert.check(this.currentModule.isCompleted());
                    this.currentModule.usesProvidesCompleter = new UsesProvidesCompleter(this.currentModule, this.interimUses, this.interimProvides);
                } else {
                    this.currentModule.uses = List.nil();
                    this.currentModule.provides = List.nil();
                }
            }
        }
        catch (IOException | ClosedFileSystemException ex) {
            throw this.badClassFile("unable.to.access.file", ex.toString());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw this.badClassFile("bad.class.file", c.flatname);
        }
        finally {
            this.interimUses = List.nil();
            this.interimProvides = List.nil();
            this.missingTypeVariables = List.nil();
            this.foundTypeVariables = List.nil();
            this.filling = false;
        }
    }

    long adjustFieldFlags(long flags) {
        return flags;
    }

    long adjustMethodFlags(long flags) {
        if ((flags & 0x40L) != 0L) {
            flags &= 0xFFFFFFFFFFFFFFBFL;
            flags |= 0x80000000L;
        }
        if ((flags & 0x80L) != 0L) {
            flags &= 0xFFFFFFFFFFFFFF7FL;
            flags |= 0x400000000L;
        }
        return flags;
    }

    long adjustClassFlags(long flags) {
        if ((flags & 0x8000L) != 0L) {
            flags &= 0xFFFFFFFFFFFF7FFFL;
            flags |= 0x8000000000000L;
        }
        return flags & 0xFFFFFFFFFFFFFFDFL;
    }

    protected static enum AttributeKind {
        CLASS,
        MEMBER;

    }

    protected abstract class AttributeReader {
        protected final Name name;
        protected final ClassFile.Version version;
        protected final Set<AttributeKind> kinds;

        protected AttributeReader(Name name, ClassFile.Version version, Set<AttributeKind> kinds) {
            this.name = name;
            this.version = version;
            this.kinds = kinds;
        }

        protected boolean accepts(AttributeKind kind) {
            if (this.kinds.contains((Object)kind)) {
                if (ClassReader.this.majorVersion > this.version.major || ClassReader.this.majorVersion == this.version.major && ClassReader.this.minorVersion >= this.version.minor) {
                    return true;
                }
                if (ClassReader.this.lintClassfile && !ClassReader.this.warnedAttrs.contains(this.name)) {
                    JavaFileObject prev = ClassReader.this.log.useSource(ClassReader.this.currentClassFile);
                    try {
                        ClassReader.this.log.warning(Lint.LintCategory.CLASSFILE, null, CompilerProperties.Warnings.FutureAttr(this.name, this.version.major, this.version.minor, ClassReader.this.majorVersion, ClassReader.this.minorVersion));
                    }
                    finally {
                        ClassReader.this.log.useSource(prev);
                    }
                    ClassReader.this.warnedAttrs.add(this.name);
                }
            }
            return false;
        }

        protected abstract void read(Symbol var1, int var2);
    }

    static class CompoundAnnotationProxy
    extends Attribute {
        final List<Pair<Name, Attribute>> values;

        public CompoundAnnotationProxy(Type type, List<Pair<Name, Attribute>> values) {
            super(type);
            this.values = values;
        }

        @Override
        public void accept(Attribute.Visitor v) {
            ((ProxyVisitor)v).visitCompoundAnnotationProxy(this);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("@");
            buf.append(this.type.tsym.getQualifiedName());
            buf.append("/*proxy*/{");
            boolean first = true;
            List<Pair<Name, Attribute>> v = this.values;
            while (v.nonEmpty()) {
                Pair value = (Pair)v.head;
                if (!first) {
                    buf.append(",");
                }
                first = false;
                buf.append((CharSequence)value.fst);
                buf.append("=");
                buf.append(value.snd);
                v = v.tail;
            }
            buf.append("}");
            return buf.toString();
        }
    }

    class AnnotationCompleter
    extends AnnotationDeproxy
    implements Runnable {
        final Symbol sym;
        final List<CompoundAnnotationProxy> l;
        final JavaFileObject classFile;

        AnnotationCompleter(Symbol sym, List<CompoundAnnotationProxy> l) {
            super(ClassReader.this.currentOwner.kind == Kinds.Kind.MTH ? ClassReader.this.currentOwner.enclClass() : (Symbol.ClassSymbol)ClassReader.this.currentOwner);
            this.sym = sym.kind == Kinds.Kind.TYP && sym.owner.kind == Kinds.Kind.MDL ? sym.owner : sym;
            this.l = l;
            this.classFile = ClassReader.this.currentClassFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JavaFileObject previousClassFile = ClassReader.this.currentClassFile;
            try {
                ClassReader.this.currentClassFile = this.classFile;
                List<Attribute.Compound> newList = this.deproxyCompoundList(this.l);
                for (Attribute.Compound attr : newList) {
                    if (attr.type.tsym != ClassReader.this.syms.deprecatedType.tsym) continue;
                    this.sym.flags_field |= 0x40000000020000L;
                    Attribute forRemoval = attr.member(ClassReader.this.names.forRemoval);
                    if (!(forRemoval instanceof Attribute.Constant)) continue;
                    Attribute.Constant constant = (Attribute.Constant)forRemoval;
                    if (constant.type != ClassReader.this.syms.booleanType || (Integer)constant.value == 0) continue;
                    this.sym.flags_field |= 0x80000000000000L;
                }
                if (this.sym.annotationsPendingCompletion()) {
                    this.sym.setDeclarationAttributes(newList);
                } else {
                    this.sym.appendAttributes(newList);
                }
            }
            finally {
                ClassReader.this.currentClassFile = previousClassFile;
            }
        }

        public String toString() {
            return " ClassReader annotate " + this.sym.owner + "." + this.sym + " with " + this.l;
        }
    }

    static class ParameterAnnotations {
        List<CompoundAnnotationProxy> proxies;

        ParameterAnnotations() {
        }

        void add(List<CompoundAnnotationProxy> newAnnotations) {
            this.proxies = this.proxies == null ? newAnnotations : this.proxies.prependList(newAnnotations);
        }
    }

    static class TypeAnnotationProxy {
        final CompoundAnnotationProxy compound;
        final TypeAnnotationPosition position;

        public TypeAnnotationProxy(CompoundAnnotationProxy compound, TypeAnnotationPosition position) {
            this.compound = compound;
            this.position = position;
        }
    }

    class TypeAnnotationCompleter
    extends AnnotationCompleter {
        List<TypeAnnotationProxy> proxies;

        TypeAnnotationCompleter(Symbol sym, List<TypeAnnotationProxy> proxies) {
            super(sym, List.nil());
            this.proxies = proxies;
        }

        List<Attribute.TypeCompound> deproxyTypeCompoundList(List<TypeAnnotationProxy> proxies) {
            ListBuffer<Attribute.TypeCompound> buf = new ListBuffer<Attribute.TypeCompound>();
            for (TypeAnnotationProxy proxy : proxies) {
                Attribute.Compound compound = this.deproxyCompound(proxy.compound);
                Attribute.TypeCompound typeCompound = new Attribute.TypeCompound(compound, proxy.position);
                buf.add(typeCompound);
            }
            return buf.toList();
        }

        @Override
        public void run() {
            JavaFileObject previousClassFile = ClassReader.this.currentClassFile;
            try {
                ClassReader.this.currentClassFile = this.classFile;
                List<Attribute.TypeCompound> newList = this.deproxyTypeCompoundList(this.proxies);
                this.sym.setTypeAttributes(newList.prependList(this.sym.getRawTypeAttributes()));
                ClassReader.addTypeAnnotationsToSymbol(this.sym, newList);
            }
            finally {
                ClassReader.this.currentClassFile = previousClassFile;
            }
        }
    }

    class AnnotationDefaultCompleter
    extends AnnotationDeproxy
    implements Runnable {
        final Symbol.MethodSymbol sym;
        final Attribute value;
        final JavaFileObject classFile;

        AnnotationDefaultCompleter(Symbol.MethodSymbol sym, Attribute value) {
            super(ClassReader.this.currentOwner.kind == Kinds.Kind.MTH ? ClassReader.this.currentOwner.enclClass() : (Symbol.ClassSymbol)ClassReader.this.currentOwner);
            this.classFile = ClassReader.this.currentClassFile;
            this.sym = sym;
            this.value = value;
        }

        @Override
        public void run() {
            JavaFileObject previousClassFile = ClassReader.this.currentClassFile;
            try {
                this.sym.defaultValue = null;
                ClassReader.this.currentClassFile = this.classFile;
                this.sym.defaultValue = this.deproxy(this.sym.type.getReturnType(), this.value);
            }
            finally {
                ClassReader.this.currentClassFile = previousClassFile;
            }
        }

        public String toString() {
            return " ClassReader store default for " + this.sym.owner + "." + this.sym + " is " + this.value;
        }
    }

    private class ProxyType
    extends Type {
        private final Name name;

        public ProxyType(int index) {
            super(ClassReader.this.syms.noSymbol, List.nil());
            this.name = ClassReader.this.poolReader.getName(index);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.NONE;
        }

        public Type resolve() {
            return this.name.map(ClassReader.this::sigToType);
        }

        @Override
        public String toString() {
            return "<ProxyType>";
        }
    }

    static class EnumAttributeProxy
    extends Attribute {
        Type enumType;
        Name enumerator;

        public EnumAttributeProxy(Type enumType, Name enumerator) {
            super(null);
            this.enumType = enumType;
            this.enumerator = enumerator;
        }

        @Override
        public void accept(Attribute.Visitor v) {
            ((ProxyVisitor)v).visitEnumAttributeProxy(this);
        }

        @Override
        public String toString() {
            return "/*proxy enum*/" + this.enumType + "." + this.enumerator;
        }
    }

    static class ClassAttributeProxy
    extends Attribute {
        Type classType;

        public ClassAttributeProxy(Type classType) {
            super(null);
            this.classType = classType;
        }

        @Override
        public void accept(Attribute.Visitor v) {
            ((ProxyVisitor)v).visitClassAttributeProxy(this);
        }

        @Override
        public String toString() {
            return "/*proxy class*/" + this.classType + ".class";
        }
    }

    static class ArrayAttributeProxy
    extends Attribute {
        List<Attribute> values;

        ArrayAttributeProxy(List<Attribute> values) {
            super(null);
            this.values = values;
        }

        @Override
        public void accept(Attribute.Visitor v) {
            ((ProxyVisitor)v).visitArrayAttributeProxy(this);
        }

        @Override
        public String toString() {
            return "{" + this.values + "}";
        }
    }

    private static class TypeAnnotationSymbolVisitor
    extends Types.DefaultSymbolVisitor<Void, Void> {
        private final List<Attribute.TypeCompound> attributes;

        private TypeAnnotationSymbolVisitor(List<Attribute.TypeCompound> attributes) {
            this.attributes = attributes;
        }

        @Override
        public Void visitClassSymbol(Symbol.ClassSymbol s, Void unused) {
            Type.ClassType t = (Type.ClassType)s.type;
            int i = 0;
            ListBuffer<Type> interfaces = new ListBuffer<Type>();
            for (Type itf : t.interfaces_field) {
                interfaces.add(this.addTypeAnnotations(itf, TypeAnnotationSymbolVisitor.classExtends(i++)));
            }
            t.interfaces_field = interfaces.toList();
            t.supertype_field = this.addTypeAnnotations(t.supertype_field, TypeAnnotationSymbolVisitor.classExtends(65535));
            if (t.typarams_field != null) {
                t.typarams_field = this.rewriteTypeParameters(t.typarams_field, TargetType.CLASS_TYPE_PARAMETER_BOUND);
            }
            return null;
        }

        @Override
        public Void visitMethodSymbol(Symbol.MethodSymbol s, Void unused) {
            Type annotated;
            Type type;
            Type t = s.type;
            if (t.hasTag(TypeTag.FORALL)) {
                Type.ForAll fa = (Type.ForAll)t;
                fa.tvars = this.rewriteTypeParameters(fa.tvars, TargetType.METHOD_TYPE_PARAMETER_BOUND);
                t = fa.qtype;
            }
            Type.MethodType mt = (Type.MethodType)t;
            ListBuffer<Type> argtypes = new ListBuffer<Type>();
            int i = 0;
            for (Symbol.VarSymbol varSymbol : s.params) {
                varSymbol.type = this.addTypeAnnotations(varSymbol.type, TypeAnnotationSymbolVisitor.methodFormalParameter(i++));
                argtypes.add(varSymbol.type);
            }
            mt.argtypes = argtypes.toList();
            ListBuffer<Type> thrown = new ListBuffer<Type>();
            i = 0;
            for (Type thrownType : mt.thrown) {
                thrown.add(this.addTypeAnnotations(thrownType, TypeAnnotationSymbolVisitor.thrownType(i++)));
            }
            mt.thrown = thrown.toList();
            if (!mt.restype.hasTag(TypeTag.VOID)) {
                mt.restype = this.addTypeAnnotations(mt.restype, TargetType.METHOD_RETURN);
            }
            Type type2 = type = mt.recvtype != null ? mt.recvtype : s.implicitReceiverType();
            if (type != null && (annotated = this.addTypeAnnotations(type, TargetType.METHOD_RECEIVER)) != type) {
                mt.recvtype = annotated;
            }
            return null;
        }

        @Override
        public Void visitVarSymbol(Symbol.VarSymbol s, Void unused) {
            s.type = this.addTypeAnnotations(s.type, TargetType.FIELD);
            return null;
        }

        @Override
        public Void visitSymbol(Symbol s, Void unused) {
            return null;
        }

        private List<Type> rewriteTypeParameters(List<Type> tvars, TargetType boundType) {
            ListBuffer<Type> tvarbuf = new ListBuffer<Type>();
            int typeVariableIndex = 0;
            for (Type tvar : tvars) {
                Type bound = tvar.getUpperBound();
                if (bound.isCompound()) {
                    Type.ClassType ct = (Type.ClassType)bound;
                    int boundIndex = 0;
                    if (ct.supertype_field != null) {
                        ct.supertype_field = this.addTypeAnnotations(ct.supertype_field, TypeAnnotationSymbolVisitor.typeParameterBound(boundType, typeVariableIndex, boundIndex++));
                    }
                    ListBuffer<Type> itfbuf = new ListBuffer<Type>();
                    for (Type itf : ct.interfaces_field) {
                        itfbuf.add(this.addTypeAnnotations(itf, TypeAnnotationSymbolVisitor.typeParameterBound(boundType, typeVariableIndex, boundIndex++)));
                    }
                    ct.interfaces_field = itfbuf.toList();
                } else {
                    bound = this.addTypeAnnotations(bound, TypeAnnotationSymbolVisitor.typeParameterBound(boundType, typeVariableIndex, bound.isInterface() ? 1 : 0));
                }
                ((Type.TypeVar)tvar).setUpperBound(bound);
                tvarbuf.add(tvar);
                ++typeVariableIndex;
            }
            return tvarbuf.toList();
        }

        private Type addTypeAnnotations(Type type, TargetType targetType) {
            return this.addTypeAnnotations(type, (TypeAnnotationPosition pos) -> pos.type == targetType);
        }

        private Type addTypeAnnotations(Type type, Predicate<TypeAnnotationPosition> filter) {
            Assert.checkNonNull(type);
            ListBuffer<Attribute.TypeCompound> filtered = new ListBuffer<Attribute.TypeCompound>();
            for (Attribute.TypeCompound typeCompound : this.attributes) {
                if (!filter.test(typeCompound.position)) continue;
                filtered.add(typeCompound);
            }
            if (filtered.isEmpty()) {
                return type;
            }
            HashMap<List, ListBuffer> attributesByPath = new HashMap<List, ListBuffer>();
            for (Attribute.TypeCompound attribute : filtered.toList()) {
                attributesByPath.computeIfAbsent(attribute.position.location, k -> new ListBuffer()).add(attribute);
            }
            HashMap hashMap = new HashMap();
            new TypeAnnotationLocator(attributesByPath, hashMap).visit(type, List.nil());
            type = (Type)new TypeAnnotationTypeMapping(hashMap).visit(type, null);
            Assert.check(hashMap.isEmpty(), "Failed to apply annotations to types");
            return type;
        }

        private static Predicate<TypeAnnotationPosition> typeParameterBound(TargetType targetType, int parameterIndex, int boundIndex) {
            return pos -> pos.type == targetType && pos.parameter_index == parameterIndex && pos.bound_index == boundIndex;
        }

        private static Predicate<TypeAnnotationPosition> methodFormalParameter(int index) {
            return pos -> pos.type == TargetType.METHOD_FORMAL_PARAMETER && pos.parameter_index == index;
        }

        private static Predicate<TypeAnnotationPosition> thrownType(int index) {
            return pos -> pos.type == TargetType.THROWS && pos.type_index == index;
        }

        private static Predicate<TypeAnnotationPosition> classExtends(int index) {
            return pos -> pos.type == TargetType.CLASS_EXTENDS && pos.type_index == index;
        }
    }

    private class CompleterDeproxy
    implements Annotate.AnnotationTypeCompleter {
        Symbol.ClassSymbol proxyOn;
        CompoundAnnotationProxy target;
        CompoundAnnotationProxy repeatable;

        public CompleterDeproxy(Symbol.ClassSymbol c, CompoundAnnotationProxy target, CompoundAnnotationProxy repeatable) {
            this.proxyOn = c;
            this.target = target;
            this.repeatable = repeatable;
        }

        @Override
        public void complete(Symbol.ClassSymbol sym) {
            Assert.check(this.proxyOn == sym);
            Attribute.Compound theTarget = null;
            Attribute.Compound theRepeatable = null;
            try {
                AnnotationDeproxy deproxy;
                if (this.target != null) {
                    deproxy = new AnnotationDeproxy(this.proxyOn);
                    theTarget = deproxy.deproxyCompound(this.target);
                }
                if (this.repeatable != null) {
                    deproxy = new AnnotationDeproxy(this.proxyOn);
                    theRepeatable = deproxy.deproxyCompound(this.repeatable);
                }
            }
            catch (Exception e) {
                throw new Symbol.CompletionFailure(sym, () -> ClassReader.this.diagFactory.fragment(CompilerProperties.Fragments.ExceptionMessage(e.getMessage())), ClassReader.this.dcfh);
            }
            sym.getAnnotationTypeMetadata().setTarget(theTarget);
            sym.getAnnotationTypeMetadata().setRepeatable(theRepeatable);
        }
    }

    private final class UsesProvidesCompleter
    implements Symbol.Completer {
        private final Symbol.ModuleSymbol currentModule;
        private final List<InterimUsesDirective> interimUsesCopy;
        private final List<InterimProvidesDirective> interimProvidesCopy;

        public UsesProvidesCompleter(Symbol.ModuleSymbol currentModule, List<InterimUsesDirective> interimUsesCopy, List<InterimProvidesDirective> interimProvidesCopy) {
            this.currentModule = currentModule;
            this.interimUsesCopy = interimUsesCopy;
            this.interimProvidesCopy = interimProvidesCopy;
        }

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            ListBuffer<Directive> directives = new ListBuffer<Directive>();
            directives.addAll((Collection<Directive>)this.currentModule.directives);
            ListBuffer<Directive.UsesDirective> uses = new ListBuffer<Directive.UsesDirective>();
            for (InterimUsesDirective interim : this.interimUsesCopy) {
                Directive.UsesDirective d = new Directive.UsesDirective(ClassReader.this.syms.enterClass(this.currentModule, interim.service));
                uses.add(d);
                directives.add(d);
            }
            this.currentModule.uses = uses.toList();
            ListBuffer<Directive.ProvidesDirective> provides = new ListBuffer<Directive.ProvidesDirective>();
            for (InterimProvidesDirective interim : this.interimProvidesCopy) {
                ListBuffer<Symbol.ClassSymbol> impls = new ListBuffer<Symbol.ClassSymbol>();
                for (Name impl : interim.impls) {
                    impls.append(ClassReader.this.syms.enterClass(this.currentModule, impl));
                }
                Directive.ProvidesDirective d = new Directive.ProvidesDirective(ClassReader.this.syms.enterClass(this.currentModule, interim.service), impls.toList());
                provides.add(d);
                directives.add(d);
            }
            this.currentModule.provides = provides.toList();
            this.currentModule.directives = directives.toList();
        }
    }

    private static final class InterimProvidesDirective {
        public final Name service;
        public final List<Name> impls;

        public InterimProvidesDirective(Name service, List<Name> impls) {
            this.service = service;
            this.impls = impls;
        }
    }

    private static final class InterimUsesDirective {
        public final Name service;

        public InterimUsesDirective(Name service) {
            this.service = service;
        }
    }

    private static class SourceFileObject
    implements JavaFileObject {
        private final Name name;

        public SourceFileObject(Name name) {
            this.name = name;
        }

        @Override
        public URI toUri() {
            try {
                return new URI(null, this.name.toString(), null);
            }
            catch (URISyntaxException e) {
                throw new PathFileObject.CannotCreateUriError(this.name.toString(), e);
            }
        }

        @Override
        public String getName() {
            return this.name.toString();
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return BaseFileManager.getKind(this.getName());
        }

        @Override
        public InputStream openInputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OutputStream openOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return true;
        }

        @Override
        public NestingKind getNestingKind() {
            return null;
        }

        @Override
        public Modifier getAccessLevel() {
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceFileObject)) return false;
            SourceFileObject sourceFileObject = (SourceFileObject)other;
            if (!this.name.equals(sourceFileObject.name)) return false;
            return true;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static class TypeAnnotationTypeMapping
    extends Type.StructuralTypeMapping<Void> {
        private final Map<Type, List<Attribute.TypeCompound>> attributesByType;

        private TypeAnnotationTypeMapping(Map<Type, List<Attribute.TypeCompound>> attributesByType) {
            this.attributesByType = attributesByType;
        }

        private <T extends Type> Type reannotate(T t, BiFunction<T, Void, Type> f) {
            List<Attribute.TypeCompound> attributes = this.attributesByType.remove(t);
            Type mapped = f.apply(t, null);
            if (attributes == null) {
                return mapped;
            }
            TypeMetadata.Annotations existing = mapped.getMetadata(TypeMetadata.Annotations.class);
            if (existing != null) {
                existing.annotationBuffer().addAll((Collection<Attribute.TypeCompound>)attributes);
                return mapped;
            }
            return mapped.annotatedType(attributes);
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void unused) {
            return this.reannotate(t, (x$0, x$1) -> super.visitClassType((Type.ClassType)x$0, x$1));
        }

        @Override
        public Type visitWildcardType(Type.WildcardType t, Void unused) {
            return this.reannotate(t, (x$0, x$1) -> super.visitWildcardType((Type.WildcardType)x$0, x$1));
        }

        @Override
        public Type visitArrayType(Type.ArrayType t, Void unused) {
            return this.reannotate(t, (x$0, x$1) -> super.visitArrayType((Type.ArrayType)x$0, x$1));
        }

        @Override
        public Type visitType(Type t, Void unused) {
            return this.reannotate(t, (x, u) -> x);
        }
    }

    private static class TypeAnnotationLocator
    extends Types.DefaultTypeVisitor<Void, List<TypeAnnotationPosition.TypePathEntry>> {
        private final Map<List<TypeAnnotationPosition.TypePathEntry>, ListBuffer<Attribute.TypeCompound>> attributesByPath;
        private final Map<Type, List<Attribute.TypeCompound>> attributesByType;

        private TypeAnnotationLocator(Map<List<TypeAnnotationPosition.TypePathEntry>, ListBuffer<Attribute.TypeCompound>> attributesByPath, Map<Type, List<Attribute.TypeCompound>> attributesByType) {
            this.attributesByPath = attributesByPath;
            this.attributesByType = attributesByType;
        }

        @Override
        public Void visitClassType(Type.ClassType t, List<TypeAnnotationPosition.TypePathEntry> path) {
            List<Type.ClassType> enclosing = List.nil();
            for (Type curr = t; curr != null && curr != Type.noType; curr = ((Type)curr).getEnclosingType()) {
                enclosing = enclosing.prepend((Type.ClassType)curr);
            }
            for (Type.ClassType te : enclosing) {
                if (te.typarams_field != null) {
                    int i = 0;
                    for (Type typaram : te.typarams_field) {
                        this.visit(typaram, path.append(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, i++)));
                    }
                }
                this.visitType((Type)te, path);
                path = path.append(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType t, List<TypeAnnotationPosition.TypePathEntry> path) {
            this.visit(t.type, path.append(TypeAnnotationPosition.TypePathEntry.WILDCARD));
            return (Void)super.visitWildcardType(t, path);
        }

        @Override
        public Void visitArrayType(Type.ArrayType t, List<TypeAnnotationPosition.TypePathEntry> path) {
            this.visit(t.elemtype, path.append(TypeAnnotationPosition.TypePathEntry.ARRAY));
            return (Void)super.visitArrayType(t, path);
        }

        @Override
        public Void visitType(Type t, List<TypeAnnotationPosition.TypePathEntry> path) {
            ListBuffer<Attribute.TypeCompound> attributes = this.attributesByPath.remove(path);
            if (attributes != null) {
                this.attributesByType.put(t, attributes.toList());
            }
            return null;
        }
    }

    class AnnotationDeproxy
    implements ProxyVisitor {
        private Symbol.ClassSymbol requestingOwner;
        Attribute result;
        Type type;

        AnnotationDeproxy(Symbol.ClassSymbol owner) {
            this.requestingOwner = owner;
        }

        List<Attribute.Compound> deproxyCompoundList(List<CompoundAnnotationProxy> pl) {
            ListBuffer<Attribute.Compound> buf = new ListBuffer<Attribute.Compound>();
            List<CompoundAnnotationProxy> l = pl;
            while (l.nonEmpty()) {
                buf.append(this.deproxyCompound((CompoundAnnotationProxy)l.head));
                l = l.tail;
            }
            return buf.toList();
        }

        Attribute.Compound deproxyCompound(CompoundAnnotationProxy a) {
            Type annotationType = this.resolvePossibleProxyType(a.type);
            ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> buf = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
            List<Pair<Name, Attribute>> l = a.values;
            while (l.nonEmpty()) {
                Symbol.MethodSymbol meth = this.findAccessMethod(annotationType, (Name)((Pair)l.head).fst);
                buf.append(new Pair<Symbol.MethodSymbol, Attribute>(meth, this.deproxy(meth.type.getReturnType(), (Attribute)((Pair)l.head).snd)));
                l = l.tail;
            }
            return new Attribute.Compound(annotationType, buf.toList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Symbol.MethodSymbol findAccessMethod(Type container, Name name) {
            Symbol.CompletionFailure failure = null;
            try {
                for (Symbol sym : container.tsym.members().getSymbolsByName(name)) {
                    if (sym.kind != Kinds.Kind.MTH || sym.type.getParameterTypes().length() != 0) continue;
                    return (Symbol.MethodSymbol)sym;
                }
            }
            catch (Symbol.CompletionFailure ex) {
                failure = ex;
            }
            JavaFileObject prevSource = ClassReader.this.log.useSource(this.requestingOwner.classfile);
            try {
                if (ClassReader.this.lintClassfile) {
                    if (failure == null) {
                        ClassReader.this.log.warning(CompilerProperties.Warnings.AnnotationMethodNotFound(container, name));
                    } else {
                        ClassReader.this.log.warning(CompilerProperties.Warnings.AnnotationMethodNotFoundReason(container, name, failure.getDetailValue()));
                    }
                }
            }
            finally {
                ClassReader.this.log.useSource(prevSource);
            }
            Type.MethodType mt = new Type.MethodType(List.nil(), ClassReader.this.syms.botType, List.nil(), ClassReader.this.syms.methodClass);
            return new Symbol.MethodSymbol(1025L, name, mt, container.tsym);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Attribute deproxy(Type t, Attribute a) {
            Type oldType = this.type;
            try {
                this.type = t;
                a.accept(this);
                Attribute attribute = this.result;
                return attribute;
            }
            finally {
                this.type = oldType;
            }
        }

        @Override
        public void visitConstant(Attribute.Constant value) {
            this.result = value;
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.result = clazz;
        }

        @Override
        public void visitEnum(Attribute.Enum e) {
            throw new AssertionError();
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            throw new AssertionError();
        }

        @Override
        public void visitArray(Attribute.Array array) {
            throw new AssertionError();
        }

        @Override
        public void visitError(Attribute.Error e) {
            throw new AssertionError();
        }

        @Override
        public void visitEnumAttributeProxy(EnumAttributeProxy proxy) {
            Type enumType = this.resolvePossibleProxyType(proxy.enumType);
            Symbol.TypeSymbol enumTypeSym = enumType.tsym;
            Symbol.VarSymbol enumerator = null;
            Symbol.CompletionFailure failure = null;
            try {
                for (Symbol sym : enumTypeSym.members().getSymbolsByName(proxy.enumerator)) {
                    if (sym.kind != Kinds.Kind.VAR) continue;
                    enumerator = (Symbol.VarSymbol)sym;
                    break;
                }
            }
            catch (Symbol.CompletionFailure ex) {
                failure = ex;
            }
            if (enumerator == null) {
                if (failure != null) {
                    ClassReader.this.log.warning(CompilerProperties.Warnings.UnknownEnumConstantReason(ClassReader.this.currentClassFile, (Symbol)enumTypeSym, proxy.enumerator, failure.getDiagnostic()));
                } else {
                    ClassReader.this.log.warning(CompilerProperties.Warnings.UnknownEnumConstant(ClassReader.this.currentClassFile, enumTypeSym, proxy.enumerator));
                }
                this.result = new Attribute.Enum(enumTypeSym.type, new Symbol.VarSymbol(0L, proxy.enumerator, ClassReader.this.syms.botType, enumTypeSym));
            } else {
                this.result = new Attribute.Enum(enumTypeSym.type, enumerator);
            }
        }

        @Override
        public void visitClassAttributeProxy(ClassAttributeProxy proxy) {
            Type classType = this.resolvePossibleProxyType(proxy.classType);
            this.result = new Attribute.Class(ClassReader.this.types, classType);
        }

        @Override
        public void visitArrayAttributeProxy(ArrayAttributeProxy proxy) {
            int length = proxy.values.length();
            Attribute[] ats = new Attribute[length];
            Type elemtype = ClassReader.this.types.elemtype(this.type);
            int i = 0;
            List<Attribute> p = proxy.values;
            while (p.nonEmpty()) {
                ats[i++] = this.deproxy(elemtype, (Attribute)p.head);
                p = p.tail;
            }
            this.result = new Attribute.Array(this.type, ats);
        }

        @Override
        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy proxy) {
            this.result = this.deproxyCompound(proxy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Type resolvePossibleProxyType(Type t) {
            if (t instanceof ProxyType) {
                ProxyType proxyType = (ProxyType)t;
                Assert.check(this.requestingOwner.owner.kind == Kinds.Kind.MDL);
                Symbol.ModuleSymbol prevCurrentModule = ClassReader.this.currentModule;
                ClassReader.this.currentModule = (Symbol.ModuleSymbol)this.requestingOwner.owner;
                try {
                    Type type = proxyType.resolve();
                    return type;
                }
                finally {
                    ClassReader.this.currentModule = prevCurrentModule;
                }
            }
            return t;
        }
    }

    static interface ProxyVisitor
    extends Attribute.Visitor {
        public void visitEnumAttributeProxy(EnumAttributeProxy var1);

        public void visitClassAttributeProxy(ClassAttributeProxy var1);

        public void visitArrayAttributeProxy(ArrayAttributeProxy var1);

        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy var1);
    }
}

