/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.model;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionProfile;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;

public abstract class NetbeansActionReader {
    protected abstract String getRawMappingsAsString();

    protected abstract Reader performDynamicSubstitutions(Map<String, String> var1, String var2) throws IOException;

    public final NetbeansActionMapping getMappingForAction(NetbeansBuildActionXpp3Reader reader, Logger LOG, String actionName, boolean[] hasInnerProfiles, Project project, String profile, Map<String, String> map) {
        NetbeansActionMapping action = null;
        try {
            List<Object> actions;
            String raw = this.getRawMappingsAsString();
            if (raw == null) {
                return null;
            }
            Reader read = this.performDynamicSubstitutions(map, raw);
            ActionToGoalMapping mapping = reader.read(read);
            if (profile == null) {
                actions = mapping.getActions();
            } else {
                actions = Collections.emptyList();
                for (NetbeansActionProfile p : mapping.getProfiles()) {
                    if (!profile.equals(p.getId())) continue;
                    actions = p.getActions();
                    break;
                }
            }
            if (hasInnerProfiles != null) {
                hasInnerProfiles[0] = !mapping.getProfiles().isEmpty();
            }
            Iterator<Object> it = actions.iterator();
            NbMavenProject mp = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            String prjPack = mp.getPackagingType();
            while (it.hasNext()) {
                NetbeansActionMapping elem = (NetbeansActionMapping)it.next();
                if (!actionName.equals(elem.getActionName()) || !elem.getPackagings().isEmpty() && !elem.getPackagings().contains(prjPack.trim()) && !elem.getPackagings().contains("*")) continue;
                action = elem;
                break;
            }
        }
        catch (XmlPullParserException ex) {
            LOG.log(Level.INFO, "Parsing action mapping", ex);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Parsing action mapping", ex);
        }
        return action;
    }
}

