/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.lib.profiler.results.locks.AbstractLockDataFrameProcessor;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;

public class CPUSamplingDataFrameProcessor
extends AbstractLockDataFrameProcessor {
    private String currentThreadName;
    private String currentThreadClassName;
    private long currentTimestamp;
    private Map<Integer, ThreadInfo> currentThreadsDump;
    private Map<Integer, ThreadInfo> lastThreadsDump;
    private List<ThreadDump> threadDumps = new ArrayList<ThreadDump>();
    private MethodNameFormatter formatter = MethodNameFormatterFactory.getDefault(new DefaultMethodNameFormatter(4)).getFormatter();
    private StackTraceSnapshotBuilder builder;

    @Override
    public void doProcessDataFrame(ByteBuffer buffer) {
        JMethodIdTable methodIdsTable = JMethodIdTable.getDefault();
        this.threadDumps = new ArrayList<ThreadDump>();
        block14: while (buffer.hasRemaining()) {
            byte eventType = buffer.get();
            switch (eventType) {
                case 31: {
                    this.currentThreadsDump = new HashMap<Integer, ThreadInfo>();
                    this.currentTimestamp = CPUSamplingDataFrameProcessor.getTimeStamp(buffer);
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block14;
                    LOGGER.finest("Thread dump start: Timestamps:" + this.currentTimestamp);
                    continue block14;
                }
                case 11: {
                    char threadId = buffer.getChar();
                    String threadName = CPUSamplingDataFrameProcessor.getString(buffer);
                    String threadClassName = CPUSamplingDataFrameProcessor.getString(buffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Creating new thread: tId=" + threadId + " name=" + threadName);
                    }
                    this.currentThreadId = threadId;
                    this.currentThreadName = threadName;
                    this.currentThreadClassName = threadClassName;
                    this.fireNewThread(threadId, threadName, threadClassName);
                    continue block14;
                }
                case 13: {
                    this.currentThreadId = buffer.getChar();
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block14;
                    LOGGER.log(Level.FINEST, "Change current thread , tId={0}", this.currentThreadId);
                    continue block14;
                }
                case 33: {
                    char threadId = buffer.getChar();
                    Integer threadIdObj = threadId;
                    ThreadInfo lastInfo = this.lastThreadsDump.get(threadIdObj);
                    assert (lastInfo != null);
                    this.currentThreadsDump.put(threadIdObj, lastInfo);
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block14;
                    LOGGER.finest("Thread info identical: tId:" + threadId);
                    continue block14;
                }
                case 34: {
                    char threadId = buffer.getChar();
                    byte state = buffer.get();
                    int stackLen = buffer.getChar();
                    int[] methodIds = new int[stackLen];
                    for (int i = 0; i < stackLen; ++i) {
                        methodIds[i] = buffer.getInt();
                        methodIdsTable.checkMethodId(methodIds[i]);
                    }
                    ThreadInfo info = this.currentThreadId == threadId ? new ThreadInfo(this.currentThreadName, threadId, state, methodIds) : new ThreadInfo(null, threadId, state, methodIds);
                    this.currentThreadsDump.put(Integer.valueOf(threadId), info);
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block14;
                    LOGGER.finest("Thread info: tId:" + threadId + " state:" + state + " mIds:" + Arrays.toString(methodIds));
                    continue block14;
                }
                case 32: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Thread dump end");
                    }
                    this.lastThreadsDump = this.currentThreadsDump;
                    this.threadDumps.add(new ThreadDump(this.currentTimestamp, this.currentThreadsDump));
                    continue block14;
                }
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    this.builder.reset();
                    continue block14;
                }
                case 28: {
                    int hash = buffer.getInt();
                    String className = CPUSamplingDataFrameProcessor.getString(buffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new monitor , monitorId={0} , className={1}", new Object[]{Integer.toHexString(hash), className});
                    }
                    this.fireNewMonitor(hash, className);
                    continue block14;
                }
                case 22: 
                case 23: {
                    long timeStamp0 = CPUSamplingDataFrameProcessor.getTimeStamp(buffer);
                    long timeStamp1 = -1L;
                    int hash = buffer.getInt();
                    if (eventType == 22) {
                        int ownerThreadId = buffer.getInt();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Monitor entry , tId={0} , monitorId={1} , ownerId={2}", new Object[]{this.currentThreadId, Integer.toHexString(hash), ownerThreadId});
                        }
                        this.fireMonitorEntry(this.currentThreadId, timeStamp0, timeStamp1, hash, ownerThreadId);
                    }
                    if (eventType != 23) continue block14;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Monitor exit , tId={0} , monitorId={1}", new Object[]{this.currentThreadId, Integer.toHexString(hash)});
                    }
                    this.fireMonitorExit(this.currentThreadId, timeStamp0, timeStamp1, hash);
                    continue block14;
                }
                case 5: {
                    long timeStamp1;
                    long timeStamp0 = CPUSamplingDataFrameProcessor.getTimeStamp(buffer);
                    long l = timeStamp1 = this.collectingTwoTimeStamps ? CPUSamplingDataFrameProcessor.getTimeStamp(buffer) : 0L;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Adjust time , tId={0}", this.currentThreadId);
                    }
                    this.fireAdjustTime(this.currentThreadId, timeStamp0, timeStamp1);
                    continue block14;
                }
            }
            LOGGER.log(Level.SEVERE, "*** Profiler Engine: internal error: got unknown event type in CPUSamplingDataFrameProcessor: {0} at {1}", new Object[]{(int)eventType, buffer.position()});
        }
        try {
            methodIdsTable.getNamesForMethodIds(this.client);
        }
        catch (ClientUtils.TargetAppOrVMTerminated ex) {
            ProfilerLogger.log(ex.getMessage());
            return;
        }
        this.processCollectedDumps(methodIdsTable, this.threadDumps);
        this.threadDumps.clear();
    }

    @Override
    public void startup(ProfilerClient client) {
        final CPUCallGraphBuilder[] ccgb = new CPUCallGraphBuilder[1];
        super.startup(client);
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                if (listener instanceof CPUCallGraphBuilder) {
                    ccgb[0] = (CPUCallGraphBuilder)listener;
                }
            }
        });
        this.builder = new StackTraceSnapshotBuilder(ccgb[0], client.getSettings().getInstrumentationFilter(), client.getStatus());
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.builder = null;
    }

    private static Thread.State getThreadState(int threadState) {
        switch (threadState) {
            case -1: {
                return Thread.State.TERMINATED;
            }
            case 0: {
                return Thread.State.TERMINATED;
            }
            case 1: {
                return Thread.State.RUNNABLE;
            }
            case 2: {
                return Thread.State.TIMED_WAITING;
            }
            case 3: {
                return Thread.State.BLOCKED;
            }
            case 4: 
            case 5: {
                return Thread.State.WAITING;
            }
        }
        return Thread.State.TERMINATED;
    }

    private void processCollectedDumps(JMethodIdTable methodIdTable, List<ThreadDump> threadDumps) {
        HashMap<Integer, StackTraceElement> stackTraceElements = new HashMap<Integer, StackTraceElement>();
        InstrumentationFilter filter = this.builder.getFilter();
        for (ThreadDump td : threadDumps) {
            StackTraceSnapshotBuilder.SampledThreadInfo[] sampledThreadInfos = new StackTraceSnapshotBuilder.SampledThreadInfo[td.threadDumps.length];
            int tindex = 0;
            for (ThreadInfo ti : td.threadDumps) {
                int[] methodIds = ti.methodsIds;
                StackTraceElement[] stackTrace = new StackTraceElement[methodIds.length];
                for (int i = 0; i < methodIds.length; ++i) {
                    int methodId = methodIds[i];
                    StackTraceElement el = (StackTraceElement)stackTraceElements.get(methodId);
                    if (el == null) {
                        JMethodIdTable.JMethodIdTableEntry entry = methodIdTable.getEntry(methodId);
                        String method = this.formatter.formatMethodName(entry.className, entry.methodName, entry.methodSig).toFormatted();
                        String className = entry.className.replace('/', '.');
                        String methodName = method + '|' + entry.methodSig;
                        el = new StackTraceElement(className, methodName, null, entry.isNative ? -2 : -1);
                        stackTraceElements.put(methodId, el);
                    }
                    stackTrace[i] = el;
                }
                sampledThreadInfos[tindex++] = new StackTraceSnapshotBuilder.SampledThreadInfo(ti.threadName, ti.threadId, ti.state, stackTrace, filter);
            }
            this.builder.addStacktrace(sampledThreadInfos, td.timestamp);
        }
    }

    private static final class ThreadInfo {
        private int[] methodsIds;
        private Thread.State state;
        private String threadName;
        private long threadId;

        ThreadInfo(String tn, long tid, byte ts, int[] st) {
            this.threadName = tn;
            this.threadId = tid;
            this.state = CPUSamplingDataFrameProcessor.getThreadState(ts);
            this.methodsIds = st;
        }
    }

    private static final class ThreadDump {
        private long timestamp;
        private ThreadInfo[] threadDumps;

        ThreadDump(long ts, Map<Integer, ThreadInfo> threadsMap) {
            this.timestamp = ts;
            this.threadDumps = threadsMap.values().toArray(new ThreadInfo[0]);
        }
    }
}

