/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.credentials;

import java.awt.Dialog;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.docker.api.Credentials;
import org.netbeans.modules.docker.api.CredentialsManager;
import org.netbeans.modules.docker.ui.credentials.Bundle;
import org.netbeans.modules.docker.ui.credentials.CredentialsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;

public final class CredentialsUtils {
    private CredentialsUtils() {
    }

    @CheckForNull
    public static Credentials askForCredentials(String registry) {
        assert (SwingUtilities.isEventDispatchThread());
        String realRegistry = registry;
        if (realRegistry == null) {
            realRegistry = "https://index.docker.io/v1/";
        }
        try {
            Credentials existing = CredentialsManager.getDefault().getCredentials(realRegistry);
            if (existing == null) {
                existing = new Credentials(realRegistry, null, new char[0], null);
            }
            return CredentialsUtils.editCredentials(existing, Collections.emptySet());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    static Credentials editCredentials(Credentials existing, Set<String> registries) {
        assert (SwingUtilities.isEventDispatchThread());
        try {
            JButton actionButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)actionButton, (String)Bundle.LBL_OK());
            CredentialsPanel panel = new CredentialsPanel(actionButton, registries);
            if (existing != null) {
                panel.setCredentials(existing);
            }
            DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.LBL_CredentialsDetailTitle(), true, new Object[]{actionButton, DialogDescriptor.CANCEL_OPTION}, (Object)actionButton, 0, null, null);
            descriptor.setClosingOptions(new Object[]{actionButton, DialogDescriptor.CANCEL_OPTION});
            panel.setMessageLine(descriptor.createNotificationLineSupport());
            Dialog dlg = null;
            try {
                dlg = DialogDisplayer.getDefault().createDialog(descriptor);
                dlg.setVisible(true);
                if (descriptor.getValue() != actionButton) return null;
                Credentials credentials2 = panel.getCredentials();
                CredentialsManager.getDefault().setCredentials(credentials2);
                Credentials credentials = credentials2;
                return credentials;
            }
            finally {
                if (dlg != null) {
                    dlg.dispose();
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

