/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIObjectCache;
import com.sun.xml.registry.uddi.infomodel.ExtensibleObjectImpl;
import com.sun.xml.registry.uddi.infomodel.ExternalIdentifierImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Slot;

public abstract class RegistryObjectImpl
extends ExtensibleObjectImpl
implements RegistryObject,
Serializable {
    ArrayList associations = new ArrayList();
    ArrayList classifications = new ArrayList();
    ArrayList externalIdentifiers = new ArrayList();
    ArrayList externalLinks = new ArrayList();
    InternationalString description = new InternationalStringImpl();
    InternationalString name = new InternationalStringImpl();
    Key key;
    Organization submittingOrganization;
    LifeCycleManager lifeCycleManager;
    transient boolean isRetrieved = false;
    transient boolean isLoaded = false;
    transient boolean isNew = true;
    transient boolean isModified = false;
    transient boolean isDeleted = false;
    transient String serviceId;
    RegistryService registryService;
    transient boolean areAssociationsLoaded = false;
    UDDIObjectCache objectManager;

    public RegistryObjectImpl() {
    }

    public RegistryObjectImpl(Key key) {
        this();
        this.key = key;
    }

    public RegistryObjectImpl(Key key, String description, String name) {
        this(key);
        this.description = new InternationalStringImpl(description);
        this.name = new InternationalStringImpl(name);
    }

    @Override
    public void addSlot(Slot slot) throws JAXRException {
        super.addSlot(slot);
        this.setIsModified(true);
    }

    @Override
    public void addSlots(Collection slots) throws JAXRException {
        super.addSlots(slots);
        this.setIsModified(true);
    }

    @Override
    public void removeSlot(String slotName) throws JAXRException {
        super.removeSlot(slotName);
        this.setIsModified(true);
    }

    @Override
    public void removeSlots(Collection slotNames) throws JAXRException {
        super.removeSlots(slotNames);
        this.setIsModified(true);
    }

    public void addAssociation(Association association) throws JAXRException {
        if (association == null) {
            return;
        }
        association.setSourceObject((RegistryObject)this);
        this.associations.add(association);
        this.setIsModified(true);
    }

    public void addAssociations(Collection associations) throws JAXRException {
        if (associations == null) {
            return;
        }
        Iterator iter = associations.iterator();
        try {
            while (iter.hasNext()) {
                this.addAssociation((Association)iter.next());
            }
        }
        catch (ClassCastException e) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:Objects_in_collection_must_be_Associations"), (Throwable)e);
        }
        this.setIsModified(true);
    }

    public void removeAssociation(Association association) throws JAXRException {
        if (association != null) {
            this.associations.remove(association);
            this.setIsModified(true);
        }
    }

    public void removeAssociations(Collection associations) throws JAXRException {
        if (associations != null) {
            this.associations.removeAll(associations);
            this.setIsModified(true);
        }
    }

    public Collection getAssociations() throws JAXRException {
        if (this.associations.isEmpty()) {
            if (this instanceof Organization) {
                this.getOrganizationAssociations();
            } else {
                this.getObject();
            }
        }
        return (Collection)this.associations.clone();
    }

    public void setAssociations(Collection associations) throws JAXRException {
        this.associations.clear();
        this.addAssociations(associations);
        this.setIsModified(true);
    }

    public void setAssociationsLoaded(boolean loaded) {
        this.areAssociationsLoaded = loaded;
    }

    public boolean areAssociationsLoaded() {
        return this.areAssociationsLoaded;
    }

    public void addClassification(Classification classification) throws JAXRException {
        if (classification == null) {
            return;
        }
        this.getObject();
        classification.setClassifiedObject((RegistryObject)this);
        this.classifications.add(classification);
        this.setIsModified(true);
    }

    public void addClassifications(Collection classifications) throws JAXRException {
        if (classifications == null) {
            return;
        }
        Iterator iter = classifications.iterator();
        try {
            while (iter.hasNext()) {
                this.addClassification((Classification)iter.next());
            }
        }
        catch (ClassCastException e) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:Objects_in_collection_must_be_Classifiations"), (Throwable)e);
        }
        this.setIsModified(true);
    }

    public void removeClassification(Classification classification) throws JAXRException {
        if (classification != null) {
            this.getObject();
            this.classifications.remove(classification);
            this.setIsModified(true);
        }
    }

    public void removeClassifications(Collection classifications) throws JAXRException {
        if (classifications != null) {
            this.getObject();
            this.classifications.removeAll(classifications);
            this.setIsModified(true);
        }
    }

    public Collection getClassifications() throws JAXRException {
        if (this.classifications.isEmpty()) {
            this.getObject();
        }
        return (Collection)this.classifications.clone();
    }

    public void setClassifications(Collection classifications) throws JAXRException {
        this.getObject();
        this.classifications.clear();
        this.addClassifications(classifications);
        this.setIsModified(true);
    }

    public void addExternalIdentifier(ExternalIdentifier identifier) throws JAXRException {
        if (identifier == null) {
            return;
        }
        this.getObject();
        ((ExternalIdentifierImpl)identifier).setRegistryObject(this);
        this.externalIdentifiers.add(identifier);
        this.setIsModified(true);
    }

    public void addExternalIdentifiers(Collection identifiers) throws JAXRException {
        if (identifiers == null) {
            return;
        }
        Iterator iter = identifiers.iterator();
        try {
            while (iter.hasNext()) {
                this.addExternalIdentifier((ExternalIdentifier)iter.next());
            }
        }
        catch (ClassCastException e) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:Objects_in_collection_must_be_ExternalIdentifers"), (Throwable)e);
        }
        this.setIsModified(true);
    }

    public void removeExternalIdentifier(ExternalIdentifier externalIdentifier) throws JAXRException {
        if (externalIdentifier != null) {
            this.getObject();
            this.externalIdentifiers.remove(externalIdentifier);
            this.setIsModified(true);
        }
    }

    public void removeExternalIdentifiers(Collection externalIdentifiers) throws JAXRException {
        if (externalIdentifiers != null) {
            this.getObject();
            this.externalIdentifiers.removeAll(externalIdentifiers);
            this.setIsModified(true);
        }
    }

    public Collection getExternalIdentifiers() throws JAXRException {
        if (this.externalIdentifiers.isEmpty()) {
            this.getObject();
        }
        return (Collection)this.externalIdentifiers.clone();
    }

    public void setExternalIdentifiers(Collection externalIdentifiers) throws JAXRException {
        this.getObject();
        this.externalIdentifiers.clear();
        this.addExternalIdentifiers(externalIdentifiers);
        this.setIsModified(true);
    }

    public void addExternalLink(ExternalLink link) throws JAXRException {
        throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:ExternalLinks_may_be_added_only_to_Organization,_Concept,_ClassificationScheme,_and_SpecificationLink"));
    }

    public void addExternalLinks(Collection links) throws JAXRException {
        throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:ExternalLinks_may_be_added_only_to_Organization,_Concept,_ClassificationScheme,_and_SpecificationLink"));
    }

    public void removeExternalLink(ExternalLink externalLink) throws JAXRException {
        if (externalLink != null) {
            this.getObject();
            this.externalLinks.remove(externalLink);
            this.setIsModified(true);
        }
    }

    public void removeExternalLinks(Collection externalLinks) throws JAXRException {
        if (externalLinks != null) {
            this.getObject();
            this.externalLinks.removeAll(externalLinks);
            this.setIsModified(true);
        }
    }

    public Collection getExternalLinks() throws JAXRException {
        if (this.externalLinks.isEmpty()) {
            this.getObject();
        }
        return (Collection)this.externalLinks.clone();
    }

    public void setExternalLinks(Collection links) throws JAXRException {
        throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:ExternalLinks_may_be_added_only_to_Organization,_Concept,_ClassificationScheme,_and_SpecificationLink"));
    }

    public InternationalString getDescription() throws JAXRException {
        String value = this.description.getValue();
        if (value == null || value.equals("")) {
            this.getObject();
        }
        return this.description;
    }

    public void setDescription(InternationalString description) throws JAXRException {
        if (description != null) {
            this.getObject();
            this.description = description;
        } else {
            this.description = new InternationalStringImpl();
        }
        this.setIsModified(true);
    }

    public InternationalString getName() throws JAXRException {
        String value = this.name.getValue();
        if (value == null || value.equals("")) {
            this.getObject();
        }
        return this.name;
    }

    public void setName(InternationalString name) throws JAXRException {
        if (name != null) {
            this.getObject();
            this.name = name;
        } else {
            this.name = new InternationalStringImpl();
        }
        this.setIsModified(true);
    }

    public Key getKey() throws JAXRException {
        return this.key;
    }

    public void setKey(Key key) throws JAXRException {
        this.key = key;
        this.setIsModified(true);
    }

    public Organization getSubmittingOrganization() throws JAXRException {
        if (this.submittingOrganization == null) {
            this.getObject();
        }
        return this.submittingOrganization;
    }

    public void setSubmittingOrganization(Organization org) throws JAXRException {
        this.submittingOrganization = org;
    }

    public Connection getConnection() throws JAXRException {
        if (this.lifeCycleManager != null) {
            RegistryServiceImpl rService = (RegistryServiceImpl)this.lifeCycleManager.getRegistryService();
            return rService != null ? rService.getConnection() : null;
        }
        return null;
    }

    public LifeCycleManager getLifeCycleManager() {
        return this.lifeCycleManager;
    }

    public void setLifeCycleManager(LifeCycleManager manager) {
        this.lifeCycleManager = manager;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setRegistryService(RegistryService service) {
        this.registryService = service;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public synchronized void setStatusFlags(boolean retrieved, boolean loaded, boolean isNew) {
        this.isRetrieved = retrieved;
        this.isLoaded = loaded;
        this.isNew = isNew;
    }

    public synchronized boolean isLoaded() {
        return this.isLoaded;
    }

    public synchronized void setIsLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    public synchronized boolean isRetrieved() {
        return this.isRetrieved;
    }

    public synchronized void setIsRetrieved(boolean retrieved) {
        this.isDeleted = false;
        this.isRetrieved = retrieved;
    }

    public synchronized boolean isNew() {
        return this.isNew;
    }

    public synchronized void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setIsModified(boolean modified) {
        this.isModified = modified;
    }

    public synchronized boolean isDeleted() {
        return this.isDeleted;
    }

    public synchronized void setIsDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    void getObject() throws JAXRException {
        if (this.isDeleted()) {
            return;
        }
        if (this.isRetrieved() && !this.isLoaded()) {
            if (this.objectManager == null) {
                this.objectManager = this.getObjectManager();
            }
            if (this.objectManager == null) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:Can_not_obtain_Object_detail"));
            }
            this.objectManager.fetchObject(this, this.serviceId);
        }
    }

    UDDIObjectCache getObjectManager() throws JAXRException {
        if (this.registryService == null && this.lifeCycleManager != null) {
            this.registryService = this.lifeCycleManager.getRegistryService();
        }
        if (this.registryService != null) {
            this.objectManager = ((RegistryServiceImpl)this.registryService).getObjectManager();
        }
        return this.objectManager;
    }

    void getOrganizationAssociations() throws JAXRException {
        if (this.isDeleted() || this.isNew()) {
            return;
        }
        if (this.isRetrieved() && !this.areAssociationsLoaded()) {
            if (this.objectManager == null) {
                this.objectManager = this.getObjectManager();
            }
            if (this.objectManager != null) {
                this.objectManager.fetchAssociations(this, this.serviceId);
            }
        }
    }

    int getSequenceId(ExternalLink link) {
        return this.externalLinks.indexOf(link);
    }

    public String toXML() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public Collection getAssociatedObjects() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public Concept getObjectType() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void setObjectType(Concept objectType) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public Collection getAuditTrail() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public Collection getRegistryPackages() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }
}

