/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.config.ConfigSupportImpl;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.DeploymentHelper;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.TargetServer;
import org.netbeans.modules.j2ee.deployment.impl.projects.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class DeployOnSaveManager {
    private static final Logger LOGGER = Logger.getLogger(DeployOnSaveManager.class.getName());
    private static final int DELAY = 300;
    private static final int PROGRESS_DELAY = 200;
    private static DeployOnSaveManager instance;
    private final WeakHashMap<J2eeModuleProvider, CompileOnSaveListener> compileListeners = new WeakHashMap();
    private final WeakHashMap<J2eeModuleProvider, CopyOnSaveListener> copyListeners = new WeakHashMap();
    private final WeakHashMap<J2eeModuleProvider, Object> suspended = new WeakHashMap();
    private final WeakHashMap<J2eeModuleProvider, List<J2eeModuleProvider.ConfigSupport.DeployOnSaveListener>> projectListeners = new WeakHashMap();
    private final ExecutorService EXECUTOR = Executors.newFixedThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    });
    private Map<J2eeModuleProvider, Set<ArtifactListener.Artifact>> toDeploy = new HashMap<J2eeModuleProvider, Set<ArtifactListener.Artifact>>();
    private Map<J2eeModuleProvider, DeploymentState> lastDeploymentStates = new HashMap<J2eeModuleProvider, DeploymentState>();
    private Future<?> current;

    private DeployOnSaveManager() {
    }

    public static synchronized DeployOnSaveManager getDefault() {
        if (instance == null) {
            instance = new DeployOnSaveManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening(J2eeModuleProvider j2eeProvider) {
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            if (this.compileListeners.containsKey(j2eeProvider)) {
                if (j2eeProvider instanceof J2eeApplicationProvider) {
                    this.stopListening(j2eeProvider);
                } else {
                    LOGGER.log(Level.FINE, "Already listening on {0}", j2eeProvider);
                    return;
                }
            }
            ArrayList<J2eeModuleProvider> providers = new ArrayList<J2eeModuleProvider>(4);
            providers.add(j2eeProvider);
            if (j2eeProvider instanceof J2eeApplicationProvider) {
                Collections.addAll(providers, ((J2eeApplicationProvider)j2eeProvider).getChildModuleProviders());
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (J2eeModuleProvider j2eeModuleProvider : providers) {
                for (FileObject file : j2eeModuleProvider.getSourceFileMap().getSourceRoots()) {
                    URL url = URLMapper.findURL((FileObject)file, (int)1);
                    if (url == null) continue;
                    urls.add(url);
                }
            }
            CompileOnSaveListener listener = new CompileOnSaveListener(j2eeProvider, urls);
            for (URL url : urls) {
                BuildArtifactMapper.addArtifactsUpdatedListener((URL)url, (BuildArtifactMapper.ArtifactsUpdated)listener);
            }
            this.compileListeners.put(j2eeProvider, listener);
            J2eeModuleProvider.DeployOnSaveSupport deployOnSaveSupport = j2eeProvider.getDeployOnSaveSupport();
            if (deployOnSaveSupport != null) {
                CopyOnSaveListener copyListener = new CopyOnSaveListener(j2eeProvider);
                deployOnSaveSupport.addArtifactListener(copyListener);
                this.copyListeners.put(j2eeProvider, copyListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening(J2eeModuleProvider j2eeProvider) {
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            CompileOnSaveListener removed = this.compileListeners.remove(j2eeProvider);
            if (removed == null) {
                LOGGER.log(Level.FINE, "Not compile-listening on {0}", j2eeProvider);
            } else {
                for (URL url : removed.getRegistered()) {
                    BuildArtifactMapper.removeArtifactsUpdatedListener((URL)url, (BuildArtifactMapper.ArtifactsUpdated)removed);
                }
            }
            CopyOnSaveListener copyRemoved = this.copyListeners.remove(j2eeProvider);
            if (removed == null) {
                LOGGER.log(Level.FINE, "Not copy-listening on {0}", j2eeProvider);
            } else {
                J2eeModuleProvider.DeployOnSaveSupport support = j2eeProvider.getDeployOnSaveSupport();
                if (support != null) {
                    support.removeArtifactListener(copyRemoved);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendListening(J2eeModuleProvider provider) {
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            this.suspended.put(provider, new Object());
            LOGGER.log(Level.FINE, "Listening suspended for {0}", provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeListening(final J2eeModuleProvider provider) {
        boolean resume = false;
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            resume = this.suspended.containsKey(provider);
        }
        if (resume) {
            FileObject fo = ((ConfigSupportImpl)provider.getConfigSupport()).getProjectDirectory();
            FileUtil.refreshAll();
            try {
                FileSystem fs = fo != null ? fo.getFileSystem() : FileUtil.getConfigRoot().getFileSystem();
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        DeployOnSaveManager.this.clearSuspended(provider);
                    }
                });
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
                this.clearSuspended(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSuspended(J2eeModuleProvider provider) {
        Object prev = null;
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            prev = this.suspended.remove(provider);
        }
        if (LOGGER.isLoggable(Level.FINE) && prev != null) {
            LOGGER.log(Level.FINE, "Resuming listening for {0}", provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeployOnSaveListener(J2eeModuleProvider provider, J2eeModuleProvider.ConfigSupport.DeployOnSaveListener listener) {
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            List<J2eeModuleProvider.ConfigSupport.DeployOnSaveListener> listeners = this.projectListeners.get(provider);
            if (listeners == null) {
                listeners = new ArrayList<J2eeModuleProvider.ConfigSupport.DeployOnSaveListener>();
                this.projectListeners.put(provider, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeployOnSaveListener(J2eeModuleProvider provider, J2eeModuleProvider.ConfigSupport.DeployOnSaveListener listener) {
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            List<J2eeModuleProvider.ConfigSupport.DeployOnSaveListener> listeners = this.projectListeners.get(provider);
            if (listeners == null) {
                return;
            }
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.projectListeners.remove(provider);
            }
        }
    }

    public static boolean isServerStateSupported(ServerInstance si) {
        return si.isRunning() && !si.isSuspended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInitialDeployment(J2eeModuleProvider provider) {
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            if (this.compileListeners.containsKey(provider) && provider instanceof J2eeApplicationProvider) {
                this.startListening(provider);
            }
            if (!this.lastDeploymentStates.containsKey(provider)) {
                this.lastDeploymentStates.put(provider, DeploymentState.MODULE_UPDATED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitChangedArtifacts(J2eeModuleProvider provider, Iterable<ArtifactListener.Artifact> artifacts) {
        assert (provider != null);
        assert (artifacts != null);
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            if (this.suspended.containsKey(provider)) {
                return;
            }
            Set<ArtifactListener.Artifact> preparedArtifacts = this.toDeploy.get(provider);
            if (preparedArtifacts == null) {
                preparedArtifacts = new HashSet<ArtifactListener.Artifact>();
                this.toDeploy.put(provider, preparedArtifacts);
            }
            for (ArtifactListener.Artifact artifact : artifacts) {
                preparedArtifacts.add(artifact);
            }
            boolean delayed = false;
            if (this.current != null && !this.current.isDone()) {
                this.current.cancel(false);
                delayed = true;
            }
            this.current = this.EXECUTOR.submit(new DeployTask(delayed));
        }
    }

    private static final class CompileOnSaveListener
    implements BuildArtifactMapper.ArtifactsUpdated {
        private final WeakReference<J2eeModuleProvider> provider;
        private final List<URL> registered;

        public CompileOnSaveListener(J2eeModuleProvider provider, List<URL> registered) {
            this.provider = new WeakReference<J2eeModuleProvider>(provider);
            this.registered = registered;
        }

        public List<URL> getRegistered() {
            return this.registered;
        }

        public void artifactsUpdated(Iterable<File> artifacts) {
            J2eeModuleProvider realProvider = (J2eeModuleProvider)this.provider.get();
            if (realProvider == null) {
                return;
            }
            J2eeModuleProvider.DeployOnSaveClassInterceptor interceptor = realProvider.getDeployOnSaveClassInterceptor();
            HashSet<ArtifactListener.Artifact> realArtifacts = new HashSet<ArtifactListener.Artifact>();
            for (File file : artifacts) {
                if (file == null) continue;
                ArtifactListener.Artifact a = ArtifactListener.Artifact.forFile(file);
                if (interceptor != null) {
                    a = interceptor.convert(a);
                }
                realArtifacts.add(a);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                for (ArtifactListener.Artifact artifact : realArtifacts) {
                    LOGGER.log(Level.FINE, "Delivered compile artifact: {0}", artifact);
                }
            }
            DeployOnSaveManager.getDefault().submitChangedArtifacts(realProvider, realArtifacts);
        }
    }

    private static final class CopyOnSaveListener
    implements ArtifactListener {
        private final WeakReference<J2eeModuleProvider> provider;

        public CopyOnSaveListener(J2eeModuleProvider provider) {
            this.provider = new WeakReference<J2eeModuleProvider>(provider);
        }

        @Override
        public void artifactsUpdated(Iterable<ArtifactListener.Artifact> artifacts) {
            J2eeModuleProvider realProvider;
            if (LOGGER.isLoggable(Level.FINE)) {
                for (ArtifactListener.Artifact artifact : artifacts) {
                    LOGGER.log(Level.FINE, "Delivered copy artifact: {0}", artifact);
                }
            }
            if ((realProvider = (J2eeModuleProvider)this.provider.get()) != null) {
                DeployOnSaveManager.getDefault().submitChangedArtifacts(realProvider, artifacts);
            }
        }
    }

    public static enum DeploymentState {
        MODULE_NOT_DEPLOYED,
        MODULE_UPDATED,
        DEPLOYMENT_FAILED,
        SERVER_STATE_UNSUPPORTED;

    }

    private class DeployTask
    implements Runnable {
        private final boolean delayed;

        public DeployTask(boolean delayed) {
            this.delayed = delayed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map deployNow;
            if (this.delayed) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    return;
                }
            }
            LOGGER.log(Level.FINE, "Performing pending deployments");
            HashMap listeners = new HashMap();
            DeployOnSaveManager deployOnSaveManager = DeployOnSaveManager.this;
            synchronized (deployOnSaveManager) {
                if (DeployOnSaveManager.this.toDeploy.isEmpty()) {
                    return;
                }
                deployNow = DeployOnSaveManager.this.toDeploy;
                DeployOnSaveManager.this.toDeploy = new HashMap();
                for (Map.Entry entry : DeployOnSaveManager.this.projectListeners.entrySet()) {
                    if (!deployNow.containsKey(entry.getKey())) continue;
                    listeners.put((J2eeModuleProvider)entry.getKey(), new ArrayList((Collection)entry.getValue()));
                }
            }
            for (Map.Entry entry : deployNow.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                try {
                    boolean updated = this.notifyServer((J2eeModuleProvider)entry.getKey(), (Iterable)entry.getValue());
                    if (!updated) continue;
                    this.runJPDAAppReloaded();
                    List toFire = (List)listeners.get(entry.getKey());
                    if (toFire == null) continue;
                    for (J2eeModuleProvider.ConfigSupport.DeployOnSaveListener listener : toFire) {
                        listener.deployed((Iterable)entry.getValue());
                    }
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, null, t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean notifyServer(J2eeModuleProvider provider, Iterable<ArtifactListener.Artifact> artifacts) {
            DeploymentState state;
            DeploymentState lastState;
            if (LOGGER.isLoggable(Level.FINEST)) {
                StringBuilder builder = new StringBuilder("Artifacts updated: [");
                for (ArtifactListener.Artifact artifact : artifacts) {
                    builder.append(artifact.getFile().getAbsolutePath()).append(",");
                }
                builder.setLength(builder.length() - 1);
                builder.append("]");
                LOGGER.log(Level.FINEST, builder.toString());
            }
            try {
                this.distributeOnSave(FileUtil.toFile((FileObject)provider.getJ2eeModule().getContentDirectory()), artifacts);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            String instanceID = provider.getServerInstanceID();
            ServerInstance inst = ServerRegistry.getInstance().getServerInstance(instanceID);
            if (inst == null && "DEV-NULL".equals(instanceID)) {
                LOGGER.log(Level.INFO, "No server set for Maven project - Deploy on Save will not be performed");
                return false;
            }
            if (null == inst) {
                LOGGER.log(Level.INFO, "Project''s server {0} is not registered - Deploy on Save will not be performed", instanceID);
                return false;
            }
            DeployTask deployTask = this;
            synchronized (deployTask) {
                lastState = (DeploymentState)((Object)DeployOnSaveManager.this.lastDeploymentStates.get(provider));
                if (lastState == null) {
                    lastState = DeploymentState.MODULE_NOT_DEPLOYED;
                }
            }
            DeploymentTarget deploymentTarget = new DeploymentTarget(provider, null);
            TargetServer server = new TargetServer(deploymentTarget);
            if (lastState == null || lastState == DeploymentState.DEPLOYMENT_FAILED || lastState == DeploymentState.SERVER_STATE_UNSUPPORTED && DeployOnSaveManager.isServerStateSupported(deploymentTarget.getServer().getServerInstance())) {
                ProgressUI ui = new ProgressUI(NbBundle.getMessage(TargetServer.class, (String)"MSG_DeployOnSave", (Object)provider.getDeploymentName()), false);
                ui.start(200);
                try {
                    DeploymentHelper.deployServerLibraries(provider);
                    DeploymentHelper.deployDatasources(provider);
                    DeploymentHelper.deployMessageDestinations(provider);
                    TargetModule[] modules = server.deploy(ui, true);
                    if (modules == null || modules.length <= 0) {
                        state = DeploymentState.DEPLOYMENT_FAILED;
                    }
                    state = DeploymentState.MODULE_UPDATED;
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    state = DeploymentState.DEPLOYMENT_FAILED;
                }
                catch (ServerException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    state = DeploymentState.DEPLOYMENT_FAILED;
                }
                catch (ConfigurationException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    state = DeploymentState.DEPLOYMENT_FAILED;
                }
                catch (DatasourceAlreadyExistsException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    state = DeploymentState.DEPLOYMENT_FAILED;
                }
                catch (TargetServer.NoArchiveException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    state = DeploymentState.DEPLOYMENT_FAILED;
                }
                finally {
                    ui.finish();
                }
            } else {
                state = server.notifyArtifactsUpdated(provider, artifacts);
                if (state == DeploymentState.SERVER_STATE_UNSUPPORTED && lastState == DeploymentState.MODULE_NOT_DEPLOYED) {
                    state = DeploymentState.MODULE_NOT_DEPLOYED;
                }
            }
            if (state == DeploymentState.MODULE_UPDATED) {
                deploymentTarget.getServer().getServerInstance().notifyUpdated(artifacts);
            }
            String message = null;
            switch (state) {
                case MODULE_UPDATED: {
                    message = NbBundle.getMessage(DeployOnSaveManager.class, (String)"MSG_DeployOnSave_Deployed", (Object)provider.getDeploymentName());
                    break;
                }
                case DEPLOYMENT_FAILED: {
                    message = NbBundle.getMessage(DeployOnSaveManager.class, (String)"MSG_DeployOnSave_Failed", (Object)provider.getDeploymentName());
                    break;
                }
                case SERVER_STATE_UNSUPPORTED: {
                    message = NbBundle.getMessage(DeployOnSaveManager.class, (String)"MSG_DeployOnSave_Unsupported", (Object)provider.getDeploymentName());
                    break;
                }
                default: {
                    message = null;
                }
            }
            if (message != null) {
                StatusDisplayer.getDefault().setStatusText(message);
            }
            LOGGER.log(Level.FINE, "Deployment state {0}", (Object)state);
            DeployTask deployTask2 = this;
            synchronized (deployTask2) {
                DeployOnSaveManager.this.lastDeploymentStates.put(provider, state);
            }
            return state == DeploymentState.MODULE_UPDATED;
        }

        private void runJPDAAppReloaded() {
            String reloadedClassName = (String)IntrospectedInfo.getKnownInfo().getDefs("task").get("nbjpdaappreloaded");
            if (reloadedClassName == null) {
                return;
            }
            String reloadedPackageName = reloadedClassName.substring(0, reloadedClassName.lastIndexOf(46));
            try {
                Map customDefClassLoaders = (Map)((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.apache.tools.ant.module.bridge.AntBridge").getMethod("getCustomDefClassLoaders", new Class[0]).invoke(null, new Object[0]);
                ClassLoader reloadedClassLoader = (ClassLoader)customDefClassLoaders.get(reloadedPackageName);
                if (reloadedClassLoader != null) {
                    Class<?> reloadedClass = reloadedClassLoader.loadClass(reloadedClassName);
                    reloadedClass.getMethod("execute", new Class[0]).invoke(reloadedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void distributeOnSave(File destDir, Iterable<ArtifactListener.Artifact> artifacts) throws IOException {
            try {
                FileObject destRoot = FileUtil.createFolder((File)destDir);
                Enumeration destFiles = destRoot.getChildren(true);
                HashMap<String, FileObject> destMap = new HashMap<String, FileObject>();
                int rootPathLen = destRoot.getPath().length();
                while (destFiles.hasMoreElements()) {
                    FileObject destFO = (FileObject)destFiles.nextElement();
                    destMap.put(destFO.getPath().substring(rootPathLen + 1), destFO);
                }
                FileObject contentDirectory = destRoot;
                assert (contentDirectory != null);
                for (ArtifactListener.Artifact artifact : artifacts) {
                    File fsFile = artifact.getFile();
                    File altDistFile = artifact.getDistributionPath();
                    if (altDistFile == null) {
                        String classes = "target" + File.separator + "classes";
                        String filePath = artifact.getFile().getPath();
                        String altDistRelativePath = filePath.substring(filePath.indexOf(classes) + classes.length());
                        altDistFile = new File(destRoot.getPath() + File.separator + "WEB-INF" + File.separator + "classes" + altDistRelativePath);
                    }
                    FileObject file = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)fsFile));
                    FileObject checkFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)altDistFile));
                    if (checkFile == null && file != null) {
                        checkFile = FileUtil.createData((File)altDistFile);
                    }
                    if (checkFile != null && file != null) {
                        String relative = FileUtil.getRelativePath((FileObject)contentDirectory, (FileObject)checkFile);
                        if (relative == null) continue;
                        FileObject targetFO = (FileObject)destMap.get(relative);
                        if (file.isFolder()) {
                            destMap.remove(relative);
                        }
                        this.createOrReplace(file, targetFO, destRoot, relative, destMap, false);
                        continue;
                    }
                    if (checkFile == null || file != null) continue;
                    checkFile.delete();
                }
            }
            catch (Exception e) {
                String msg = NbBundle.getMessage(DeployOnSaveManager.class, (String)"MSG_IncrementalDeployFailed", (Object)e);
                throw new RuntimeException(msg, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createOrReplace(FileObject sourceFO, FileObject targetFO, FileObject destRoot, String relativePath, Map<String, FileObject> destMap, boolean checkTimeStamps) throws IOException {
            block37: {
                OutputStream destStream = null;
                InputStream sourceStream = null;
                try {
                    FileObject destFolder;
                    if (targetFO == null) {
                        targetFO = destRoot.getFileObject(relativePath);
                    }
                    if (targetFO == null) {
                        destFolder = this.findOrCreateParentFolder(destRoot, relativePath);
                    } else {
                        destMap.remove(relativePath);
                        if (checkTimeStamps && !sourceFO.lastModified().after(targetFO.lastModified())) {
                            return;
                        }
                        if (targetFO.equals(sourceFO)) {
                            return;
                        }
                        destFolder = targetFO.getParent();
                        destStream = targetFO.getOutputStream();
                    }
                    if (sourceFO.isFolder()) {
                        FileUtil.createFolder((FileObject)destFolder, (String)sourceFO.getNameExt());
                        return;
                    }
                    try {
                        if (null == destStream) {
                            FileUtil.copyFile((FileObject)sourceFO, (FileObject)destFolder, (String)sourceFO.getName());
                            break block37;
                        }
                        sourceStream = sourceFO.getInputStream();
                        FileUtil.copy((InputStream)sourceStream, (OutputStream)destStream);
                    }
                    catch (FileNotFoundException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                }
                finally {
                    if (null != sourceStream) {
                        try {
                            sourceStream.close();
                        }
                        catch (IOException ioe) {
                            LOGGER.log(Level.WARNING, null, ioe);
                        }
                    }
                    if (null != destStream) {
                        try {
                            destStream.close();
                        }
                        catch (IOException ioe) {
                            LOGGER.log(Level.WARNING, null, ioe);
                        }
                    }
                }
            }
        }

        private FileObject findOrCreateParentFolder(FileObject dest, String relativePath) throws IOException {
            File parentRelativePath = new File(relativePath).getParentFile();
            if (parentRelativePath == null) {
                return dest;
            }
            FileObject folder = FileUtil.createFolder((FileObject)dest, (String)parentRelativePath.getPath());
            if (folder.isData()) {
                LOGGER.log(Level.FINER, "found file {0} when a folder was expecetd", folder.getPath());
                folder = null;
            }
            return folder;
        }
    }
}

