/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.ProtectedPart;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.gui.editor.autocompleter.AutoCompleterListView;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.OStrings;
import org.omegat.util.TagUtil;
import org.omegat.util.Token;

public class TagAutoCompleterView
extends AutoCompleterListView {
    private static final ITokenizer TAG_TOKENIZER = new TagTokenizer();

    public TagAutoCompleterView() {
        super(OStrings.getString("AC_TAG_VIEW"));
    }

    @Override
    public List<AutoCompleterItem> computeListData(String prevText, boolean contextualOnly) {
        String wordChunk = this.getLastToken(prevText);
        List<String> missingGroups = TagUtil.getGroupedMissingTagsFromTarget();
        for (TagUtil.Tag tag : TagUtil.getAllTagsInSource()) {
            if (!tag.tag.equals(wordChunk)) continue;
            wordChunk = "";
            break;
        }
        ArrayList<String> matchGroups = new ArrayList<String>();
        if (!"".equals(wordChunk)) {
            for (String g : missingGroups) {
                if (!g.startsWith(wordChunk)) continue;
                matchGroups.add(g);
            }
        }
        if (matchGroups.isEmpty() && !contextualOnly) {
            return TagAutoCompleterView.convertList(missingGroups, 0);
        }
        return TagAutoCompleterView.convertList(matchGroups, wordChunk.length());
    }

    private static List<AutoCompleterItem> convertList(List<String> list, int replacementLength) {
        ArrayList<AutoCompleterItem> result = new ArrayList<AutoCompleterItem>();
        for (String s : list) {
            int sep = s.indexOf("\ue100");
            String cleaned = s;
            String display = s;
            int adjustment = 0;
            boolean keepSelection = false;
            if (sep > -1) {
                cleaned = s.replace("\ue100", "");
                display = s.replace("\ue100", "|");
                adjustment = -(s.length() - 1 - sep);
                keepSelection = true;
            }
            result.add(new AutoCompleterItem(cleaned, new String[]{display}, adjustment, keepSelection, replacementLength));
        }
        return result;
    }

    @Override
    public ITokenizer getTokenizer() {
        return TAG_TOKENIZER;
    }

    @Override
    public String itemToString(AutoCompleterItem item) {
        return item.extras[0];
    }

    private static class TagTokenizer
    implements ITokenizer {
        private TagTokenizer() {
        }

        @Override
        public Token[] tokenizeWords(String str, ITokenizer.StemmingMode stemmingMode) {
            return this.tokenize(str);
        }

        @Override
        public String[] tokenizeWordsToStrings(String str, ITokenizer.StemmingMode stemmingMode) {
            return null;
        }

        @Override
        public Token[] tokenizeVerbatim(String str) {
            return this.tokenize(str);
        }

        @Override
        public String[] tokenizeVerbatimToStrings(String str) {
            return null;
        }

        private Token[] tokenize(String str) {
            String regex = this.buildRegex();
            if (regex == null) {
                return new Token[]{new Token(str, 0)};
            }
            String[] pieces = str.split(regex);
            Token[] tokens = new Token[pieces.length];
            int offset = 0;
            for (int i = 0; i < pieces.length; ++i) {
                tokens[i] = new Token(pieces[i], offset);
                offset += pieces[i].length();
            }
            return tokens;
        }

        private String buildRegex() {
            ProtectedPart[] protectedParts = Core.getEditor().getCurrentEntry().getProtectedParts();
            if (protectedParts.length == 0) {
                return null;
            }
            ArrayList<String> initials = new ArrayList<String>();
            for (ProtectedPart pp : protectedParts) {
                String part = pp.getTextInSourceSegment();
                String initial = part.substring(0, part.offsetByCodePoints(0, 1));
                if (initials.contains(initial)) continue;
                initials.add(initial);
            }
            StringBuilder regex = new StringBuilder("(?=");
            int max = initials.size();
            for (int i = 0; i < max; ++i) {
                regex.append(Pattern.quote((String)initials.get(i)));
                if (i + 1 >= max) continue;
                regex.append('|');
            }
            regex.append(')');
            return regex.toString();
        }

        @Override
        public String[] getSupportedLanguages() {
            return null;
        }
    }
}

