/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.KnownException;
import org.omegat.core.data.ProjectFactory;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.NearString;
import org.omegat.core.search.SearchMode;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.align.AlignFilePickerController;
import org.omegat.gui.dialogs.AboutDialog;
import org.omegat.gui.dialogs.GoToSegmentDialog;
import org.omegat.gui.dialogs.LastChangesDialog;
import org.omegat.gui.dialogs.LogDialog;
import org.omegat.gui.dialogs.VersionCheckDialog;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.SegmentExportImport;
import org.omegat.gui.filters2.FiltersCustomizerController;
import org.omegat.gui.issues.IssueProvidersSelectorController;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.preferences.PreferencesWindowController;
import org.omegat.gui.preferences.view.EditingBehaviorController;
import org.omegat.gui.search.SearchWindowController;
import org.omegat.gui.segmentation.SegmentationCustomizerController;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.help.Help;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.RecentProjects;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;

public final class MainWindowMenuHandler {
    private final MainWindow mainWindow;

    public MainWindowMenuHandler(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void projectNewMenuItemActionPerformed() {
        ProjectUICommands.projectCreate();
    }

    public void projectTeamNewMenuItemActionPerformed() {
        ProjectUICommands.projectTeamCreate();
    }

    public void projectOpenMenuItemActionPerformed() {
        ProjectUICommands.projectOpen(null);
    }

    public void projectClearRecentMenuItemActionPerformed() {
        RecentProjects.clear();
    }

    public void projectMedOpenMenuItemActionPerformed() {
        ProjectUICommands.projectOpenMED();
    }

    public void projectMedCreateMenuItemActionPerformed() {
        ProjectUICommands.projectCreateMED();
    }

    public void projectImportMenuItemActionPerformed() {
        ProjectUICommands.doPromptImportSourceFiles();
    }

    public void projectWikiImportMenuItemActionPerformed() {
        ProjectUICommands.doWikiImport();
    }

    public void projectReloadMenuItemActionPerformed() {
        ProjectUICommands.projectReload();
    }

    public void projectCloseMenuItemActionPerformed() {
        ProjectUICommands.projectClose();
    }

    public void projectSaveMenuItemActionPerformed() {
        ProjectUICommands.projectSave();
    }

    public void projectCompileMenuItemActionPerformed() {
        if (!this.checkTags()) {
            return;
        }
        ProjectUICommands.projectCompile();
    }

    private boolean checkTags() {
        List<ErrorReport> stes;
        if (Preferences.isPreference("tags_valid_required") && !(stes = Core.getTagValidation().listInvalidTags()).isEmpty()) {
            Core.getIssues().showAll(OStrings.getString("TF_MESSAGE_COMPILE"));
            return false;
        }
        return true;
    }

    public void projectCommitTargetFilesActionPerformed() {
        if (!this.checkTags()) {
            return;
        }
        ProjectUICommands.projectCompileAndCommit();
    }

    public void projectCommitSourceFilesActionPerformed() {
        ProjectUICommands.projectCommitSourceFiles();
    }

    public void projectSingleCompileMenuItemActionPerformed() {
        List<ErrorReport> stes;
        String midName = Core.getEditor().getCurrentFile();
        if (StringUtil.isEmpty(midName)) {
            return;
        }
        String sourcePattern = Pattern.quote(midName);
        if (Preferences.isPreference("tags_valid_required") && !(stes = Core.getTagValidation().listInvalidTags(sourcePattern)).isEmpty()) {
            Core.getIssues().showForFiles(midName, OStrings.getString("TF_MESSAGE_COMPILE"));
            return;
        }
        ProjectUICommands.projectSingleCompile(sourcePattern);
    }

    public void projectEditMenuItemActionPerformed() {
        ProjectUICommands.projectEditProperties();
    }

    public void viewFileListMenuItemActionPerformed() {
        if (this.mainWindow.projWin == null) {
            this.mainWindow.menu.viewFileListMenuItem.setSelected(false);
            return;
        }
        this.mainWindow.projWin.setActive(!this.mainWindow.projWin.isActive());
    }

    public void projectAccessRootMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getProjectRoot();
        this.openFile(new File(path));
    }

    public void projectAccessDictionaryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getDictRoot();
        this.openFile(new File(path));
    }

    public void projectAccessGlossaryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getGlossaryRoot();
        this.openFile(new File(path));
    }

    public void projectAccessSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getSourceRoot();
        this.openFile(new File(path));
    }

    public void projectAccessTargetMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getTargetRoot();
        this.openFile(new File(path));
    }

    public void projectAccessTMMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getTMRoot();
        this.openFile(new File(path));
    }

    public void projectAccessCurrentSourceDocumentMenuItemActionPerformed(int modifier) {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String root = Core.getProject().getProjectProperties().getSourceRoot();
        String path = Core.getEditor().getCurrentFile();
        if (StringUtil.isEmpty(path)) {
            return;
        }
        File toOpen = new File(root, path);
        if ((modifier & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            toOpen = toOpen.getParentFile();
        }
        this.openFile(toOpen);
    }

    public void projectAccessCurrentTargetDocumentMenuItemActionPerformed(int modifier) {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String root = Core.getProject().getProjectProperties().getTargetRoot();
        String path = Core.getEditor().getCurrentTargetFile();
        if (StringUtil.isEmpty(path)) {
            return;
        }
        File toOpen = new File(root, path);
        if ((modifier & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            toOpen = toOpen.getParentFile();
        }
        this.openFile(toOpen);
    }

    public void projectAccessWriteableGlossaryMenuItemActionPerformed(int modifier) {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getWriteableGlossary();
        if (StringUtil.isEmpty(path)) {
            return;
        }
        File toOpen = new File(path);
        if ((modifier & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            toOpen = toOpen.getParentFile();
        }
        this.openFile(toOpen);
    }

    private void openFile(File path) {
        try {
            path = path.getCanonicalFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!path.exists()) {
            Core.getMainWindow().showStatusMessageRB("LFC_ERROR_FILE_DOESNT_EXIST", path);
            return;
        }
        try {
            Desktop.getDesktop().open(path);
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "RPF_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(ex, "RPF_ERROR", new Object[0]);
        }
    }

    public void projectExitMenuItemActionPerformed() {
        if (Core.getProject().isProjectLoaded()) {
            Core.getEditor().commitAndLeave();
        }
        boolean projectModified = false;
        if (Core.getProject().isProjectLoaded()) {
            projectModified = Core.getProject().isProjectModified();
        }
        if ((projectModified || Preferences.isPreference("always_confirm_quit")) && 0 != JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_QUIT_CONFIRM"), OStrings.getString("CONFIRM_DIALOG_TITLE"), 0)) {
            return;
        }
        SegmentExportImport.flushExportedSegments();
        new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                if (Core.getProject().isProjectLoaded()) {
                    ISpellChecker sc = Core.getSpellChecker();
                    sc.saveWordLists();
                    try {
                        Core.executeExclusively(true, () -> {
                            Core.getProject().saveProject(true);
                            ProjectFactory.closeProject();
                        });
                    }
                    catch (KnownException knownException) {
                        // empty catch block
                    }
                }
                CoreEvents.fireApplicationShutdown();
                PluginUtils.unloadPlugins();
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    MainWindowUI.saveScreenLayout(MainWindowMenuHandler.this.mainWindow);
                    Preferences.save();
                    System.exit(0);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public void editUndoMenuItemActionPerformed() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == Core.getNotes()) {
            Core.getNotes().undo();
        } else {
            Core.getEditor().undo();
        }
    }

    public void editRedoMenuItemActionPerformed() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == Core.getNotes()) {
            Core.getNotes().redo();
        } else {
            Core.getEditor().redo();
        }
    }

    public void editOverwriteTranslationMenuItemActionPerformed() {
        this.mainWindow.doRecycleTrans();
    }

    public void editInsertTranslationMenuItemActionPerformed() {
        this.mainWindow.doInsertTrans();
    }

    public void editOverwriteMachineTranslationMenuItemActionPerformed() {
        String tr = Core.getMachineTranslatePane().getDisplayedTranslation();
        if (tr == null) {
            Core.getMachineTranslatePane().forceLoad();
        } else if (!StringUtil.isEmpty(tr)) {
            Core.getEditor().replaceEditText(tr);
        }
    }

    public void editOverwriteSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String toInsert = Core.getEditor().getCurrentEntry().getSrcText();
        if (Preferences.isPreference("glossary_replace_on_insert")) {
            toInsert = EditorUtils.replaceGlossaryEntries(toInsert);
        }
        Core.getEditor().replaceEditText(toInsert);
    }

    public void editInsertSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String toInsert = Core.getEditor().getCurrentEntry().getSrcText();
        if (Preferences.isPreference("glossary_replace_on_insert")) {
            toInsert = EditorUtils.replaceGlossaryEntries(toInsert);
        }
        Core.getEditor().insertText(toInsert);
    }

    public void editExportSelectionMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String selection = Core.getEditor().getSelectedText();
        if (selection == null) {
            SourceTextEntry ste = Core.getEditor().getCurrentEntry();
            TMXEntry te = Core.getProject().getTranslationInfo(ste);
            selection = te.isTranslated() ? te.translation : ste.getSrcText();
        }
        SegmentExportImport.exportCurrentSelection(selection);
    }

    public void editSearchDictionaryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String selection = Core.getEditor().getSelectedText();
        if (selection == null) {
            SourceTextEntry ste = Core.getEditor().getCurrentEntry();
            selection = ste.getSrcText();
        }
        Core.getDictionaries().searchText(selection);
    }

    public void editCreateGlossaryEntryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getGlossary().showCreateGlossaryEntryDialog(Core.getMainWindow().getApplicationFrame());
    }

    public void editFindInProjectMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        SearchWindowController search = new SearchWindowController(SearchMode.SEARCH);
        this.mainWindow.addSearchWindow(search);
        search.makeVisible(this.getTrimmedSelectedTextInMainWindow());
    }

    void findInProjectReuseLastWindow() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        List<SearchWindowController> windows = this.mainWindow.getSearchWindows();
        for (int i = windows.size() - 1; i >= 0; --i) {
            SearchWindowController swc = windows.get(i);
            if (swc.getMode() != SearchMode.SEARCH) continue;
            swc.makeVisible(this.getTrimmedSelectedTextInMainWindow());
            return;
        }
        this.editFindInProjectMenuItemActionPerformed();
    }

    public void editReplaceInProjectMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        SearchWindowController search = new SearchWindowController(SearchMode.REPLACE);
        this.mainWindow.addSearchWindow(search);
        search.makeVisible(this.getTrimmedSelectedTextInMainWindow());
    }

    private String getTrimmedSelectedTextInMainWindow() {
        String selection = null;
        Component component = this.mainWindow.getMostRecentFocusOwner();
        if (component instanceof JTextComponent && !StringUtil.isEmpty(selection = ((JTextComponent)component).getSelectedText())) {
            selection = EditorUtils.removeDirectionChars(selection);
            selection = selection.trim();
        }
        return selection;
    }

    public void editSelectFuzzy1MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(0);
    }

    public void editSelectFuzzy2MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(1);
    }

    public void editSelectFuzzy3MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(2);
    }

    public void editSelectFuzzy4MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(3);
    }

    public void editSelectFuzzy5MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(4);
    }

    public void editSelectFuzzyNextMenuItemActionPerformed() {
        Core.getMatcher().setNextActiveMatch();
    }

    public void editSelectFuzzyPrevMenuItemActionPerformed() {
        Core.getMatcher().setPrevActiveMatch();
    }

    public void insertCharsLRMActionPerformed() {
        Core.getEditor().insertText("\u200e");
    }

    public void insertCharsRLMActionPerformed() {
        Core.getEditor().insertText("\u200f");
    }

    public void insertCharsLREActionPerformed() {
        Core.getEditor().insertText("\u202a");
    }

    public void insertCharsRLEActionPerformed() {
        Core.getEditor().insertText("\u202b");
    }

    public void insertCharsPDFActionPerformed() {
        Core.getEditor().insertText("\u202c");
    }

    public void editMultipleDefaultActionPerformed() {
        Core.getEditor().setAlternateTranslationForCurrentEntry(false);
    }

    public void editMultipleAlternateActionPerformed() {
        Core.getEditor().setAlternateTranslationForCurrentEntry(true);
    }

    public void editRegisterUntranslatedMenuItemActionPerformed() {
        Core.getEditor().registerUntranslated();
    }

    public void editRegisterEmptyMenuItemActionPerformed() {
        Core.getEditor().registerEmptyTranslation();
    }

    public void editRegisterIdenticalMenuItemActionPerformed() {
        Core.getEditor().registerIdenticalTranslation();
    }

    public void optionsPreferencesMenuItemActionPerformed() {
        PreferencesWindowController pwc = new PreferencesWindowController();
        pwc.show(Core.getMainWindow().getApplicationFrame());
    }

    public void cycleSwitchCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.CYCLE);
    }

    public void sentenceCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.SENTENCE);
    }

    public void titleCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.TITLE);
    }

    public void upperCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.UPPER);
    }

    public void lowerCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.LOWER);
    }

    public void gotoNextUntranslatedMenuItemActionPerformed() {
        Core.getEditor().nextUntranslatedEntry();
    }

    public void gotoNextUniqueMenuItemActionPerformed() {
        Core.getEditor().nextUniqueEntry();
    }

    public void gotoNextTranslatedMenuItemActionPerformed() {
        Core.getEditor().nextTranslatedEntry();
    }

    public void gotoNextSegmentMenuItemActionPerformed() {
        Core.getEditor().nextEntry();
    }

    public void gotoPreviousSegmentMenuItemActionPerformed() {
        Core.getEditor().prevEntry();
    }

    public void gotoNextNoteMenuItemActionPerformed() {
        Core.getEditor().nextEntryWithNote();
    }

    public void gotoPreviousNoteMenuItemActionPerformed() {
        Core.getEditor().prevEntryWithNote();
    }

    public void gotoSegmentMenuItemActionPerformed() {
        GoToSegmentDialog dialog = new GoToSegmentDialog(this.mainWindow);
        dialog.setVisible(true);
        int jumpTo = dialog.getResult();
        if (jumpTo != -1) {
            Core.getEditor().gotoEntry(jumpTo);
        }
    }

    public void gotoHistoryBackMenuItemActionPerformed() {
        Core.getEditor().gotoHistoryBack();
    }

    public void gotoHistoryForwardMenuItemActionPerformed() {
        Core.getEditor().gotoHistoryForward();
    }

    public void gotoMatchSourceSegmentActionPerformed() {
        NearString ns = Core.getMatcher().getActiveMatch();
        if (ns != null && ns.comesFrom == NearString.MATCH_SOURCE.MEMORY) {
            Core.getEditor().gotoEntry(ns.source, ns.key);
        }
    }

    public void viewMarkTranslatedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkTranslated(this.mainWindow.menu.viewMarkTranslatedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkUntranslatedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkUntranslated(this.mainWindow.menu.viewMarkUntranslatedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkParagraphStartCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkParagraphDelimitations(this.mainWindow.menu.viewMarkParagraphStartCheckBoxMenuItem.isSelected());
    }

    public void viewDisplaySegmentSourceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplaySegmentSources(this.mainWindow.menu.viewDisplaySegmentSourceCheckBoxMenuItem.isSelected());
    }

    public void viewMarkNonUniqueSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNonUniqueSegments(this.mainWindow.menu.viewMarkNonUniqueSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkNotedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNotedSegments(this.mainWindow.menu.viewMarkNotedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkNBSPCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNBSP(this.mainWindow.menu.viewMarkNBSPCheckBoxMenuItem.isSelected());
    }

    public void viewMarkWhitespaceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkWhitespace(this.mainWindow.menu.viewMarkWhitespaceCheckBoxMenuItem.isSelected());
    }

    public void viewMarkBidiCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkBidi(this.mainWindow.menu.viewMarkBidiCheckBoxMenuItem.isSelected());
    }

    public void viewMarkAutoPopulatedCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkAutoPopulated(this.mainWindow.menu.viewMarkAutoPopulatedCheckBoxMenuItem.isSelected());
    }

    public void viewMarkGlossaryMatchesCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkGlossaryMatches(this.mainWindow.menu.viewMarkGlossaryMatchesCheckBoxMenuItem.isSelected());
    }

    public void viewMarkLanguageCheckerCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkLanguageChecker(this.mainWindow.menu.viewMarkLanguageCheckerCheckBoxMenuItem.isSelected());
    }

    public void viewMarkFontFallbackCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDoFontFallback(this.mainWindow.menu.viewMarkFontFallbackCheckBoxMenuItem.isSelected());
    }

    public void viewDisplayModificationInfoNoneRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo("none");
    }

    public void viewDisplayModificationInfoSelectedRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo("selected");
    }

    public void viewDisplayModificationInfoAllRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo("all");
    }

    public void toolsCheckIssuesMenuItemActionPerformed() {
        IssueProvidersSelectorController dialog;
        if (!Preferences.isPreference("issue_providers_dont_ask") && !(dialog = new IssueProvidersSelectorController()).show(this.mainWindow)) {
            return;
        }
        Core.getIssues().showAll();
    }

    public void toolsCheckIssuesCurrentFileMenuItemActionPerformed() {
        Core.getIssues().showForFiles(Pattern.quote(Core.getEditor().getCurrentFile()));
    }

    public void editTagPainterMenuItemActionPerformed() {
        for (TagUtil.Tag tag : TagUtil.getAllTagsMissingFromTarget()) {
            Core.getEditor().insertTag(tag.tag);
        }
    }

    public void editTagNextMissedMenuItemActionPerformed() {
        List<TagUtil.Tag> tags = TagUtil.getAllTagsMissingFromTarget();
        if (tags.isEmpty()) {
            return;
        }
        Core.getEditor().insertTag(tags.get((int)0).tag);
    }

    public void toolsShowStatisticsStandardMenuItemActionPerformed() {
        new StatisticsWindow((Frame)Core.getMainWindow().getApplicationFrame(), StatisticsWindow.STAT_TYPE.STANDARD).setVisible(true);
    }

    public void toolsShowStatisticsMatchesMenuItemActionPerformed() {
        new StatisticsWindow((Frame)Core.getMainWindow().getApplicationFrame(), StatisticsWindow.STAT_TYPE.MATCHES).setVisible(true);
    }

    public void toolsShowStatisticsMatchesPerFileMenuItemActionPerformed() {
        new StatisticsWindow((Frame)Core.getMainWindow().getApplicationFrame(), StatisticsWindow.STAT_TYPE.MATCHES_PER_FILE).setVisible(true);
    }

    public void toolsAlignFilesMenuItemActionPerformed() {
        AlignFilePickerController picker = new AlignFilePickerController();
        if (Core.getProject().isProjectLoaded()) {
            String srcRoot = Core.getProject().getProjectProperties().getSourceRoot();
            String curFile = Core.getEditor().getCurrentFile();
            if (curFile != null) {
                picker.setSourceFile(srcRoot + curFile);
            }
            picker.setSourceDefaultDir(srcRoot);
            picker.setDefaultSaveDir(Core.getProject().getProjectProperties().getTMRoot());
            picker.setSourceLanguage(Core.getProject().getProjectProperties().getSourceLanguage());
            picker.setTargetLanguage(Core.getProject().getProjectProperties().getTargetLanguage());
        } else {
            String trgLang;
            String srcLang = Preferences.getPreference("source_lang");
            if (!StringUtil.isEmpty(srcLang)) {
                picker.setSourceLanguage(new Language(srcLang));
            }
            if (!StringUtil.isEmpty(trgLang = Preferences.getPreference("target_lang"))) {
                picker.setTargetLanguage(new Language(trgLang));
            }
        }
        picker.show(this.mainWindow);
    }

    public void optionsAutoCompleteShowAutomaticallyItemActionPerformed() {
        Preferences.setPreference("ac_show_suggestions_automatically", this.mainWindow.menu.optionsAutoCompleteShowAutomaticallyItem.isSelected());
    }

    public void optionsAutoCompleteHistoryCompletionMenuItemActionPerformed() {
        Preferences.setPreference("allow_history_completer", this.mainWindow.menu.optionsAutoCompleteHistoryCompletionMenuItem.isSelected());
    }

    public void optionsAutoCompleteHistoryPredictionMenuItemActionPerformed() {
        Preferences.setPreference("history_completer_prediction_enabled", this.mainWindow.menu.optionsAutoCompleteHistoryPredictionMenuItem.isSelected());
    }

    public void optionsMTAutoFetchCheckboxMenuItemActionPerformed() {
        boolean enabled = this.mainWindow.menu.optionsMTAutoFetchCheckboxMenuItem.isSelected();
        Preferences.setPreference("mt_auto_fetch", enabled);
    }

    public void optionsDictionaryFuzzyMatchingCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("dictionary_fuzzy_matching", this.mainWindow.menu.optionsDictionaryFuzzyMatchingCheckBoxMenuItem.isSelected());
        Preferences.save();
    }

    public void optionsSetupFileFiltersMenuItemActionPerformed() {
        new PreferencesWindowController().show(this.mainWindow, FiltersCustomizerController.class);
    }

    public void optionsSentsegMenuItemActionPerformed() {
        new PreferencesWindowController().show(this.mainWindow, SegmentationCustomizerController.class);
    }

    public void optionsWorkflowMenuItemActionPerformed() {
        new PreferencesWindowController().show(this.mainWindow, EditingBehaviorController.class);
    }

    public void viewRestoreGUIMenuItemActionPerformed() {
        MainWindowUI.resetDesktopLayout(this.mainWindow);
    }

    public void optionsAccessConfigDirMenuItemActionPerformed() {
        this.openFile(new File(StaticUtils.getConfigDir()));
    }

    public void helpContentsMenuItemActionPerformed() {
        try {
            Help.showHelp();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.mainWindow, ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
            Log.log(ex);
        }
    }

    public void helpAboutMenuItemActionPerformed() {
        new AboutDialog(this.mainWindow).setVisible(true);
    }

    public void helpLastChangesMenuItemActionPerformed() {
        new LastChangesDialog(this.mainWindow).setVisible(true);
    }

    public void helpLogMenuItemActionPerformed() {
        new LogDialog(this.mainWindow).setVisible(true);
    }

    public void helpUpdateCheckMenuItemActionPerformed() {
        VersionCheckDialog.checkAndShowResultAsync(this.mainWindow);
    }
}

