/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNCopySource {
    private SVNRevision myPegRevision;
    private SVNRevision myRevision;
    private SVNURL myURL;
    private File myPath;
    private boolean myIsCopyContents;

    public SVNCopySource(SVNRevision pegRevision, SVNRevision revision, File path) {
        this.myPegRevision = pegRevision;
        this.myRevision = revision;
        this.myPath = path.getAbsoluteFile();
    }

    public SVNCopySource(SVNRevision pegRevision, SVNRevision revision, SVNURL url) {
        this.myPegRevision = pegRevision;
        this.myRevision = revision;
        this.myURL = url;
    }

    public File getFile() {
        return this.myPath;
    }

    public SVNRevision getPegRevision() {
        return this.myPegRevision;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public boolean isURL() {
        return this.myURL != null;
    }

    public String getName() {
        if (this.isURL()) {
            return SVNPathUtil.tail(this.myURL.getPath());
        }
        return this.myPath.getName();
    }

    public void setCopyContents(boolean copyContents) {
        this.myIsCopyContents = copyContents;
    }

    public boolean isCopyContents() {
        return this.myIsCopyContents;
    }
}

