/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.formatter;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.formatter.Formatter;

public class PresentationFormatter
implements Formatter {
    public static final int DEFAULT_WIDTH = 79;
    public static final int MIN_WIDTH = 5;
    private PrintWriter writer;
    private int width;
    private int maxLength;
    private String emptyString;

    public PresentationFormatter(Writer writer, int width) {
        if (width < 5) {
            throw new IllegalArgumentException("Width is: " + width + " and must be at least: " + 5);
        }
        this.writer = new PrintWriter(writer, true);
        this.width = width;
        this.maxLength = (this.width - 3) / 2;
        this.emptyString = this.buildString(' ', this.maxLength);
    }

    public PresentationFormatter(Writer writer) {
        this(writer, 79);
    }

    @Override
    public void format(List<Alignment> alignmentList) {
        int index = 0;
        for (Alignment alignment : alignmentList) {
            String string;
            List<String> sourceList = this.splitStringList(alignment.getSourceSegmentList(), this.maxLength);
            List<String> targetList = this.splitStringList(alignment.getTargetSegmentList(), this.maxLength);
            Iterator<String> sourceIterator = sourceList.iterator();
            Iterator<String> targetIterator = targetList.iterator();
            while (sourceIterator.hasNext() && targetIterator.hasNext()) {
                string = this.formatString(sourceIterator.next(), targetIterator.next(), this.maxLength);
                this.writer.println(string);
            }
            while (sourceIterator.hasNext()) {
                string = this.formatString(sourceIterator.next(), this.emptyString, this.maxLength);
                this.writer.println(string);
            }
            while (targetIterator.hasNext()) {
                string = this.formatString(this.emptyString, targetIterator.next(), this.maxLength);
                this.writer.println(string);
            }
            if (index < alignmentList.size() - 1) {
                this.writer.print(this.buildString('_', this.maxLength + 1));
                this.writer.print('|');
                this.writer.println(this.buildString('_', this.maxLength + 1));
            }
            ++index;
        }
    }

    private List<String> splitStringList(List<String> stringList, int maxLength) {
        ArrayList<String> splitStringList = new ArrayList<String>();
        int index = 0;
        for (String string : stringList) {
            splitStringList.addAll(this.splitString(string, maxLength));
            if (index < stringList.size() - 1) {
                splitStringList.add(this.emptyString);
            }
            ++index;
        }
        return splitStringList;
    }

    private List<String> splitString(String string, int maxLength) {
        ArrayList<String> stringList = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (int position = 0; position < string.length(); ++position) {
            char ch = string.charAt(position);
            if (ch == '\n') {
                int eolWidth = maxLength - builder.length();
                builder.append(this.buildString(' ', eolWidth));
            } else if (ch == '\t') {
                int tabWidth = Math.min(4, maxLength - builder.length());
                builder.append(this.buildString(' ', tabWidth));
            } else {
                builder.append(ch);
            }
            if (builder.length() < maxLength) continue;
            String line = builder.substring(0, maxLength);
            stringList.add(line);
            builder.delete(0, maxLength);
        }
        if (builder.length() > 0) {
            builder.append(this.buildString(' ', maxLength - builder.length()));
            stringList.add(builder.toString());
        }
        return stringList;
    }

    private String formatString(String sourceString, String targetString, int maxLength) {
        return sourceString + " | " + targetString;
    }

    private String buildString(char character, int length) {
        StringBuilder builder = new StringBuilder();
        builder.setLength(length);
        for (int i = 0; i < length; ++i) {
            builder.setCharAt(i, character);
        }
        return builder.toString();
    }
}

