/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.omegat.filters2.TranslationException;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.PreferencesImpl;
import org.omegat.util.StringUtil;
import org.omegat.util.xml.XMLBlock;
import org.omegat.util.xml.XMLStreamReader;

public class PreferencesXML
implements PreferencesImpl.IPrefsPersistence {
    private final File loadFile;
    private final File saveFile;

    public PreferencesXML(File loadFile, File saveFile) {
        this.loadFile = loadFile;
        this.saveFile = saveFile;
    }

    @Override
    public void load(List<String> keys, List<String> values) {
        block31: {
            try (XMLStreamReader xml = new XMLStreamReader();){
                xml.killEmptyBlocks();
                if (this.loadFile == null) {
                    try (InputStream is = this.getClass().getResourceAsStream(Preferences.FILE_PREFERENCES);){
                        if (is != null) {
                            xml.setStream(is);
                            PreferencesXML.readXmlPrefs(xml, keys, values);
                        }
                        break block31;
                    }
                }
                xml.setStream(this.loadFile);
                PreferencesXML.readXmlPrefs(xml, keys, values);
            }
            catch (TranslationException te) {
                Log.logWarningRB("PM_WARNING_PARSEERROR_ON_READ", new Object[0]);
                Log.log(te);
                PreferencesXML.makeBackup(this.loadFile);
            }
            catch (IndexOutOfBoundsException e3) {
                Log.logWarningRB("PM_WARNING_PARSEERROR_ON_READ", new Object[0]);
                Log.log(e3);
                PreferencesXML.makeBackup(this.loadFile);
            }
            catch (UnsupportedEncodingException e3) {
                Log.logErrorRB(e3, "PM_UNSUPPORTED_ENCODING", new Object[0]);
                PreferencesXML.makeBackup(this.loadFile);
            }
            catch (IOException e4) {
                Log.logErrorRB(e4, "PM_ERROR_READING_FILE", new Object[0]);
                PreferencesXML.makeBackup(this.loadFile);
            }
        }
    }

    private static void makeBackup(File file) {
        if (file == null || !file.isFile()) {
            return;
        }
        String timestamp = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
        File bakFile = new File(file.getAbsolutePath() + "." + timestamp + ".bak");
        try {
            FileUtils.copyFile(file, bakFile);
            Log.logWarningRB("PM_BACKED_UP_PREFS_FILE", bakFile.getAbsolutePath());
        }
        catch (IOException ex) {
            Log.logErrorRB(ex, "PM_ERROR_BACKING_UP_PREFS_FILE", new Object[0]);
        }
    }

    static void readXmlPrefs(XMLStreamReader xml, List<String> keys, List<String> values) throws TranslationException {
        if (xml.advanceToTag("omegat") == null) {
            return;
        }
        XMLBlock blk = xml.advanceToTag("preference");
        if (blk == null) {
            return;
        }
        String ver = blk.getAttribute("version");
        if (ver != null && !ver.equals("1.0")) {
            return;
        }
        List<XMLBlock> lst = xml.closeBlock(blk);
        if (lst == null) {
            return;
        }
        for (int i = 0; i < lst.size(); ++i) {
            blk = lst.get(i);
            if (blk.isClose() || !blk.isTag()) continue;
            String pref = blk.getTagName();
            String val = (blk = lst.get(++i)).isClose() ? "" : blk.getText();
            if (pref == null || val == null) continue;
            keys.add(pref);
            values.add(val);
        }
    }

    @Override
    public void save(List<String> keys, List<String> values) throws Exception {
        try (BufferedWriter out = Files.newBufferedWriter(this.saveFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            out.write("<omegat>\n");
            out.write("  <preference version=\"1.0\">\n");
            for (int i = 0; i < keys.size(); ++i) {
                String name = keys.get(i);
                String val = StringUtil.makeValidXML(values.get(i).toString());
                out.write("    <" + name + ">");
                out.write(val);
                out.write("</" + name + ">\n");
            }
            out.write("  </preference>\n");
            out.write("</omegat>\n");
        }
    }
}

