/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.gui;

import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;
import org.jdesktop.beansbinding.Converter;
import org.madlonkay.supertmxmerge.util.LocString;

public class MapToTextConverter
extends Converter {
    public Object convertForward(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException();
        }
        Map map = (Map)value;
        return MapToTextConverter.mapToHtml(map);
    }

    public static String mapToHtml(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<html>");
        for (Map.Entry<?, ?> e : new TreeMap(map).entrySet()) {
            sb.append("<b>");
            sb.append(MapToTextConverter.localize(MapToTextConverter.toString(e.getKey())));
            sb.append(":</b> ");
            sb.append(MapToTextConverter.toString(e.getValue()));
            sb.append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    public static String mapToPlainText(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> e : new TreeMap(map).entrySet()) {
            sb.append(" - ");
            sb.append(MapToTextConverter.localize(MapToTextConverter.toString(e.getKey())));
            sb.append(": ");
            sb.append(MapToTextConverter.toString(e.getValue()));
            sb.append("\n");
        }
        return sb.toString();
    }

    public Object convertReverse(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static String localize(String string) {
        try {
            return LocString.get("STM_METADATA_" + string.toUpperCase());
        }
        catch (MissingResourceException ex) {
            return string;
        }
    }

    private static String toString(Object o) {
        return o == null ? "null" : o.toString();
    }
}

