/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.shortcuts;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public class PropertiesShortcuts {
    private static final Logger LOGGER = Logger.getLogger(PropertiesShortcuts.class.getName());
    private static final String BUNDLED_ROOT = "/org/omegat/gui/main/";
    private static final String MAIN_MENU_SHORTCUTS_FILE = "MainMenuShortcuts.properties";
    private static final String EDITOR_SHORTCUTS_FILE = "EditorShortcuts.properties";
    private final Map<String, String> data = new HashMap<String, String>();

    public static PropertiesShortcuts getMainMenuShortcuts() {
        return LoadedShortcuts.MAIN_MENU_SHORTCUTS;
    }

    public static PropertiesShortcuts getEditorShortcuts() {
        return LoadedShortcuts.EDITOR_SHORTCUTS;
    }

    static PropertiesShortcuts loadBundled(String classpathRoot, String filename) {
        PropertiesShortcuts result = new PropertiesShortcuts();
        try {
            result.loadFromClasspath(classpathRoot + filename);
            result.loadFromFile(new File(StaticUtils.getConfigDir(), filename));
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to load shortcuts properties file", ex);
        }
        return result;
    }

    public void loadFromClasspath(String propertiesFile) throws IOException {
        boolean loaded = false;
        if (Platform.isMacOSX()) {
            String macSpecific = this.getMacProperties(propertiesFile);
            loaded = this.loadFromClasspathImpl(macSpecific);
        }
        if (!loaded) {
            this.loadFromClasspathImpl(propertiesFile);
        }
    }

    private String getMacProperties(String properties) {
        return properties.replaceAll("\\.properties$", ".mac.properties");
    }

    private boolean loadFromClasspathImpl(String path) throws IOException {
        try (InputStream in = this.getClass().getResourceAsStream(path);){
            if (in != null) {
                this.loadProperties(in);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void loadFromFile(File file) throws IOException {
        File macSpecific;
        boolean loaded = false;
        if (Platform.isMacOSX() && (macSpecific = new File(this.getMacProperties(file.getPath()))).isFile()) {
            this.loadFromFileImpl(macSpecific);
            loaded = true;
        }
        if (!loaded && file.isFile()) {
            this.loadFromFileImpl(file);
        }
    }

    private void loadFromFileImpl(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            this.loadProperties(fis);
        }
    }

    private void loadProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.data.put(k.toString(), v.toString())));
    }

    public KeyStroke getKeyStroke(String key) {
        String shortcut = this.data.get(key);
        if (shortcut == null) {
            throw new IllegalArgumentException("Keyboard shortcut not defined. Key=" + key);
        }
        KeyStroke result = KeyStroke.getKeyStroke(shortcut);
        if (!shortcut.isEmpty() && result == null) {
            LOGGER.warning("Keyboard shortcut is invalid: " + key + "=" + shortcut);
        }
        return result;
    }

    public void bindKeyStrokes(JMenuBar menu) {
        this.applyTo(menu.getComponents());
    }

    private void applyTo(Component[] items) {
        for (Component c : items) {
            if (!(c instanceof JMenuItem)) continue;
            this.bindKeyStrokes((JMenuItem)c);
        }
    }

    public void bindKeyStrokes(JMenuItem item) {
        if (item instanceof JMenu) {
            this.applyTo(((JMenu)item).getMenuComponents());
        } else {
            String shortcut = item.getActionCommand();
            if (!StringUtil.isEmpty(shortcut)) {
                try {
                    item.setAccelerator(this.getKeyStroke(shortcut));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void bindKeyStrokes(InputMap inputMap, String ... keys) {
        for (String key : keys) {
            try {
                KeyStroke keyStroke = this.getKeyStroke(key);
                if (keyStroke == null) {
                    this.removeEntry(inputMap, key);
                    continue;
                }
                inputMap.put(keyStroke, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private KeyStroke removeEntry(InputMap inputMap, String keyToBeRemoved) {
        KeyStroke removedEntry = null;
        for (KeyStroke ks : inputMap.keys()) {
            String key = (String)inputMap.get(ks);
            if (!key.equals(keyToBeRemoved)) continue;
            inputMap.remove(ks);
            removedEntry = ks;
            break;
        }
        return removedEntry;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    Map<String, String> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    private static class LoadedShortcuts {
        static final PropertiesShortcuts MAIN_MENU_SHORTCUTS = PropertiesShortcuts.loadBundled("/org/omegat/gui/main/", "MainMenuShortcuts.properties");
        static final PropertiesShortcuts EDITOR_SHORTCUTS = PropertiesShortcuts.loadBundled("/org/omegat/gui/main/", "EditorShortcuts.properties");

        private LoadedShortcuts() {
        }
    }
}

