/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.Reporter;
import org.testng.internal.Utils;
import org.testng.reporters.XMLReporterConfig;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.XMLSuiteResultWriter;
import org.testng.xml.XmlSuite;

public class XMLReporter
implements IReporter {
    public static final String FILE_NAME = "testng-results.xml";
    private static final String JVM_ARG = "testng.report.xml.name";
    private final XMLReporterConfig config = new XMLReporterConfig();
    private XMLStringBuffer rootBuffer;

    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        if (Utils.isStringEmpty(this.config.getOutputDirectory())) {
            this.config.setOutputDirectory(string);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (ISuite object : list2) {
            Map<String, ISuiteResult> map = object.getResults();
            for (ISuiteResult iSuiteResult : map.values()) {
                ITestContext iTestContext = iSuiteResult.getTestContext();
                n += iTestContext.getPassedTests().size();
                n2 += iTestContext.getFailedTests().size();
                n3 += iTestContext.getSkippedTests().size();
                n4 += iTestContext.getExcludedMethods().size();
            }
        }
        this.rootBuffer = new XMLStringBuffer();
        Properties properties = new Properties();
        properties.put("passed", (Object)n);
        properties.put("failed", (Object)n2);
        properties.put("skipped", (Object)n3);
        properties.put("ignored", (Object)n4);
        properties.put("total", (Object)(n + n2 + n3 + n4));
        this.rootBuffer.push("testng-results", properties);
        this.writeReporterOutput(this.rootBuffer);
        for (ISuite iSuite : list2) {
            this.writeSuite(iSuite);
        }
        this.rootBuffer.pop();
        Utils.writeUtf8File(this.config.getOutputDirectory(), XMLReporter.fileName(), this.rootBuffer, null);
    }

    private static final String fileName() {
        return System.getProperty(JVM_ARG, FILE_NAME);
    }

    private void writeReporterOutput(XMLStringBuffer xMLStringBuffer) {
        xMLStringBuffer.push("reporter-output");
        List<String> list = Reporter.getOutput();
        for (String string : list) {
            if (string == null) continue;
            xMLStringBuffer.push("line");
            xMLStringBuffer.addCDATA(string);
            xMLStringBuffer.pop();
        }
        xMLStringBuffer.pop();
    }

    private void writeSuite(ISuite iSuite) {
        switch (this.config.getFileFragmentationLevel()) {
            case 1: {
                this.writeSuiteToBuffer(this.rootBuffer, iSuite);
                break;
            }
            case 2: 
            case 3: {
                File file = this.referenceSuite(this.rootBuffer, iSuite);
                this.writeSuiteToFile(file, iSuite);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected value: " + this.config.getFileFragmentationLevel()));
            }
        }
    }

    private void writeSuiteToFile(File file, ISuite iSuite) {
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        this.writeSuiteToBuffer(xMLStringBuffer, iSuite);
        File file2 = file.getParentFile();
        file.getParentFile().mkdirs();
        if (file2.exists() || file.getParentFile().exists()) {
            Utils.writeUtf8File(file2.getAbsolutePath(), FILE_NAME, xMLStringBuffer.toXML());
        }
    }

    private File referenceSuite(XMLStringBuffer xMLStringBuffer, ISuite iSuite) {
        String string = iSuite.getName() + File.separatorChar + FILE_NAME;
        File file = new File(this.config.getOutputDirectory(), string);
        Properties properties = new Properties();
        properties.setProperty("url", string);
        xMLStringBuffer.addEmptyElement("suite", properties);
        return file;
    }

    private void writeSuiteToBuffer(XMLStringBuffer xMLStringBuffer, ISuite iSuite) {
        xMLStringBuffer.push("suite", this.getSuiteAttributes(iSuite));
        this.writeSuiteGroups(xMLStringBuffer, iSuite);
        Map<String, ISuiteResult> map = iSuite.getResults();
        XMLSuiteResultWriter xMLSuiteResultWriter = new XMLSuiteResultWriter(this.config);
        for (Map.Entry<String, ISuiteResult> entry : map.entrySet()) {
            xMLSuiteResultWriter.writeSuiteResult(xMLStringBuffer, entry.getValue());
        }
        xMLStringBuffer.pop();
    }

    private void writeSuiteGroups(XMLStringBuffer xMLStringBuffer, ISuite iSuite) {
        xMLStringBuffer.push("groups");
        Map<String, Collection<ITestNGMethod>> map = iSuite.getMethodsByGroups();
        for (Map.Entry<String, Collection<ITestNGMethod>> entry : map.entrySet()) {
            Properties properties = new Properties();
            properties.setProperty("name", entry.getKey());
            xMLStringBuffer.push("group", properties);
            Set<ITestNGMethod> set = this.getUniqueMethodSet(entry.getValue());
            for (ITestNGMethod iTestNGMethod : set) {
                Properties properties2 = new Properties();
                properties2.setProperty("name", iTestNGMethod.getMethodName());
                properties2.setProperty("signature", iTestNGMethod.toString());
                properties2.setProperty("class", iTestNGMethod.getRealClass().getName());
                xMLStringBuffer.addEmptyElement("method", properties2);
            }
            xMLStringBuffer.pop();
        }
        xMLStringBuffer.pop();
    }

    private Properties getSuiteAttributes(ISuite iSuite) {
        Properties properties = new Properties();
        properties.setProperty("name", iSuite.getName());
        Map<String, ISuiteResult> map = iSuite.getResults();
        Date date = new Date();
        Date date2 = null;
        for (Map.Entry<String, ISuiteResult> entry : map.entrySet()) {
            ITestContext iTestContext = entry.getValue().getTestContext();
            Date date3 = iTestContext.getStartDate();
            Date date4 = iTestContext.getEndDate();
            if (date.after(date3)) {
                date = date3;
            }
            if (date2 != null && !date2.before(date4)) continue;
            date2 = date4 != null ? date4 : date3;
        }
        if (date2 == null) {
            date2 = date;
        }
        XMLReporter.addDurationAttributes(this.config, properties, date, date2);
        return properties;
    }

    public static void addDurationAttributes(XMLReporterConfig xMLReporterConfig, Properties properties, Date date, Date date2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(xMLReporterConfig.getTimestampFormat());
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        simpleDateFormat.setTimeZone(timeZone);
        String string = simpleDateFormat.format(date);
        String string2 = simpleDateFormat.format(date2);
        long l = date2.getTime() - date.getTime();
        properties.setProperty("started-at", string);
        properties.setProperty("finished-at", string2);
        properties.setProperty("duration-ms", Long.toString(l));
    }

    private Set<ITestNGMethod> getUniqueMethodSet(Collection<ITestNGMethod> collection) {
        LinkedHashSet<ITestNGMethod> linkedHashSet = new LinkedHashSet<ITestNGMethod>();
        for (ITestNGMethod iTestNGMethod : collection) {
            linkedHashSet.add(iTestNGMethod);
        }
        return linkedHashSet;
    }

    @Deprecated
    public int getFileFragmentationLevel() {
        return this.config.getFileFragmentationLevel();
    }

    @Deprecated
    public void setFileFragmentationLevel(int n) {
        this.config.setFileFragmentationLevel(n);
    }

    @Deprecated
    public int getStackTraceOutputMethod() {
        return this.config.getStackTraceOutputMethod();
    }

    @Deprecated
    public void setStackTraceOutputMethod(int n) {
        this.config.setStackTraceOutputMethod(n);
    }

    @Deprecated
    public String getOutputDirectory() {
        return this.config.getOutputDirectory();
    }

    @Deprecated
    public void setOutputDirectory(String string) {
        this.config.setOutputDirectory(string);
    }

    @Deprecated
    public boolean isGenerateGroupsAttribute() {
        return this.config.isGenerateGroupsAttribute();
    }

    @Deprecated
    public void setGenerateGroupsAttribute(boolean bl) {
        this.config.setGenerateGroupsAttribute(bl);
    }

    @Deprecated
    public boolean isSplitClassAndPackageNames() {
        return this.config.isSplitClassAndPackageNames();
    }

    @Deprecated
    public void setSplitClassAndPackageNames(boolean bl) {
        this.config.setSplitClassAndPackageNames(bl);
    }

    @Deprecated
    public String getTimestampFormat() {
        return this.config.getTimestampFormat();
    }

    @Deprecated
    public void setTimestampFormat(String string) {
        this.config.setTimestampFormat(string);
    }

    @Deprecated
    public boolean isGenerateDependsOnMethods() {
        return this.config.isGenerateDependsOnMethods();
    }

    @Deprecated
    public void setGenerateDependsOnMethods(boolean bl) {
        this.config.setGenerateDependsOnMethods(bl);
    }

    @Deprecated
    public void setGenerateDependsOnGroups(boolean bl) {
        this.config.setGenerateDependsOnGroups(bl);
    }

    @Deprecated
    public boolean isGenerateDependsOnGroups() {
        return this.config.isGenerateDependsOnGroups();
    }

    @Deprecated
    public void setGenerateTestResultAttributes(boolean bl) {
        this.config.setGenerateTestResultAttributes(bl);
    }

    @Deprecated
    public boolean isGenerateTestResultAttributes() {
        return this.config.isGenerateTestResultAttributes();
    }

    public XMLReporterConfig getConfig() {
        return this.config;
    }
}

