/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.relaxng;

import java.io.BufferedReader;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.relaxng.RelaxNGDialect;
import org.omegat.util.OStrings;

public class RelaxNGFilter
extends XMLFilter {
    public RelaxNGFilter() {
        super(new RelaxNGDialect());
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("RELAXNG_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.rng", null, null)};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public boolean isFileSupported(BufferedReader reader) {
        XMLDialect dialect = this.getDialect();
        if (dialect.getConstraints() == null || dialect.getConstraints().isEmpty()) {
            return true;
        }
        try {
            char[] cbuf = new char[65536];
            int cbufLen = reader.read(cbuf);
            String buf = new String(cbuf, 0, cbufLen);
            return RelaxNGDialect.RELAXNG_ROOT_TAG.matcher(buf).find() && RelaxNGDialect.RELAXNG_XMLNS.matcher(buf).find();
        }
        catch (Exception e) {
            return false;
        }
    }
}

