/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.stream.IntStream;

public class MixedEolHandlingReader
extends Reader {
    private final BufferedReader in;
    private String detectedEol;
    private boolean hasMixedEol;

    public MixedEolHandlingReader(Reader in) throws IOException {
        this.in = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        this.init();
    }

    private void init() throws IOException {
        this.in.mark(65536);
        char[] buf = new char[65536];
        int read = this.in.read(buf);
        int[] counts = MixedEolHandlingReader.countEols(buf, read);
        this.hasMixedEol = IntStream.of(counts).filter(i -> i > 0).count() > 1L;
        this.detectedEol = MixedEolHandlingReader.decideRepresentativeEol(counts[0], counts[1], counts[2]);
        this.in.reset();
    }

    static int[] countEols(char[] buf, int len) {
        int cr = 0;
        int lf = 0;
        int crlf = 0;
        for (int i = 0; i < len; ++i) {
            char c = buf[i];
            if (c == '\r') {
                if (i < len - 1 && buf[i + 1] == '\n') {
                    ++crlf;
                    ++i;
                    continue;
                }
                ++cr;
                continue;
            }
            if (c != '\n') continue;
            ++lf;
        }
        return new int[]{cr, lf, crlf};
    }

    static String decideRepresentativeEol(int cr, int lf, int crlf) {
        if (cr > lf && cr > crlf) {
            return "\r";
        }
        if (lf > cr && lf > crlf) {
            return "\n";
        }
        if (crlf > lf && crlf > cr) {
            return "\r\n";
        }
        if (crlf > 0) {
            return "\r\n";
        }
        return System.lineSeparator();
    }

    public String getDetectedEol() {
        return this.detectedEol;
    }

    public boolean hasMixedEol() {
        return this.hasMixedEol;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.in.read(cbuf, off, len);
    }

    public String readLine() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            return null;
        }
        StringBuilder line = new StringBuilder(1024);
        do {
            line.append((char)c);
            if (!this.encounteredEol(line)) continue;
            return line.substring(0, line.length() - this.detectedEol.length());
        } while ((c = this.in.read()) != -1);
        return line.toString();
    }

    private boolean encounteredEol(StringBuilder sb) {
        if (sb.length() < this.detectedEol.length()) {
            return false;
        }
        for (int i = 0; i < this.detectedEol.length(); ++i) {
            if (sb.charAt(sb.length() - this.detectedEol.length() + i) == this.detectedEol.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

