/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import com.vlsolutions.swing.docking.AutoHidePolicy;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.ui.DockingUISettings;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.function.BiConsumer;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ColorUIResource;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.gui.CustomContainerFactory;
import org.omegat.util.gui.ResourcesUtil;
import org.omegat.util.gui.RoundedCornerBorder;
import org.omegat.util.gui.Styles;

public final class UIDesignManager {
    private UIDesignManager() {
    }

    public static void initialize() throws IOException {
        UIDesignManager.loadDefaultColors();
        DockingUISettings.getInstance().installUI();
        DockableContainerFactory.setFactory(new CustomContainerFactory());
        AutoHidePolicy.getPolicy().setExpandMode(AutoHidePolicy.ExpandMode.EXPAND_ON_ROLLOVER);
        UIManager.put("DockViewTitleBar.minimizeButtonText", OStrings.getString("DOCKING_HINT_MINIMIZE"));
        UIManager.put("DockViewTitleBar.maximizeButtonText", OStrings.getString("DOCKING_HINT_MAXIMIZE"));
        UIManager.put("DockViewTitleBar.restoreButtonText", OStrings.getString("DOCKING_HINT_RESTORE"));
        UIManager.put("DockViewTitleBar.attachButtonText", OStrings.getString("DOCKING_HINT_DOCK"));
        UIManager.put("DockViewTitleBar.floatButtonText", OStrings.getString("DOCKING_HINT_UNDOCK"));
        UIManager.put("DockViewTitleBar.closeButtonText", "");
        UIManager.put("DockTabbedPane.minimizeButtonText", OStrings.getString("DOCKING_HINT_MINIMIZE"));
        UIManager.put("DockTabbedPane.maximizeButtonText", OStrings.getString("DOCKING_HINT_MAXIMIZE"));
        UIManager.put("DockTabbedPane.restoreButtonText", OStrings.getString("DOCKING_HINT_RESTORE"));
        UIManager.put("DockTabbedPane.floatButtonText", OStrings.getString("DOCKING_HINT_UNDOCK"));
        UIManager.put("DockTabbedPane.closeButtonText", "");
        Font defaultFont = UIManager.getFont("Label.font");
        UIManager.put("DockViewTitleBar.titleFont", defaultFont);
        UIManager.put("JTabbedPaneSmartIcon.font", defaultFont);
        UIManager.put("AutoHideButton.font", defaultFont);
        UIManager.put("DockViewTitleBar.isCloseButtonDisplayed", false);
        UIManager.put("DockingDesktop.closeActionAccelerator", null);
        UIManager.put("DockingDesktop.maximizeActionAccelerator", null);
        UIManager.put("DockingDesktop.dockActionAccelerator", null);
        UIManager.put("DockingDesktop.floatActionAccelerator", null);
        UIManager.put("DockViewTitleBar.menu.close", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close.rollover", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close.pressed", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.close", UIDesignManager.getIcon("empty.gif"));
        UIDesignManager.installFlatDesign();
        UIManager.put("DockingDesktop.notificationBlinkCount", 2);
        UIManager.put("DockingDesktop.notificationColor", Styles.EditorColor.COLOR_NOTIFICATION_MAX.getColor());
        UIDesignManager.ensureTitlebarReadability();
    }

    private static void installClassicDesign() {
        UIManager.put("OmegaTStatusArea.border", new MatteBorder(1, 1, 1, 1, Color.BLACK));
        UIManager.put("DockViewTitleBar.hide", UIDesignManager.getIcon("minimize.gif"));
        UIManager.put("DockViewTitleBar.hide.rollover", UIDesignManager.getIcon("minimize.rollover.gif"));
        UIManager.put("DockViewTitleBar.hide.pressed", UIDesignManager.getIcon("minimize.pressed.gif"));
        UIManager.put("DockViewTitleBar.maximize", UIDesignManager.getIcon("maximize.gif"));
        UIManager.put("DockViewTitleBar.maximize.rollover", UIDesignManager.getIcon("maximize.rollover.gif"));
        UIManager.put("DockViewTitleBar.maximize.pressed", UIDesignManager.getIcon("maximize.pressed.gif"));
        UIManager.put("DockViewTitleBar.restore", UIDesignManager.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.restore.rollover", UIDesignManager.getIcon("restore.rollover.gif"));
        UIManager.put("DockViewTitleBar.restore.pressed", UIDesignManager.getIcon("restore.pressed.gif"));
        UIManager.put("DockViewTitleBar.dock", UIDesignManager.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.dock.rollover", UIDesignManager.getIcon("restore.rollover.gif"));
        UIManager.put("DockViewTitleBar.dock.pressed", UIDesignManager.getIcon("restore.pressed.gif"));
        UIManager.put("DockViewTitleBar.float", UIDesignManager.getIcon("undock.gif"));
        UIManager.put("DockViewTitleBar.float.rollover", UIDesignManager.getIcon("undock.rollover.gif"));
        UIManager.put("DockViewTitleBar.float.pressed", UIDesignManager.getIcon("undock.pressed.gif"));
        UIManager.put("DockViewTitleBar.attach", UIDesignManager.getIcon("dock.gif"));
        UIManager.put("DockViewTitleBar.attach.rollover", UIDesignManager.getIcon("dock.rollover.gif"));
        UIManager.put("DockViewTitleBar.attach.pressed", UIDesignManager.getIcon("dock.pressed.gif"));
        UIManager.put("DockViewTitleBar.menu.hide", UIDesignManager.getIcon("minimize.gif"));
        UIManager.put("DockViewTitleBar.menu.maximize", UIDesignManager.getIcon("maximize.gif"));
        UIManager.put("DockViewTitleBar.menu.restore", UIDesignManager.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.menu.dock", UIDesignManager.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.menu.float", UIDesignManager.getIcon("undock.gif"));
        UIManager.put("DockViewTitleBar.menu.attach", UIDesignManager.getIcon("dock.gif"));
        UIManager.put("DockTabbedPane.menu.hide", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.maximize", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.float", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.closeAll", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.closeAllOther", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DragControler.detachCursor", UIDesignManager.getIcon("undock.gif").getImage());
    }

    private static void ensureTitlebarReadability() {
        Color textColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        Color backColor = UIManager.getColor("Panel.background");
        if (textColor != null && backColor != null && textColor.equals(backColor)) {
            float[] hsb = Color.RGBtoHSB(textColor.getRed(), textColor.getGreen(), textColor.getBlue(), null);
            float brightness = hsb[2];
            brightness = brightness >= 0.5f ? (brightness -= 0.5f) : (brightness += 0.5f);
            int rgb = Color.HSBtoRGB(hsb[0], hsb[1], brightness);
            ColorUIResource res = new ColorUIResource(rgb);
            UIManager.put("InternalFrame.inactiveTitleForeground", res);
        }
        UIManager.put("DockingDesktop.notificationBlinkCount", 2);
        UIManager.put("DockingDesktop.notificationColor", Styles.EditorColor.COLOR_NOTIFICATION_MAX.getColor());
    }

    private static void installFlatDesign() {
        Color standardBgColor = UIManager.getColor("Panel.background");
        Color activeTitleBgColor = UIDesignManager.adjustRGB(standardBgColor, 8);
        Color bottomAreaBgColor = UIDesignManager.adjustRGB(standardBgColor, -16);
        Color borderColor = UIDesignManager.adjustRGB(standardBgColor, -83);
        UIManager.put("OmegaTBorder.color", borderColor);
        Color statusAreaColor = UIDesignManager.adjustRGB(standardBgColor, -151);
        UIManager.put("VLDocking.highlight", activeTitleBgColor);
        UIManager.put("VLDocking.shadow", statusAreaColor);
        int outside = 5;
        UIManager.put("DockingDesktop.border", new EmptyBorder(outside, outside, outside, outside));
        int panel = 2;
        UIManager.put("DockView.singleDockableBorder", new EmptyBorder(panel, panel, panel, panel));
        int maxPanel = outside + panel;
        UIManager.put("DockView.maximizedDockableBorder", new EmptyBorder(maxPanel, maxPanel, maxPanel, maxPanel));
        UIManager.put("OmegaTDockablePanel.border", new MatteBorder(1, 1, 1, 1, borderColor));
        UIManager.put("OmegaTDockablePanelViewport.border", new EmptyBorder(0, 0, 0, 0));
        UIManager.put("OmegaTDockablePanel.isProportionalMargins", true);
        if (Platform.isMacOSX()) {
            UIManager.put("DockView.tabbedDockableBorder", new MatteBorder(0, 5, 5, 5, new Color(0xE6E6E6)));
        } else if (UIDesignManager.isWindowsLAF() && !UIDesignManager.isWindowsClassicLAF()) {
            UIManager.put("DockView.tabbedDockableBorder", new MatteBorder(2, 5, 5, 5, Color.WHITE));
        } else {
            UIManager.put("DockView.tabbedDockableBorder", new MatteBorder(5, 5, 5, 5, standardBgColor));
        }
        int cornerRadius = UIDesignManager.isFlatWindows() ? 0 : 8;
        Color activeTitleText = UIManager.getColor("Label.foreground");
        Color inactiveTitleText = UIDesignManager.adjustRGB(activeTitleText, 128);
        UIManager.put("DockViewTitleBar.border", new RoundedCornerBorder(cornerRadius, borderColor, 0));
        UIManager.put("InternalFrame.activeTitleForeground", activeTitleText);
        UIManager.put("InternalFrame.activeTitleBackground", activeTitleBgColor);
        UIManager.put("InternalFrame.inactiveTitleForeground", inactiveTitleText);
        UIManager.put("InternalFrame.inactiveTitleBackground", standardBgColor);
        UIManager.put("DockViewTitleBar.disableCustomPaint", true);
        UIManager.put("AutoHideButtonPanel.bottomBorder", new CompoundBorder(new MatteBorder(1, 0, 0, 0, borderColor), new EmptyBorder(0, 2 * outside, 0, 2 * outside)));
        UIManager.put("AutoHideButtonPanel.background", bottomAreaBgColor);
        UIManager.put("AutoHideButton.expandBorderBottom", new RoundedCornerBorder(cornerRadius, borderColor, 2));
        UIManager.put("AutoHideButton.background", standardBgColor);
        UIManager.put("OmegaTStatusArea.border", new MatteBorder(1, 1, 1, 1, statusAreaColor));
        UIManager.put("OmegaTMainWindowBottomMargin.border", new EmptyBorder(0, 2 * outside, outside, 2 * outside));
        UIManager.put("OmegaTEditorFilter.border", new MatteBorder(1, 1, 0, 1, borderColor));
        UIManager.put("activeCaption", Color.WHITE);
        UIManager.put("activeCaptionBorder", borderColor);
        UIManager.put("inactiveCaption", standardBgColor);
        UIManager.put("inactiveCaptionBorder", borderColor);
        UIManager.put("DockViewTitleBar.maximize", UIDesignManager.getIcon("appbar.app.tall.inactive.png"));
        UIManager.put("DockViewTitleBar.maximize.rollover", UIDesignManager.getIcon("appbar.app.tall.png"));
        UIManager.put("DockViewTitleBar.maximize.pressed", UIDesignManager.getIcon("appbar.app.tall.pressed.png"));
        UIManager.put("DockViewTitleBar.restore", UIDesignManager.getIcon("appbar.window.restore.inactive.png"));
        UIManager.put("DockViewTitleBar.restore.rollover", UIDesignManager.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.restore.pressed", UIDesignManager.getIcon("appbar.window.restore.pressed.png"));
        UIManager.put("DockViewTitleBar.hide", UIDesignManager.getIcon("appbar.hide.inactive.png"));
        UIManager.put("DockViewTitleBar.hide.rollover", UIDesignManager.getIcon("appbar.hide.png"));
        UIManager.put("DockViewTitleBar.hide.pressed", UIDesignManager.getIcon("appbar.hide.pressed.png"));
        UIManager.put("DockViewTitleBar.float", UIDesignManager.getIcon("appbar.fullscreen.inactive.png"));
        UIManager.put("DockViewTitleBar.float.rollover", UIDesignManager.getIcon("appbar.fullscreen.png"));
        UIManager.put("DockViewTitleBar.float.pressed", UIDesignManager.getIcon("appbar.fullscreen.pressed.png"));
        UIManager.put("DockViewTitleBar.dock", UIDesignManager.getIcon("appbar.window.restore.inactive.png"));
        UIManager.put("DockViewTitleBar.dock.rollover", UIDesignManager.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.dock.pressed", UIDesignManager.getIcon("appbar.window.restore.pressed.png"));
        UIManager.put("DockViewTitleBar.attach", UIDesignManager.getIcon("appbar.dock.window.inactive.png"));
        UIManager.put("DockViewTitleBar.attach.rollover", UIDesignManager.getIcon("appbar.dock.window.png"));
        UIManager.put("DockViewTitleBar.attach.pressed", UIDesignManager.getIcon("appbar.dock.window.pressed.png"));
        UIManager.put("DockViewTitleBar.menu.hide", UIDesignManager.getIcon("appbar.hide.png"));
        UIManager.put("DockViewTitleBar.menu.maximize", UIDesignManager.getIcon("appbar.app.tall.png"));
        UIManager.put("DockViewTitleBar.menu.restore", UIDesignManager.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.menu.dock", UIDesignManager.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.menu.float", UIDesignManager.getIcon("appbar.fullscreen.png"));
        UIManager.put("DockViewTitleBar.menu.attach", UIDesignManager.getIcon("appbar.dock.window.png"));
        UIManager.put("DockTabbedPane.menu.hide", UIDesignManager.getIcon("appbar.hide.png"));
        UIManager.put("DockTabbedPane.menu.maximize", UIDesignManager.getIcon("appbar.app.tall.png"));
        UIManager.put("DockTabbedPane.menu.float", UIDesignManager.getIcon("appbar.fullscreen.png"));
        UIManager.put("DragControler.detachCursor", ResourcesUtil.getBundledImage("appbar.fullscreen.cursor32x32.png"));
        if (Platform.isMacOSX()) {
            UIManager.put("DockViewTitleBar.maximize", UIDesignManager.getIcon("appbar.fullscreen.corners.inactive.png"));
            UIManager.put("DockViewTitleBar.maximize.rollover", UIDesignManager.getIcon("appbar.fullscreen.corners.png"));
            UIManager.put("DockViewTitleBar.maximize.pressed", UIDesignManager.getIcon("appbar.fullscreen.corners.pressed.png"));
            UIManager.put("DockViewTitleBar.restore", UIDesignManager.getIcon("appbar.restore.corners.inactive.png"));
            UIManager.put("DockViewTitleBar.restore.rollover", UIDesignManager.getIcon("appbar.restore.corners.png"));
            UIManager.put("DockViewTitleBar.restore.pressed", UIDesignManager.getIcon("appbar.restore.corners.pressed.png"));
            UIManager.put("DockViewTitleBar.hide", UIDesignManager.getIcon("appbar.minus.inactive.png"));
            UIManager.put("DockViewTitleBar.hide.rollover", UIDesignManager.getIcon("appbar.minus.png"));
            UIManager.put("DockViewTitleBar.hide.pressed", UIDesignManager.getIcon("appbar.minus.pressed.png"));
            UIManager.put("DockViewTitleBar.menu.hide", UIDesignManager.getIcon("appbar.minus.png"));
            UIManager.put("DockViewTitleBar.menu.maximize", UIDesignManager.getIcon("appbar.fullscreen.corners.png"));
            UIManager.put("DockViewTitleBar.menu.restore", UIDesignManager.getIcon("appbar.restore.corners.png"));
            UIManager.put("DockTabbedPane.menu.hide", UIDesignManager.getIcon("appbar.minus.png"));
            UIManager.put("DockTabbedPane.menu.maximize", UIDesignManager.getIcon("appbar.fullscreen.corners.png"));
            UIManager.put("DragControler.detachCursor", ResourcesUtil.getBundledImage("appbar.fullscreen.png"));
        }
    }

    private static Color adjustRGB(Color color, int adjustment) {
        Color result = new Color(Math.max(0, Math.min(255, color.getRed() + adjustment)), Math.max(0, Math.min(255, color.getGreen() + adjustment)), Math.max(0, Math.min(255, color.getBlue() + adjustment)));
        return result;
    }

    private static boolean isWindowsLAF() {
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }

    private static boolean isWindowsClassicLAF() {
        return UIDesignManager.isWindowsLAF() && (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive") == false;
    }

    private static boolean isFlatWindows() {
        return System.getProperty("os.name").startsWith("Windows") && System.getProperty("os.version").matches("6\\.[23]|10\\..*");
    }

    private static ImageIcon getIcon(String iconName) {
        Image image = ResourcesUtil.getBundledImage(iconName);
        return image == null ? null : new ImageIcon(image);
    }

    public static void removeUnusedMenuSeparators(JPopupMenu menu) {
        if (menu.getComponentCount() > 0 && menu.getComponent(0) instanceof JSeparator) {
            menu.remove(0);
        }
        if (menu.getComponentCount() > 0 && menu.getComponent(menu.getComponentCount() - 1) instanceof JSeparator) {
            menu.remove(menu.getComponentCount() - 1);
        }
        for (int i = 0; i < menu.getComponentCount() - 1; ++i) {
            if (!(menu.getComponent(i) instanceof JSeparator) || !(menu.getComponent(i + 1) instanceof JSeparator)) continue;
            menu.remove(i);
        }
    }

    public static void ensureDockablesVisible(DockingDesktop desktop) {
        for (DockableState state : desktop.getDockables()) {
            if (!state.isClosed()) continue;
            desktop.addDockable(state.getDockable());
        }
    }

    public static DockingDesktop getDesktop(Container c) {
        while (c != null && !(c instanceof DockingDesktop)) {
            c = c.getParent();
        }
        return (DockingDesktop)c;
    }

    private static boolean isDarkTheme() {
        Color foreground = UIManager.getColor("Table.foreground");
        Color background = UIManager.getColor("Table.background");
        float foreground_brightness = Color.RGBtoHSB(foreground.getRed(), foreground.getGreen(), foreground.getBlue(), null)[2];
        float background_brightness = Color.RGBtoHSB(background.getRed(), background.getGreen(), background.getBlue(), null)[2];
        return background_brightness < foreground_brightness;
    }

    private static void loadColors(String scheme) throws IOException {
        ResourcesUtil.getBundleColorProperties(scheme).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (v.toString().charAt(0) != '#') {
                throw new RuntimeException("Invalid color value for key " + k + ": " + v);
            }
            try {
                Color color;
                String hex = v.toString().substring(1);
                if (hex.length() <= 6) {
                    color = new Color(Integer.parseInt(hex, 16));
                } else {
                    long val = Long.parseLong(hex, 16);
                    int a = (int)(val & 0xFFL);
                    int b = (int)(val >> 8 & 0xFFL);
                    int g = (int)(val >> 16 & 0xFFL);
                    int r = (int)(val >> 24 & 0xFFL);
                    color = new Color(r, g, b, a);
                }
                UIManager.put(k.toString(), color);
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("Invalid color value for key '" + k + "': " + v, ex);
            }
        }));
    }

    private static void loadDefaultColors() throws IOException {
        Color hilite;
        if (UIDesignManager.isDarkTheme()) {
            UIDesignManager.loadColors("dark");
            hilite = UIManager.getColor("TextArea.background").brighter();
            if (Platform.isLinux() && Color.WHITE.equals(UIManager.getColor("TextPane.background"))) {
                UIManager.put("TextPane.background", UIManager.getColor("List.background"));
            }
        } else {
            UIDesignManager.loadColors("light");
            Color bg = UIManager.getColor("TextArea.background").darker();
            hilite = new Color(bg.getRed(), bg.getBlue(), bg.getGreen(), 32);
        }
        UIManager.put("OmegaT.alternatingHilite", hilite);
    }
}

