/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.convert;

import gen.core.project.RepositoryDefinition;
import gen.core.project.RepositoryMapping;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.team2.ProjectTeamSettings;
import org.omegat.util.OStrings;
import org.omegat.util.ProjectFileStorage;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public final class ConvertProject26to37team {
    private ConvertProject26to37team() {
    }

    public static void checkTeam(File projectRootFolder) throws Exception {
        if (ConvertProject26to37team.isSVNDirectory(projectRootFolder) || ConvertProject26to37team.isGITDirectory(projectRootFolder)) {
            if (ConvertProject26to37team.isConsoleMode()) {
                Core.getMainWindow().displayWarningRB("TEAM_26_TO_37_CONSOLE", new Object[0]);
                return;
            }
            int res = JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("TEAM_26_to_37_CONFIRM_MESSAGE"), OStrings.getString("TEAM_26_to_37_CONFIRM_TITLE"), 2);
            if (res != 0) {
                return;
            }
            ConvertProject26to37team.convert(projectRootFolder);
            JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("TEAM_26_to_37_CONVERTED_MESSAGE"), OStrings.getString("TEAM_26_to_37_CONFIRM_TITLE"), 1);
        }
    }

    private static void convert(File projectRootFolder) throws Exception {
        String version;
        String url;
        ProjectProperties props = ProjectFileStorage.loadProjectProperties(projectRootFolder);
        RepositoryDefinition def = new RepositoryDefinition();
        if (ConvertProject26to37team.isSVNDirectory(projectRootFolder)) {
            url = ConvertProject26to37team.getSVNUrl(projectRootFolder);
            def.setType("svn");
            version = ConvertProject26to37team.getSVNTmxVersion(projectRootFolder);
        } else {
            url = ConvertProject26to37team.getGITUrl(projectRootFolder);
            def.setType("git");
            version = ConvertProject26to37team.getGITTmxVersion(projectRootFolder);
        }
        if (url == null) {
            throw new Exception("Repository URL not defined");
        }
        def.setUrl(url);
        ConvertProject26to37team.saveVersion(projectRootFolder, "omegat/project_save.tmx", version);
        RepositoryMapping map = new RepositoryMapping();
        map.setLocal("");
        map.setRepository("");
        def.getMapping().add(map);
        props.setRepositories(new ArrayList<RepositoryDefinition>());
        props.getRepositories().add(def);
        ProjectFileStorage.writeProjectFile(props);
        FileUtils.deleteDirectory((File)new File(projectRootFolder, ".svn"));
        FileUtils.deleteDirectory((File)new File(projectRootFolder, ".git"));
    }

    private static void saveVersion(File projectRootFolder, String file, String version) throws IOException {
        ProjectTeamSettings teamSettings = new ProjectTeamSettings(new File(projectRootFolder, ".repositories/"));
        teamSettings.set("version-based-on." + file, version);
    }

    private static boolean isSVNDirectory(File projectRootFolder) {
        File svnDir = new File(projectRootFolder, ".svn");
        return svnDir.exists() && svnDir.isDirectory();
    }

    private static boolean isGITDirectory(File projectRootFolder) {
        File gitDir = new File(projectRootFolder, ".git");
        return gitDir.exists() && gitDir.isDirectory();
    }

    private static String getSVNUrl(File wc) throws Exception {
        SvnOperationFactory of = new SvnOperationFactory();
        SvnGetInfo infoOp = of.createGetInfo();
        infoOp.setSingleTarget(SvnTarget.fromFile((File)wc));
        infoOp.setDepth(SVNDepth.EMPTY);
        infoOp.setRevision(SVNRevision.WORKING);
        SvnInfo info = (SvnInfo)infoOp.run();
        SVNURL svn = info.getUrl();
        return svn.toString();
    }

    private static String getGITUrl(File wc) throws Exception {
        Repository repository = Git.open((File)wc).getRepository();
        StoredConfig config = repository.getConfig();
        return config.getString("remote", "origin", "url");
    }

    private static String getSVNTmxVersion(File wc) throws Exception {
        SvnOperationFactory of = new SvnOperationFactory();
        SvnGetInfo infoOp = of.createGetInfo();
        infoOp.setSingleTarget(SvnTarget.fromFile((File)new File(wc, "omegat/project_save.tmx")));
        infoOp.setDepth(SVNDepth.EMPTY);
        SvnInfo info = (SvnInfo)infoOp.run();
        long r = info.getRevision();
        return Long.toString(r);
    }

    private static String getGITTmxVersion(File wc) throws Exception {
        Repository repository = Git.open((File)wc).getRepository();
        try (RevWalk walk = new RevWalk(repository);){
            Ref localBranch = repository.findRef("HEAD");
            RevCommit headCommit = walk.lookupCommit((AnyObjectId)localBranch.getObjectId());
            String string = headCommit.getName();
            return string;
        }
    }

    private static boolean isConsoleMode() {
        try {
            Core.getMainWindow().getApplicationFrame();
            return false;
        }
        catch (NoSuchMethodError ex) {
            return true;
        }
    }
}

