/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.util.List;
import java.util.stream.Collectors;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.UnderlineFactory;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.util.gui.Styles;

public class SpellCheckerMarker
implements IMarker {
    protected static final Highlighter.HighlightPainter PAINTER = new UnderlineFactory.WaveUnderline(Styles.EditorColor.COLOR_SPELLCHECK.getColor());

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
        if (translationText == null) {
            return null;
        }
        if (!Core.getEditor().getSettings().isAutoSpellChecking()) {
            return null;
        }
        return Core.getSpellChecker().getMisspelledTokens(translationText).stream().map(tok -> {
            int st = tok.getOffset();
            int en = st + tok.getLength();
            Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, st, en);
            m.painter = PAINTER;
            return m;
        }).collect(Collectors.toList());
    }
}

